/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.image.streams;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.SystemResourceSupport;

public abstract class JunImageStream
extends JunAbstractObject {
    protected InputStream inStream;
    protected OutputStream outStream;
    protected StImage imageObject;
    protected StValueHolder progressValue = new StValueHolder(0.0f);
    protected static HashMap ImageKindTable;

    protected static void FlushImageKindTable() {
        ImageKindTable = null;
    }

    protected static Map ImageKindTable() {
        if (ImageKindTable == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("bmp", "jp.co.sra.jun.goodies.image.streams.JunBmpImageStream");
            hashMap.put("jpg", "jp.co.sra.jun.goodies.image.streams.JunJpegImageStream");
            hashMap.put("jpeg", "jp.co.sra.jun.goodies.image.streams.JunJpegImageStream");
            hashMap.put("png", "jp.co.sra.jun.goodies.image.streams.JunPngImageStream");
            hashMap.put("gif", "jp.co.sra.jun.goodies.image.streams.JunGifImageStream");
            hashMap.put("giff", "jp.co.sra.jun.goodies.image.streams.JunGifImageStream");
            ImageKindTable = hashMap;
        }
        return ImageKindTable;
    }

    public static Class ImageStreamClassForFileName_(File file) {
        return JunImageStream.ImageStreamClassForFileName_(file.toString());
    }

    public static Class ImageStreamClassForFileName_(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1).toLowerCase();
        String string3 = (String)JunImageStream.ImageKindTable().get(string2);
        if (string3 == null) {
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        return clazz;
    }

    public static StImage ImageSmalltalkBalloon128x128() {
        return new StImage(SystemResourceSupport.createImage((String)"/jp/co/sra/jun/goodies/image/streams/imageSmalltalkBalloon128x128.jpg"));
    }

    public static StImage ImageSmalltalkBalloon256x256() {
        return new StImage(SystemResourceSupport.createImage((String)"/jp/co/sra/jun/goodies/image/streams/imageSmalltalkBalloon256x256.jpg"));
    }

    public static JunImageStream On_(InputStream inputStream) throws IOException {
        throw new IOException("subclassResponsibilitty");
    }

    public static JunImageStream On_(OutputStream outputStream) throws IOException {
        throw new IOException("subclassResponsibilitty");
    }

    protected static JunImageStream On_(JunImageStream junImageStream, InputStream inputStream) throws IOException {
        if (junImageStream == null) {
            throw new IOException("could not load image");
        }
        junImageStream.on_(inputStream);
        return junImageStream;
    }

    protected static JunImageStream On_(JunImageStream junImageStream, OutputStream outputStream) throws IOException {
        if (junImageStream == null) {
            throw new IOException("could not save image");
        }
        junImageStream.on_(outputStream);
        return junImageStream;
    }

    public void close() throws IOException {
        if (this.inStream != null) {
            this.inStream.close();
            this.inStream = null;
        }
        if (this.outStream != null) {
            this.outStream.close();
            this.outStream = null;
        }
    }

    public void flush() throws IOException {
        if (this.outStream != null) {
            this.outStream.flush();
        }
    }

    protected void nextPut_(int n) throws IOException {
        this.outStream.write(n);
    }

    protected void nextPutAll_(byte[] byArray) throws IOException {
        this.outStream.write(byArray);
    }

    public abstract StImage nextImage() throws IOException;

    public abstract void nextPutImage_(StImage var1) throws IOException;

    public abstract String defaultImageExtension();

    protected void on_(InputStream inputStream) throws IOException {
        this.inStream = inputStream;
    }

    protected void on_(OutputStream outputStream) throws IOException {
        this.outStream = outputStream;
    }

    public void compute_(StBlockClosure stBlockClosure) {
        this.progressValue().compute_(stBlockClosure);
    }

    public void progress_(float f) {
        if (0.0f <= f && f <= 1.0f) {
            float f2 = (float)Math.round((double)f / 0.005) * 0.005f;
            if (this.progressValue()._floatValue() != f2) {
                this.progressValue().value_(f2);
            }
        }
    }

    public void progress() {
        this.progressValue()._floatValue();
    }

    protected void progressValue_(StValueHolder stValueHolder) {
        this.progressValue = stValueHolder;
    }

    protected StValueHolder progressValue() {
        return this.progressValue;
    }

    static {
        JunImageStream.FlushImageKindTable();
    }
}

