/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.spirodesign;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.geometry.transformations.Jun2dTransformation;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.jun.goodies.image.streams.JunJpegImageStream;
import jp.co.sra.jun.goodies.image.support.JunImageAdjuster;
import jp.co.sra.jun.goodies.nib.JunNibChoiceWithColor;
import jp.co.sra.jun.goodies.nib.JunNibChoiceWithColorDialog;
import jp.co.sra.jun.goodies.spirodesign.JunSpiroCircle;
import jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel;
import jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAnimationThread;
import jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignView;
import jp.co.sra.jun.goodies.spirodesign.JunSpiroPen;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StInputState;
import jp.co.sra.smalltalk.StInterval;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StCheckBoxMenuItem;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

public class JunSpiroDesign
extends JunSpiroDesignAbstractModel {
    protected JunSpiroCircle teraCircle;
    protected JunSpiroCircle moonCircle;
    protected JunSpiroPen spiroPen;
    protected boolean isCircumscribe;
    protected int howMany;
    protected boolean animationState;
    protected StValueHolder animationHolder;
    protected transient JunSpiroDesignAnimationThread _spiroDesignProcess;
    protected transient StPopupMenu _popupMenu;

    public JunSpiroDesign() {
    }

    public JunSpiroDesign(Color color) {
        this(color, 1);
    }

    public JunSpiroDesign(Color color, int n) {
        this.spiroPen().color_(color);
        this.spiroPen().width_(n);
    }

    public JunSpiroDesign(JunSpiroCircle junSpiroCircle, JunSpiroCircle junSpiroCircle2, JunSpiroPen junSpiroPen) {
        this.setTeraCircle_(junSpiroCircle);
        this.setMoonCircle_(junSpiroCircle2);
        this.setSpiroPen_(junSpiroPen);
    }

    protected void initialize() {
        super.initialize();
        this.teraCircle = null;
        this.moonCircle = null;
        this.spiroPen = null;
        this.isCircumscribe = false;
        this.howMany = 36;
        this.animationState = false;
        this.animationHolder = null;
        this._spiroDesignProcess = null;
        this._popupMenu = null;
    }

    public Color color() {
        return this.spiroPen().color();
    }

    public void color_width_(Color color, int n) {
        this.spiroPen().color_(color);
        this.spiroPen().width_(n);
        if (this.animationHolder().value() != null) {
            JunSpiroDesign junSpiroDesign = (JunSpiroDesign)((Object)this.animationHolder().value());
            junSpiroDesign.spiroPen().color_(this.spiroPen().color());
            junSpiroDesign.spiroPen().width_(this.spiroPen().width());
        }
    }

    public int howMany() {
        return this.howMany;
    }

    public void howMany_(int n) {
        this.howMany = n;
    }

    public int howManyCircle() {
        return 36;
    }

    public JunSpiroCircle moonCircle() {
        if (this.moonCircle == null) {
            int n = 70;
            Jun2dPoint jun2dPoint = new Jun2dPoint(this.teraCircle().radius() - (double)n, 0.0);
            this.moonCircle = new JunSpiroCircle(jun2dPoint, n, Color.blue, 1);
        }
        return this.moonCircle;
    }

    public Jun2dPoint point() {
        return this.spiroPen().point();
    }

    public boolean rainbow() {
        return this.spiroPen().rainbow();
    }

    public void rainbow_(boolean bl) {
        this.spiroPen().rainbow_(bl);
        if (this.animationHolder().value() != null) {
            JunSpiroDesign junSpiroDesign = (JunSpiroDesign)((Object)this.animationHolder().value());
            junSpiroDesign.spiroPen().rainbow_(this.spiroPen().rainbow());
        }
    }

    public JunSpiroPen spiroPen() {
        if (this.spiroPen == null) {
            this.spiroPen = new JunSpiroPen(this.moonCircle().center().plus_(new Jun2dPoint(-20.0, 50.0)));
        }
        return this.spiroPen;
    }

    public JunSpiroCircle teraCircle() {
        if (this.teraCircle == null) {
            this.teraCircle = new JunSpiroCircle(new Jun2dPoint(0.0, 0.0), 120.0, Color.red, 1);
        }
        return this.teraCircle;
    }

    public int width() {
        return this.spiroPen().width();
    }

    public StValueHolder animationHolder() {
        if (this.animationHolder == null) {
            this.animationHolder = new StValueHolder();
        }
        return this.animationHolder;
    }

    public Rectangle boundingBox() {
        Rectangle rectangle = this.teraCircle().boundingBox();
        if (this.isCircumscribe()) {
            rectangle.grow(this.moonCircle().boundingBox().width, this.moonCircle().boundingBox().height);
        }
        rectangle.add(this.spiroPen().mark());
        return rectangle;
    }

    public Rectangle bounds() {
        return this.preferredBounds();
    }

    public Rectangle preferredBounds() {
        Rectangle rectangle = this.teraCircle().bounds();
        if (this.isCircumscribe()) {
            rectangle.grow(this.moonCircle().bounds().width, this.moonCircle().bounds().height);
        }
        rectangle.add(this.spiroPen().mark());
        return rectangle;
    }

    public void compute_(StBlockClosure stBlockClosure) {
        this.animationHolder().compute_(stBlockClosure);
    }

    public float defaultImageQuality() {
        return 0.95f;
    }

    public StInterval defaultLocusInterval() {
        return new StInterval(0.0, (double)(360 * this.howMany()), (double)JunSpiroPen.DefaultTickAngle);
    }

    public long defaultTickTime() {
        return 50L;
    }

    public void displayOn_at_(Graphics graphics, Point point) {
        this.displayOn_at_withParts_(graphics, point, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayOn_at_betweenTera_andMoon_(Graphics graphics, Point point, JunSpiroCircle junSpiroCircle, JunSpiroCircle junSpiroCircle2) {
        Jun2dPoint[] jun2dPointArray = junSpiroCircle2.points();
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            jun2dPointArray[i] = jun2dPointArray[i].rounded().translatedBy_(new Jun2dPoint(point));
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            this.applyAttributesToGraphicsContext_(graphics2D);
            graphics2D.drawLine((int)Math.round(junSpiroCircle.center().x() + (double)point.x), (int)Math.round(junSpiroCircle.center().y() + (double)point.y), (int)Math.round(jun2dPointArray[0].x()), (int)Math.round(jun2dPointArray[0].y()));
            graphics2D.drawLine((int)Math.round(jun2dPointArray[1].x()), (int)Math.round(jun2dPointArray[1].y()), (int)Math.round(jun2dPointArray[3].x()), (int)Math.round(jun2dPointArray[3].y()));
            graphics2D.drawLine((int)Math.round(jun2dPointArray[2].x()), (int)Math.round(jun2dPointArray[2].y()), (int)Math.round(jun2dPointArray[4].x()), (int)Math.round(jun2dPointArray[4].y()));
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
                graphics2D = null;
            }
        }
    }

    public void displayOn_at_withParts_(Graphics graphics, Point point, boolean bl) {
        if (this.animationState()) {
            this.displayOn_at_withParts_spiroDesign_(graphics, point, bl, (JunSpiroDesign)((Object)this.animationHolder().value()));
        } else {
            JunSpiroPen junSpiroPen = (JunSpiroPen)this.spiroPen().copy();
            junSpiroPen.points_(this.spiroLocus());
            junSpiroPen.displayOn_at_with_Marks_(graphics, point, false);
            if (bl) {
                this.displayOn_at_betweenTera_andMoon_(graphics, point, this.teraCircle(), this.moonCircle());
                this.teraCircle().displayOn_at_with_Marks_(graphics, point, true);
                this.moonCircle().displayOn_at_with_Marks_(graphics, point, true);
                this.spiroPen().displayOn_at_with_Marks_(graphics, point, true);
            }
        }
    }

    public void displayOn_at_withParts_spiroDesign_(Graphics graphics, Point point, boolean bl, JunSpiroDesign junSpiroDesign) {
        if (junSpiroDesign == null) {
            return;
        }
        junSpiroDesign.spiroPen().displayOn_at_with_Marks_(graphics, point, false);
        if (bl) {
            this.displayOn_at_betweenTera_andMoon_(graphics, point, junSpiroDesign.teraCircle(), junSpiroDesign.moonCircle());
            junSpiroDesign.teraCircle().displayOn_at_with_Marks_(graphics, point, true);
            junSpiroDesign.moonCircle().displayOn_at_with_Marks_(graphics, point, true);
            junSpiroDesign.spiroPen().displayOn_at_with_Marks_(graphics, point, true);
        }
    }

    public boolean animationState() {
        return this.animationState;
    }

    public void animationState_(boolean bl) {
        this.animationState = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAnimation_onViews_(final StBlockClosure stBlockClosure, final JunSpiroDesignView[] junSpiroDesignViewArray) {
        try {
            final JunSpiroDesign junSpiroDesign = this;
            this.animationState_(true);
            final boolean bl = StInputState.Default().altDown();
            final boolean bl2 = StInputState.Default().shiftDown();
            final File file = new File(JunFileModel.DefaultDirectory(), junSpiroDesign.defaultBaseName());
            final StValueHolder stValueHolder = new StValueHolder(1);
            if (bl && !file.exists()) {
                file.mkdir();
            }
            final Rectangle rectangle = this.bounds();
            this.spiroLocusInterim_(new StBlockClosure(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object value_value_value_(Object object, Object object2, Object object3) {
                    Object object4;
                    JunSpiroCircle junSpiroCircle = (JunSpiroCircle)((Object)object);
                    JunSpiroCircle junSpiroCircle2 = (JunSpiroCircle)((Object)object2);
                    JunSpiroPen junSpiroPen = (JunSpiroPen)((Object)object3);
                    junSpiroDesign.animationHolder().value_((Object)new JunSpiroDesign(junSpiroCircle, junSpiroCircle2, junSpiroPen));
                    Rectangle rectangle3 = junSpiroCircle2.bounds();
                    rectangle3.add(junSpiroPen.mark());
                    rectangle3.add(junSpiroCircle.mark());
                    Rectangle rectangle2 = new Rectangle(rectangle);
                    rectangle2.add(rectangle3);
                    for (int i = 0; i < junSpiroDesignViewArray.length; ++i) {
                        junSpiroDesignViewArray[i].update_(new DependentEvent((Object)this, 1.$((String)"invalidate"), (Object)new Rectangle(rectangle2)));
                    }
                    rectangle.setBounds(rectangle3);
                    if (stBlockClosure != null && (object4 = stBlockClosure.value()) != null) {
                        throw new RuntimeException("Alt/Shift key event is happend.");
                    }
                    if (bl) {
                        StImage stImage = junSpiroDesign.asImageWithParts();
                        if (bl2) {
                            stImage = JunImageAdjuster.Adjust_extent_(stImage, new Dimension(stImage.width() / 2, stImage.height() / 2));
                        }
                        String string = new DecimalFormat("00000000").format(stValueHolder._intValue());
                        File file2 = new File(file, string + ".jpg");
                        JunImageStream junImageStream = null;
                        JunCursors junCursors = new JunCursors(JunCursors.ExecuteCursor());
                        try {
                            junCursors._show();
                            junImageStream = JunJpegImageStream.On_(new FileOutputStream(file2));
                            junImageStream.nextPutImage_(stImage);
                        }
                        catch (IOException iOException) {
                            System.err.println(iOException.getMessage());
                            iOException.printStackTrace();
                        }
                        finally {
                            if (junImageStream != null) {
                                try {
                                    junImageStream.flush();
                                    junImageStream.close();
                                }
                                catch (IOException iOException) {}
                                junImageStream = null;
                            }
                            junCursors._restore();
                        }
                        stValueHolder.value_(stValueHolder._intValue() + 1);
                    }
                    try {
                        Thread.sleep(junSpiroDesign.defaultTickTime());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return null;
                }
            });
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        catch (RuntimeException runtimeException) {
            System.out.println(runtimeException.getMessage());
            runtimeException.printStackTrace();
        }
        finally {
            this.animationState_(false);
            this.changed_(JunSpiroDesign.$((String)"spiroDesign"));
        }
    }

    public Collection spiroLocus() {
        return this.spiroLocusInterim_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                return null;
            }
        });
    }

    public Collection spiroLocusInterim_(final StBlockClosure stBlockClosure) {
        final double d = Math.abs(this.moonCircle().circumference()) < JunGeometry.Accuracy() ? 0.0 : this.teraCircle().circumference() / this.moonCircle().circumference();
        final Jun2dPoint jun2dPoint = this.spiroPen().point().minus_(this.moonCircle().center());
        StInterval stInterval = this.defaultLocusInterval();
        final ArrayList arrayList = new ArrayList(stInterval.size());
        final JunSpiroDesign junSpiroDesign = this;
        stInterval.do_(new StBlockClosure(){

            public Object value_(Object object) {
                int n = ((Number)object).intValue();
                double d2 = (double)n * d;
                if (junSpiroDesign.isInscribe()) {
                    d2 = 0.0 - d2;
                }
                Jun2dPoint jun2dPoint3 = new Jun2dPoint(junSpiroDesign.moonCircle().center().x(), junSpiroDesign.moonCircle().center().y()).transform_(Jun2dTransformation.Rotate_around_(JunAngle.FromDeg_(n), junSpiroDesign.teraCircle().center()));
                Jun2dPoint jun2dPoint2 = new Jun2dPoint(jun2dPoint.x(), jun2dPoint.y()).transform_(Jun2dTransformation.Rotate_around_(JunAngle.FromDeg_(d2 += (double)n), new Jun2dPoint(0.0, 0.0)));
                jun2dPoint2 = jun2dPoint2.plus_(jun2dPoint3);
                jun2dPoint3 = new Jun2dPoint(jun2dPoint3.x(), jun2dPoint3.y());
                jun2dPoint2 = new Jun2dPoint(jun2dPoint2.x(), jun2dPoint2.y());
                arrayList.add(jun2dPoint2);
                if (stBlockClosure != null) {
                    JunSpiroCircle junSpiroCircle = (JunSpiroCircle)junSpiroDesign.teraCircle().copy();
                    JunSpiroCircle junSpiroCircle2 = (JunSpiroCircle)junSpiroDesign.moonCircle().copy();
                    junSpiroCircle2.center_(jun2dPoint3);
                    junSpiroCircle2.angle_(d2);
                    JunSpiroPen junSpiroPen = (JunSpiroPen)junSpiroDesign.spiroPen().copy();
                    junSpiroPen.points_(new ArrayList(arrayList));
                    stBlockClosure.value_value_value_((Object)junSpiroCircle, (Object)junSpiroCircle2, (Object)junSpiroPen);
                }
                Thread.yield();
                return null;
            }
        });
        return arrayList;
    }

    public StMenu updateMenuIndication_(StMenu stMenu) {
        if (stMenu == null) {
            return null;
        }
        StMenuItem stMenuItem = stMenu.atNameKey_(JunSpiroDesign.$((String)"doAnimation"));
        if (stMenuItem != null) {
            if (this.isActiveSpiroDesignProcess()) {
                stMenuItem.beEnabled(false);
            } else {
                stMenuItem.beEnabled(true);
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunSpiroDesign.$((String)"beInscribe"))) != null) {
            if (this.isInscribe()) {
                stMenuItem.beEnabled(false);
            } else {
                stMenuItem.beEnabled(true);
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunSpiroDesign.$((String)"beCircumscribe"))) != null) {
            if (this.isCircumscribe()) {
                stMenuItem.beEnabled(false);
            } else {
                stMenuItem.beEnabled(true);
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunSpiroDesign.$((String)"toggleRainbow"))) != null) {
            if (this.isRainbow()) {
                ((StCheckBoxMenuItem)stMenuItem).beOn();
            } else {
                ((StCheckBoxMenuItem)stMenuItem).beOff();
            }
        }
        return stMenu;
    }

    public void beCircumscribe() {
        this.isCircumscribe = true;
        Jun2dPoint jun2dPoint = this.teraCircle().center();
        Jun2dPoint jun2dPoint2 = this.moonCircle().center();
        Jun2dLine jun2dLine = new Jun2dLine(jun2dPoint, jun2dPoint2).normalized();
        Jun2dPoint jun2dPoint3 = jun2dLine.atT_(this.teraCircle().radius() + this.moonCircle().radius());
        this.moonCircle().center_(jun2dPoint3);
        this.pointOfSpiroPen_(this.spiroPen().point());
        this.changed_(JunSpiroDesign.$((String)"spiroDesign"));
    }

    public void beInscribe() {
        this.isCircumscribe = false;
        Jun2dPoint jun2dPoint = this.teraCircle().center();
        Jun2dPoint jun2dPoint2 = this.moonCircle().center();
        if (this.teraCircle().radius() > this.moonCircle().radius()) {
            Jun2dLine jun2dLine = new Jun2dLine(jun2dPoint, jun2dPoint2).normalized();
            Jun2dPoint jun2dPoint3 = jun2dLine.atT_(this.teraCircle().radius() - this.moonCircle().radius());
            this.moonCircle().center_(jun2dPoint3);
        } else {
            Jun2dLine jun2dLine = new Jun2dLine(jun2dPoint, jun2dPoint2).normalized();
            double d = this.moonCircle().center().distance_(this.teraCircle().center());
            Jun2dPoint jun2dPoint4 = jun2dLine.atT_(d + this.moonCircle().radius());
            this.teraCircle().radius_(jun2dPoint4.distance_(this.teraCircle().center()));
        }
        this.pointOfSpiroPen_(this.spiroPen().point());
        this.changed_(JunSpiroDesign.$((String)"spiroDesign"));
    }

    public void beOneColor() {
        this.spiroPen().rainbow_(false);
        this.changed_(JunSpiroDesign.$((String)"spiroDesign"));
    }

    public void beRainbowColor() {
        this.spiroPen().rainbow_(true);
        this.changed_(JunSpiroDesign.$((String)"spiroDesign"));
    }

    public void choiceNib() {
        Object[] objectArray = (Object[])JunNibChoiceWithColorDialog.Request(JunSpiroDesign.$String((String)"Select nib."), new JunNibChoiceWithColor(new double[]{1.0, 2.0, 3.0, 4.0, 5.0}, this.spiroPen().width(), this.spiroPen().color(), JunSpiroDesign.$((String)"rectangle")));
        if (objectArray == null) {
            return;
        }
        int n = ((Number)objectArray[1]).intValue();
        Color color = (Color)objectArray[2];
        this.spiroPen().width_(n);
        this.spiroPen().color_(color);
        this.beOneColor();
    }

    public synchronized void doAnimation() {
        this._spiroDesignProcess = new JunSpiroDesignAnimationThread(this, this.getSpiroDesignViews(), null){
            MouseListener[] mouseListeners;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    JunSpiroDesignView[] junSpiroDesignViewArray = this.spiroDesignViews();
                    this.mouseListeners = new JunAbstractController[junSpiroDesignViewArray.length];
                    for (int i = 0; i < junSpiroDesignViewArray.length; ++i) {
                        this.mouseListeners[i] = new JunAbstractController(){

                            public void mousePressed(MouseEvent mouseEvent) {
                                (this).JunSpiroDesign.this._spiroDesignProcess.animationSuspend();
                            }

                            public void mouseReleased(MouseEvent mouseEvent) {
                                if (!mouseEvent.isAltDown()) {
                                    (this).JunSpiroDesign.this._spiroDesignProcess.animationStop();
                                } else {
                                    (this).JunSpiroDesign.this._spiroDesignProcess.animationResume();
                                }
                            }
                        };
                        junSpiroDesignViewArray[i].toComponent().addMouseListener(this.mouseListeners[i]);
                    }
                    super.run();
                }
                finally {
                    if (JunSpiroDesign.this._spiroDesignProcess != null) {
                        this.animationStop();
                    }
                }
            }

            public void animationStop() {
                super.animationStop();
                if (this.mouseListeners != null) {
                    JunSpiroDesignView[] junSpiroDesignViewArray = this.spiroDesignViews();
                    for (int i = 0; i < junSpiroDesignViewArray.length; ++i) {
                        junSpiroDesignViewArray[i].toComponent().removeMouseListener(this.mouseListeners[i]);
                    }
                    this.mouseListeners = null;
                }
                JunSpiroDesign junSpiroDesign = JunSpiroDesign.this;
                junSpiroDesign._spiroDesignProcess.yield();
                JunSpiroDesign.this._spiroDesignProcess = null;
                this.spiroDesign().changed_(StSymbol.$((String)"spiroDesign"));
            }
        };
        this._spiroDesignProcess.start();
    }

    public void toggleRainbow() {
        this.rainbow_(!this.rainbow());
        this.changed_(JunSpiroDesign.$((String)"spiroDesign"));
    }

    public void centerOfMoonCircle_(Jun2dPoint jun2dPoint) {
        Jun2dPoint jun2dPoint2 = jun2dPoint.minus_(this.moonCircle().center());
        if (this.isInscribe()) {
            this.moonCircle().center_(jun2dPoint);
            double d = this.moonCircle().center().distance_(this.teraCircle().center());
            this.teraCircle().radius_(d + this.moonCircle().radius());
        } else {
            double d = jun2dPoint.distance_(this.teraCircle().center());
            if (d >= this.moonCircle().radius()) {
                this.moonCircle().center_(jun2dPoint);
                d = this.moonCircle().center().distance_(this.teraCircle().center());
                this.teraCircle().radius_(d - this.moonCircle().radius());
            } else {
                Jun2dPoint jun2dPoint3 = this.teraCircle().center();
                Jun2dPoint jun2dPoint4 = this.moonCircle().center();
                Jun2dLine jun2dLine = new Jun2dLine(jun2dPoint3, jun2dPoint4).normalized();
                Jun2dPoint jun2dPoint5 = jun2dLine.atT_(this.moonCircle().radius());
                this.moonCircle().center_(jun2dPoint5);
                this.teraCircle().radius_(0.0);
                jun2dPoint2 = jun2dPoint5.minus_(this.moonCircle().center());
            }
        }
        this.pointOfSpiroPen_(this.spiroPen().point().plus_(jun2dPoint2));
        this.changed_(JunSpiroDesign.$((String)"spiroDesign"));
    }

    public void centerOfTeraCircle_(Jun2dPoint jun2dPoint) {
        Jun2dPoint jun2dPoint2 = jun2dPoint.minus_(this.teraCircle().center());
        this.moonCircle().center_(this.moonCircle().center().plus_(jun2dPoint2));
        this.teraCircle().center_(jun2dPoint);
        this.pointOfSpiroPen_(this.spiroPen().point().plus_(jun2dPoint2));
        this.changed_(JunSpiroDesign.$((String)"spiroDesign"));
    }

    public void pointOfSpiroPen_(Jun2dPoint jun2dPoint) {
        double d = this.moonCircle().radius();
        Jun2dPoint jun2dPoint2 = this.moonCircle().center();
        Jun2dPoint jun2dPoint3 = null;
        if (jun2dPoint.distance_(jun2dPoint2) > d) {
            Jun2dLine jun2dLine = new Jun2dLine(jun2dPoint2, jun2dPoint).normalized();
            jun2dPoint3 = jun2dLine.atT_(d);
        } else {
            jun2dPoint3 = jun2dPoint;
        }
        this.spiroPen().point_(jun2dPoint3);
        this.changed_(JunSpiroDesign.$((String)"spiroDesign"));
    }

    public void radiusOfMoonCircle_(double d) {
        double d2 = this.moonCircle().center().distance_(this.teraCircle().center());
        if (this.isInscribe()) {
            this.moonCircle().radius_(d);
            this.teraCircle().radius_(d2 + this.moonCircle().radius());
        } else {
            this.moonCircle().radius_(Math.min(d, d2));
            this.teraCircle().radius_(d2 - this.moonCircle().radius());
        }
        this.pointOfSpiroPen_(this.spiroPen().point());
        this.changed_(JunSpiroDesign.$((String)"spiroDesign"));
    }

    public void radiusOfTeraCircle_(double d) {
        double d2 = this.moonCircle().center().distance_(this.teraCircle().center());
        if (this.isInscribe()) {
            this.teraCircle().radius_(Math.max(d, d2));
            this.moonCircle().radius_(this.teraCircle().radius() - d2);
        } else {
            this.teraCircle().radius_(Math.min(d, d2));
            this.moonCircle().radius_(d2 - this.teraCircle().radius());
        }
        this.pointOfSpiroPen_(this.spiroPen().point());
        this.changed_(JunSpiroDesign.$((String)"spiroDesign"));
    }

    protected void setMoonCircle_(JunSpiroCircle junSpiroCircle) {
        this.moonCircle = junSpiroCircle;
        this.isCircumscribe = this.teraCircle().center().distance_(this.moonCircle().center()) > this.teraCircle().radius();
    }

    protected void setSpiroPen_(JunSpiroPen junSpiroPen) {
        this.spiroPen = junSpiroPen;
    }

    protected void setTeraCircle_(JunSpiroCircle junSpiroCircle) {
        this.teraCircle = junSpiroCircle;
    }

    public boolean isActiveSpiroDesignProcess() {
        return false;
    }

    public boolean isCircumscribe() {
        return this.isCircumscribe;
    }

    public boolean isInscribe() {
        return !this.isCircumscribe();
    }

    public boolean isRainbow() {
        return this.spiroPen().isRainbow();
    }

    public boolean containsPoint_(Point point) {
        if (!this.bounds().contains(point)) {
            return false;
        }
        double d = this.teraCircle().center().distance_(new Jun2dPoint(point));
        if (this.isInscribe()) {
            if (d > this.teraCircle().radius()) {
                return false;
            }
            if (d < this.teraCircle().radius() - this.moonCircle().radius() * 2.0) {
                return false;
            }
        } else {
            if (d < this.teraCircle().radius()) {
                return false;
            }
            if (d > this.teraCircle().radius() + this.moonCircle().radius() * 2.0) {
                return false;
            }
        }
        return true;
    }

    protected void applyAttributesToGraphicsContext_(Graphics2D graphics2D) {
        graphics2D.setColor(Color.green);
        graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public StPopupMenu _popupMenu() {
        if (this._popupMenu == null) {
            this._popupMenu = new StPopupMenu();
            this._popupMenu.add(new StMenuItem((Object)JunSpiroDesign.$String((String)"Animation"), JunSpiroDesign.$((String)"doAnimation"), (MenuListener)new MenuPerformer((StObject)this, "doAnimation")));
            this._popupMenu.addSeparator();
            this._popupMenu.add(new StMenuItem((Object)JunSpiroDesign.$String((String)"Inscribe"), JunSpiroDesign.$((String)"beInscribe"), (MenuListener)new MenuPerformer((StObject)this, "beInscribe")));
            this._popupMenu.add(new StMenuItem((Object)JunSpiroDesign.$String((String)"Circumscribe"), JunSpiroDesign.$((String)"beCircumscribe"), (MenuListener)new MenuPerformer((StObject)this, "beCircumscribe")));
            this._popupMenu.addSeparator();
            this._popupMenu.add((StMenuItem)new StCheckBoxMenuItem((Object)JunSpiroDesign.$String((String)"Rainbow"), JunSpiroDesign.$((String)"toggleRainbow"), (MenuListener)new MenuPerformer((StObject)this, "toggleRainbow")));
            this._popupMenu.add(new StMenuItem((Object)JunSpiroDesign.$String((String)"Choice nib"), JunSpiroDesign.$((String)"choiceNib"), (MenuListener)new MenuPerformer((StObject)this, "choiceNib")));
            this._popupMenu.add(new StMenuItem((Object)JunSpiroDesign.$String((String)"Spawn as image"), JunSpiroDesign.$((String)"spawnAsImage"), (MenuListener)new MenuPerformer((StObject)this, "spawnAsImage")));
        }
        return (StPopupMenu)this.updateMenuIndication_((StMenu)this._popupMenu);
    }
}

