/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.track;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import jp.co.sra.jun.goodies.track.JunSimpleSliderController;
import jp.co.sra.jun.goodies.track.JunSimpleSliderModel;
import jp.co.sra.jun.goodies.track.JunSimpleSliderView;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;

public class JunSimpleSliderViewSwing
extends JunAbstractViewJPanel
implements JunSimpleSliderView {
    protected StRectangle sliderRectangle;
    protected StRectangle savedSliderRectangle;

    public JunSimpleSliderViewSwing() {
    }

    public JunSimpleSliderViewSwing(JunSimpleSliderModel junSimpleSliderModel) {
        super(junSimpleSliderModel);
    }

    public void displayOn_(Graphics graphics) {
        if (!this.isShowing()) {
            return;
        }
        this.displayBackgroundOn_(graphics);
        this.displaySliderOn_(graphics);
    }

    public void displaySliderOn_(Graphics graphics) {
        StRectangle stRectangle = this.sliderRectangle();
        Polygon polygon = new Polygon();
        polygon.addPoint(stRectangle.left(), stRectangle.bottom());
        polygon.addPoint(stRectangle.right(), stRectangle.bottom());
        polygon.addPoint(stRectangle.center().x, stRectangle.center().y - 1);
        graphics.setColor(Gray20);
        graphics.fillPolygon(polygon);
        this.savedSliderRectangle = stRectangle;
    }

    public JunSimpleSliderModel getModel() {
        return (JunSimpleSliderModel)this.model();
    }

    public JunSimpleSliderModel getSimpleSliderModel() {
        return (JunSimpleSliderModel)this.model();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.flushSliderRectangles();
    }

    public void setModel(JunSimpleSliderModel junSimpleSliderModel) {
        this.model_((StModel)junSimpleSliderModel);
    }

    public void setModelValue_(int n, int n2) {
        StRectangle stRectangle = this.sliderArea();
        stRectangle = stRectangle.insetBy_(new StRectangle(0, 0, 1, 1));
        double d = (double)(n - stRectangle.originX()) / (double)stRectangle.width();
        this.getSimpleSliderModel().value_(Math.max(0.0, Math.min(d, 1.0)));
    }

    public StRectangle sliderArea() {
        return new StRectangle(this.getSize()).insetBy_(this.margin());
    }

    public StRectangle sliderRectangle() {
        if (this.sliderRectangle == null) {
            this.sliderRectangle = this.sliderRectangleForValue_(this.getSimpleSliderModel().doubleValue());
        }
        return this.sliderRectangle;
    }

    public void update_(DependentEvent dependentEvent) {
        if (!this.isShowing()) {
            return;
        }
        StSymbol stSymbol = dependentEvent.getAspect();
        if (stSymbol == JunSimpleSliderViewSwing.$((String)"value")) {
            this.sliderRectangle = null;
            StRectangle stRectangle = this.sliderRectangle();
            if (!stRectangle.equals((Object)this.savedSliderRectangle)) {
                if (this.savedSliderRectangle != null) {
                    stRectangle = stRectangle.merge_(this.savedSliderRectangle);
                }
                this.repaint(stRectangle.originX(), stRectangle.originY(), stRectangle.width(), stRectangle.height());
            }
        } else {
            super.update_(dependentEvent);
        }
    }

    protected void buildComponent() {
        this.setPreferredSize(new Dimension(150, 20));
    }

    protected StController defaultController() {
        return new JunSimpleSliderController();
    }

    protected StModel defaultModel() {
        return new JunSimpleSliderModel();
    }

    protected void displayBackgroundOn_(Graphics graphics) {
        StRectangle stRectangle = new StRectangle(this.getSize());
        graphics.clipRect(stRectangle.left(), stRectangle.top(), stRectangle.right(), stRectangle.bottom());
        graphics.setColor(Gray70);
        graphics.fillRect(stRectangle.left(), stRectangle.top(), stRectangle.right(), stRectangle.bottom());
        graphics.drawRect(stRectangle.left(), stRectangle.top(), stRectangle.right(), stRectangle.bottom());
        graphics.setColor(Gray80);
        graphics.drawLine(stRectangle.left(), stRectangle.top(), stRectangle.right() - 1, stRectangle.top());
        graphics.drawLine(stRectangle.left(), stRectangle.top(), stRectangle.left(), stRectangle.bottom() - 1);
        graphics.setColor(Gray20);
        graphics.drawLine(stRectangle.left(), stRectangle.bottom() - 1, stRectangle.right() - 1, stRectangle.bottom() - 1);
        graphics.drawLine(stRectangle.right() - 1, stRectangle.top(), stRectangle.right() - 1, stRectangle.bottom() - 1);
        stRectangle = this.sliderArea();
        graphics.setColor(Gray80);
        graphics.drawLine(stRectangle.left() + 1, stRectangle.top() + 1, stRectangle.left() + 1, stRectangle.bottom() - 1);
        graphics.drawLine(stRectangle.left(), stRectangle.center().y, stRectangle.right() - 1, stRectangle.center().y);
        graphics.drawLine(stRectangle.right(), stRectangle.top(), stRectangle.right(), stRectangle.bottom() - 1);
        graphics.setColor(Gray20);
        graphics.drawLine(stRectangle.left(), stRectangle.top(), stRectangle.left(), stRectangle.bottom() - 1);
        graphics.drawLine(stRectangle.left() + 1, stRectangle.center().y - 1, stRectangle.right() - 1, stRectangle.center().y - 1);
        graphics.drawLine(stRectangle.right() - 1, stRectangle.top() + 1, stRectangle.right() - 1, stRectangle.bottom() - 1);
    }

    protected void flushSliderRectangles() {
        this.sliderRectangle = null;
        this.savedSliderRectangle = null;
    }

    protected void initialize() {
        this.flushSliderRectangles();
    }

    protected StRectangle margin() {
        return new StRectangle(6, 4, 6, 4);
    }

    protected StRectangle sliderRectangleForValue_(double d) {
        StRectangle stRectangle = this.sliderArea();
        stRectangle = stRectangle.insetBy_(new StRectangle(0, 0, 1, 1));
        int n = (int)Math.round((double)stRectangle.width() * d) + stRectangle.originX();
        StRectangle stRectangle2 = new StRectangle(n, stRectangle.top(), n, stRectangle.bottom());
        stRectangle2 = stRectangle2.expandedBy_(new StRectangle(this.margin().left() - 2, 0, this.margin().right() - 2, 1));
        return stRectangle2;
    }
}

