/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.track;

import java.io.IOException;
import java.io.Writer;
import jp.co.sra.jun.goodies.track.JunTrackSliderViewAwt;
import jp.co.sra.jun.goodies.track.JunTrackSliderViewSwing;
import jp.co.sra.jun.goodies.track.JunTrackerModel;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StBlockValue;
import jp.co.sra.smalltalk.StBlockValued;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

public class JunTrackSliderModel
extends JunApplicationModel
implements StBlockValued {
    protected StValueHolder valueHolder;
    protected StValueHolder intervalHolder;
    protected double[] intervalBounds;
    protected boolean fixFirstMarker;
    protected boolean fixLastMarker;
    protected boolean useMarkers;
    protected StPopupMenu enabledPopupMenu;
    protected StPopupMenu disabledPopupMenu;
    protected JunTrackerModel parentTracker;

    public JunTrackSliderModel() {
        this.initialize();
    }

    protected void initialize() {
        super.initialize();
        this.valueHolder = null;
        this.intervalHolder = null;
        this.intervalBounds = null;
        this.fixFirstMarker = false;
        this.fixLastMarker = false;
        this.useMarkers = false;
        this.enabledPopupMenu = null;
        this.disabledPopupMenu = null;
        this.parentTracker = null;
        this.valueHolder();
        this.intervalHolder();
    }

    public JunTrackSliderModel childTracker() {
        return null;
    }

    public void disableMarkers() {
        this.useMarkers = false;
        if (this.parentTracker() == null) {
            this.changed_(JunTrackSliderModel.$((String)"useMarkers"));
        }
    }

    public double doubleValue() {
        return ((Number)this.value()).doubleValue();
    }

    public void enableMarkers() {
        this.useMarkers = true;
        if (this.parentTracker() == null) {
            this.changed_(JunTrackSliderModel.$((String)"useMarkers"));
        }
    }

    public double firstMarker() {
        return this.interval()[0];
    }

    public void firstMarker_(double d) {
        if (!this.fixFirstMarker()) {
            double d2 = Math.min(d, this.lastMarker());
            d2 = Math.max(d2, this.intervalBounds()[0]);
            d2 = Math.min(d2, this.intervalBounds()[1]);
            this.interval_(new double[]{d2, this.lastMarker()});
        }
    }

    public boolean fixFirstMarker() {
        return this.fixFirstMarker;
    }

    public void fixFirstMarker_(boolean bl) {
        this.fixFirstMarker = bl;
    }

    public boolean fixLastMarker() {
        return this.fixLastMarker;
    }

    public void fixLastMarker_(boolean bl) {
        this.fixLastMarker = bl;
    }

    public double[] interval() {
        return (double[])this.intervalHolder().value();
    }

    public void interval_(double[] dArray) {
        this.intervalHolder().value_((Object)this.adjustInterval_(dArray));
        this.changed_(JunTrackSliderModel.$((String)"interval"));
    }

    public double lastMarker() {
        return this.interval()[1];
    }

    public void lastMarker_(double d) {
        if (!this.fixLastMarker()) {
            double d2 = Math.max(d, this.firstMarker());
            d2 = Math.max(d2, this.intervalBounds()[0]);
            d2 = Math.min(d2, this.intervalBounds()[1]);
            this.interval_(new double[]{this.firstMarker(), d2});
        }
    }

    public JunTrackerModel parentTracker() {
        return this.parentTracker;
    }

    public void parentTracker_(JunTrackerModel junTrackerModel) {
        this.parentTracker = junTrackerModel;
        junTrackerModel.childTracker_(this);
    }

    public Object value() {
        return this.valueHolder.value();
    }

    public void value_(double d) {
        this.valueHolder.value_(Math.max(0.0, Math.min(d, 1.0)));
        this.changed_(JunTrackSliderModel.$((String)"value"));
    }

    public StValueHolder valueHolder() {
        if (this.valueHolder == null) {
            this.valueHolder = new StValueHolder(0.0);
        }
        return this.valueHolder;
    }

    public StValueHolder intervalHolder() {
        if (this.intervalHolder == null) {
            this.intervalHolder = new StValueHolder((Object)new double[]{0.0, 0.0});
        }
        return this.intervalHolder;
    }

    public StBlockValue compute_(StBlockClosure stBlockClosure) {
        return new StBlockValue(stBlockClosure, (StBlockValued)this);
    }

    public StView defaultView() {
        if (JunTrackSliderModel.GetDefaultViewMode() == 0) {
            return new JunTrackSliderViewAwt(this);
        }
        return new JunTrackSliderViewSwing(this);
    }

    protected String windowTitle() {
        return JunTrackSliderModel.$String((String)"Track Slider");
    }

    public void flushMarkers() {
        this.lastMarker_(0.0);
    }

    public void selectAll() {
        this.lastMarker_(1.0);
        this.firstMarker_(0.0);
    }

    public void setFirstMarker() {
        this.firstMarker_(this.doubleValue());
    }

    public void setLastMarker() {
        this.lastMarker_(this.doubleValue());
    }

    public void printOn_(Writer writer) throws IOException {
        super.printOn_(writer);
        writer.write(" (");
        writer.write(String.valueOf(this.value()));
        writer.write(41);
    }

    public boolean areMarkersActive() {
        return this.useMarkers;
    }

    public boolean isIntervalNotEmpty() {
        return this.areMarkersActive() && this.firstMarker() < this.lastMarker();
    }

    public StPopupMenu _popupMenu() {
        if (this.parentTracker() != null) {
            return this.parentTracker()._popupMenu();
        }
        if (this.areMarkersActive()) {
            StMenuItem stMenuItem;
            if (this.enabledPopupMenu == null) {
                this.enabledPopupMenu = this._createEnabledPopupMenu();
            }
            if ((stMenuItem = this.enabledPopupMenu.atNameKey_(JunTrackSliderModel.$((String)"flushMarkers"))) != null) {
                stMenuItem.beEnabled(this.isIntervalNotEmpty());
            }
            return this.enabledPopupMenu;
        }
        if (this.disabledPopupMenu == null) {
            this.disabledPopupMenu = this._createDisabledPopupMenu();
        }
        return this.disabledPopupMenu;
    }

    protected StPopupMenu _createDisabledPopupMenu() {
        StPopupMenu stPopupMenu = new StPopupMenu();
        stPopupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Enable markers"), (MenuListener)new MenuPerformer((StObject)this, "enableMarkers")));
        return stPopupMenu;
    }

    protected StPopupMenu _createEnabledPopupMenu() {
        StPopupMenu stPopupMenu = new StPopupMenu();
        stPopupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Select all"), (MenuListener)new MenuPerformer((StObject)this, "selectAll")));
        stPopupMenu.addSeparator();
        stPopupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Set first marker"), (MenuListener)new MenuPerformer((StObject)this, "setFirstMarker")));
        stPopupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Set last marker"), (MenuListener)new MenuPerformer((StObject)this, "setLastMarker")));
        stPopupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Flush markers"), JunTrackSliderModel.$((String)"flushMarkers"), (MenuListener)new MenuPerformer((StObject)this, "flushMarkers")));
        stPopupMenu.addSeparator();
        stPopupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Disable markers"), (MenuListener)new MenuPerformer((StObject)this, "disableMarkers")));
        return stPopupMenu;
    }

    protected double[] adjustInterval_(double[] dArray) {
        double d = Math.min(dArray[0], dArray[1]);
        double d2 = Math.max(dArray[0], dArray[1]);
        d = Math.max(0.0, Math.min(d, 1.0));
        d2 = Math.max(d, Math.min(d2, 1.0));
        return new double[]{d, d2};
    }

    protected double[] intervalBounds() {
        if (this.intervalBounds == null) {
            this.intervalBounds = new double[]{0.0, 1.0};
        }
        return this.intervalBounds;
    }

    protected void intervalBounds_(double[] dArray) {
        this.intervalBounds = this.adjustInterval_(dArray);
        this.changed_(JunTrackSliderModel.$((String)"intervalBounds"));
    }
}

