/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.wavelet;

import jp.co.sra.jun.collections.sequences.JunDoubleMatrix;
import jp.co.sra.jun.goodies.wavelet.JunDiscreteWavelet1dTransformation;
import jp.co.sra.jun.goodies.wavelet.JunDiscreteWaveletTransformation;
import jp.co.sra.jun.goodies.wavelet.JunWaveletTransformation;
import jp.co.sra.smalltalk.StObject;

public class JunDiscreteWavelet2dTransformation
extends JunDiscreteWaveletTransformation {
    protected JunDoubleMatrix sourceCoefficients;
    protected JunDoubleMatrix scalingCoefficients;
    protected JunDoubleMatrix[] waveletCoefficients;
    protected JunDoubleMatrix recomposedCoefficients;

    public JunDiscreteWavelet2dTransformation(JunDoubleMatrix junDoubleMatrix) {
        this.sourceCoefficients_(junDoubleMatrix);
    }

    public JunDiscreteWavelet2dTransformation(JunDoubleMatrix junDoubleMatrix, JunDoubleMatrix[] junDoubleMatrixArray) {
        this.scalingCoefficients_(junDoubleMatrix);
        this.waveletCoefficients_(junDoubleMatrixArray);
    }

    protected void initialize() {
        super.initialize();
        this.sourceCoefficients = null;
        this.scalingCoefficients = null;
        this.waveletCoefficients = null;
        this.recomposedCoefficients = null;
    }

    public JunDoubleMatrix recomposedCoefficients() {
        if (this.recomposedCoefficients == null) {
            this.computeRecomposedCoefficients();
        }
        return this.recomposedCoefficients;
    }

    public JunDoubleMatrix scalingCoefficients() {
        if (this.scalingCoefficients == null) {
            this.computeScalingAndWaveletCoefficients();
        }
        return this.scalingCoefficients;
    }

    public void scalingCoefficients_(JunDoubleMatrix junDoubleMatrix) {
        this.scalingCoefficients = junDoubleMatrix;
        this.recomposedCoefficients = null;
    }

    public JunDoubleMatrix sourceCoefficients() {
        return this.sourceCoefficients;
    }

    public void sourceCoefficients_(JunDoubleMatrix junDoubleMatrix) {
        this.sourceCoefficients = junDoubleMatrix;
        this.scalingCoefficients = null;
        this.recomposedCoefficients = null;
    }

    public JunDoubleMatrix[] waveletCoefficients() {
        if (this.waveletCoefficients == null) {
            this.computeScalingAndWaveletCoefficients();
        }
        return this.waveletCoefficients;
    }

    public void waveletCoefficients_(JunDoubleMatrix[] junDoubleMatrixArray) {
        this.waveletCoefficients = junDoubleMatrixArray;
        this.recomposedCoefficients = null;
    }

    public JunDoubleMatrix diagonalWaveletCoefficients() {
        return this.waveletCoefficients()[2];
    }

    public JunDoubleMatrix horizontalWaveletCoefficients() {
        return this.waveletCoefficients()[0];
    }

    public JunDoubleMatrix verticalWaveletCoefficients() {
        return this.waveletCoefficients()[1];
    }

    public JunWaveletTransformation applyTo_(Object object) {
        if (!(object instanceof JunDoubleMatrix)) {
            throw new IllegalArgumentException("anObject must be a JunDoubleMatrix.");
        }
        this.sourceCoefficients_((JunDoubleMatrix)((Object)object));
        this.scalingCoefficients();
        this.waveletCoefficients();
        return this;
    }

    public JunWaveletTransformation transform_(JunWaveletTransformation junWaveletTransformation) {
        if (!(junWaveletTransformation instanceof JunDiscreteWavelet2dTransformation)) {
            throw new IllegalArgumentException("waveletTransformation must be a JunDiscreteWavelet2dTransformation.");
        }
        JunDiscreteWavelet2dTransformation junDiscreteWavelet2dTransformation = (JunDiscreteWavelet2dTransformation)junWaveletTransformation;
        return (JunWaveletTransformation)((Object)JunDiscreteWavelet2dTransformation._New(((Object)((Object)this)).getClass(), (Object)((Object)(junDiscreteWavelet2dTransformation.sourceCoefficients() == null ? junDiscreteWavelet2dTransformation.recomposedCoefficients() : null))));
    }

    protected void computeRecomposedCoefficients() {
        if (this.scalingCoefficients == null) {
            return;
        }
        if (this.waveletCoefficients == null) {
            return;
        }
        int n = this.scalingCoefficients.rowSize();
        int n2 = n * 2;
        int n3 = this.scalingCoefficients.columnSize();
        int n4 = n3 * 2;
        JunDoubleMatrix junDoubleMatrix = (JunDoubleMatrix)this.scalingCoefficients.transpose();
        JunDoubleMatrix junDoubleMatrix2 = (JunDoubleMatrix)this.horizontalWaveletCoefficients().transpose();
        JunDoubleMatrix junDoubleMatrix3 = (JunDoubleMatrix)this.verticalWaveletCoefficients().transpose();
        JunDoubleMatrix junDoubleMatrix4 = (JunDoubleMatrix)this.diagonalWaveletCoefficients().transpose();
        JunDoubleMatrix junDoubleMatrix5 = new JunDoubleMatrix(n3, n2);
        JunDoubleMatrix junDoubleMatrix6 = new JunDoubleMatrix(n3, n2);
        for (int i = 0; i < n3; ++i) {
            JunDiscreteWavelet1dTransformation junDiscreteWavelet1dTransformation = new JunDiscreteWavelet1dTransformation(junDoubleMatrix._doubleValuesBasicAt_(i), junDoubleMatrix2._doubleValuesBasicAt_(i));
            junDoubleMatrix5.basicAt_put_(i, junDiscreteWavelet1dTransformation.recomposedCoefficients());
            junDiscreteWavelet1dTransformation = new JunDiscreteWavelet1dTransformation(junDoubleMatrix3._doubleValuesBasicAt_(i), junDoubleMatrix4._doubleValuesBasicAt_(i));
            junDoubleMatrix6.basicAt_put_(i, junDiscreteWavelet1dTransformation.recomposedCoefficients());
        }
        junDoubleMatrix5 = (JunDoubleMatrix)junDoubleMatrix5.transpose();
        junDoubleMatrix6 = (JunDoubleMatrix)junDoubleMatrix6.transpose();
        JunDoubleMatrix junDoubleMatrix7 = new JunDoubleMatrix(n2, n4);
        for (int i = 0; i < n2; ++i) {
            JunDiscreteWavelet1dTransformation junDiscreteWavelet1dTransformation = new JunDiscreteWavelet1dTransformation(junDoubleMatrix5._doubleValuesBasicAt_(i), junDoubleMatrix6._doubleValuesBasicAt_(i));
            junDoubleMatrix7.basicAt_put_(i, junDiscreteWavelet1dTransformation.recomposedCoefficients());
        }
        this.recomposedCoefficients = junDoubleMatrix7;
    }

    protected void computeScalingAndWaveletCoefficients() {
        StObject stObject;
        if (this.sourceCoefficients == null) {
            return;
        }
        int n = this.sourceCoefficients.rowSize();
        int n2 = n / 2;
        int n3 = this.sourceCoefficients.columnSize();
        int n4 = n3 / 2;
        JunDoubleMatrix junDoubleMatrix = new JunDoubleMatrix(n, n4);
        JunDoubleMatrix junDoubleMatrix2 = new JunDoubleMatrix(n, n4);
        for (int i = 0; i < n; ++i) {
            stObject = new JunDiscreteWavelet1dTransformation(this.sourceCoefficients._doubleValuesBasicAt_(i));
            junDoubleMatrix.basicAt_put_(i, stObject.scalingCoefficients());
            junDoubleMatrix2.basicAt_put_(i, stObject.waveletCoefficients());
        }
        junDoubleMatrix = (JunDoubleMatrix)junDoubleMatrix.transpose();
        junDoubleMatrix2 = (JunDoubleMatrix)junDoubleMatrix2.transpose();
        JunDoubleMatrix junDoubleMatrix3 = new JunDoubleMatrix(n4, n2);
        stObject = new JunDoubleMatrix(n4, n2);
        JunDoubleMatrix junDoubleMatrix4 = new JunDoubleMatrix(n4, n2);
        JunDoubleMatrix junDoubleMatrix5 = new JunDoubleMatrix(n4, n2);
        for (int i = 0; i < n4; ++i) {
            JunDiscreteWavelet1dTransformation junDiscreteWavelet1dTransformation = new JunDiscreteWavelet1dTransformation(junDoubleMatrix._doubleValuesBasicAt_(i));
            junDoubleMatrix3.basicAt_put_(i, junDiscreteWavelet1dTransformation.scalingCoefficients());
            stObject.basicAt_put_(i, junDiscreteWavelet1dTransformation.waveletCoefficients());
            junDiscreteWavelet1dTransformation = new JunDiscreteWavelet1dTransformation(junDoubleMatrix2._doubleValuesBasicAt_(i));
            junDoubleMatrix4.basicAt_put_(i, junDiscreteWavelet1dTransformation.scalingCoefficients());
            junDoubleMatrix5.basicAt_put_(i, junDiscreteWavelet1dTransformation.waveletCoefficients());
        }
        junDoubleMatrix3 = (JunDoubleMatrix)junDoubleMatrix3.transpose();
        stObject = (JunDoubleMatrix)stObject.transpose();
        junDoubleMatrix4 = (JunDoubleMatrix)junDoubleMatrix4.transpose();
        junDoubleMatrix5 = (JunDoubleMatrix)junDoubleMatrix5.transpose();
        this.scalingCoefficients = junDoubleMatrix3;
        this.waveletCoefficients = new JunDoubleMatrix[]{stObject, junDoubleMatrix4, junDoubleMatrix5};
    }
}

