/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.graphics.navigator;

import java.util.LinkedList;
import jp.co.sra.jun.graphics.list.JunFileList;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.smalltalk.StBlockClosure;

public class JunFileListDispenser
extends JunAbstractObject {
    protected int cacheSize;
    protected LinkedList cachedFileLists;
    public static JunFileListDispenser SoleFileListDispenser;

    public static void FlushSole() {
        SoleFileListDispenser = null;
    }

    public static JunFileListDispenser Default() {
        if (SoleFileListDispenser == null) {
            SoleFileListDispenser = new JunFileListDispenser();
        }
        return SoleFileListDispenser;
    }

    protected static int DefaultCacheSize() {
        return 32;
    }

    private JunFileListDispenser() {
        this(JunFileListDispenser.DefaultCacheSize());
    }

    private JunFileListDispenser(int n) {
        this.cacheSize_(n);
    }

    protected synchronized void initialize() {
        super.initialize();
        this.cachedFileLists = null;
        this.cacheSize = 0;
    }

    public synchronized JunFileList at_(JunFileList junFileList) {
        return this.at_ifAbsent_(junFileList, new StBlockClosure(){

            public Object value() {
                return null;
            }
        });
    }

    public synchronized JunFileList at_ifAbsent_(JunFileList junFileList, StBlockClosure stBlockClosure) {
        int n = this.cachedFileLists().indexOf((Object)junFileList);
        if (n > 0) {
            return (JunFileList)((Object)this.cachedFileLists().get(n));
        }
        return (JunFileList)((Object)stBlockClosure.value());
    }

    public synchronized boolean includes_(JunFileList junFileList) {
        return this.cachedFileLists().contains((Object)junFileList);
    }

    public synchronized void add_(JunFileList junFileList) {
        if (junFileList.isDirectory() && !junFileList.isRoot() && !this.includes_(junFileList)) {
            JunFileList junFileList2 = (JunFileList)junFileList.copy();
            if (this.cachedFileLists().size() >= this.cacheSize()) {
                this.cachedFileLists().removeLast();
            }
            this.cachedFileLists().addFirst(junFileList2);
        }
    }

    public synchronized void remove_(JunFileList junFileList) {
        JunFileList junFileList2;
        if (junFileList.isDirectory() && (junFileList2 = this.at_(junFileList)) != null) {
            this.cachedFileLists().remove((Object)junFileList2);
        }
    }

    public int cacheSize() {
        if (this.cacheSize <= 0) {
            this.cacheSize = JunFileListDispenser.DefaultCacheSize();
        }
        return this.cacheSize;
    }

    public void cacheSize_(int n) {
        this.cacheSize = Math.max(1, n);
    }

    public synchronized LinkedList cachedFileLists() {
        if (this.cachedFileLists == null) {
            this.cachedFileLists = new LinkedList();
        }
        return this.cachedFileLists;
    }

    public synchronized void flushCachedFileLists() {
        this.cachedFileLists = null;
    }

    static {
        JunFileListDispenser.FlushSole();
    }
}

