/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.graphics.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.SwingUtilities;
import jp.co.sra.jun.goodies.button.JunButtonViewAwt;
import jp.co.sra.jun.graphics.framework.JunGraphicViewAwt;
import jp.co.sra.jun.graphics.list.JunSequenceListViewAwt;
import jp.co.sra.jun.graphics.navigator.JunEmbeddedFileListViewAwt;
import jp.co.sra.jun.graphics.navigator.JunFileNavigator;
import jp.co.sra.jun.graphics.navigator.JunFileNavigatorView;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.WindowSpecLayout;

public class JunFileNavigatorViewAwt
extends JunGraphicViewAwt
implements JunFileNavigatorView {
    protected JunSequenceListViewAwt centerView;
    protected JunSequenceListViewAwt leftView;
    protected JunSequenceListViewAwt rightView;
    protected JunButtonViewAwt homeButtonView;
    protected Label currentFileName;
    protected Label statusLabel;

    public JunFileNavigatorViewAwt(JunFileNavigator junFileNavigator) {
        super(junFileNavigator);
    }

    public JunFileNavigator getFileNavigator() {
        return (JunFileNavigator)this.model();
    }

    protected void buildComponent() {
        this.setLayout((LayoutManager)new WindowSpecLayout());
        this.add((Component)((Object)this.homeButtonView()), WindowSpecLayout.Position((float)0.0f, (int)1, (float)0.0f, (int)1, (float)0.0f, (int)25, (float)0.0f, (int)25));
        this.add(this.currentFileNameWithBorder(), WindowSpecLayout.Position((float)0.0f, (int)26, (float)0.0f, (int)1, (float)1.0f, (int)-1, (float)0.0f, (int)25));
        this.add((Component)((Object)this.leftView()), WindowSpecLayout.Position((float)0.0f, (int)1, (float)0.0f, (int)26, (float)0.32f, (int)-1, (float)1.0f, (int)-21));
        this.add((Component)((Object)this.centerView()), WindowSpecLayout.Position((float)0.32f, (int)0, (float)0.0f, (int)26, (float)0.68f, (int)0, (float)1.0f, (int)-21));
        this.add((Component)((Object)this.rightView()), WindowSpecLayout.Position((float)0.68f, (int)1, (float)0.0f, (int)26, (float)1.0f, (int)-1, (float)1.0f, (int)-21));
        this.add(this.statusLabel(), WindowSpecLayout.Position((float)0.0f, (int)1, (float)1.0f, (int)-20, (float)1.0f, (int)-1, (float)1.0f, (int)-1));
        this.setSize(500, 300);
    }

    protected JunSequenceListViewAwt centerView() {
        if (this.centerView == null) {
            this.centerView = new JunEmbeddedFileListViewAwt(this.getFileNavigator().centerList());
        }
        return this.centerView;
    }

    protected JunSequenceListViewAwt leftView() {
        if (this.leftView == null) {
            this.leftView = new JunEmbeddedFileListViewAwt(this.getFileNavigator().leftList());
            this.leftView.setVisible(!this.getFileNavigator().isLeftEnd());
        }
        return this.leftView;
    }

    protected JunSequenceListViewAwt rightView() {
        if (this.rightView == null) {
            this.rightView = new JunSequenceListViewAwt(this.getFileNavigator().rightList());
        }
        return this.rightView;
    }

    protected JunButtonViewAwt homeButtonView() {
        if (this.homeButtonView == null) {
            this.homeButtonView = new JunButtonViewAwt(this.getFileNavigator().homeButton());
        }
        return this.homeButtonView;
    }

    protected Label currentFileName() {
        if (this.currentFileName == null) {
            this.currentFileName = new Label();
            this.currentFileName.setFocusable(false);
            if (this.getFileNavigator().currentFileHolder().value() != null) {
                this.currentFileName.setText(this.getFileNavigator().currentFileAsString());
            }
            this.getFileNavigator().currentFileHolder().compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunFileNavigatorViewAwt.this.currentFileName.setText(JunFileNavigatorViewAwt.this.getFileNavigator().currentFileAsString());
                    return null;
                }
            });
        }
        return this.currentFileName;
    }

    protected Component currentFileNameWithBorder() {
        Panel panel = new Panel(){

            public Insets getInsets() {
                return new Insets(0, 10, 0, 0);
            }
        };
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.currentFileName(), "Center");
        return panel;
    }

    protected Label statusLabel() {
        if (this.statusLabel == null) {
            this.statusLabel = new Label(this.getFileNavigator().currentStatus());
            this.statusLabel.setAlignment(1);
        }
        return this.statusLabel;
    }

    public void addNotify() {
        super.addNotify();
        this.topComponent().addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                JunFileNavigatorViewAwt.this.getFileNavigator().fixScrollingOffset();
            }
        });
    }

    public void _setupKeyboard(final Window window) {
        KeyListener keyListener = this.centerView().getSequenceList()._keyListener();
        if (keyListener == null) {
            return;
        }
        this.centerView().addKeyListener(keyListener);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                if (window.isActive() && window.getFocusOwner() != JunFileNavigatorViewAwt.this.centerView()) {
                    JunFileNavigatorViewAwt.this.centerView().requestFocus();
                }
            }
        };
        this.centerView().canvas().addMouseListener((MouseListener)mouseAdapter);
        this.leftView().canvas().addMouseListener((MouseListener)mouseAdapter);
        this.rightView().canvas().addMouseListener((MouseListener)mouseAdapter);
        window.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Component component = window.getFocusOwner();
                        if (component == null || component != JunFileNavigatorViewAwt.this.centerView()) {
                            JunFileNavigatorViewAwt.this.centerView().requestFocus();
                        }
                    }
                });
            }
        });
    }

    public void update_(DependentEvent dependentEvent) {
        StSymbol stSymbol = dependentEvent.getAspect();
        if (stSymbol == JunFileNavigatorViewAwt.$((String)"current file")) {
            this.statusLabel().setText(this.getFileNavigator().currentStatus());
            this.setListViewVisible(this.leftView(), !this.getFileNavigator().isLeftEnd());
            this.setListViewVisible(this.rightView(), !this.getFileNavigator().isCurrentFileInaccessibleDirectory());
        } else {
            super.update_(dependentEvent);
        }
    }

    protected void setListViewVisible(JunSequenceListViewAwt junSequenceListViewAwt, boolean bl) {
        if (junSequenceListViewAwt.isVisible() != bl) {
            junSequenceListViewAwt.setVisible(bl);
        }
    }
}

