/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.graphics.navigator;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import jp.co.sra.jun.goodies.button.JunButtonViewSwing;
import jp.co.sra.jun.graphics.framework.JunGraphicViewSwing;
import jp.co.sra.jun.graphics.list.JunSequenceListViewSwing;
import jp.co.sra.jun.graphics.navigator.JunEmbeddedFileListViewSwing;
import jp.co.sra.jun.graphics.navigator.JunFileNavigator;
import jp.co.sra.jun.graphics.navigator.JunFileNavigatorView;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.WindowSpecLayout;

public class JunFileNavigatorViewSwing
extends JunGraphicViewSwing
implements JunFileNavigatorView {
    protected JunSequenceListViewSwing centerView;
    protected JunSequenceListViewSwing leftView;
    protected JunSequenceListViewSwing rightView;
    protected JunButtonViewSwing homeButtonView;
    protected JLabel currentFileName;
    protected JLabel statusLabel;

    public JunFileNavigatorViewSwing(JunFileNavigator junFileNavigator) {
        super(junFileNavigator);
    }

    public JunFileNavigator getFileNavigator() {
        return (JunFileNavigator)this.model();
    }

    protected void buildComponent() {
        this.setLayout((LayoutManager)new WindowSpecLayout());
        this.add((Component)((Object)this.homeButtonView()), WindowSpecLayout.Position((float)0.0f, (int)1, (float)0.0f, (int)1, (float)0.0f, (int)25, (float)0.0f, (int)25));
        this.add(this.currentFileName(), WindowSpecLayout.Position((float)0.0f, (int)26, (float)0.0f, (int)1, (float)1.0f, (int)-1, (float)0.0f, (int)25));
        this.add((Component)((Object)this.leftView()), WindowSpecLayout.Position((float)0.0f, (int)1, (float)0.0f, (int)26, (float)0.32f, (int)-1, (float)1.0f, (int)-21));
        this.add((Component)((Object)this.centerView()), WindowSpecLayout.Position((float)0.32f, (int)0, (float)0.0f, (int)26, (float)0.68f, (int)0, (float)1.0f, (int)-21));
        this.add((Component)((Object)this.rightView()), WindowSpecLayout.Position((float)0.68f, (int)1, (float)0.0f, (int)26, (float)1.0f, (int)-1, (float)1.0f, (int)-21));
        this.add(this.statusLabel(), WindowSpecLayout.Position((float)0.0f, (int)1, (float)1.0f, (int)-20, (float)1.0f, (int)-1, (float)1.0f, (int)-1));
        this.setPreferredSize(new Dimension(500, 300));
    }

    protected JunSequenceListViewSwing centerView() {
        if (this.centerView == null) {
            this.centerView = new JunEmbeddedFileListViewSwing(this.getFileNavigator().centerList());
        }
        return this.centerView;
    }

    protected JunSequenceListViewSwing leftView() {
        if (this.leftView == null) {
            this.leftView = new JunEmbeddedFileListViewSwing(this.getFileNavigator().leftList());
            this.leftView.setVisible(!this.getFileNavigator().isLeftEnd());
        }
        return this.leftView;
    }

    protected JunSequenceListViewSwing rightView() {
        if (this.rightView == null) {
            this.rightView = new JunSequenceListViewSwing(this.getFileNavigator().rightList());
        }
        return this.rightView;
    }

    protected JunButtonViewSwing homeButtonView() {
        if (this.homeButtonView == null) {
            this.homeButtonView = new JunButtonViewSwing(this.getFileNavigator().homeButton());
        }
        return this.homeButtonView;
    }

    protected JLabel currentFileName() {
        if (this.currentFileName == null) {
            this.currentFileName = new JLabel();
            this.currentFileName.setFocusable(false);
            this.currentFileName.setBorder(new EmptyBorder(0, 10, 0, 0));
            if (this.getFileNavigator().currentFileHolder().value() != null) {
                this.currentFileName.setText(this.getFileNavigator().currentFileAsString());
            }
            this.getFileNavigator().currentFileHolder().compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunFileNavigatorViewSwing.this.currentFileName.setText(JunFileNavigatorViewSwing.this.getFileNavigator().currentFileAsString());
                    return null;
                }
            });
        }
        return this.currentFileName;
    }

    protected JLabel statusLabel() {
        if (this.statusLabel == null) {
            this.statusLabel = new JLabel(this.getFileNavigator().currentStatus());
            this.statusLabel.setHorizontalAlignment(0);
        }
        return this.statusLabel;
    }

    public void addNotify() {
        super.addNotify();
        this.topComponent().addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                JunFileNavigatorViewSwing.this.getFileNavigator().fixScrollingOffset();
            }
        });
    }

    public void _setupKeyboard(final Window window) {
        KeyListener keyListener = this.centerView().getSequenceList()._keyListener();
        if (keyListener == null) {
            return;
        }
        this.centerView().addKeyListener(keyListener);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                if (window.isActive() && window.getFocusOwner() != JunFileNavigatorViewSwing.this.centerView()) {
                    JunFileNavigatorViewSwing.this.centerView().requestFocus();
                }
            }
        };
        this.centerView().canvas().addMouseListener((MouseListener)mouseAdapter);
        this.leftView().canvas().addMouseListener((MouseListener)mouseAdapter);
        this.rightView().canvas().addMouseListener((MouseListener)mouseAdapter);
        window.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Component component = window.getFocusOwner();
                        if (component == null || component != JunFileNavigatorViewSwing.this.centerView()) {
                            JunFileNavigatorViewSwing.this.centerView().requestFocus();
                        }
                    }
                });
            }
        });
    }

    public void update_(DependentEvent dependentEvent) {
        StSymbol stSymbol = dependentEvent.getAspect();
        if (stSymbol == JunFileNavigatorViewSwing.$((String)"current file")) {
            this.statusLabel().setText(this.getFileNavigator().currentStatus());
            this.setListViewVisible(this.leftView(), !this.getFileNavigator().isLeftEnd());
            this.setListViewVisible(this.rightView(), !this.getFileNavigator().isCurrentFileInaccessibleDirectory());
        } else {
            super.update_(dependentEvent);
        }
    }

    protected void setListViewVisible(JunSequenceListViewSwing junSequenceListViewSwing, boolean bl) {
        if (junSequenceListViewSwing.isVisible() != bl) {
            junSequenceListViewSwing.setVisible(bl);
        }
    }
}

