/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.display;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.surfaces.JunSphereSurface;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.colors.JunColorChoiceDialog;
import jp.co.sra.jun.goodies.tables.JunAttributeTable;
import jp.co.sra.jun.opengl.display.JunOpenGL3dView;
import jp.co.sra.jun.opengl.display.JunOpenGL3dViewAwt;
import jp.co.sra.jun.opengl.display.JunOpenGL3dViewSwing;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight;
import jp.co.sra.jun.opengl.grapher.JunOpenGL3dGraph;
import jp.co.sra.jun.opengl.lights.JunOpenGLLight;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.projection.JunOpenGLParallelProjection;
import jp.co.sra.jun.opengl.projection.JunOpenGLPerspectiveProjection;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjection;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjector;
import jp.co.sra.jun.opengl.support.JunGLImage;
import jp.co.sra.jun.opengl.support.JunOpenGLDrawable;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderer;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.jun.opengl.support.JunOpenGLResource;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSmallCompiler;
import jp.co.sra.smalltalk.DependentListener;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StInputState;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StCheckBoxMenuItem;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StRadioButtonGroup;
import jp.co.sra.smalltalk.menu.StRadioButtonMenuItem;

public class JunOpenGL3dModel
extends JunApplicationModel
implements JunOpenGLRenderer,
ClipboardOwner {
    public static final Dimension DefaultImageExtent = new Dimension(256, 256);
    protected static final double ThetaAccuracy = 0.001;
    protected static Color DefaultBackgroundColor = Color.white;
    protected JunOpenGL3dObject openGL3dObject;
    protected JunOpenGLProjector openGLProjector;
    protected JunOpenGLDisplayLight[] displayLights;
    protected Vector selectedObjects;
    protected Map defaultProjectionTable;
    protected StValueHolder displayListHolder;
    protected StBlockClosure superimposeBlock;
    protected JunAttributeTable preferenceTable;
    protected Color _backgroundColor;
    protected JunOpenGLProjection[] _presetProjections;
    protected StMenuBar _menuBar;

    public JunOpenGL3dModel() {
    }

    public JunOpenGL3dModel(JunOpenGL3dObject junOpenGL3dObject) {
        this.openGL3dObject_(junOpenGL3dObject);
    }

    protected void initialize() {
        super.initialize();
        this.openGL3dObject = null;
        this.openGLProjector = null;
        this.displayLights = null;
        this.selectedObjects = null;
        this.defaultProjectionTable = null;
        this.displayListHolder = null;
        this.superimposeBlock = null;
        this.preferenceTable = null;
        this._menuBar = null;
        this._presetProjections = null;
        this._backgroundColor = null;
    }

    public JunOpenGL3dObject openGL3dObject() {
        return this.openGL3dObject;
    }

    public void openGL3dObject_(JunOpenGL3dObject junOpenGL3dObject) {
        this.openGL3dObject = junOpenGL3dObject;
        this.clearSelectedObjects();
        this.updateMenuIndication();
    }

    public JunOpenGLProjector openGLProjector() {
        if (this.openGLProjector == null) {
            JunOpenGLProjector junOpenGLProjector = new JunOpenGLProjector();
            this.preCreateDisplayProjector_(junOpenGLProjector);
            junOpenGLProjector.setEyePoint_(this.defaultEyePoint());
            junOpenGLProjector.setSightPoint_(this.defaultSightPoint());
            junOpenGLProjector.setUpVector_(this.defaultUpVector());
            junOpenGLProjector.setViewFactor_(this.defaultViewFactor());
            junOpenGLProjector.setZoomHeight_(this.defaultZoomHeight());
            junOpenGLProjector.setProjection();
            junOpenGLProjector.presentation_(this.defaultPresentation());
            junOpenGLProjector.shading_(this.defaultShading());
            if (this.defaultProjection() == JunOpenGLParallelProjection.Type) {
                junOpenGLProjector.parallelProjection();
            } else {
                junOpenGLProjector.perspectiveProjection();
            }
            this.postCreateDisplayProjector_(junOpenGLProjector);
            this.openGLProjector = junOpenGLProjector;
        }
        return this.openGLProjector;
    }

    protected JunOpenGLProjector preCreateDisplayProjector_(JunOpenGLProjector junOpenGLProjector) {
        return junOpenGLProjector;
    }

    protected JunOpenGLProjector postCreateDisplayProjector_(JunOpenGLProjector junOpenGLProjector) {
        return junOpenGLProjector;
    }

    public JunOpenGLProjection openGLProjection() {
        return this.openGLProjector().projection();
    }

    public void openGLProjection_(JunOpenGLProjection junOpenGLProjection) {
        this.openGLProjector().projection_(junOpenGLProjection);
    }

    public Color backgroundColor() {
        if (this._backgroundColor == null) {
            this._backgroundColor = DefaultBackgroundColor;
        }
        return this._backgroundColor;
    }

    public void presetProjections_(JunOpenGLProjection[] junOpenGLProjectionArray) {
        this._presetProjections = junOpenGLProjectionArray;
        this.updateMenuBar();
    }

    public void backgroundColor_(Color color) {
        this._backgroundColor = color;
        this.changed_(JunOpenGL3dModel.$((String)"backgroundColor"));
    }

    public void flushObject() {
        this.openGL3dObject = null;
    }

    public void flushProjector() {
        this.openGLProjector = null;
    }

    protected void flushDisplayObject() {
        this.flushObject();
    }

    protected void flushMenus() {
        super.flushMenus();
        this._menuBar = null;
    }

    public Jun3dBoundingBox boundingBox() {
        if (this.openGL3dObject() == null) {
            return Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(0.0, 0.0, 0.0));
        }
        return this.openGL3dObject().boundingBox();
    }

    public boolean isEmpty() {
        if (this.openGL3dObject() == null) {
            return true;
        }
        if (!this.openGL3dObject().isCompound()) {
            return false;
        }
        JunOpenGL3dObject junOpenGL3dObject = this.openGL3dObject();
        if (junOpenGL3dObject instanceof JunOpenGL3dCompoundObject) {
            return ((JunOpenGL3dCompoundObject)junOpenGL3dObject).components().length == 0;
        }
        if (junOpenGL3dObject instanceof JunOpenGL3dGraph) {
            return ((JunOpenGL3dGraph)junOpenGL3dObject).components().length == 0;
        }
        return false;
    }

    public void pointsDo_(StBlockClosure stBlockClosure) {
        if (this.openGL3dObject() == null) {
            return;
        }
        this.openGL3dObject().pointsDo_(stBlockClosure);
    }

    public StImage asImage() {
        Image image = this.toImage();
        return image == null ? null : new StImage(image);
    }

    public Image toImage() {
        StView stView = this.getView();
        Dimension dimension = null;
        dimension = stView == null ? this.defaultImageExtent() : stView.toComponent().getSize();
        return this.toImageExtent_(dimension);
    }

    public Image toImageExtent_(Dimension dimension) {
        JunGLImage junGLImage = new JunGLImage(dimension.width, dimension.height);
        junGLImage.setRenderer(this);
        return junGLImage.image();
    }

    public Jun3dPoint convertModelPointToView3dPoint_in_(Jun3dPoint jun3dPoint, Rectangle rectangle) {
        double d = (double)rectangle.height / 2.0;
        Jun3dPoint jun3dPoint2 = new Jun3dPoint((double)rectangle.width / 2.0, d, 0.0);
        JunOpenGLProjection junOpenGLProjection = this.openGLProjection();
        Jun3dPoint jun3dPoint3 = junOpenGLProjection.translateToPointFrom3dPoint_(jun3dPoint);
        Jun3dPoint jun3dPoint4 = new Jun3dPoint(jun3dPoint3.x(), -jun3dPoint3.y(), -jun3dPoint3.z());
        jun3dPoint4 = jun3dPoint4.scaledBy_(d);
        jun3dPoint4 = jun3dPoint4.translatedBy_(jun3dPoint2);
        return jun3dPoint4;
    }

    public Jun3dPoint[] convertModelPointsToView3dPoints_in_(Jun3dPoint[] jun3dPointArray, Rectangle rectangle) {
        Jun3dPoint[] jun3dPointArray2 = new Jun3dPoint[jun3dPointArray.length];
        for (int i = 0; i < jun3dPointArray2.length; ++i) {
            jun3dPointArray2[i] = this.convertModelPointToView3dPoint_in_(jun3dPointArray[i], rectangle);
        }
        return jun3dPointArray2;
    }

    public Map.Entry[] convertModelPointsToView3dPointsSortedByZ_in_(Jun3dPoint[] jun3dPointArray, Rectangle rectangle) {
        Jun3dPoint[] jun3dPointArray2 = this.convertModelPointsToView3dPoints_in_(jun3dPointArray, rectangle);
        HashMap<Double, Jun3dPoint[]> hashMap = new HashMap<Double, Jun3dPoint[]>();
        for (int i = 0; i < jun3dPointArray2.length; ++i) {
            hashMap.put(new Double(jun3dPointArray2[i].z()), new Jun3dPoint[]{jun3dPointArray[i], jun3dPointArray2[i]});
        }
        TreeSet treeSet = new TreeSet(new Comparator(){

            public int compare(Object object, Object object2) {
                double d;
                double d2 = ((Number)((Map.Entry)object).getKey()).doubleValue();
                return d2 < (d = ((Number)((Map.Entry)object2).getKey()).doubleValue()) ? -1 : (d < d2 ? 1 : 0);
            }
        });
        treeSet.addAll(hashMap.entrySet());
        return treeSet.toArray(new Map.Entry[treeSet.size()]);
    }

    public JunOpenGLDisplayLight displayLight1() {
        return this.displayLights()[0];
    }

    public JunOpenGLDisplayLight displayLight2() {
        return this.displayLights()[1];
    }

    public JunOpenGLDisplayLight displayLight3() {
        return this.displayLights()[2];
    }

    public JunOpenGLDisplayLight displayLight4() {
        return this.displayLights()[3];
    }

    public JunOpenGLDisplayLight displayLight5() {
        return this.displayLights()[4];
    }

    public JunOpenGLLight[] displayLightCollection() {
        ArrayList<JunOpenGLLight> arrayList = new ArrayList<JunOpenGLLight>();
        Jun3dTransformation jun3dTransformation = this.openGLProjection().asEyeTransformation().inverse();
        JunOpenGLDisplayLight[] junOpenGLDisplayLightArray = this.displayLights();
        for (int i = 0; i < junOpenGLDisplayLightArray.length; ++i) {
            if (!junOpenGLDisplayLightArray[i].isOn()) continue;
            arrayList.add(junOpenGLDisplayLightArray[i].light().transform_(jun3dTransformation));
        }
        return arrayList.toArray(new JunOpenGLLight[arrayList.size()]);
    }

    public void displayLightsAllOff() {
        JunOpenGLDisplayLight[] junOpenGLDisplayLightArray = this.displayLights();
        for (int i = 0; i < junOpenGLDisplayLightArray.length; ++i) {
            junOpenGLDisplayLightArray[i].beOff();
        }
        this.updateLightMenuIndication();
        this.changed_(JunOpenGL3dModel.$((String)"light"));
    }

    public JunOpenGLDisplayLight[] displayLights() {
        if (this.displayLights == null) {
            this.displayLights = new JunOpenGLDisplayLight[5];
            this.displayLights[0] = JunOpenGLDisplayLight.ParallelLight_color_position_(true, this.defaultLightColor(), this.defaultLightPoint());
            this.displayLights[1] = new JunOpenGLDisplayLight();
            this.displayLights[2] = new JunOpenGLDisplayLight();
            this.displayLights[3] = new JunOpenGLDisplayLight();
            this.displayLights[4] = JunOpenGLDisplayLight.AmbientLight_color_(true, this.defaultLightColor());
            for (int i = 0; i < this.displayLights.length; ++i) {
                this.displayLights[i].compute_(new StBlockClosure(){

                    public Object value() {
                        JunOpenGL3dModel.this.updateLightMenuIndication();
                        JunOpenGL3dModel.this.changed_(2.$((String)"light"));
                        return null;
                    }
                });
            }
            String[] stringArray = new String[]{JunOpenGL3dModel.$String((String)"Light") + "1", JunOpenGL3dModel.$String((String)"Light") + "2", JunOpenGL3dModel.$String((String)"Light") + "3", JunOpenGL3dModel.$String((String)"Light") + "4", JunOpenGL3dModel.$String((String)"Ambient Light", (String)"Ambient")};
            for (int i = 0; i < this.displayLights.length; ++i) {
                this.displayLights[i].lightName_(stringArray[i]);
            }
        }
        return this.displayLights;
    }

    public void displayLights_(JunOpenGLDisplayLight[] junOpenGLDisplayLightArray) {
        if (junOpenGLDisplayLightArray == null || junOpenGLDisplayLightArray.length != 5) {
            return;
        }
        this.displayLights = junOpenGLDisplayLightArray;
    }

    public void renderOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        this.renderOn_withDisplayList_(junOpenGLRenderingContext, this.displayListHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderOn_withDisplayList_(JunOpenGLRenderingContext junOpenGLRenderingContext, StValueHolder stValueHolder) {
        junOpenGLRenderingContext.clear();
        try {
            JunOpenGL3dObject junOpenGL3dObject = this.openGL3dObject();
            if (junOpenGL3dObject == null) {
                this.openGLProjector().projectOn_(junOpenGLRenderingContext);
            } else {
                JunOpenGLLight[] junOpenGLLightArray = this.displayLightCollection();
                if (this.selectedObjects().isEmpty()) {
                    this.openGLProjector().project_withLights_on_withDisplayList_(junOpenGL3dObject, junOpenGLLightArray, junOpenGLRenderingContext, stValueHolder);
                } else {
                    JunOpenGLProjector junOpenGLProjector = (JunOpenGLProjector)this.openGLProjector().copy();
                    if (this.openGLProjector().presentation() == JunOpenGL3dModel.$((String)"solidPresentation")) {
                        junOpenGLProjector.wireframePresentation();
                    } else if (this.openGLProjector().presentation() == JunOpenGL3dModel.$((String)"wireframePresentation")) {
                        junOpenGLProjector.wireframePresentation();
                    } else if (this.openGLProjector().presentation() == JunOpenGL3dModel.$((String)"hiddenlinePresentation")) {
                        junOpenGLProjector.hiddenlinePresentation();
                    }
                    junOpenGLProjector.project_withLights_on_withDisplayList_(junOpenGL3dObject, junOpenGLLightArray, junOpenGLRenderingContext, stValueHolder);
                    if (this.openGLProjector().presentation() == JunOpenGL3dModel.$((String)"solidPresentation")) {
                        junOpenGLProjector.solidPresentation();
                    } else if (this.openGLProjector().presentation() == JunOpenGL3dModel.$((String)"wireframePresentation")) {
                        junOpenGLProjector.solidPresentation();
                    } else if (this.openGLProjector().presentation() == JunOpenGL3dModel.$((String)"hiddenlinePresentation")) {
                        junOpenGLProjector.solidPresentation();
                    }
                    Object[] objectArray = this.selectedObjects().toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        junOpenGLProjector.project_on_((JunOpenGL3dObject)((Object)objectArray[i]), junOpenGLRenderingContext);
                    }
                }
            }
        }
        finally {
            junOpenGLRenderingContext.flush();
        }
    }

    public void grab_(Jun2dPoint jun2dPoint) {
        this.grab_(jun2dPoint, false);
    }

    public void grab_(Jun2dPoint jun2dPoint, boolean bl) {
        if (this.openGL3dObject() == null) {
            return;
        }
        Jun2dPoint jun2dPoint2 = new Jun2dPoint(0.0, 0.0);
        Jun2dPoint jun2dPoint3 = bl ? new Jun2dPoint(jun2dPoint.x() / 10.0, jun2dPoint.y() / 10.0) : new Jun2dPoint(jun2dPoint.x(), jun2dPoint.y());
        this.grab_xy_(jun2dPoint2, jun2dPoint3);
    }

    public void grab_xy_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        if (this.openGL3dObject() == null) {
            return;
        }
        JunOpenGLProjection junOpenGLProjection = this.openGLProjection();
        JunSphereSurface junSphereSurface = this.grabSphere();
        Jun3dPoint jun3dPoint = junSphereSurface.center();
        Jun3dPoint jun3dPoint2 = this.grab3dPoint_(new Jun2dPoint(jun2dPoint.x(), jun2dPoint.y()));
        Jun3dPoint jun3dPoint3 = this.grab3dPoint_(new Jun2dPoint(jun2dPoint2.x(), jun2dPoint2.y()));
        JunAngle junAngle = new Jun3dLine(jun3dPoint, jun3dPoint3).angleWithLine_(new Jun3dLine(jun3dPoint, jun3dPoint2));
        if (Math.abs(junAngle.rad()) > 0.001) {
            Jun3dLine jun3dLine = new Jun3dLine(jun3dPoint, jun3dPoint.minus_(jun3dPoint2.minus_(jun3dPoint).product_(jun3dPoint3.minus_(jun3dPoint))));
            Jun3dTransformation jun3dTransformation = Jun3dTransformation.Rotate_around_(junAngle, jun3dLine);
            Jun3dTransformation jun3dTransformation2 = Jun3dTransformation.Rotate_around_(junAngle.negated(), jun3dLine);
            Jun3dPoint jun3dPoint4 = junOpenGLProjection.sightPoint().plus_(junOpenGLProjection.unitUpVector());
            junOpenGLProjection.eyePoint_(jun3dTransformation2.applyTo_(junOpenGLProjection.eyePoint()));
            junOpenGLProjection.upVector_(jun3dTransformation.applyTo_(jun3dPoint4).minus_(junOpenGLProjection.sightPoint()));
            this.openGLProjection_(junOpenGLProjection);
            this.changed_(JunOpenGL3dModel.$((String)"projection"));
        }
    }

    public void look_xy_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        if (this.openGL3dObject() == null) {
            return;
        }
        JunOpenGLProjection junOpenGLProjection = this.openGLProjection();
        Jun3dPoint jun3dPoint = this.grab3dPoint_(new Jun2dPoint(jun2dPoint.x(), jun2dPoint.y()));
        Jun3dPoint jun3dPoint2 = this.grab3dPoint_(new Jun2dPoint(jun2dPoint2.x(), jun2dPoint2.y()));
        junOpenGLProjection.eyePoint_(junOpenGLProjection.eyePoint().minus_(jun3dPoint2.minus_(jun3dPoint)));
        this.openGLProjection_(junOpenGLProjection);
        this.changed_(JunOpenGL3dModel.$((String)"projection"));
    }

    public Jun3dPoint press_with_(Jun2dPoint jun2dPoint, MouseEvent mouseEvent) {
        JunOpenGLProjection junOpenGLProjection = this.openGLProjection();
        Jun3dPoint jun3dPoint = junOpenGLProjection.translateTo3dPointFromPoint_(jun2dPoint);
        if (mouseEvent.isShiftDown()) {
            System.out.println(jun3dPoint.toString());
        }
        return jun3dPoint;
    }

    public void slide_xy_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        if (this.openGL3dObject() == null) {
            return;
        }
        JunOpenGLProjection junOpenGLProjection = this.openGLProjection();
        Jun3dPoint jun3dPoint = this.grab3dPoint_(new Jun2dPoint(jun2dPoint.x(), jun2dPoint.y()));
        Jun3dPoint jun3dPoint2 = this.grab3dPoint_(new Jun2dPoint(jun2dPoint2.x(), jun2dPoint2.y()));
        junOpenGLProjection.sightPoint_(junOpenGLProjection.sightPoint().minus_(jun3dPoint2.minus_(jun3dPoint)));
        junOpenGLProjection.eyePoint_(junOpenGLProjection.eyePoint().minus_(jun3dPoint2.minus_(jun3dPoint)));
        this.openGLProjection_(junOpenGLProjection);
        this.changed_(JunOpenGL3dModel.$((String)"projection"));
    }

    public void addSelectedObject_(JunOpenGL3dObject junOpenGL3dObject) {
        if (this.openGL3dObject() == null) {
            return;
        }
        if (this.openGL3dObject().isPrimitive()) {
            return;
        }
        if (!this.selectedObjects().contains((Object)junOpenGL3dObject)) {
            this.selectedObjects().add(junOpenGL3dObject);
        }
    }

    public void clearSelectedObjects() {
        this.selectedObjects = new Vector();
    }

    public void removeSelectedObject_(JunOpenGL3dObject junOpenGL3dObject) {
        if (this.openGL3dObject() == null) {
            return;
        }
        if (this.openGL3dObject().isPrimitive()) {
            return;
        }
        if (this.selectedObjects().contains((Object)junOpenGL3dObject)) {
            this.selectedObjects().remove((Object)junOpenGL3dObject);
        }
    }

    public Vector selectedObjects() {
        if (this.selectedObjects == null) {
            this.clearSelectedObjects();
        }
        return this.selectedObjects;
    }

    public JunAttributeTable preferenceTable() {
        if (this.preferenceTable == null) {
            this.preferenceTable = new JunAttributeTable();
        }
        return this.preferenceTable;
    }

    public boolean useDisplayList() {
        Boolean bl = (Boolean)this.preferenceTable().at_(JunOpenGL3dModel.$((String)"useDisplayList"));
        if (bl == null) {
            bl = Boolean.FALSE;
            this.preferenceTable().at_put_(JunOpenGL3dModel.$((String)"useDisplayList"), bl);
        }
        return bl;
    }

    public void useDisplayList_(boolean bl) {
        this.preferenceTable().at_put_(JunOpenGL3dModel.$((String)"useDisplayList"), new Boolean(bl));
        if (!bl) {
            this.displayListHolder = null;
        } else if (this.displayListHolder == null) {
            this.displayListHolder = new StValueHolder();
        }
    }

    public String windowLabel() {
        return (String)this.preferenceTable().at_ifAbsentPut_(JunOpenGL3dModel.$((String)"windowLabel"), new StBlockClosure(){

            public Object value() {
                return 3.$String((String)"Viewfinder");
            }
        });
    }

    public void windowLabel_(String string) {
        this.preferenceTable().at_put_(JunOpenGL3dModel.$((String)"windowLabel"), string);
        if (this.windowLabel() != null) {
            this.updateWindowTitle();
        }
    }

    public void hiddenlinePresentation() {
        this.openGLProjector().hiddenlinePresentation();
        this.updateViewMenuIndication();
        this.changed_(JunOpenGL3dModel.$((String)"presentation"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGL3dModel.$((String)"presentation"))) {
            this.defaultPresentation_(JunOpenGL3dModel.$((String)"hiddenlinePresentation"));
        }
    }

    public void solidPresentation() {
        this.openGLProjector().solidPresentation();
        this.updateViewMenuIndication();
        this.changed_(JunOpenGL3dModel.$((String)"presentation"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGL3dModel.$((String)"presentation"))) {
            this.defaultPresentation_(JunOpenGL3dModel.$((String)"solidPresentation"));
        }
    }

    public void wireframePresentation() {
        this.openGLProjector().wireframePresentation();
        this.updateViewMenuIndication();
        this.changed_(JunOpenGL3dModel.$((String)"presentation"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGL3dModel.$((String)"presentation"))) {
            this.defaultPresentation_(JunOpenGL3dModel.$((String)"wireframePresentation"));
        }
    }

    public void dolly_(double d) {
        double d2 = d;
        Jun3dLine jun3dLine = new Jun3dLine(this.eyePoint(), this.sightPoint());
        Jun3dPoint jun3dPoint = jun3dLine.atT_(0.0 + d2);
        Jun3dPoint jun3dPoint2 = jun3dLine.atT_(1.0 + d2);
        this.openGLProjector.eyePoint_(jun3dPoint);
        this.openGLProjector.sightPoint_(jun3dPoint2);
        this.changed_(JunOpenGL3dModel.$((String)"projection"));
    }

    public Jun3dPoint eyePoint() {
        return this.openGLProjector().eyePoint();
    }

    public void eyePoint_(Jun3dPoint jun3dPoint) {
        this.openGLProjector().eyePoint_(jun3dPoint);
        this.changed_(JunOpenGL3dModel.$((String)"projection"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGL3dModel.$((String)"eyePoint"))) {
            this.defaultEyePoint_(jun3dPoint);
        }
    }

    public void fit() {
        if (this.openGL3dObject() == null) {
            return;
        }
        this.fitSilently();
        this.changed_(JunOpenGL3dModel.$((String)"projection"));
    }

    public void fitSight() {
        if (this.openGL3dObject() == null) {
            return;
        }
        Jun3dPoint jun3dPoint = this.computeSightPoint();
        this.sightPoint_(jun3dPoint);
    }

    public void fitSilently() {
        if (this.openGL3dObject() == null) {
            return;
        }
        Jun3dPoint jun3dPoint = this.computeSightPoint();
        this.openGLProjector().sightPoint_(jun3dPoint);
        double d = this.computeZoomHeight();
        this.openGLProjector().zoomHeight_(d);
    }

    public void fitZoom() {
        if (this.openGL3dObject() == null) {
            return;
        }
        double d = this.computeZoomHeight();
        this.zoomHeight_(d);
    }

    public void pan() {
        this.zoom_(0.5);
    }

    public void parallelProjection() {
        this.openGLProjector().parallelProjection();
        this.updateViewMenuIndication();
        this.changed_(JunOpenGL3dModel.$((String)"projection"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGL3dModel.$((String)"projection"))) {
            this.defaultProjection_(JunOpenGLParallelProjection.Type);
        }
    }

    public void perspectiveProjection() {
        this.openGLProjector().perspectiveProjection();
        this.updateViewMenuIndication();
        this.changed_(JunOpenGL3dModel.$((String)"projection"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGL3dModel.$((String)"projection"))) {
            this.defaultProjection_(JunOpenGLPerspectiveProjection.Type);
        }
    }

    public Jun3dPoint sightPoint() {
        return this.openGLProjector().sightPoint();
    }

    public void sightPoint_(Jun3dPoint jun3dPoint) {
        this.openGLProjector().sightPoint_(jun3dPoint);
        this.changed_(JunOpenGL3dModel.$((String)"projection"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGL3dModel.$((String)"sightPoint"))) {
            this.defaultSightPoint_(jun3dPoint);
        }
    }

    public Jun3dPoint upVector() {
        return this.openGLProjector().upVector();
    }

    public void upVector_(Jun3dPoint jun3dPoint) {
        this.openGLProjector().upVector_(jun3dPoint);
        this.changed_(JunOpenGL3dModel.$((String)"projection"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGL3dModel.$((String)"upVector"))) {
            this.defaultUpVector_(jun3dPoint);
        }
    }

    public double viewFactor() {
        return this.openGLProjector().viewFactor();
    }

    public void viewFactor_(double d) {
        this.openGLProjector().viewFactor_(d);
        this.changed_(JunOpenGL3dModel.$((String)"projection"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGL3dModel.$((String)"viewFactor"))) {
            this.defaultViewFactor_(d);
        }
    }

    public void zoom() {
        this.zoom_(2.0);
    }

    public void zoom_(double d) {
        if (StInputState.Default().shiftDown()) {
            d = d >= 1.0 ? 1.0 + (d - 1.0) * 0.1 : 1.0 - (1.0 - d) * 0.1;
        }
        this.openGLProjector().zoom_(d);
        this.changed_(JunOpenGL3dModel.$((String)"projection"));
    }

    public double zoomHeight() {
        return this.openGLProjector().zoomHeight();
    }

    protected Map postGetProjectionTable_(Map map) {
        return map;
    }

    protected Map postPutProjectionTable_into_(Map map, JunOpenGLProjector junOpenGLProjector) {
        return map;
    }

    protected Map preGetProjectionTable_(Map map) {
        return map;
    }

    protected Map prePutProjectionTable_into_(Map map, JunOpenGLProjector junOpenGLProjector) {
        return map;
    }

    public Map projectionTable() {
        HashMap<StSymbol, Object> hashMap = new HashMap<StSymbol, Object>(8);
        this.preGetProjectionTable_(hashMap);
        hashMap.put(JunOpenGL3dModel.$((String)"eyePoint"), (Object)this.eyePoint());
        hashMap.put(JunOpenGL3dModel.$((String)"sightPoint"), (Object)this.sightPoint());
        hashMap.put(JunOpenGL3dModel.$((String)"upVector"), (Object)this.upVector());
        hashMap.put(JunOpenGL3dModel.$((String)"viewFactor"), new Double(this.viewFactor()));
        hashMap.put(JunOpenGL3dModel.$((String)"zoomHeight"), new Double(this.zoomHeight()));
        hashMap.put(JunOpenGL3dModel.$((String)"presentation"), this.openGLProjector().presentation());
        hashMap.put(JunOpenGL3dModel.$((String)"shading"), this.openGLProjector().shading());
        hashMap.put(JunOpenGL3dModel.$((String)"projection"), this.openGLProjector().projection() instanceof JunOpenGLParallelProjection ? JunOpenGL3dModel.$((String)"parallelProjection") : JunOpenGL3dModel.$((String)"perspectiveProjection"));
        this.postGetProjectionTable_(hashMap);
        return hashMap;
    }

    public void projectionTable_(Map map) {
        JunOpenGLProjector junOpenGLProjector = this.openGLProjector();
        this.prePutProjectionTable_into_(map, junOpenGLProjector);
        if (map.containsKey(JunOpenGL3dModel.$((String)"eyePoint"))) {
            junOpenGLProjector.eyePoint_((Jun3dPoint)((Object)map.get(JunOpenGL3dModel.$((String)"eyePoint"))));
        }
        if (map.containsKey(JunOpenGL3dModel.$((String)"sightPoint"))) {
            junOpenGLProjector.sightPoint_((Jun3dPoint)((Object)map.get(JunOpenGL3dModel.$((String)"sightPoint"))));
        }
        if (map.containsKey(JunOpenGL3dModel.$((String)"upVector"))) {
            junOpenGLProjector.upVector_((Jun3dPoint)((Object)map.get(JunOpenGL3dModel.$((String)"upVector"))));
        }
        if (map.containsKey(JunOpenGL3dModel.$((String)"viewFactor"))) {
            junOpenGLProjector.viewFactor_(((Number)map.get(JunOpenGL3dModel.$((String)"viewFactor"))).doubleValue());
        }
        if (map.containsKey(JunOpenGL3dModel.$((String)"zoomHeight"))) {
            junOpenGLProjector.zoomHeight_(((Number)map.get(JunOpenGL3dModel.$((String)"zoomHeight"))).doubleValue());
        }
        if (map.containsKey(JunOpenGL3dModel.$((String)"presentation"))) {
            junOpenGLProjector.presentation_((StSymbol)map.get(JunOpenGL3dModel.$((String)"presentation")));
        }
        if (map.containsKey(JunOpenGL3dModel.$((String)"shading"))) {
            junOpenGLProjector.shading_((StSymbol)map.get(JunOpenGL3dModel.$((String)"shading")));
        }
        if (map.containsKey(JunOpenGL3dModel.$((String)"projection"))) {
            if ((StSymbol)map.get(JunOpenGL3dModel.$((String)"projection")) == JunOpenGL3dModel.$((String)"parallelProjection")) {
                junOpenGLProjector.parallelProjection();
            } else {
                junOpenGLProjector.perspectiveProjection();
            }
        }
        this.postPutProjectionTable_into_(map, junOpenGLProjector);
        this.changed_(JunOpenGL3dModel.$((String)"projection"));
    }

    protected void projectionTableFromCopyBuffer() {
        JunAttributeTable junAttributeTable;
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        String string = null;
        try {
            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            throw new SmalltalkException(exception);
        }
        if (string == null) {
            return;
        }
        String string2 = "((JunAttributeTable fromString: '";
        String string3 = "') attributeTable)";
        if (!string.startsWith(string2) && !string.endsWith(string3)) {
            string2 = "(JunAttributeTable fromString: '";
            string3 = "') attributeTable";
            if (!string.startsWith(string2) && !string.endsWith(string3)) {
                return;
            }
        }
        if ((junAttributeTable = JunAttributeTable.FromString_(string = string.substring(string2.length(), string.length() - string3.length()))) == null) {
            return;
        }
        this.projectionTable_(junAttributeTable.attributeTable());
    }

    protected void projectionTableToCopyBuffer() {
        String string = ") yourself)";
        String string2 = new JunAttributeTable(this.projectionTable()).storeString();
        if (string2.endsWith(string)) {
            string2 = string2.substring(0, string2.length() - string.length()) + ") attributeTable)";
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string2), this);
    }

    public void zoomHeight_(double d) {
        this.openGLProjector().zoomHeight_(d);
        this.changed_(JunOpenGL3dModel.$((String)"projection"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGL3dModel.$((String)"zoomHeight"))) {
            this.defaultZoomHeight_(d);
        }
    }

    public void flatShading() {
        this.openGLProjector().flatShading();
        this.updateViewMenuIndication();
        this.changed_(JunOpenGL3dModel.$((String)"shading"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGL3dModel.$((String)"shading"))) {
            this.defaultShading_(JunOpenGL3dModel.$((String)"flatShading"));
        }
    }

    public void smoothShading() {
        this.openGLProjector().smoothShading();
        this.updateViewMenuIndication();
        this.changed_(JunOpenGL3dModel.$((String)"shading"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGL3dModel.$((String)"shading"))) {
            this.defaultShading_(JunOpenGL3dModel.$((String)"smoothShading"));
        }
    }

    public boolean hasTextureMapping() {
        JunOpenGL3dObject junOpenGL3dObject = this.openGL3dObject();
        if (junOpenGL3dObject == null) {
            return false;
        }
        final StValueHolder stValueHolder = new StValueHolder(false);
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)object);
                JunOpenGLTexture junOpenGLTexture = junOpenGL3dObject.texture();
                if (junOpenGLTexture != null) {
                    stValueHolder.value_(true);
                }
                return null;
            }
        });
        return stValueHolder._booleanValue();
    }

    public boolean clamp() {
        JunOpenGL3dObject junOpenGL3dObject = this.openGL3dObject();
        if (junOpenGL3dObject == null) {
            return false;
        }
        final StValueHolder stValueHolder = new StValueHolder(false);
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)object);
                JunOpenGLTexture junOpenGLTexture = junOpenGL3dObject.texture();
                if (junOpenGLTexture != null) {
                    stValueHolder.value_(junOpenGLTexture.clamp());
                }
                return null;
            }
        });
        return stValueHolder._booleanValue();
    }

    public boolean linear() {
        JunOpenGL3dObject junOpenGL3dObject = this.openGL3dObject();
        if (junOpenGL3dObject == null) {
            return false;
        }
        final StValueHolder stValueHolder = new StValueHolder(false);
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)object);
                JunOpenGLTexture junOpenGLTexture = junOpenGL3dObject.texture();
                if (junOpenGLTexture != null) {
                    stValueHolder.value_(junOpenGLTexture.linear());
                }
                return null;
            }
        });
        return stValueHolder._booleanValue();
    }

    public boolean mipmap() {
        JunOpenGL3dObject junOpenGL3dObject = this.openGL3dObject();
        if (junOpenGL3dObject == null) {
            return false;
        }
        final StValueHolder stValueHolder = new StValueHolder(false);
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)object);
                JunOpenGLTexture junOpenGLTexture = junOpenGL3dObject.texture();
                if (junOpenGLTexture != null) {
                    stValueHolder.value_(junOpenGLTexture.mipmap());
                }
                return null;
            }
        });
        return stValueHolder._booleanValue();
    }

    public boolean modulate() {
        JunOpenGL3dObject junOpenGL3dObject = this.openGL3dObject();
        if (junOpenGL3dObject == null) {
            return false;
        }
        final StValueHolder stValueHolder = new StValueHolder(false);
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)object);
                JunOpenGLTexture junOpenGLTexture = junOpenGL3dObject.texture();
                if (junOpenGLTexture != null) {
                    stValueHolder.value_(junOpenGLTexture.modulate());
                }
                return null;
            }
        });
        return stValueHolder._booleanValue();
    }

    public boolean nearest() {
        return !this.linear();
    }

    public boolean repeat() {
        return !this.clamp();
    }

    public StBlockClosure superimposeBlock() {
        return this.superimposeBlock;
    }

    public void superimposeBlock_(StBlockClosure stBlockClosure) {
        this.superimposeBlock = stBlockClosure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void superimposeOn_(Graphics graphics, JunOpenGLDrawable junOpenGLDrawable) {
        if (this.superimposeBlock == null) {
            return;
        }
        Shape shape = graphics.getClip();
        try {
            graphics.setClip(0, 0, junOpenGLDrawable.toComponent().getWidth(), junOpenGLDrawable.toComponent().getHeight());
            switch (this.superimposeBlock.numArgs()) {
                case 0: {
                    this.superimposeBlock.value();
                    return;
                }
                case 1: {
                    this.superimposeBlock.value_((Object)graphics);
                    return;
                }
                case 2: {
                    this.superimposeBlock.value_value_((Object)graphics, (Object)this.getOpenGLViewWith(junOpenGLDrawable));
                    return;
                }
            }
            return;
        }
        finally {
            graphics.setClip(shape);
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public StView defaultView() {
        if (JunOpenGL3dModel.GetDefaultViewMode() == 0) {
            return new JunOpenGL3dViewAwt(this);
        }
        return new JunOpenGL3dViewSwing(this);
    }

    protected Frame allButOpenView_(StView stView) {
        this.flushProjector();
        this.projectionTable_(this.defaultProjectionTable());
        return super.allButOpenView_(stView);
    }

    public void postOpenWith_(StView stView) {
        super.postOpenWith_(stView);
        if (!this.defaultProjectionTable().containsKey(JunOpenGL3dModel.$((String)"sightPoint")) || !this.defaultProjectionTable().containsKey(JunOpenGL3dModel.$((String)"zoomHeight"))) {
            this.fitSilently();
        }
    }

    protected String windowTitle() {
        return this.windowLabel();
    }

    public void changeBackgroundColor() {
        Color color = JunColorChoiceDialog.Request();
        if (color == null) {
            return;
        }
        this.backgroundColor_(color);
    }

    public void changeEyePoint() {
        Jun3dPoint jun3dPoint = this.eyePoint();
        float f = (float)jun3dPoint.x();
        float f2 = (float)jun3dPoint.y();
        float f3 = (float)jun3dPoint.z();
        String string = JunDialog.Request_(JunOpenGL3dModel.$String((String)"Input a new eye point.") + " (x, y, z)", "(" + f + "," + f2 + "," + f3 + ")");
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            jun3dPoint = (Jun3dPoint)((Object)JunSmallCompiler.Evaluate_(string));
        }
        catch (Exception exception) {
            JunDialog.Warn_(string + JunOpenGL3dModel.$String((String)" is invalid point."));
        }
        this.eyePoint_(jun3dPoint);
    }

    public void changeSightPoint() {
        Jun3dPoint jun3dPoint = this.sightPoint();
        float f = (float)jun3dPoint.x();
        float f2 = (float)jun3dPoint.y();
        float f3 = (float)jun3dPoint.z();
        String string = JunDialog.Request_(JunOpenGL3dModel.$String((String)"Input a new sight point.") + " (x, y, z)", "(" + f + "," + f2 + "," + f3 + ")");
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            jun3dPoint = (Jun3dPoint)((Object)JunSmallCompiler.Evaluate_(string));
        }
        catch (Exception exception) {
            JunDialog.Warn_(string + JunOpenGL3dModel.$String((String)" is invalid point."));
        }
        this.sightPoint_(jun3dPoint);
    }

    public void changeSmoothingAngle() {
        JunOpenGL3dObject junOpenGL3dObject = this.openGL3dObject();
        if (junOpenGL3dObject == null) {
            return;
        }
        JunAngle junAngle = junOpenGL3dObject.smoothingAngle();
        if (junAngle == null) {
            junAngle = junOpenGL3dObject.defaultSmoothingAngle();
        }
        double d = junAngle.deg();
        String string = JunDialog.Request_(JunOpenGL3dModel.$String((String)"Input a smoothing angle."), String.valueOf((float)d));
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            d = Double.valueOf(string);
        }
        catch (Exception exception) {
            JunDialog.Warn_(string + JunOpenGL3dModel.$String((String)" is invalid value."));
        }
        junAngle = JunAngle.FromDeg_(d);
        this.openGL3dObject().establishAllNormalVectorsWithSmoothingAngle_(junAngle);
        this.changed_(JunOpenGL3dModel.$((String)"presentation"));
    }

    public void changeUpVector() {
        Jun3dPoint jun3dPoint = this.upVector();
        float f = (float)jun3dPoint.x();
        float f2 = (float)jun3dPoint.y();
        float f3 = (float)jun3dPoint.z();
        String string = JunDialog.Request_(JunOpenGL3dModel.$String((String)"Input a new up vector.") + " (x, y, z)", "(" + f + "," + f2 + "," + f3 + ")");
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            jun3dPoint = (Jun3dPoint)((Object)JunSmallCompiler.Evaluate_(string));
        }
        catch (Exception exception) {
            JunDialog.Warn_(string + JunOpenGL3dModel.$String((String)" is invalid point."));
        }
        this.upVector_(jun3dPoint);
    }

    public void changeViewFactor() {
        double d = this.viewFactor();
        String string = JunDialog.Request_(JunOpenGL3dModel.$String((String)"Input a new view factor."), String.valueOf((float)d));
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            d = Double.valueOf(string);
        }
        catch (Exception exception) {
            JunDialog.Warn_(string + JunOpenGL3dModel.$String((String)" is invalid value."));
        }
        this.viewFactor_(d);
    }

    public void changeZoomHeight() {
        double d = this.zoomHeight();
        String string = JunDialog.Request_(JunOpenGL3dModel.$String((String)"Input a new zoom height."), String.valueOf((float)d));
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            d = Double.valueOf(string);
        }
        catch (Exception exception) {
            JunDialog.Warn_(string + JunOpenGL3dModel.$String((String)" is invalid value."));
        }
        this.zoomHeight_(d);
    }

    public void closeUp() {
        JunOpenGLProjection junOpenGLProjection = this.openGLProjection();
        double d = junOpenGLProjection.regularHeight() / 2.0;
        double d2 = junOpenGLProjection.sightPoint().distance_(junOpenGLProjection.eyePoint());
        Jun3dLine jun3dLine = new Jun3dLine(junOpenGLProjection.sightPoint(), junOpenGLProjection.eyePoint());
        Jun3dPoint jun3dPoint = jun3dLine.atT_(d / d2);
        junOpenGLProjection.eyePoint_(jun3dPoint);
        junOpenGLProjection.zoomHeight_(this.computeZoomHeight());
        this.openGLProjection_(junOpenGLProjection);
        this.changed_(JunOpenGL3dModel.$((String)"projection"));
    }

    public void lineSmooth() {
        this.openGLProjector().lineSmooth_(!this.openGLProjector().lineSmooth());
        this.updateViewMenuIndication();
        this.changed_(JunOpenGL3dModel.$((String)"smoothing"));
    }

    public void openLight1() {
        JunOpenGLDisplayLight junOpenGLDisplayLight = this.displayLight1();
        if (junOpenGLDisplayLight.builder().windows().length > 0) {
            junOpenGLDisplayLight._windowExpandAndRaise();
        } else {
            junOpenGLDisplayLight.openPositionLight();
        }
    }

    public void openLight2() {
        JunOpenGLDisplayLight junOpenGLDisplayLight = this.displayLight2();
        if (junOpenGLDisplayLight.builder().windows().length > 0) {
            junOpenGLDisplayLight._windowExpandAndRaise();
        } else {
            junOpenGLDisplayLight.openPositionLight();
        }
    }

    public void openLight3() {
        JunOpenGLDisplayLight junOpenGLDisplayLight = this.displayLight3();
        if (junOpenGLDisplayLight.builder().windows().length > 0) {
            junOpenGLDisplayLight._windowExpandAndRaise();
        } else {
            junOpenGLDisplayLight.openPositionLight();
        }
    }

    public void openLight4() {
        JunOpenGLDisplayLight junOpenGLDisplayLight = this.displayLight4();
        if (junOpenGLDisplayLight.builder().windows().length > 0) {
            junOpenGLDisplayLight._windowExpandAndRaise();
        } else {
            junOpenGLDisplayLight.openPositionLight();
        }
    }

    public void openLight5() {
        JunOpenGLDisplayLight junOpenGLDisplayLight = this.displayLight5();
        if (junOpenGLDisplayLight.builder().windows().length > 0) {
            junOpenGLDisplayLight._windowExpandAndRaise();
        } else {
            junOpenGLDisplayLight.openAmbientLight();
        }
    }

    public void polygonSmooth() {
        this.openGLProjector().polygonSmooth_(!this.openGLProjector().polygonSmooth());
        this.updateViewMenuIndication();
        this.changed_(JunOpenGL3dModel.$((String)"smoothing"));
    }

    public void resetView() {
        this.flushProjector();
        this.fit();
        this.updateMenuIndication();
    }

    public StMenuBar _menuBar() {
        if (this._menuBar == null) {
            this._menuBar = new StMenuBar();
            this._menuBar.add(this._createViewMenu());
            this._menuBar.add(this._createLightMenu());
        }
        return this._menuBar;
    }

    protected StMenu _createViewMenu() {
        StMenu stMenu = new StMenu((Object)JunOpenGL3dModel.$String((String)"View"), JunOpenGL3dModel.$((String)"viewMenu"));
        stMenu.add(new StMenuItem((Object)JunOpenGL3dModel.$String((String)"Background color"), (MenuListener)new MenuPerformer((StObject)this, "changeBackgroundColor")));
        stMenu.addSeparator();
        StMenu stMenu2 = new StMenu((Object)JunOpenGL3dModel.$String((String)"Zooming"), JunOpenGL3dModel.$((String)"zoomingMenu"));
        stMenu2.add(new StMenuItem((Object)JunOpenGL3dModel.$String((String)"Fit zoom"), (MenuListener)new MenuPerformer((StObject)this, "fitZoom")));
        stMenu2.add(new StMenuItem((Object)JunOpenGL3dModel.$String((String)"Close up"), (MenuListener)new MenuPerformer((StObject)this, "closeUp")));
        stMenu2.addSeparator();
        stMenu2.add(new StMenuItem((Object)JunOpenGL3dModel.$String((String)"Zoom"), (MenuListener)new MenuPerformer((StObject)this, "zoom")));
        stMenu2.add(new StMenuItem((Object)JunOpenGL3dModel.$String((String)"Pan"), (MenuListener)new MenuPerformer((StObject)this, "pan")));
        stMenu.add((StMenuItem)stMenu2);
        StMenu stMenu3 = new StMenu((Object)JunOpenGL3dModel.$String((String)"Pointing"), JunOpenGL3dModel.$((String)"pointingMenu"));
        stMenu3.add(new StMenuItem((Object)JunOpenGL3dModel.$String((String)"Fit sight"), (MenuListener)new MenuPerformer((StObject)this, "fitSight")));
        stMenu3.addSeparator();
        stMenu3.add(new StMenuItem((Object)(JunOpenGL3dModel.$String((String)"Eye point") + "..."), (MenuListener)new MenuPerformer((StObject)this, "changeEyePoint")));
        stMenu3.add(new StMenuItem((Object)(JunOpenGL3dModel.$String((String)"Sight point") + "..."), (MenuListener)new MenuPerformer((StObject)this, "changeSightPoint")));
        stMenu3.add(new StMenuItem((Object)(JunOpenGL3dModel.$String((String)"Up vector") + "..."), (MenuListener)new MenuPerformer((StObject)this, "changeUpVector")));
        stMenu3.addSeparator();
        stMenu3.add(new StMenuItem((Object)(JunOpenGL3dModel.$String((String)"Zoom height") + "..."), (MenuListener)new MenuPerformer((StObject)this, "changeZoomHeight")));
        stMenu3.add(new StMenuItem((Object)(JunOpenGL3dModel.$String((String)"View factor") + "..."), (MenuListener)new MenuPerformer((StObject)this, "changeViewFactor")));
        stMenu.add((StMenuItem)stMenu3);
        stMenu.addSeparator();
        StMenu stMenu4 = new StMenu((Object)JunOpenGL3dModel.$String((String)"Projection"), JunOpenGL3dModel.$((String)"projectionMenu"));
        StRadioButtonGroup stRadioButtonGroup = new StRadioButtonGroup();
        stMenu4.add((StMenuItem)new StRadioButtonMenuItem((Object)JunOpenGL3dModel.$String((String)"Perspective Projection", (String)"Perspective"), JunOpenGL3dModel.$((String)"perspectiveProjectionMenu"), stRadioButtonGroup, (MenuListener)new MenuPerformer((StObject)this, "perspectiveProjection")));
        stMenu4.add((StMenuItem)new StRadioButtonMenuItem((Object)JunOpenGL3dModel.$String((String)"Parallel Projection", (String)"Parallel"), JunOpenGL3dModel.$((String)"parallelProjectionMenu"), stRadioButtonGroup, (MenuListener)new MenuPerformer((StObject)this, "parallelProjection")));
        stMenu.add((StMenuItem)stMenu4);
        StMenu stMenu5 = new StMenu((Object)JunOpenGL3dModel.$String((String)"Presentation"), JunOpenGL3dModel.$((String)"presentationMenu"));
        StRadioButtonGroup stRadioButtonGroup2 = new StRadioButtonGroup();
        stMenu5.add((StMenuItem)new StRadioButtonMenuItem((Object)JunOpenGL3dModel.$String((String)"Solid Presentation", (String)"Solid"), JunOpenGL3dModel.$((String)"solidPresentationMenu"), stRadioButtonGroup2, (MenuListener)new MenuPerformer((StObject)this, "solidPresentation")));
        stMenu5.add((StMenuItem)new StRadioButtonMenuItem((Object)JunOpenGL3dModel.$String((String)"Wireframe Presentation", (String)"Wireframe"), JunOpenGL3dModel.$((String)"wireframePresentationMenu"), stRadioButtonGroup2, (MenuListener)new MenuPerformer((StObject)this, "wireframePresentation")));
        stMenu5.add((StMenuItem)new StRadioButtonMenuItem((Object)JunOpenGL3dModel.$String((String)"Hidden-line Presentation", (String)"Hidden-line"), JunOpenGL3dModel.$((String)"hiddenlinePresentationMenu"), stRadioButtonGroup2, (MenuListener)new MenuPerformer((StObject)this, "hiddenlinePresentation")));
        stMenu.add((StMenuItem)stMenu5);
        StMenu stMenu6 = new StMenu((Object)JunOpenGL3dModel.$String((String)"Shading"), JunOpenGL3dModel.$((String)"shadingMenu"));
        StRadioButtonGroup stRadioButtonGroup3 = new StRadioButtonGroup();
        stMenu6.add((StMenuItem)new StRadioButtonMenuItem((Object)JunOpenGL3dModel.$String((String)"Flat Shading", (String)"Flat"), JunOpenGL3dModel.$((String)"flatShadingMenu"), stRadioButtonGroup3, (MenuListener)new MenuPerformer((StObject)this, "flatShading")));
        stMenu6.add((StMenuItem)new StRadioButtonMenuItem((Object)JunOpenGL3dModel.$String((String)"Smooth Shading", (String)"Smooth"), JunOpenGL3dModel.$((String)"smoothShadingMenu"), stRadioButtonGroup3, (MenuListener)new MenuPerformer((StObject)this, "smoothShading")));
        stMenu.add((StMenuItem)stMenu6);
        StMenu stMenu7 = new StMenu((Object)JunOpenGL3dModel.$String((String)"Smoothing"), JunOpenGL3dModel.$((String)"smoothingMenu"));
        stMenu7.add((StMenuItem)new StCheckBoxMenuItem((Object)JunOpenGL3dModel.$String((String)"Line smooth"), JunOpenGL3dModel.$((String)"lineSmoothMenu"), (MenuListener)new MenuPerformer((StObject)this, "lineSmooth")));
        stMenu7.add((StMenuItem)new StCheckBoxMenuItem((Object)JunOpenGL3dModel.$String((String)"Polygon smooth"), JunOpenGL3dModel.$((String)"polygonSmoothMenu"), (MenuListener)new MenuPerformer((StObject)this, "polygonSmooth")));
        stMenu.add((StMenuItem)stMenu7);
        stMenu.add(new StMenuItem((Object)JunOpenGL3dModel.$String((String)"Smoothing angle"), (MenuListener)new MenuPerformer((StObject)this, "changeSmoothingAngle")));
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)JunOpenGL3dModel.$String((String)"Reset"), JunOpenGL3dModel.$((String)"resetMenu"), (MenuListener)new MenuPerformer((StObject)this, "resetView")));
        stMenu.add((StMenuItem)this._createPresetProjectionMenu());
        return stMenu;
    }

    protected StMenu _createLightMenu() {
        StMenu stMenu = new StMenu((Object)JunOpenGL3dModel.$String((String)"Light"), JunOpenGL3dModel.$((String)"lightMenu"));
        stMenu.add((StMenuItem)new StCheckBoxMenuItem((Object)(JunOpenGL3dModel.$String((String)"Light") + "1"), JunOpenGL3dModel.$((String)"light1"), (MenuListener)new MenuPerformer((StObject)this, "openLight1")));
        stMenu.add((StMenuItem)new StCheckBoxMenuItem((Object)(JunOpenGL3dModel.$String((String)"Light") + "2"), JunOpenGL3dModel.$((String)"light2"), (MenuListener)new MenuPerformer((StObject)this, "openLight2")));
        stMenu.add((StMenuItem)new StCheckBoxMenuItem((Object)(JunOpenGL3dModel.$String((String)"Light") + "3"), JunOpenGL3dModel.$((String)"light3"), (MenuListener)new MenuPerformer((StObject)this, "openLight3")));
        stMenu.add((StMenuItem)new StCheckBoxMenuItem((Object)(JunOpenGL3dModel.$String((String)"Light") + "4"), JunOpenGL3dModel.$((String)"light4"), (MenuListener)new MenuPerformer((StObject)this, "openLight4")));
        stMenu.addSeparator();
        stMenu.add((StMenuItem)new StCheckBoxMenuItem((Object)JunOpenGL3dModel.$String((String)"Ambient Light", (String)"Ambient"), JunOpenGL3dModel.$((String)"light5"), (MenuListener)new MenuPerformer((StObject)this, "openLight5")));
        return stMenu;
    }

    protected StMenu _createPresetProjectionMenu() {
        StMenu stMenu = new StMenu((Object)JunOpenGL3dModel.$String((String)"Preset"), JunOpenGL3dModel.$((String)"presetMenu"));
        if (this._presetProjections != null) {
            for (int i = 0; i < this._presetProjections.length; ++i) {
                String string = this._presetProjections[i].description();
                if (string == null || string.length() == 0) {
                    string = "(no name)";
                }
                StMenuItem stMenuItem = new StMenuItem((Object)string, (MenuListener)new MenuPerformer((StObject)this, "defaultProjection_", (Object)this._presetProjections[i]));
                stMenu.add(stMenuItem);
            }
        }
        return stMenu;
    }

    public void updateMenuIndication() {
        this.updateViewMenuIndication();
        this.updateLightMenuIndication();
    }

    public void updateViewMenuIndication() {
        StMenu stMenu;
        if (this._menuBar() == null) {
            return;
        }
        StMenu stMenu2 = (StMenu)this._menuBar().atNameKey_(JunOpenGL3dModel.$((String)"viewMenu"));
        if (stMenu2 == null) {
            return;
        }
        boolean bl = !this.isEmpty();
        StMenuItem stMenuItem = stMenu2.atNameKey_(JunOpenGL3dModel.$((String)"zoomingMenu"));
        if (stMenuItem != null) {
            stMenuItem.beEnabled(bl);
        }
        if ((stMenuItem = stMenu2.atNameKey_(JunOpenGL3dModel.$((String)"pointingMenu"))) != null) {
            stMenuItem.beEnabled(bl);
        }
        if ((stMenuItem = stMenu2.atNameKey_(JunOpenGL3dModel.$((String)"resetMenu"))) != null) {
            stMenuItem.beEnabled(bl);
        }
        if ((stMenuItem = stMenu2.atNameKey_(JunOpenGL3dModel.$((String)"presetMenu"))) != null) {
            stMenuItem.beEnabled(bl && this._presetProjections != null && this._presetProjections.length > 0);
        }
        if ((stMenuItem = stMenu2.atNameKey_(JunOpenGL3dModel.$((String)"projectionMenu"))) != null) {
            stMenu = (StMenu)stMenuItem;
            if (this.openGLProjector().projection() instanceof JunOpenGLPerspectiveProjection) {
                stMenuItem = stMenu.atNameKey_(JunOpenGL3dModel.$((String)"perspectiveProjectionMenu"));
                if (stMenuItem != null) {
                    ((StRadioButtonMenuItem)stMenuItem).beOn();
                }
            } else {
                stMenuItem = stMenu.atNameKey_(JunOpenGL3dModel.$((String)"parallelProjectionMenu"));
                if (stMenuItem != null) {
                    ((StRadioButtonMenuItem)stMenuItem).beOn();
                }
            }
        }
        if ((stMenuItem = stMenu2.atNameKey_(JunOpenGL3dModel.$((String)"presentationMenu"))) != null) {
            stMenu = (StMenu)stMenuItem;
            if (this.openGLProjector().presentation() == JunOpenGL3dModel.$((String)"solidPresentation")) {
                stMenuItem = stMenu.atNameKey_(JunOpenGL3dModel.$((String)"solidPresentationMenu"));
                if (stMenuItem != null) {
                    ((StRadioButtonMenuItem)stMenuItem).beOn();
                }
            } else if (this.openGLProjector().presentation() == JunOpenGL3dModel.$((String)"wireframePresentation")) {
                stMenuItem = stMenu.atNameKey_(JunOpenGL3dModel.$((String)"wireframePresentationMenu"));
                if (stMenuItem != null) {
                    ((StRadioButtonMenuItem)stMenuItem).beOn();
                }
            } else if (this.openGLProjector().presentation() == JunOpenGL3dModel.$((String)"hiddenlinePresentation") && (stMenuItem = stMenu.atNameKey_(JunOpenGL3dModel.$((String)"hiddenlinePresentationMenu"))) != null) {
                ((StRadioButtonMenuItem)stMenuItem).beOn();
            }
        }
        if ((stMenuItem = stMenu2.atNameKey_(JunOpenGL3dModel.$((String)"shadingMenu"))) != null) {
            stMenu = (StMenu)stMenuItem;
            if (this.openGLProjector().shading() == JunOpenGL3dModel.$((String)"flatShading")) {
                stMenuItem = stMenu.atNameKey_(JunOpenGL3dModel.$((String)"flatShadingMenu"));
                if (stMenuItem != null) {
                    ((StRadioButtonMenuItem)stMenuItem).beOn();
                }
            } else {
                stMenuItem = stMenu.atNameKey_(JunOpenGL3dModel.$((String)"smoothShadingMenu"));
                if (stMenuItem != null) {
                    ((StRadioButtonMenuItem)stMenuItem).beOn();
                }
            }
        }
        if ((stMenuItem = stMenu2.atNameKey_(JunOpenGL3dModel.$((String)"smoothingMenu"))) != null) {
            stMenu = (StMenu)stMenuItem;
            if ((stMenuItem = stMenu.atNameKey_(JunOpenGL3dModel.$((String)"lineSmoothMenu"))) != null) {
                ((StCheckBoxMenuItem)stMenuItem).beSelected(this.openGLProjector().lineSmooth());
            }
            if ((stMenuItem = stMenu.atNameKey_(JunOpenGL3dModel.$((String)"polygonSmoothMenu"))) != null) {
                ((StCheckBoxMenuItem)stMenuItem).beSelected(this.openGLProjector().polygonSmooth());
            }
        }
    }

    public void updateLightMenuIndication() {
        if (this._menuBar() == null) {
            return;
        }
        StMenu stMenu = (StMenu)this._menuBar().atNameKey_(JunOpenGL3dModel.$((String)"lightMenu"));
        if (stMenu == null) {
            return;
        }
        for (int i = 1; i <= 5; ++i) {
            StCheckBoxMenuItem stCheckBoxMenuItem = (StCheckBoxMenuItem)stMenu.atNameKey_(JunOpenGL3dModel.$((String)("light" + i)));
            stCheckBoxMenuItem.beSelected(this.displayLights()[i - 1].isOn());
        }
    }

    public Jun3dPoint defaultEyePoint() {
        if (this.openGL3dObject() == null) {
            return new Jun3dPoint(10000.0, 10000.0, 10000.0);
        }
        Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)this.defaultProjectionTable().get(JunOpenGL3dModel.$((String)"eyePoint")));
        if (jun3dPoint != null) {
            return jun3dPoint;
        }
        Jun3dBoundingBox jun3dBoundingBox = this.boundingBox();
        double d = jun3dBoundingBox.origin().distance_(jun3dBoundingBox.corner());
        return new Jun3dPoint(d *= 2.0, d, d);
    }

    public void defaultEyePoint_(Jun3dPoint jun3dPoint) {
        this.defaultProjectionTable().put(JunOpenGL3dModel.$((String)"eyePoint"), jun3dPoint);
    }

    public Dimension defaultImageExtent() {
        return DefaultImageExtent;
    }

    public Color defaultLightColor() {
        return Color.gray;
    }

    public Jun3dPoint defaultLightPoint() {
        return new Jun3dPoint(0.0, 0.0, 1.0);
    }

    public StSymbol defaultPresentation() {
        StSymbol stSymbol = (StSymbol)this.defaultProjectionTable().get(JunOpenGL3dModel.$((String)"presentation"));
        if (stSymbol != null) {
            return stSymbol;
        }
        return JunOpenGL3dModel.$((String)"solidPresentation");
    }

    public void defaultPresentation_(StSymbol stSymbol) {
        if (stSymbol == JunOpenGL3dModel.$((String)"solidPresentation") || stSymbol == JunOpenGL3dModel.$((String)"wireframePresentation") || stSymbol == JunOpenGL3dModel.$((String)"hiddenlinePresentation")) {
            this.defaultProjectionTable().put(JunOpenGL3dModel.$((String)"presentation"), stSymbol);
        }
    }

    public StSymbol defaultProjection() {
        StSymbol stSymbol = (StSymbol)this.defaultProjectionTable().get(JunOpenGL3dModel.$((String)"projection"));
        if (stSymbol != null) {
            return stSymbol;
        }
        return JunOpenGLPerspectiveProjection.Type;
    }

    public void defaultProjection_(StSymbol stSymbol) {
        if (stSymbol == JunOpenGLParallelProjection.Type || stSymbol == JunOpenGLPerspectiveProjection.Type) {
            this.defaultProjectionTable().put(JunOpenGL3dModel.$((String)"projection"), stSymbol);
        }
    }

    public void defaultProjection_(JunOpenGLProjection junOpenGLProjection) {
        this.defaultProjection_(junOpenGLProjection.type());
        this.defaultEyePoint_(junOpenGLProjection.eyePoint());
        this.defaultSightPoint_(junOpenGLProjection.sightPoint());
        this.defaultUpVector_(junOpenGLProjection.upVector());
        this.defaultViewFactor_(junOpenGLProjection.viewFactor());
        this.defaultZoomHeight_(junOpenGLProjection.zoomHeight());
        this.flushProjector();
        this.changed_(JunOpenGL3dModel.$((String)"projection"));
    }

    public Map defaultProjectionTable() {
        if (this.defaultProjectionTable == null) {
            this.defaultProjectionTable = new HashMap();
        }
        return this.defaultProjectionTable;
    }

    public void defaultProjectionTable_(Map map) {
        this.defaultProjectionTable = map;
    }

    public StSymbol defaultShading() {
        StSymbol stSymbol = (StSymbol)this.defaultProjectionTable().get(JunOpenGL3dModel.$((String)"shading"));
        return stSymbol != null ? stSymbol : JunOpenGL3dModel.$((String)"smoothShading");
    }

    public void defaultShading_(StSymbol stSymbol) {
        if (stSymbol == JunOpenGL3dModel.$((String)"flatShading") || stSymbol == JunOpenGL3dModel.$((String)"smoothShading")) {
            this.defaultProjectionTable().put(JunOpenGL3dModel.$((String)"shading"), stSymbol);
        }
    }

    public Jun3dPoint defaultSightPoint() {
        if (this.openGL3dObject() == null) {
            return new Jun3dPoint(0.0, 0.0, 0.0);
        }
        Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)this.defaultProjectionTable().get(JunOpenGL3dModel.$((String)"sightPoint")));
        if (jun3dPoint != null) {
            return jun3dPoint;
        }
        return this.boundingBox().center();
    }

    public void defaultSightPoint_(Jun3dPoint jun3dPoint) {
        this.defaultProjectionTable().put(JunOpenGL3dModel.$((String)"sightPoint"), jun3dPoint);
    }

    public Jun3dPoint defaultUpVector() {
        Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)this.defaultProjectionTable().get(JunOpenGL3dModel.$((String)"upVector")));
        if (jun3dPoint != null) {
            return jun3dPoint;
        }
        return new Jun3dPoint(-1.0, -1.0, 1.0);
    }

    public void defaultUpVector_(Jun3dPoint jun3dPoint) {
        this.defaultProjectionTable().put(JunOpenGL3dModel.$((String)"upVector"), jun3dPoint);
    }

    public double defaultViewFactor() {
        Number number = (Number)this.defaultProjectionTable().get(JunOpenGL3dModel.$((String)"viewFactor"));
        if (number != null) {
            return number.doubleValue();
        }
        return 10.0;
    }

    public void defaultViewFactor_(double d) {
        this.defaultProjectionTable().put(JunOpenGL3dModel.$((String)"viewFactor"), new Double(d));
    }

    public double defaultZoomHeight() {
        Number number = (Number)this.defaultProjectionTable().get(JunOpenGL3dModel.$((String)"zoomHeight"));
        if (number != null) {
            return number.doubleValue();
        }
        return this.defaultZoomHeightFactor();
    }

    public void defaultZoomHeight_(double d) {
        this.defaultProjectionTable().put(JunOpenGL3dModel.$((String)"zoomHeight"), new Double(d));
    }

    public double defaultZoomHeightFactor() {
        return 2.5;
    }

    protected Jun3dPoint computeSightPoint() {
        return this.boundingBox().center();
    }

    protected double computeZoomHeight() {
        Rectangle rectangle;
        double d = this.openGLProjection().distance();
        Jun3dPoint jun3dPoint = this.openGLProjection().translateTo3dPointFromPoint_depth_(new Jun2dPoint(0.0, -1.0), d);
        Jun3dPoint jun3dPoint2 = this.openGLProjection().translateTo3dPointFromPoint_depth_(new Jun2dPoint(0.0, 1.0), d);
        Jun3dPoint jun3dPoint3 = this.openGLProjection().translateTo3dPointFromPoint_depth_(new Jun2dPoint(1.0, 0.0), d);
        Jun3dPoint jun3dPoint4 = this.openGLProjection().translateTo3dPointFromPoint_depth_(new Jun2dPoint(-1.0, 0.0), d);
        final JunPlane junPlane = new JunPlane(this.openGLProjection().eyePoint(), jun3dPoint4, jun3dPoint3);
        final JunPlane junPlane2 = new JunPlane(this.openGLProjection().eyePoint(), jun3dPoint, jun3dPoint2);
        final double[] dArray = new double[]{0.0, 0.0};
        this.pointsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                double d = junPlane2.distanceFromPoint_((Jun3dPoint)((Object)object));
                double d2 = junPlane.distanceFromPoint_((Jun3dPoint)((Object)object));
                if (d > dArray[0]) {
                    dArray[0] = d;
                }
                if (d2 > dArray[1]) {
                    dArray[1] = d2;
                }
                return null;
            }
        });
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = 0.0;
        JunOpenGL3dView junOpenGL3dView = this.getOpenGLView();
        Rectangle rectangle2 = rectangle = junOpenGL3dView == null ? null : junOpenGL3dView.toComponent().getBounds();
        if (rectangle != null && rectangle.height != 0 && d2 != 0.0 && d3 != 0.0) {
            if (d3 * (double)rectangle.width / (double)rectangle.height < d2) {
                double d5 = (double)rectangle.width * d3 * d3 / ((double)rectangle.height * d2);
                d4 = d3 * d3 / d5;
            } else {
                d4 = d3;
            }
        } else {
            d4 = Math.max(d2, d3);
        }
        return d4 *= this.defaultZoomHeightFactor();
    }

    protected Jun3dPoint grab3dPoint_(Jun2dPoint jun2dPoint) {
        JunOpenGLParallelProjection junOpenGLParallelProjection;
        Jun3dLine jun3dLine;
        JunOpenGLProjection junOpenGLProjection = this.openGLProjection();
        JunSphereSurface junSphereSurface = this.grabSphere();
        Jun3dPoint[] jun3dPointArray = junSphereSurface.crossPointsWithLine_(jun3dLine = new Jun3dLine((junOpenGLParallelProjection = junOpenGLProjection.asParallelProjection()).translateTo3dPointInNearBoundaryPlaneFromPoint_(jun2dPoint), junOpenGLParallelProjection.translateTo3dPointInFarBoundaryPlaneFromPoint_(jun2dPoint)));
        if (jun3dPointArray.length == 0) {
            return junOpenGLParallelProjection.translateTo3dPointFromPoint_(jun2dPoint);
        }
        return jun3dPointArray[0];
    }

    protected JunSphereSurface grabSphere() {
        JunOpenGLProjection junOpenGLProjection = this.openGLProjection();
        JunSphereSurface junSphereSurface = new JunSphereSurface(junOpenGLProjection.sightPoint(), junOpenGLProjection.regularHeight() / 2.0);
        return junSphereSurface;
    }

    public StView getView() {
        return this.getOpenGLView();
    }

    protected JunOpenGL3dView getOpenGLView() {
        DependentListener[] dependentListenerArray = this.dependents();
        for (int i = 0; i < dependentListenerArray.length; ++i) {
            DependentListener dependentListener = dependentListenerArray[i];
            if (!(dependentListener instanceof JunOpenGL3dView) || ((JunOpenGL3dView)dependentListener).getOpenGL3dModel() != this) continue;
            return (JunOpenGL3dView)dependentListener;
        }
        return null;
    }

    protected JunOpenGL3dView getOpenGLViewWith(JunOpenGLDrawable junOpenGLDrawable) {
        DependentListener[] dependentListenerArray = this.dependents();
        for (int i = 0; i < dependentListenerArray.length; ++i) {
            JunOpenGL3dView junOpenGL3dView;
            DependentListener dependentListener = dependentListenerArray[i];
            if (!(dependentListener instanceof JunOpenGL3dView) || (junOpenGL3dView = (JunOpenGL3dView)dependentListener).getOpenGLDrawable() != junOpenGLDrawable) continue;
            return junOpenGL3dView;
        }
        return null;
    }

    protected JunOpenGLDrawable createOpenGLDrawable(Class clazz) {
        if (clazz != null && !JunOpenGLDrawable.class.isAssignableFrom(clazz)) {
            System.err.println("The specified class is not a kind of JunOpenGLDrawable : " + clazz);
            clazz = null;
        }
        if (clazz == null) {
            clazz = JunOpenGLResource.GetDefaultOpenGLDrawableClass();
        }
        JunOpenGLDrawable junOpenGLDrawable = null;
        try {
            junOpenGLDrawable = (JunOpenGLDrawable)clazz.newInstance();
            junOpenGLDrawable.setRenderer(this);
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return junOpenGLDrawable;
    }
}

