/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Timer;
import java.util.TimerTask;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.opengl.display.JunOpenGL3dView;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayView;
import jp.co.sra.jun.opengl.support.JunOpenGLDrawable;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StView;

public class JunOpenGLDisplayController
extends JunAbstractController
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected static final long _InertiaTime = 100L;
    protected Jun2dPoint movementVector;
    protected Point _startPoint;
    protected Point _previousPoint;
    protected Timer _rotationTimer;
    protected long _pressTime;
    protected Rectangle _boundingBox;
    protected Cursor _savedCursor;

    public void initialize() {
        super.initialize();
        this.movementVector = null;
        this._startPoint = null;
        this._previousPoint = null;
        this._rotationTimer = null;
        this._pressTime = -1L;
        this._boundingBox = null;
        this._savedCursor = null;
    }

    public void release() {
        Component component = this.getOpenGLDrawable().toComponent();
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        component.removeMouseWheelListener(this);
        this.flushMovementVector();
        super.release();
    }

    protected void buildListener(StView stView) {
        Component component = this.getOpenGLDrawable().toComponent();
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        component.addMouseWheelListener(this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.view = null;
    }

    protected JunOpenGLDisplayModel getOpenGLDisplayModel() {
        return (JunOpenGLDisplayModel)this.model();
    }

    protected JunOpenGLDisplayView getOpenGLDisplayView() {
        return (JunOpenGLDisplayView)this.view();
    }

    protected JunOpenGLDrawable getOpenGLDrawable() {
        return this.getOpenGLDisplayView().getOpenGLDrawable();
    }

    protected JunOpenGL3dView getOpenGLView() {
        return this.getOpenGLDisplayView().getOpenGLView();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.getOpenGLDisplayModel().noControl()) {
            return;
        }
        super.mousePressed(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.getOpenGLDisplayModel().noControl()) {
            return;
        }
        super.mouseReleased(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        StSymbol stSymbol = this.getOpenGLDisplayModel().buttonState();
        if (stSymbol == null) {
            return;
        }
        Component component = this.getOpenGLDrawable().toComponent();
        this._savedCursor = component.getCursor();
        if (stSymbol == JunOpenGLDisplayController.$((String)"pick")) {
            component.setCursor(JunCursors.CrossCursor());
        } else if (stSymbol == JunOpenGLDisplayController.$((String)"grab")) {
            component.setCursor(JunCursors.HandCursor());
        } else if (stSymbol == JunOpenGLDisplayController.$((String)"drag")) {
            component.setCursor(JunCursors.QuartersCursor());
        } else if (stSymbol == JunOpenGLDisplayController.$((String)"focus")) {
            component.setCursor(JunCursors.GlassCursor());
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.getOpenGLDrawable().toComponent().setCursor(this._savedCursor);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point;
        if (this._startPoint != null && !(point = mouseEvent.getPoint()).equals(this._previousPoint)) {
            this.mouseDraggedFrom_to_with_(this._previousPoint, point, mouseEvent);
            this._previousPoint = point;
            this._pressTime = System.currentTimeMillis();
        }
        Thread.yield();
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.getOpenGLDisplayModel().wheel_at_in_(mouseWheelEvent.getUnitsToScroll(), mouseWheelEvent.getPoint(), this.getOpenGLDrawable().toComponent().getBounds());
    }

    public synchronized Jun2dPoint movementVector() {
        return this.movementVector;
    }

    public synchronized void movementVector_(Jun2dPoint jun2dPoint) {
        double d = Math.max(-1.0, Math.min(jun2dPoint.x(), 1.0));
        double d2 = Math.max(-1.0, Math.min(jun2dPoint.y(), 1.0));
        this.movementVector = new Jun2dPoint(d, d2);
    }

    public synchronized void flushMovementVector() {
        this.movementVector = null;
        Thread.yield();
    }

    public boolean useMovementProcess() {
        return this.getOpenGLDisplayModel().useMovementProcess();
    }

    public void useMovementProcess(boolean bl) {
        this.getOpenGLDisplayModel().useMovementProcess_(bl);
    }

    public void createMovementProcess() {
        if (!this.useMovementProcess()) {
            return;
        }
        if (this._rotationTimer != null) {
            this._rotationTimer.cancel();
        }
        this._rotationTimer = new Timer();
        this._rotationTimer.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                Jun2dPoint jun2dPoint = JunOpenGLDisplayController.this.movementVector();
                if (jun2dPoint == null || jun2dPoint.isZero()) {
                    JunOpenGLDisplayController.this._rotationTimer.cancel();
                    JunOpenGLDisplayController.this._rotationTimer = null;
                } else {
                    JunOpenGLDisplayController.this.getOpenGLDisplayModel().grab_(jun2dPoint);
                }
            }
        }, 0L, 83L);
    }

    protected void redButtonPressedActivity(MouseEvent mouseEvent) {
        this.flushMovementVector();
        this._previousPoint = this._startPoint = mouseEvent.getPoint();
        this._pressTime = System.currentTimeMillis();
        if (this.getOpenGLDisplayModel().buttonState() == JunOpenGLDisplayController.$((String)"pick")) {
            this.pickActivityOn_with_(this._startPoint, mouseEvent);
        }
    }

    protected void redButtonReleasedActivity(MouseEvent mouseEvent) {
        if (this._startPoint != null) {
            StSymbol stSymbol = this.getOpenGLDisplayModel().buttonState();
            if (stSymbol == JunOpenGLDisplayController.$((String)"grab")) {
                if (System.currentTimeMillis() - this._pressTime <= 100L && this.movementVector() != null) {
                    this.createMovementProcess();
                }
            } else if (stSymbol == JunOpenGLDisplayController.$((String)"focus")) {
                Jun2dBoundingBox jun2dBoundingBox = Jun2dBoundingBox.Origin_corner_(new Jun2dPoint(-1.0, -1.0), new Jun2dPoint(1.0, 1.0));
                Jun2dBoundingBox jun2dBoundingBox2 = this.mouse2dRectangle();
                this._hideBoundingBox();
                if (mouseEvent.isShiftDown()) {
                    this.getOpenGLDisplayModel().focus_to_(jun2dBoundingBox2, jun2dBoundingBox);
                } else {
                    this.getOpenGLDisplayModel().focus_to_(jun2dBoundingBox, jun2dBoundingBox2);
                }
            }
            this._startPoint = null;
        }
    }

    protected void yellowButtonActivity(MouseEvent mouseEvent) {
        this.flushMovementVector();
        if (this.getOpenGLDisplayModel().useYellowButtonMenu()) {
            this.view()._showPopupMenu(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected void mouseDraggedFrom_to_with_(Point point, Point point2, MouseEvent mouseEvent) {
        StSymbol stSymbol = this.getOpenGLDisplayModel().buttonState();
        if (stSymbol == JunOpenGLDisplayController.$((String)"grab")) {
            this.grabActivityFrom_to_(point, point2);
        } else if (stSymbol == JunOpenGLDisplayController.$((String)"drag")) {
            this.dragActivityFrom_to_with_(point, point2, mouseEvent);
        } else if (stSymbol == JunOpenGLDisplayController.$((String)"focus")) {
            this.focusActivityFrom_to_(point, point2);
        } else if (this.getOpenGLDisplayModel().usePressActivity()) {
            this.pressActivityOn_with_(point2, mouseEvent);
        }
    }

    protected void grabActivityFrom_to_(Point point, Point point2) {
        this.flushMovementVector();
        Jun2dPoint jun2dPoint = this.mouse2dPoint_(point);
        Jun2dPoint jun2dPoint2 = this.mouse2dPoint_(point2);
        this.getOpenGLDisplayModel().grab_xy_(jun2dPoint, jun2dPoint2);
        this.movementVector_(jun2dPoint2.minus_(jun2dPoint));
    }

    protected void dragActivityFrom_to_with_(Point point, Point point2, MouseEvent mouseEvent) {
        Jun2dPoint jun2dPoint = this.mouse2dPoint_(point);
        Jun2dPoint jun2dPoint2 = this.mouse2dPoint_(point2);
        if (mouseEvent.isShiftDown()) {
            this.getOpenGLDisplayModel().look_xy_(jun2dPoint, jun2dPoint2);
        } else {
            this.getOpenGLDisplayModel().slide_xy_(jun2dPoint, jun2dPoint2);
        }
    }

    protected void focusActivityFrom_to_(Point point, Point point2) {
        int n = Math.min(this._startPoint.x, point2.x);
        int n2 = Math.min(this._startPoint.y, point2.y);
        int n3 = Math.max(this._startPoint.x, point2.x);
        int n4 = Math.max(this._startPoint.y, point2.y);
        Rectangle rectangle = new Rectangle(n, n2, n3 - n, n4 - n2);
        this._showBoundingBox(rectangle);
    }

    protected void pickActivityOn_with_(Point point, MouseEvent mouseEvent) {
        this.flushMovementVector();
        this.getOpenGLDisplayModel().pick_with_(this.mouse2dPoint_(point), mouseEvent);
    }

    protected void pressActivityOn_with_(Point point, MouseEvent mouseEvent) {
        this.getOpenGLDisplayModel().press_with_(this.mouse2dPoint_(point), mouseEvent);
    }

    protected Rectangle _getBoundingBox() {
        return this._boundingBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _showBoundingBox(Rectangle rectangle) {
        if (this._boundingBox != null) {
            this._hideBoundingBox();
        }
        this._boundingBox = rectangle;
        Graphics graphics = null;
        try {
            graphics = this.getOpenGLDrawable().toComponent().getGraphics();
            graphics.setColor(Color.white);
            graphics.setXORMode(Color.black);
            graphics.drawRect(this._boundingBox.x, this._boundingBox.y, this._boundingBox.width, this._boundingBox.height);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _hideBoundingBox() {
        if (this._boundingBox == null) {
            return;
        }
        Graphics graphics = null;
        try {
            graphics = this.getOpenGLDrawable().toComponent().getGraphics();
            graphics.setColor(Color.white);
            graphics.setXORMode(Color.black);
            graphics.drawRect(this._boundingBox.x, this._boundingBox.y, this._boundingBox.width, this._boundingBox.height);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
        this._boundingBox = null;
    }

    protected Jun2dPoint mouse2dPoint_(Point point) {
        return Jun2dPoint.Coerce_(this.regularizePoint_(point));
    }

    protected Jun2dBoundingBox mouse2dRectangle() {
        Rectangle rectangle = this._getBoundingBox();
        rectangle = rectangle == null ? new Rectangle(this._startPoint.x, this._startPoint.y, 0, 0) : new Rectangle(rectangle);
        if (rectangle.height <= 2) {
            int n = Math.max(this.getOpenGLDrawable().toComponent().getBounds().height / 4, 8);
            rectangle.grow(n, n);
        }
        Jun2dPoint jun2dPoint = this.regularizePoint_(new Point(rectangle.x, rectangle.y));
        Jun2dPoint jun2dPoint2 = this.regularizePoint_(new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
        return Jun2dBoundingBox.Origin_corner_(jun2dPoint, jun2dPoint2);
    }

    protected Jun2dPoint regularizePoint_(Point point) {
        Dimension dimension = this.getOpenGLDrawable().toComponent().getSize();
        double d = ((double)point.x - (double)dimension.width / 2.0) / ((double)dimension.height / 2.0);
        double d2 = -((double)point.y - (double)dimension.height / 2.0) / ((double)dimension.height / 2.0);
        return new Jun2dPoint(d, d2);
    }
}

