/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.grapher;

import java.awt.Color;
import java.io.Writer;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.goodies.lisp.JunLispParser;
import jp.co.sra.jun.opengl.grapher.JunOpenGL3dArc;
import jp.co.sra.jun.opengl.grapher.JunOpenGL3dGraph;
import jp.co.sra.jun.opengl.grapher.JunOpenGL3dNode;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StReadStream;

public abstract class JunOpenGL3dGraphAbstract
extends JunOpenGL3dObject {
    protected JunOpenGL3dObject displayObject;
    protected Color displayColor;

    public static Class DefaultArcClass() {
        return JunOpenGL3dArc.class;
    }

    public static Class DefaultGraphClass() {
        return JunOpenGL3dGraph.class;
    }

    public static Class DefaultNodeClass() {
        return JunOpenGL3dNode.class;
    }

    public static JunOpenGL3dGraphAbstract LoadFrom_(Class clazz, StReadStream stReadStream) {
        JunLispList junLispList = (JunLispList)((Object)JunLispParser.Parse_(stReadStream));
        try {
            JunOpenGL3dGraphAbstract junOpenGL3dGraphAbstract = (JunOpenGL3dGraphAbstract)((Object)JunOpenGL3dGraphAbstract._PerformWith((Class)clazz, (String)"FromLispList_", (Object)((Object)junLispList)));
            return junOpenGL3dGraphAbstract;
        }
        catch (Exception exception) {
            throw new SmalltalkException(exception);
        }
    }

    public JunOpenGL3dGraphAbstract() {
    }

    protected JunOpenGL3dGraphAbstract(JunLispList junLispList) {
        super(junLispList);
    }

    public JunOpenGL3dCompoundObject asCompoundObject() {
        return new JunOpenGL3dCompoundObject(this.displayObject());
    }

    public Jun3dPoint[] asPointArray() {
        return this.displayObject().asPointArray();
    }

    public Jun3dBoundingBox boundingBox() {
        return this.displayObject().boundingBox();
    }

    public Color color() {
        return this.displayColor;
    }

    public void color_(Color color) {
        this.displayColor = color;
        this.flushDisplayObject();
    }

    public void establishAllNormalVectorsWithSmoothingAngle_(JunAngle junAngle) {
        if (this.displayObject != null) {
            this.displayObject.establishAllNormalVectorsWithSmoothingAngle_(junAngle);
        }
    }

    public void flushAllAlphas() {
        this.flushAlpha();
        if (this.displayObject != null) {
            this.displayObject.flushAllAlphas();
        }
    }

    public void flushAllBounds() {
        this.flushBounds();
        if (this.displayObject != null) {
            this.displayObject.flushAllBounds();
        }
    }

    public void flushAllColors() {
        this.flushColors();
        if (this.displayObject != null) {
            this.displayObject.flushAllColors();
        }
    }

    public void flushAllNames() {
        this.flushName();
        if (this.displayObject != null) {
            this.displayObject.flushAllNames();
        }
    }

    public void flushAllNormalVectors() {
        this.flushNormalVectors();
        if (this.displayObject != null) {
            this.displayObject.flushAllNormalVectors();
        }
    }

    public void flushAllPaints() {
        this.flushPaint();
        if (this.displayObject != null) {
            this.displayObject.flushAllPaints();
        }
    }

    protected void colorFromLispList(JunLispList junLispList) {
        Number number;
        Number number2;
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 1.$((String)"color"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        Number number3 = (Number)(junLispCons = (JunLispCons)((Object)junLispCons.tail())).nth_(1);
        if (number3 instanceof Integer) {
            number3 = new Float(Math.max(0.0f, Math.min(number3.floatValue() / 255.0f, 1.0f)));
        }
        if ((number2 = (Number)junLispCons.nth_(2)) instanceof Integer) {
            number2 = new Float(Math.max(0.0f, Math.min(number2.floatValue() / 255.0f, 1.0f)));
        }
        if ((number = (Number)junLispCons.nth_(3)) instanceof Integer) {
            number = new Float(Math.max(0.0f, Math.min(number.floatValue() / 255.0f, 1.0f)));
        }
        this.color_(new Color(number3.floatValue(), number2.floatValue(), number.floatValue()));
    }

    protected JunLispList colorToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dGraphAbstract.$((String)"color"));
        Color color = this.color();
        junLispCons.add_(new Float((float)color.getRed() / 255.0f));
        junLispCons.add_(new Float((float)color.getGreen() / 255.0f));
        junLispCons.add_(new Float((float)color.getBlue() / 255.0f));
        if (this.hasAlpha()) {
            junLispCons.add_(new Float(this.alpha()));
        }
        return junLispCons;
    }

    public StObject copy() {
        return this;
    }

    protected abstract JunOpenGL3dObject createDisplayObject();

    public JunOpenGL3dObject displayObject() {
        if (this.displayObject == null) {
            this.displayObject = this.createDisplayObject();
        }
        return this.displayObject;
    }

    protected void flushDisplayObject() {
        this.displayObject = null;
    }

    public void fromLispList(JunLispList junLispList) {
        super.fromLispList(junLispList);
    }

    protected String generateIdString() {
        return JunOpenGL3dObject.UniqueId();
    }

    public Object geometriesDo_(StBlockClosure stBlockClosure) {
        if (this.displayObject() == null) {
            return null;
        }
        return this.displayObject().geometriesDo_(stBlockClosure);
    }

    public boolean hasColor() {
        return this.color() != null;
    }

    public boolean isArc() {
        return false;
    }

    public boolean isGraph() {
        return false;
    }

    public boolean isNode() {
        return false;
    }

    public int numberOfPolygons() {
        if (this.displayObject() == null) {
            return 0;
        }
        return this.displayObject().numberOfPolygons();
    }

    public int numberOfPrimitives() {
        if (this.displayObject() == null) {
            return 0;
        }
        return this.displayObject().numberOfPrimitives();
    }

    public Object objectsDo_(StBlockClosure stBlockClosure) {
        if (this.displayObject() == null) {
            return null;
        }
        return this.displayObject().objectsDo_(stBlockClosure);
    }

    public void pointsDo_(StBlockClosure stBlockClosure) {
        if (this.displayObject() == null) {
            return;
        }
        this.displayObject().pointsDo_(stBlockClosure);
    }

    public void polygonsDo_(StBlockClosure stBlockClosure) {
        if (this.displayObject() == null) {
            return;
        }
        this.displayObject().polygonsDo_(stBlockClosure);
    }

    public void polylinesDo_(StBlockClosure stBlockClosure) {
        if (this.displayObject() == null) {
            return;
        }
        this.displayObject().polylinesDo_(stBlockClosure);
    }

    public Object primitivesDo_(StBlockClosure stBlockClosure) {
        if (this.displayObject() == null) {
            return null;
        }
        return this.displayObject().primitivesDo_(stBlockClosure);
    }

    public void renderOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        this.displayObject().renderOn_(junOpenGLRenderingContext);
    }

    public JunOpenGL3dObject reversed() {
        return this.displayObject().reversed();
    }

    public void setValue_(Object object) {
        this.displayObject = (JunOpenGL3dObject)((Object)object);
    }

    public Jun3dTransformation transformation() {
        return this.displayObject().transformation();
    }

    public Object value() {
        return this.displayObject();
    }

    public void vrml10On_(Writer writer) {
        JunOpenGL3dObject junOpenGL3dObject = this.displayObject();
        if (junOpenGL3dObject == null) {
            return;
        }
        junOpenGL3dObject.vrml10On_(writer);
    }

    public void vrml20On_(Writer writer) {
        JunOpenGL3dObject junOpenGL3dObject = this.displayObject();
        if (junOpenGL3dObject == null) {
            return;
        }
        junOpenGL3dObject.vrml20On_(writer);
    }

    public void vrmlOn_(Writer writer) {
        JunOpenGL3dObject junOpenGL3dObject = this.displayObject();
        if (junOpenGL3dObject == null) {
            return;
        }
        junOpenGL3dObject.vrmlOn_(writer);
    }
}

