/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.objects;

import java.awt.Color;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.ListIterator;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.picking.JunOpenGLPickingObjects;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;

public class JunOpenGL3dPatchedObject
extends JunOpenGL3dCompoundObject
implements JunOpenGLPickingObjects {
    protected ArrayList points;
    protected ArrayList colors;
    protected ArrayList normalVectors;
    protected ArrayList patches;

    public JunOpenGL3dPatchedObject() {
    }

    public JunOpenGL3dPatchedObject(JunOpenGL3dPolygon[] junOpenGL3dPolygonArray) {
        for (int i = 0; i < junOpenGL3dPolygonArray.length; ++i) {
            this.add_(junOpenGL3dPolygonArray[i]);
        }
    }

    public JunOpenGL3dPatchedObject(JunLispList junLispList) {
        this.fromLispList(junLispList);
    }

    protected void initialize() {
        super.initialize();
        this.points = new ArrayList();
        this.colors = new ArrayList();
        this.normalVectors = new ArrayList();
        this.patches = new ArrayList();
    }

    protected Jun3dPoint pointAt(int n) {
        return (Jun3dPoint)((Object)this.points.get(n));
    }

    protected int indexOfPoint(Jun3dPoint jun3dPoint) {
        int n = this.points.indexOf((Object)jun3dPoint);
        if (n < 0) {
            n = this.points.size();
            this.points.add(jun3dPoint);
        }
        return n;
    }

    protected Color colorAt(int n) {
        return (Color)this.colors.get(n);
    }

    protected int indexOfColor(Color color) {
        if (color == null) {
            return -1;
        }
        int n = this.colors.indexOf(color);
        if (n < 0) {
            n = this.colors.size();
            this.colors.add(color);
        }
        return n;
    }

    protected Jun3dPoint normalVectorAt(int n) {
        return (Jun3dPoint)((Object)this.normalVectors.get(n));
    }

    protected int indexOfNormalVector(Jun3dPoint jun3dPoint) {
        if (jun3dPoint == null) {
            return -1;
        }
        int n = this.normalVectors.indexOf((Object)jun3dPoint);
        if (n < 0) {
            n = this.normalVectors.size();
            this.normalVectors.add(jun3dPoint);
        }
        return n;
    }

    protected ArrayList _components() {
        if (this.components == null) {
            this.components = new ArrayList();
            this.flushBounds();
            for (int i = 0; i < this.patches.size(); ++i) {
                Vertex[] vertexArray = (Vertex[])this.patches.get(i);
                Jun3dPoint[] jun3dPointArray = new Jun3dPoint[vertexArray.length];
                ArrayList<Color> arrayList = new ArrayList<Color>();
                ArrayList<Jun3dPoint> arrayList2 = new ArrayList<Jun3dPoint>();
                for (int j = 0; j < vertexArray.length; ++j) {
                    jun3dPointArray[j] = this.pointAt(vertexArray[j].pointIndex);
                    if (vertexArray[j].colorIndex >= 0) {
                        arrayList.add(this.colorAt(vertexArray[j].colorIndex));
                    }
                    if (vertexArray[j].vectorIndex < 0) continue;
                    arrayList2.add(this.normalVectorAt(vertexArray[j].vectorIndex));
                }
                JunOpenGL3dPolygon junOpenGL3dPolygon = new JunOpenGL3dPolygon(jun3dPointArray);
                if (!arrayList.isEmpty()) {
                    junOpenGL3dPolygon.colors_(arrayList.toArray(new Color[arrayList.size()]));
                }
                if (!arrayList2.isEmpty()) {
                    junOpenGL3dPolygon.normalVectors_(arrayList2.toArray(new Jun3dPoint[arrayList2.size()]));
                }
                this.components.add(junOpenGL3dPolygon);
            }
        }
        return this.components;
    }

    public void add_(JunOpenGL3dPolygon junOpenGL3dPolygon) {
        Jun3dPoint[] jun3dPointArray = junOpenGL3dPolygon.vertexes();
        Color[] colorArray = junOpenGL3dPolygon.hasColors() ? junOpenGL3dPolygon.colors() : null;
        Jun3dPoint[] jun3dPointArray2 = junOpenGL3dPolygon.hasNormalVectors() ? junOpenGL3dPolygon.normalVectors() : null;
        Vertex[] vertexArray = new Vertex[jun3dPointArray.length];
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            Jun3dPoint jun3dPoint = jun3dPointArray[i];
            Color color = null;
            if (colorArray != null && i < colorArray.length && colorArray[i] != null) {
                color = colorArray[i];
            }
            Jun3dPoint jun3dPoint2 = null;
            if (jun3dPointArray2 != null && i < jun3dPointArray2.length && jun3dPointArray2[i] != null) {
                jun3dPoint2 = jun3dPointArray2[i];
            }
            vertexArray[i] = new Vertex(this.indexOfPoint(jun3dPoint), this.indexOfColor(color), this.indexOfNormalVector(jun3dPoint2));
        }
        this.patches.add(vertexArray);
        this.flushComponents();
    }

    public JunOpenGL3dObject transform_(Jun3dTransformation jun3dTransformation) {
        JunOpenGL3dPatchedObject junOpenGL3dPatchedObject = new JunOpenGL3dPatchedObject();
        this._copyInto(junOpenGL3dPatchedObject);
        boolean bl = this.components != null;
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            junOpenGL3dPatchedObject.add_((JunOpenGL3dPolygon)junOpenGL3dObjectArray[i].transform_(jun3dTransformation));
        }
        if (bl) {
            JunOpenGL3dObject[] junOpenGL3dObjectArray2 = junOpenGL3dPatchedObject.components();
            for (int i = 0; i < junOpenGL3dObjectArray2.length; ++i) {
                junOpenGL3dObjectArray[i]._copyInto(junOpenGL3dObjectArray2[i]);
            }
        }
        return junOpenGL3dPatchedObject;
    }

    public boolean isCompoundBody() {
        return false;
    }

    public boolean isPatchedBody() {
        return true;
    }

    public boolean isSkinningBody() {
        return false;
    }

    public boolean hasColors() {
        return !this.colors.isEmpty();
    }

    public boolean hasNormalVectors() {
        return !this.normalVectors.isEmpty();
    }

    public StObject postCopy() {
        super.postCopy();
        this.points = (ArrayList)this.points.clone();
        this.colors = (ArrayList)this.colors.clone();
        this.normalVectors = (ArrayList)this.normalVectors.clone();
        this.patches = (ArrayList)this.patches.clone();
        return this;
    }

    public JunOpenGL3dCompoundObject asCompoundObject() {
        return new JunOpenGL3dCompoundObject(this.components());
    }

    public JunOpenGL3dObject reversed() {
        JunOpenGL3dPatchedObject junOpenGL3dPatchedObject = (JunOpenGL3dPatchedObject)this.copy();
        junOpenGL3dPatchedObject.patches = new ArrayList(this.patches.size());
        for (int i = 0; i < this.patches.size(); ++i) {
            Vertex[] vertexArray = (Vertex[])this.patches.get(i);
            Vertex[] vertexArray2 = new Vertex[vertexArray.length];
            for (int j = 0; j < vertexArray.length; ++j) {
                vertexArray2[vertexArray.length - j - 1] = new Vertex(vertexArray[j]);
            }
            junOpenGL3dPatchedObject.patches.add(vertexArray2);
        }
        return junOpenGL3dPatchedObject;
    }

    public int numberOfPolygons() {
        return this.patches.size();
    }

    public int numberOfPrimitives() {
        return this.patches.size();
    }

    public StSymbol kindName() {
        return JunOpenGL3dPatchedObject.$((String)"PatchedBody");
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(this.kindName());
        if (this.hasName()) {
            junLispCons.add_((Object)this.nameToLispList());
        }
        if (this.hasColor()) {
            junLispCons.add_((Object)this.colorToLispList());
        }
        if (this.hasTexture()) {
            junLispCons.add_((Object)this.textureToLispList());
        }
        junLispCons.add_((Object)this.pointsToLispList());
        junLispCons.add_((Object)this.patchesToLispList());
        if (this.hasColors()) {
            junLispCons.add_((Object)this.colorsToLispList());
            junLispCons.add_((Object)this.colorIndexesToLispList());
        }
        if (this.hasNormalVectors()) {
            junLispCons.add_((Object)this.normalVectorsToLispList());
            junLispCons.add_((Object)this.normalVectorIndexesToLispList());
        }
        return junLispCons;
    }

    protected JunLispList pointsToLispList() {
        return new JunLispCons(JunOpenGL3dPatchedObject.$((String)"points"), (Object)JunLispCons.List_(this.points));
    }

    protected JunLispList patchesToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dPatchedObject.$((String)"patches"));
        for (int i = 0; i < this.patches.size(); ++i) {
            Vertex[] vertexArray = (Vertex[])this.patches.get(i);
            int[] nArray = new int[vertexArray.length];
            for (int j = 0; j < vertexArray.length; ++j) {
                nArray[j] = vertexArray[j].pointIndex + 1;
            }
            junLispCons.add_((Object)JunLispCons.List_(nArray));
        }
        return junLispCons;
    }

    protected JunLispList colorsToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dPatchedObject.$((String)"colors"));
        for (int i = 0; i < this.colors.size(); ++i) {
            Color color = this.colorAt(i);
            junLispCons.add_((Object)JunLispCons.List_(new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f}));
        }
        return junLispCons;
    }

    protected JunLispList colorIndexesToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dPatchedObject.$((String)"colorIndexes"));
        for (int i = 0; i < this.patches.size(); ++i) {
            Vertex[] vertexArray = (Vertex[])this.patches.get(i);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int j = 0; j < vertexArray.length; ++j) {
                if (vertexArray[j].colorIndex < 0) continue;
                arrayList.add(new Integer(vertexArray[j].colorIndex + 1));
            }
            junLispCons.add_((Object)JunLispCons.List_(arrayList));
        }
        return junLispCons;
    }

    protected JunLispList normalVectorsToLispList() {
        return new JunLispCons(JunOpenGL3dPatchedObject.$((String)"normalVectors"), (Object)JunLispCons.List_(this.normalVectors));
    }

    protected JunLispList normalVectorIndexesToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dPatchedObject.$((String)"normalVectorIndexes"));
        for (int i = 0; i < this.patches.size(); ++i) {
            Vertex[] vertexArray = (Vertex[])this.patches.get(i);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int j = 0; j < vertexArray.length; ++j) {
                if (vertexArray[j].vectorIndex < 0) continue;
                arrayList.add(new Integer(vertexArray[j].vectorIndex + 1));
            }
            junLispCons.add_((Object)JunLispCons.List_(arrayList));
        }
        return junLispCons;
    }

    public void fromLispList(JunLispList junLispList) {
        this.nameFromLispList(junLispList);
        this.colorFromLispList(junLispList);
        this.textureFromLispList(junLispList);
        this.pointsFromLispList(junLispList);
        this.patchesFromLispList(junLispList);
        this.colorsFromLispList(junLispList);
        this.colorIndexesFromLispList(junLispList);
        this.normalVectorsFromLispList(junLispList);
        this.normalVectorIndexesFromLispList(junLispList);
        this.transformationFromLispList(junLispList);
    }

    protected void pointsFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 1.$((String)"points"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.points = new ArrayList();
        Object object = junLispCons.tail();
        while (object instanceof JunLispCons) {
            Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)((JunLispCons)((Object)object)).head());
            this.points.add(jun3dPoint);
            object = ((JunLispCons)((Object)object)).tail();
        }
        this.flushComponents();
    }

    protected void patchesFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 2.$((String)"patches"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.patches = new ArrayList();
        Object object = junLispCons.tail();
        while (object instanceof JunLispCons) {
            Object[] objectArray = ((JunLispCons)((Object)((JunLispCons)((Object)object)).head())).asArray();
            Vertex[] vertexArray = new Vertex[objectArray.length];
            for (int i = 0; i < vertexArray.length; ++i) {
                int n = ((Number)objectArray[i]).intValue() - 1;
                vertexArray[i] = new Vertex(n);
            }
            this.patches.add(vertexArray);
            object = ((JunLispCons)((Object)object)).tail();
        }
        this.flushComponents();
    }

    protected void colorsFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 3.$((String)"colors"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.colors = new ArrayList();
        Object[] objectArray = ((JunLispCons)((Object)junLispCons.tail())).asArray();
        for (int i = 0; i < objectArray.length; ++i) {
            JunLispCons junLispCons2 = (JunLispCons)((Object)objectArray[i]);
            float f = ((Number)junLispCons2.nth_(1)).floatValue();
            float f2 = ((Number)junLispCons2.nth_(2)).floatValue();
            float f3 = ((Number)junLispCons2.nth_(3)).floatValue();
            float f4 = ((Number)junLispCons2.nth_(4)).floatValue();
            this.colors.add(new Color(f, f2, f3, f4));
        }
        this.flushComponents();
    }

    protected void colorIndexesFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 4.$((String)"colorIndexes"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        if (this.patches == null || this.patches.isEmpty()) {
            return;
        }
        ListIterator listIterator = this.patches.listIterator();
        Object object = junLispCons.tail();
        while (object instanceof JunLispCons) {
            Object[] objectArray = ((JunLispCons)((Object)((JunLispCons)((Object)object)).head())).asArray();
            Vertex[] vertexArray = (Vertex[])listIterator.next();
            for (int i = 0; i < objectArray.length; ++i) {
                vertexArray[i].colorIndex = ((Number)objectArray[i]).intValue() - 1;
            }
            object = ((JunLispCons)((Object)object)).tail();
        }
        this.flushComponents();
    }

    protected void normalVectorsFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 5.$((String)"normalVectors"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.normalVectors = new ArrayList();
        Object object = junLispCons.tail();
        while (object instanceof JunLispCons) {
            Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)((JunLispCons)((Object)object)).head());
            this.normalVectors.add(jun3dPoint);
            object = ((JunLispCons)((Object)object)).tail();
        }
        this.flushComponents();
    }

    protected void normalVectorIndexesFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 6.$((String)"normalVectorIndexes"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        if (this.patches == null || this.patches.isEmpty()) {
            return;
        }
        ListIterator listIterator = this.patches.listIterator();
        Object object = junLispCons.tail();
        while (object instanceof JunLispCons) {
            Object[] objectArray = ((JunLispCons)((Object)((JunLispCons)((Object)object)).head())).asArray();
            Vertex[] vertexArray = (Vertex[])listIterator.next();
            for (int i = 0; i < objectArray.length; ++i) {
                vertexArray[i].vectorIndex = ((Number)objectArray[i]).intValue() - 1;
            }
            object = ((JunLispCons)((Object)object)).tail();
        }
        this.flushComponents();
    }

    public void vrml10On_(Writer writer) {
        super.vrml10On_(writer);
    }

    public void vrml20On_(PrintWriter printWriter, String string) {
        printWriter.println(string + "Transform {");
        printWriter.println(string + "\t" + "children [");
        this.vrml20ShapeOn_(printWriter, string + "\t" + "\t");
        printWriter.println(string + "\t" + "] # children");
        Jun3dBoundingBox jun3dBoundingBox = this.boundingBox();
        Jun3dPoint jun3dPoint = jun3dBoundingBox.center();
        printWriter.print(string + "\t" + "bboxCenter ");
        printWriter.print((float)jun3dPoint.x());
        printWriter.print(' ');
        printWriter.print((float)jun3dPoint.y());
        printWriter.print(' ');
        printWriter.print((float)jun3dPoint.z());
        printWriter.println();
        printWriter.print(string + "\t" + "bboxSize ");
        printWriter.print((float)jun3dBoundingBox.width());
        printWriter.print(' ');
        printWriter.print((float)jun3dBoundingBox.height());
        printWriter.print(' ');
        printWriter.print((float)jun3dBoundingBox.depth());
        printWriter.println();
        printWriter.println(string + "} #Transform");
        printWriter.flush();
    }

    protected void vrml20GeometryOn_(PrintWriter printWriter, String string) {
        printWriter.println(string + "geometry " + this.vrml20IndexedSetName() + " {");
        this.vrml20CoordOn_(printWriter, string + "\t");
        this.vrml20CoordIndexOn_(printWriter, string + "\t");
        if (this.hasColors()) {
            this.vrml20ColorOn_(printWriter, string + "\t");
            this.vrml20ColorIndexOn_(printWriter, string + "\t");
        }
        if (this.hasNormalVectors()) {
            this.vrml20NormalOn_(printWriter, string + "\t");
            this.vrml20NormalIndexOn_(printWriter, string + "\t");
        }
        if (this.hasTexture() && this.texture().hasCoordinates()) {
            this.vrml20TexCoordOn_(printWriter, string + "\t");
            this.vrml20TexCoordIndexOn_(printWriter, string + "\t");
        }
        printWriter.println(string + "} #" + this.vrml20IndexedSetName());
    }

    protected void vrml20CoordOn_(PrintWriter printWriter, String string) {
        printWriter.println(string + "coord Coordinate {");
        printWriter.println(string + "\t" + "point [");
        for (int i = 0; i < this.points.size(); ++i) {
            Jun3dPoint jun3dPoint = this.pointAt(i);
            printWriter.print(string + "\t" + "\t");
            printWriter.print((float)jun3dPoint.x());
            printWriter.print(' ');
            printWriter.print((float)jun3dPoint.y());
            printWriter.print(' ');
            printWriter.print((float)jun3dPoint.z());
            if (i < this.points.size() - 1) {
                printWriter.print(',');
            }
            printWriter.println(" #" + i);
        }
        printWriter.println(string + "\t" + "] #point");
        printWriter.println(string + "} #Coordinate");
    }

    protected void vrml20CoordIndexOn_(PrintWriter printWriter, String string) {
        printWriter.println(string + "coordIndex [");
        for (int i = 0; i < this.patches.size(); ++i) {
            printWriter.print(string + "\t");
            Vertex[] vertexArray = (Vertex[])this.patches.get(i);
            for (int j = 0; j < vertexArray.length; ++j) {
                printWriter.print(vertexArray[j].pointIndex);
                printWriter.print(", ");
            }
            printWriter.println(-1);
        }
        printWriter.println(string + "] #coordIndex");
    }

    protected void vrml20ColorOn_(PrintWriter printWriter, String string) {
        printWriter.println(string + "color Color {");
        printWriter.println(string + "\t" + "color [");
        for (int i = 0; i < this.colors.size(); ++i) {
            Color color = this.colorAt(i);
            printWriter.print(string + "\t" + "\t");
            printWriter.print((float)color.getRed() / 255.0f);
            printWriter.print(' ');
            printWriter.print((float)color.getGreen() / 255.0f);
            printWriter.print(' ');
            printWriter.print((float)color.getBlue() / 255.0f);
            if (i < this.colors.size() - 1) {
                printWriter.print(',');
            }
            printWriter.println(" #" + i);
        }
        printWriter.println(string + "\t" + "] #color");
        printWriter.println(string + "} #Color");
    }

    protected void vrml20ColorIndexOn_(PrintWriter printWriter, String string) {
        printWriter.println(string + "colorIndex [");
        for (int i = 0; i < this.patches.size(); ++i) {
            printWriter.print(string + "\t");
            Vertex[] vertexArray = (Vertex[])this.patches.get(i);
            int n = -1;
            for (int j = 0; j < vertexArray.length; ++j) {
                if (vertexArray[j].colorIndex >= 0) {
                    n = vertexArray[j].colorIndex;
                }
                printWriter.print(n);
                printWriter.print(", ");
            }
            printWriter.println(-1);
        }
        printWriter.println(string + "] #colorIndex");
    }

    protected void vrml20NormalOn_(PrintWriter printWriter, String string) {
        printWriter.println(string + "normal Normal {");
        printWriter.println(string + "\t" + "vector [");
        for (int i = 0; i < this.normalVectors.size(); ++i) {
            Jun3dPoint jun3dPoint = this.normalVectorAt(i);
            printWriter.print(string + "\t" + "\t");
            printWriter.print((float)jun3dPoint.x());
            printWriter.print(' ');
            printWriter.print((float)jun3dPoint.y());
            printWriter.print(' ');
            printWriter.print((float)jun3dPoint.z());
            if (i < this.normalVectors.size() - 1) {
                printWriter.print(',');
            }
            printWriter.println(" #" + i);
        }
        printWriter.println(string + "\t" + "] #vector");
        printWriter.println(string + "} #Normal");
    }

    protected void vrml20NormalIndexOn_(PrintWriter printWriter, String string) {
        printWriter.println(string + "normalIndex [");
        for (int i = 0; i < this.patches.size(); ++i) {
            printWriter.print(string + "\t");
            Vertex[] vertexArray = (Vertex[])this.patches.get(i);
            int n = -1;
            for (int j = 0; j < vertexArray.length; ++j) {
                if (vertexArray[j].vectorIndex >= 0) {
                    n = vertexArray[j].vectorIndex;
                }
                printWriter.print(n);
                printWriter.print(", ");
            }
            printWriter.println(-1);
        }
        printWriter.println(string + "] #normalIndex");
    }

    protected void vrml20TexCoordOn_(PrintWriter printWriter, String string) {
        printWriter.println(string + "texCoord TextureCoordinate {");
        printWriter.println(string + "\t" + "point [");
        Jun2dPoint[] jun2dPointArray = this.texture().coordinates();
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            printWriter.print(string + "\t" + "\t");
            printWriter.print((float)jun2dPointArray[i].x());
            printWriter.print(' ');
            printWriter.print((float)jun2dPointArray[i].y());
            if (i < jun2dPointArray.length - 1) {
                printWriter.print(',');
            }
            printWriter.println(" #" + i);
        }
        printWriter.println(string + "\t" + "] #point");
        printWriter.println(string + "} #TextureCoordinate");
    }

    protected void vrml20TexCoordIndexOn_(PrintWriter printWriter, String string) {
        printWriter.println(string + "texCoordIndex [");
        int n = this.texture().coordinates().length;
        int n2 = 0;
        for (int i = 0; i < this.patches.size(); ++i) {
            printWriter.print(string + "\t");
            Vertex[] vertexArray = (Vertex[])this.patches.get(i);
            for (int j = 0; j < vertexArray.length; ++j) {
                printWriter.print(n2++);
                if (n2 >= n) {
                    n2 = 0;
                }
                printWriter.print(", ");
            }
            printWriter.println(-1);
        }
        printWriter.println(string + "] #texCoordIndex");
    }

    public static class Vertex {
        int pointIndex;
        int colorIndex;
        int vectorIndex;

        public Vertex(int n, int n2, int n3) {
            this.pointIndex = n;
            this.colorIndex = n2;
            this.vectorIndex = n3;
        }

        public Vertex(int n) {
            this(n, -1, -1);
        }

        public Vertex(Vertex vertex) {
            this(vertex.pointIndex, vertex.colorIndex, vertex.vectorIndex);
        }
    }
}

