/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.objects;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;

public class JunOpenGL3dSphere
extends JunOpenGL3dCompoundObject {
    protected static final Jun3dPoint DefaultCenter = new Jun3dPoint(0.0, 0.0, 0.0);
    protected static final double DefaultRadius = 1.0;
    protected static final int DefaultSlices = 20;
    protected static final int DefaultStacks = 10;
    protected Jun3dPoint center;
    protected double radius;
    protected int slices;
    protected int stacks;

    public JunOpenGL3dSphere(double d) {
        this(DefaultCenter, d, 20, 10);
    }

    public JunOpenGL3dSphere(double d, int n, int n2) {
        this(DefaultCenter, d, n, n2);
    }

    public JunOpenGL3dSphere(Jun3dPoint jun3dPoint, double d) {
        this(jun3dPoint, d, 20, 10);
    }

    public JunOpenGL3dSphere(Jun3dPoint jun3dPoint, double d, int n, int n2) {
        this.center_(jun3dPoint);
        this.radius_(d);
        this.slices_(n);
        this.stacks_(n2);
    }

    public JunOpenGL3dSphere(JunLispList junLispList) {
        this.fromLispList(junLispList);
    }

    protected void initialize() {
        super.initialize();
        this.center = null;
        this.radius = Double.NaN;
        this.slices = 20;
        this.stacks = 10;
    }

    public Jun3dPoint center() {
        if (this.center == null) {
            this.center = DefaultCenter;
        }
        return this.center;
    }

    public void center_(Jun3dPoint jun3dPoint) {
        this.center = jun3dPoint;
        this.flushComponents();
    }

    public double radius() {
        if (Double.isNaN(this.radius)) {
            this.radius = 1.0;
        }
        return this.radius;
    }

    public void radius_(double d) {
        this.radius = Math.max(d, 0.001);
        this.flushComponents();
    }

    public int slices() {
        return this.slices;
    }

    public void slices_(int n) {
        this.slices = Math.max(n, 4);
        this.flushComponents();
    }

    public int stacks() {
        return this.stacks;
    }

    public void stacks_(int n) {
        this.stacks = Math.max(n, 2);
        this.flushComponents();
    }

    protected ArrayList _components() {
        if (this.components == null) {
            this.components = new ArrayList();
            this.flushBounds();
            double d = Math.PI / (double)this.stacks();
            double d2 = Math.PI * 2 / (double)this.slices();
            for (int i = 0; i < this.stacks(); ++i) {
                double d3 = d * (double)i - 1.5707963267948966;
                for (int j = 0; j < this.slices(); ++j) {
                    double d4 = d2 * (double)j;
                    Jun3dPoint[] jun3dPointArray = new Jun3dPoint[]{this.pointAt(d3, d4), this.pointAt(d3, d4 + d2), this.pointAt(d3 + d, d4 + d2), this.pointAt(d3 + d, d4)};
                    JunOpenGL3dPolygon junOpenGL3dPolygon = new JunOpenGL3dPolygon(jun3dPointArray);
                    junOpenGL3dPolygon.paint_(null);
                    this.components.add(junOpenGL3dPolygon);
                }
            }
        }
        return this.components;
    }

    public JunOpenGL3dObject transform_(Jun3dTransformation jun3dTransformation) {
        JunOpenGL3dSphere junOpenGL3dSphere = (JunOpenGL3dSphere)this.copy();
        Jun3dPoint jun3dPoint = new Jun3dPoint(this.center().x() + this.radius(), this.center().y(), this.center().z());
        Jun3dPoint jun3dPoint2 = jun3dPoint.transform_(jun3dTransformation);
        Jun3dPoint jun3dPoint3 = this.center().transform_(jun3dTransformation);
        double d = jun3dPoint3.distance_(jun3dPoint2);
        junOpenGL3dSphere.center_(jun3dPoint3);
        junOpenGL3dSphere.radius_(d);
        return junOpenGL3dSphere;
    }

    public StObject postCopy() {
        super.postCopy();
        if (this.center != null) {
            this.center = new Jun3dPoint(this.center.x(), this.center.y(), this.center.z());
        }
        return this;
    }

    protected Jun3dPoint pointAt(double d, double d2) {
        double d3;
        double d4;
        double d5 = this.radius() * Math.cos(d) * Math.cos(d2);
        if (Math.abs(d5) < 1.0E-12) {
            d5 = 0.0;
        }
        if (Math.abs(d4 = this.radius() * Math.cos(d) * Math.sin(d2)) < 1.0E-12) {
            d4 = 0.0;
        }
        if (Math.abs(d3 = this.radius() * Math.sin(d)) < 1.0E-12) {
            d3 = 0.0;
        }
        return this.center().plus_(new Jun3dPoint(d5, d4, d3));
    }

    public StSymbol kindName() {
        return JunOpenGL3dSphere.$((String)"Sphere");
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(this.kindName());
        if (this.hasName()) {
            junLispCons.add_((Object)this.nameToLispList());
        }
        if (this.hasColor()) {
            junLispCons.add_((Object)this.colorToLispList());
        }
        if (this.hasTexture()) {
            junLispCons.add_((Object)this.textureToLispList());
        }
        junLispCons.add_((Object)this.centerToLispList());
        junLispCons.add_((Object)this.radiusToLispList());
        junLispCons.add_((Object)this.slicesToLispList());
        junLispCons.add_((Object)this.stacksToLispList());
        return junLispCons;
    }

    protected JunLispList centerToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dSphere.$((String)"center"));
        junLispCons.tail_((Object)this.center());
        return junLispCons;
    }

    protected JunLispList radiusToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dSphere.$((String)"radius"));
        junLispCons.tail_(new Double(this.radius()));
        return junLispCons;
    }

    protected JunLispList slicesToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dSphere.$((String)"slices"));
        junLispCons.tail_(new Integer(this.slices()));
        return junLispCons;
    }

    protected JunLispList stacksToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dSphere.$((String)"stacks"));
        junLispCons.tail_(new Integer(this.stacks()));
        return junLispCons;
    }

    public void fromLispList(JunLispList junLispList) {
        super.fromLispList(junLispList);
        this.centerFromLispList(junLispList);
        this.radiusFromLispList(junLispList);
        this.slicesFromLispList(junLispList);
        this.stacksFromLispList(junLispList);
    }

    protected void centerFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 1.$((String)"center"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.center_((Jun3dPoint)((Object)junLispCons.tail()));
    }

    protected void radiusFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 2.$((String)"radius"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.radius_(((Number)junLispCons.tail()).doubleValue());
    }

    protected void slicesFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 3.$((String)"slices"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.slices_(((Number)junLispCons.tail()).intValue());
    }

    protected void stacksFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 4.$((String)"stacks"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.stacks_(((Number)junLispCons.tail()).intValue());
    }

    public void vrml10On_(Writer writer) {
        super.vrml10On_(writer);
    }

    public void vrml20On_(PrintWriter printWriter, String string) {
        printWriter.println(string + "Transform {");
        printWriter.println(string + "\t" + "translation " + this.center().x() + " " + this.center().y() + " " + this.center().z());
        printWriter.println(string + "\t" + "children [");
        this.vrml20ShapeOn_(printWriter, string + "\t" + "\t");
        printWriter.println(string + "\t" + "] # children");
        printWriter.println(string + "} #Transform");
        printWriter.flush();
    }

    protected void vrml20GeometryOn_(PrintWriter printWriter, String string) {
        printWriter.println(string + "geometry Sphere { radius " + this.radius() + " }");
    }
}

