/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.objects;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.curves.Jun3dPolyline;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPrimitiveObject;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StValueHolder;

public abstract class JunOpenGL3dVertexesObject
extends JunOpenGL3dPrimitiveObject {
    protected Jun3dPoint[] vertexes;
    protected Color[] colors;
    protected Jun3dPoint[] normalVectors;
    protected Jun3dPoint preferredNormalVector;

    public JunOpenGL3dVertexesObject() {
    }

    public JunOpenGL3dVertexesObject(Jun3dPoint[] jun3dPointArray) {
        this();
        this.vertexes_(jun3dPointArray);
    }

    public JunOpenGL3dVertexesObject(Jun3dPoint[] jun3dPointArray, Color color) {
        this();
        this.vertexes_(jun3dPointArray);
        this.paint_(color);
    }

    public JunOpenGL3dVertexesObject(Jun3dPoint[] jun3dPointArray, Color color, float f) {
        this();
        this.vertexes_(jun3dPointArray);
        this.paint_(color);
        this.alpha_(f);
    }

    public JunOpenGL3dVertexesObject(Jun3dPoint[] jun3dPointArray, Color[] colorArray) {
        this();
        this.vertexes_(jun3dPointArray);
        this.colors_(colorArray);
    }

    public JunOpenGL3dVertexesObject(Jun3dPoint[] jun3dPointArray, Color[] colorArray, float f) {
        this();
        this.vertexes_(jun3dPointArray);
        this.colors_(colorArray);
        this.alpha_(f);
    }

    public JunOpenGL3dVertexesObject(Jun3dPoint[] jun3dPointArray, Jun3dPoint[] jun3dPointArray2) {
        this();
        this.vertexes_(jun3dPointArray);
        this.normalVectors_(jun3dPointArray2);
    }

    public JunOpenGL3dVertexesObject(Jun3dPoint[] jun3dPointArray, Jun3dPoint[] jun3dPointArray2, Color[] colorArray) {
        this();
        this.vertexes_(jun3dPointArray);
        this.normalVectors_(jun3dPointArray2);
        this.colors_(colorArray);
    }

    public JunOpenGL3dVertexesObject(Jun3dPoint[] jun3dPointArray, Jun3dPoint[] jun3dPointArray2, Color[] colorArray, float f) {
        this();
        this.vertexes_(jun3dPointArray);
        this.normalVectors_(jun3dPointArray2);
        this.colors_(colorArray);
        this.alpha_(f);
    }

    public JunOpenGL3dVertexesObject(Collection collection) {
        this();
        this.vertexes_(collection);
    }

    public JunOpenGL3dVertexesObject(Collection collection, Color color) {
        this();
        this.vertexes_(collection);
        this.paint_(color);
    }

    public JunOpenGL3dVertexesObject(Collection collection, Color color, float f) {
        this();
        this.vertexes_(collection);
        this.paint_(color);
        this.alpha_(f);
    }

    public JunOpenGL3dVertexesObject(JunLispList junLispList) {
        this();
        this.fromLispList(junLispList);
    }

    protected static JunOpenGL3dObject Vertexes_(Class clazz, Jun3dPoint[] jun3dPointArray) {
        JunOpenGL3dVertexesObject junOpenGL3dVertexesObject = (JunOpenGL3dVertexesObject)((Object)JunOpenGL3dVertexesObject._New((Class)clazz));
        junOpenGL3dVertexesObject.vertexes_(jun3dPointArray);
        return junOpenGL3dVertexesObject;
    }

    protected static JunOpenGL3dObject Vertexes_(Class clazz, Collection collection) {
        JunOpenGL3dVertexesObject junOpenGL3dVertexesObject = (JunOpenGL3dVertexesObject)((Object)JunOpenGL3dVertexesObject._New((Class)clazz));
        junOpenGL3dVertexesObject.vertexes_(collection);
        return junOpenGL3dVertexesObject;
    }

    protected static JunOpenGL3dObject Vertexes_paint_(Class clazz, Jun3dPoint[] jun3dPointArray, Color color) {
        JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dVertexesObject.Vertexes_(clazz, jun3dPointArray);
        junOpenGL3dObject.paint_(color);
        return junOpenGL3dObject;
    }

    protected void initialize() {
        super.initialize();
        this.vertexes = null;
        this.colors = null;
        this.normalVectors = null;
    }

    public Jun3dPoint[] vertexes() {
        return this.vertexes;
    }

    public void vertexes_(Jun3dPoint[] jun3dPointArray) {
        int n = jun3dPointArray.length;
        this.vertexes = new Jun3dPoint[n];
        System.arraycopy(jun3dPointArray, 0, this.vertexes, 0, n);
        this.flushBounds();
        this.flushNormalVectors();
    }

    public void vertexes_(Collection collection) {
        this.vertexes = new Jun3dPoint[collection.size()];
        collection.toArray(this.vertexes);
        this.flushBounds();
        this.flushNormalVectors();
    }

    public Jun3dPoint averagePoint() {
        final StValueHolder stValueHolder = new StValueHolder((Object)new Jun3dPoint(0.0, 0.0, 0.0));
        this.pointsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)stValueHolder.value());
                jun3dPoint = jun3dPoint.plus_((Jun3dPoint)((Object)object));
                stValueHolder.value_((Object)jun3dPoint);
                return null;
            }
        });
        Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)stValueHolder.value());
        Jun3dPoint jun3dPoint2 = jun3dPoint.dividedBy_(this.numberOfVertexes());
        return jun3dPoint2;
    }

    public Color[] colors() {
        return this.colors;
    }

    public void colors_(Color[] colorArray) {
        this.colors = colorArray;
    }

    public int numberOfVertexes() {
        return this.vertexes().length;
    }

    public Jun3dPoint vertexAt(int n) {
        return this.vertexes()[n];
    }

    public int indexOfVertex(Jun3dPoint jun3dPoint) {
        Jun3dPoint[] jun3dPointArray = this.vertexes();
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            if (!jun3dPointArray[i].equal_((Object)jun3dPoint)) continue;
            return i;
        }
        return -1;
    }

    public Jun3dPoint previousVertexOf(Jun3dPoint jun3dPoint) {
        int n = this.indexOfVertex(jun3dPoint);
        if (n < 0) {
            return null;
        }
        if (--n < 0) {
            n = this.numberOfVertexes() - 1;
        }
        return this.vertexAt(n);
    }

    public Jun3dPoint nextVertexOf(Jun3dPoint jun3dPoint) {
        int n = this.indexOfVertex(jun3dPoint);
        if (n < 0) {
            return null;
        }
        if (++n >= this.numberOfVertexes()) {
            n = 0;
        }
        return this.vertexAt(n);
    }

    public Jun3dPoint[] normalVectors() {
        if (this.normalVectors == null) {
            this.normalVectors = new Jun3dPoint[]{this.normalVector()};
        }
        return this.normalVectors;
    }

    public void normalVectors_(Jun3dPoint[] jun3dPointArray) {
        this.normalVectors = jun3dPointArray;
    }

    public Jun3dPoint normalVector() {
        if (this.preferredNormalVector == null) {
            this.preferredNormalVector = this.preferredNormalVector();
        }
        return this.preferredNormalVector;
    }

    public void normalVector_(Jun3dPoint jun3dPoint) {
        this.preferredNormalVector = jun3dPoint;
    }

    public Jun3dPoint normalUnitVector() {
        return this.normalVector().normalUnitVector();
    }

    public void establishAllNormalVectorsWithSmoothingAngle_(JunAngle junAngle) {
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[this.numberOfVertexes()];
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            jun3dPointArray[i] = this.normalVector();
        }
        this.normalVectors_(jun3dPointArray);
    }

    public void flushColors() {
        this.colors = null;
    }

    public void flushNormalVectors() {
        this.normalVectors = null;
    }

    public boolean isVertexesObject() {
        return true;
    }

    public boolean hasColors() {
        return this.colors != null;
    }

    public boolean hasNormalVectors() {
        return this.normalVectors != null;
    }

    public StObject postCopy() {
        Object[] objectArray;
        super.postCopy();
        if (this.vertexes != null) {
            objectArray = new Jun3dPoint[this.vertexes.length];
            System.arraycopy(this.vertexes, 0, objectArray, 0, this.vertexes.length);
            this.vertexes = objectArray;
        }
        if (this.colors != null) {
            objectArray = new Color[this.colors.length];
            System.arraycopy(this.colors, 0, objectArray, 0, this.colors.length);
            this.colors = objectArray;
        }
        if (this.normalVectors != null) {
            objectArray = new Jun3dPoint[this.normalVectors.length];
            System.arraycopy(this.normalVectors, 0, objectArray, 0, this.normalVectors.length);
            this.normalVectors = objectArray;
        }
        if (this.preferredNormalVector != null) {
            this.preferredNormalVector = new Jun3dPoint(this.preferredNormalVector);
        }
        return this;
    }

    public void pointsDo_(StBlockClosure stBlockClosure) {
        for (int i = 0; i < this.vertexes.length; ++i) {
            stBlockClosure.value_((Object)this.vertexes[i]);
        }
    }

    public Jun3dLine[] asArrayOfLines() {
        Jun3dPoint[] jun3dPointArray = this.vertexes();
        Jun3dPoint[] jun3dPointArray2 = new Jun3dPoint[jun3dPointArray.length];
        for (int i = 0; i < jun3dPointArray2.length; ++i) {
            jun3dPointArray2[i] = new Jun3dPoint(jun3dPointArray[i]);
        }
        Jun3dPolyline jun3dPolyline = new Jun3dPolyline(jun3dPointArray2);
        return jun3dPolyline.asArrayOfLines();
    }

    public Jun3dPoint[] asArrayOfPoints() {
        return this.vertexes();
    }

    public JunOpenGL3dObject transform_(Jun3dTransformation jun3dTransformation) {
        int n;
        JunOpenGL3dVertexesObject junOpenGL3dVertexesObject = (JunOpenGL3dVertexesObject)this.copy();
        junOpenGL3dVertexesObject.vertexes = new Jun3dPoint[this.vertexes.length];
        for (n = 0; n < this.vertexes.length; ++n) {
            junOpenGL3dVertexesObject.vertexes[n] = this.vertexes[n].transform_(jun3dTransformation);
        }
        if (this.normalVectors != null) {
            junOpenGL3dVertexesObject.normalVectors = new Jun3dPoint[this.normalVectors.length];
            if (this.normalVectors.length == 1) {
                Jun3dPoint jun3dPoint = this.averageVertex();
                Jun3dLine jun3dLine = new Jun3dLine(jun3dPoint, jun3dPoint.plus_(this.normalVectors[0]));
                junOpenGL3dVertexesObject.normalVectors[0] = jun3dLine.transform_(jun3dTransformation).asUnitVector();
            } else {
                for (n = 0; n < this.normalVectors.length; ++n) {
                    Jun3dPoint jun3dPoint = this.vertexes[n].plus_(this.normalVectors[n]).transform_(jun3dTransformation);
                    junOpenGL3dVertexesObject.normalVectors[n] = jun3dPoint.minus_(junOpenGL3dVertexesObject.vertexes[n]).unitVector();
                }
            }
        }
        return junOpenGL3dVertexesObject;
    }

    public JunPlane asPlane() {
        Jun3dPoint[] jun3dPointArray = this.vertexes();
        if (jun3dPointArray == null || jun3dPointArray.length < 3) {
            return null;
        }
        int n = jun3dPointArray.length / 3;
        Jun3dPoint jun3dPoint = jun3dPointArray[0];
        Jun3dPoint jun3dPoint2 = jun3dPointArray[0].plus_(n);
        Jun3dPoint jun3dPoint3 = jun3dPointArray[0].plus_(n * 2);
        return new JunPlane(jun3dPoint, jun3dPoint2, jun3dPoint3);
    }

    public Jun3dTriangle asTriangle() {
        Jun3dPoint[] jun3dPointArray = this.vertexes();
        if (jun3dPointArray == null || jun3dPointArray.length != 3) {
            return null;
        }
        return Jun3dTriangle.On_on_on_(jun3dPointArray[0], jun3dPointArray[1], jun3dPointArray[2]);
    }

    public JunOpenGL3dObject reversed() {
        int n;
        JunOpenGL3dVertexesObject junOpenGL3dVertexesObject = (JunOpenGL3dVertexesObject)this.copy();
        if (this.vertexes != null) {
            junOpenGL3dVertexesObject.vertexes = new Jun3dPoint[this.vertexes.length];
            for (n = 0; n < this.vertexes.length; ++n) {
                junOpenGL3dVertexesObject.vertexes[n] = this.vertexes[this.vertexes.length - n - 1];
            }
        }
        if (this.colors != null) {
            junOpenGL3dVertexesObject.colors = new Color[this.colors.length];
            for (n = 0; n < this.colors.length; ++n) {
                junOpenGL3dVertexesObject.colors[n] = this.colors[this.colors.length - n - 1];
            }
        }
        if (this.normalVectors != null) {
            junOpenGL3dVertexesObject.normalVectors = new Jun3dPoint[this.normalVectors.length];
            for (n = 0; n < this.normalVectors.length; ++n) {
                junOpenGL3dVertexesObject.normalVectors[n] = this.normalVectors[this.normalVectors.length - n - 1];
            }
        }
        return junOpenGL3dVertexesObject;
    }

    public JunOpenGL3dObject normalVectorObject() {
        Jun3dPoint jun3dPoint = this.averageVertex();
        JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.ConeFrom_to_width_(jun3dPoint, jun3dPoint.plus_(this.normalVector()), 0.15);
        junOpenGL3dObject.flushAllPaints();
        junOpenGL3dObject.flushAllAlphas();
        return junOpenGL3dObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JunOpenGL3dObject normalVectorObjectAppliedTransformation_(Jun3dTransformation jun3dTransformation) {
        JunOpenGL3dVertexesObject junOpenGL3dVertexesObject;
        Jun3dPoint jun3dPoint = this.transform_(jun3dTransformation).averageVertex();
        boolean bl = this.hasNormalVectors();
        if (!bl) {
            this.establishAllNormalVectors();
        }
        try {
            junOpenGL3dVertexesObject = (JunOpenGL3dVertexesObject)this.transform_(jun3dTransformation);
        }
        finally {
            if (!bl) {
                this.flushNormalVectors();
            }
        }
        Jun3dPoint jun3dPoint2 = junOpenGL3dVertexesObject.normalVector();
        JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.ConeFrom_to_width_(jun3dPoint, jun3dPoint.plus_(jun3dPoint2), 0.15);
        junOpenGL3dObject.flushAllPaints();
        junOpenGL3dObject.flushAllAlphas();
        return junOpenGL3dObject;
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(this.kindName());
        if (!(this.hasName() || this.hasColor() || this.hasStipple() || this.hasTexture() || this.hasColors() || this.hasNormalVectors())) {
            for (int i = 0; i < this.vertexes.length; ++i) {
                junLispCons.add_((Object)this.vertexes[i]);
            }
            return junLispCons;
        }
        if (this.hasName()) {
            junLispCons.add_((Object)this.nameToLispList());
        }
        if (this.hasColor()) {
            junLispCons.add_((Object)this.colorToLispList());
        }
        if (this.hasStipple()) {
            junLispCons.add_((Object)this.stippleToLispList());
        }
        if (this.hasTexture()) {
            junLispCons.add_((Object)this.textureToLispList());
        }
        junLispCons.add_((Object)this.vertexesToLispList());
        if (this.hasColors()) {
            junLispCons.add_((Object)this.colorsToLispList());
        }
        if (this.hasNormalVectors()) {
            junLispCons.add_((Object)this.normalVectorsToLispList());
        }
        return junLispCons;
    }

    protected abstract JunLispList stippleToLispList();

    protected abstract JunLispList textureToLispList();

    protected JunLispList vertexesToLispList() {
        Object[] objectArray = new Object[this.vertexes.length + 1];
        objectArray[0] = JunOpenGL3dVertexesObject.$((String)"points");
        for (int i = 0; i < this.vertexes.length; ++i) {
            objectArray[i + 1] = this.vertexes[i];
        }
        return JunLispCons.List_(objectArray);
    }

    protected JunLispList colorsToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dVertexesObject.$((String)"colors"));
        if (this.colors != null) {
            for (int i = 0; i < this.colors.length; ++i) {
                junLispCons.add_((Object)JunLispCons.List_(new float[]{(float)this.colors[i].getRed() / 255.0f, (float)this.colors[i].getGreen() / 255.0f, (float)this.colors[i].getBlue() / 255.0f}));
            }
        }
        return junLispCons;
    }

    protected JunLispList normalVectorsToLispList() {
        Object[] objectArray = new Object[this.normalVectors.length + 1];
        objectArray[0] = JunOpenGL3dVertexesObject.$((String)"normalVectors");
        if (this.normalVectors != null) {
            for (int i = 0; i < this.normalVectors.length; ++i) {
                objectArray[i + 1] = this.normalVectors[i];
            }
        }
        return JunLispCons.List_(objectArray);
    }

    public void fromLispList(JunLispList junLispList) {
        super.fromLispList(junLispList);
        this.stippleFromLispList(junLispList);
        this.textureFromLispList(junLispList);
        this.vertexesFromLispList(junLispList);
        this.colorsFromLispList(junLispList);
        this.normalVectorsFromLispList(junLispList);
    }

    protected abstract void stippleFromLispList(JunLispList var1);

    protected abstract void textureFromLispList(JunLispList var1);

    protected void vertexesFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 2.$((String)"points"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            this.vertexes_(((JunLispList)((Object)junLispList.tail())).toVector());
        } else {
            this.vertexes_(((JunLispList)((Object)junLispCons.tail())).toVector());
        }
    }

    protected void colorsFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 3.$((String)"colors"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        Object[] objectArray = ((JunLispCons)((Object)junLispCons.tail())).asArray();
        Color[] colorArray = new Color[objectArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            JunLispCons junLispCons2 = (JunLispCons)((Object)objectArray[i]);
            float f = ((Number)junLispCons2.nth_(1)).floatValue();
            float f2 = ((Number)junLispCons2.nth_(2)).floatValue();
            float f3 = ((Number)junLispCons2.nth_(3)).floatValue();
            colorArray[i] = new Color(f, f2, f3);
        }
        this.colors_(colorArray);
    }

    protected void normalVectorsFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 4.$((String)"normalVectors"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        Object[] objectArray = ((JunLispCons)((Object)junLispCons.tail())).asArray();
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[objectArray.length];
        System.arraycopy(objectArray, 0, jun3dPointArray, 0, jun3dPointArray.length);
        this.normalVectors_(jun3dPointArray);
    }

    public void vrml10On_(Writer writer) {
        try {
            BufferedWriter bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
            bufferedWriter.write("DEF ");
            bufferedWriter.write(this.legalName());
            bufferedWriter.newLine();
            bufferedWriter.write("Separator {");
            bufferedWriter.newLine();
            this.vrml10ColorOn_(bufferedWriter);
            this.vrml10VertexesOn_(bufferedWriter);
            bufferedWriter.write("} #Separator");
            bufferedWriter.newLine();
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
    }

    protected void vrml10VertexesOn_(Writer writer) {
        Jun3dPoint[] jun3dPointArray = this.vrmlVertexes();
        if (jun3dPointArray.length == 0) {
            return;
        }
        try {
            int n;
            BufferedWriter bufferedWriter;
            BufferedWriter bufferedWriter2 = bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
            if (this.hasTexture()) {
                bufferedWriter.write("\t");
                bufferedWriter.write("Texture2");
                bufferedWriter.newLine();
                bufferedWriter.write("\t\t");
                bufferedWriter.write("image ");
                this.texture().vrmlSFImageOn_(bufferedWriter);
                bufferedWriter.newLine();
                bufferedWriter.write("\t");
                bufferedWriter.write("} #Texture2");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("\t");
            bufferedWriter.write("Coordinate3 {");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\t");
            bufferedWriter.write("point [");
            bufferedWriter.newLine();
            for (n = 0; n < jun3dPointArray.length; ++n) {
                Jun3dPoint jun3dPoint = jun3dPointArray[n];
                bufferedWriter.write("\t\t\t");
                bufferedWriter.write(String.valueOf((float)jun3dPoint.x()));
                bufferedWriter.write(" ");
                bufferedWriter.write(String.valueOf((float)jun3dPoint.y()));
                bufferedWriter.write(" ");
                bufferedWriter.write(String.valueOf((float)jun3dPoint.z()));
                if (n != jun3dPointArray.length - 1) {
                    bufferedWriter.write(",");
                }
                bufferedWriter.write(" #");
                bufferedWriter.write(String.valueOf(n));
                bufferedWriter.newLine();
            }
            bufferedWriter.write("\t\t");
            bufferedWriter.write("] #point");
            bufferedWriter.newLine();
            bufferedWriter.write("\t");
            bufferedWriter.write("} #Coordinate3");
            bufferedWriter.newLine();
            if (this.hasTexture() && this.texture().hasCoordinates()) {
                bufferedWriter.write("\t");
                bufferedWriter.write("TextureCoordinate2 {");
                bufferedWriter.newLine();
                bufferedWriter.write("\t\t");
                bufferedWriter.write("point [");
                bufferedWriter.newLine();
                Jun2dPoint[] jun2dPointArray = this.texture().coordinates();
                for (int i = 0; i < jun2dPointArray.length; ++i) {
                    Jun2dPoint jun2dPoint = jun2dPointArray[i];
                    bufferedWriter.write("\t\t\t");
                    bufferedWriter.write(String.valueOf((float)jun2dPoint.x()));
                    bufferedWriter.write(" ");
                    bufferedWriter.write(String.valueOf((float)jun2dPoint.y()));
                    if (i != jun2dPointArray.length - 1) {
                        bufferedWriter.write(",");
                    }
                    bufferedWriter.write(" #");
                    bufferedWriter.write(String.valueOf(i));
                    bufferedWriter.newLine();
                }
                bufferedWriter.write("\t\t");
                bufferedWriter.write("]");
                bufferedWriter.newLine();
                bufferedWriter.write("\t");
                bufferedWriter.write("} #TextureCoordinate2");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("\t");
            bufferedWriter.write(this.vrml10IndexedSetName());
            bufferedWriter.write(" {");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\t");
            bufferedWriter.write("coordIndex [");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\t\t");
            for (n = 0; n < jun3dPointArray.length; ++n) {
                bufferedWriter.write(String.valueOf(n));
                bufferedWriter.write(", ");
            }
            bufferedWriter.write("-1");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\t");
            bufferedWriter.write("] #coordIndex");
            bufferedWriter.newLine();
            if (this.hasTexture()) {
                bufferedWriter.write("\t");
                bufferedWriter.write("textureCoordIndex [");
                bufferedWriter.newLine();
                bufferedWriter.write("\t\t");
                for (n = 0; n < jun3dPointArray.length; ++n) {
                    bufferedWriter.write(String.valueOf(n));
                    bufferedWriter.write(", ");
                }
                bufferedWriter.write("-1");
                bufferedWriter.newLine();
                bufferedWriter.write("\t");
                bufferedWriter.write("] #textureCoordIndex");
            }
            bufferedWriter.write("\t");
            bufferedWriter.write("} #");
            bufferedWriter.write(this.vrml10IndexedSetName());
            bufferedWriter.newLine();
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
    }

    protected void vrml20MaterialOn_(PrintWriter printWriter, String string) {
        printWriter.println(string + "material Material {");
        printWriter.print(string + "\t" + "emissiveColor ");
        Color color = this.paint();
        printWriter.print((float)color.getRed() / 255.0f);
        printWriter.print(' ');
        printWriter.print((float)color.getGreen() / 255.0f);
        printWriter.print(' ');
        printWriter.print((float)color.getBlue() / 255.0f);
        printWriter.println();
        printWriter.println(string + "} #Material");
    }

    protected void vrml20GeometryOn_(PrintWriter printWriter, String string) {
        if (this.vrmlVertexes().length == 0) {
            return;
        }
        printWriter.println(string + "geometry " + this.vrml20IndexedSetName() + " {");
        this.vrml20CoordOn_(printWriter, string + "\t");
        this.vrml20CoordIndexOn_(printWriter, string + "\t");
        if (this.hasNormalVectors()) {
            this.vrml20NormalOn_(printWriter, string + "\t");
        }
        if (this.hasTexture() && this.texture().hasCoordinates()) {
            this.vrml20TexCoordOn_(printWriter, string + "\t");
            this.vrml20TexCoordIndexOn_(printWriter, string + "\t");
        }
        printWriter.println(string + "} #" + this.vrml20IndexedSetName());
    }

    protected void vrml20CoordOn_(PrintWriter printWriter, String string) {
        printWriter.println(string + "coord Coordinate {");
        printWriter.println(string + "\t" + "point [");
        Jun3dPoint[] jun3dPointArray = this.vrmlVertexes();
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            printWriter.print(string + "\t" + "\t");
            printWriter.print((float)jun3dPointArray[i].x());
            printWriter.print(' ');
            printWriter.print((float)jun3dPointArray[i].y());
            printWriter.print(' ');
            printWriter.print((float)jun3dPointArray[i].z());
            if (i < jun3dPointArray.length - 1) {
                printWriter.print(',');
            }
            printWriter.println(" #" + i);
        }
        printWriter.println(string + "\t" + "] #point");
        printWriter.println(string + "} #Coordinate");
    }

    protected void vrml20CoordIndexOn_(PrintWriter printWriter, String string) {
        printWriter.println(string + "coordIndex [");
        printWriter.print(string + "\t");
        Jun3dPoint[] jun3dPointArray = this.vrmlVertexes();
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            printWriter.print(i);
            printWriter.print(", ");
        }
        printWriter.println(-1);
        printWriter.println(string + "] #coordIndex");
    }

    protected void vrml20NormalOn_(PrintWriter printWriter, String string) {
        printWriter.println(string + "normal Normal {");
        printWriter.println(string + "\t" + "vector [");
        Jun3dPoint[] jun3dPointArray = this.normalVectors();
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            printWriter.print(string + "\t" + "\t");
            printWriter.print((float)jun3dPointArray[i].x());
            printWriter.print(' ');
            printWriter.print((float)jun3dPointArray[i].y());
            printWriter.print(' ');
            printWriter.print((float)jun3dPointArray[i].z());
            if (i < jun3dPointArray.length - 1) {
                printWriter.print(',');
            }
            printWriter.println(" #" + i);
        }
        printWriter.println(string + "\t" + "] #vector");
        printWriter.println(string + "} #Normal");
    }

    protected void vrml20TexCoordOn_(PrintWriter printWriter, String string) {
        printWriter.println(string + "texCoord TextureCoordinate {");
        printWriter.println(string + "\t" + "point [");
        Jun2dPoint[] jun2dPointArray = this.texture().coordinates();
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            printWriter.print(string + "\t" + "\t");
            printWriter.print((float)jun2dPointArray[i].x());
            printWriter.print(' ');
            printWriter.print((float)jun2dPointArray[i].y());
            if (i < jun2dPointArray.length - 1) {
                printWriter.print(',');
            }
            printWriter.println(" #" + i);
        }
        printWriter.println(string + "\t" + "] #point");
        printWriter.println(string + "} #TextureCoordinate");
    }

    protected void vrml20TexCoordIndexOn_(PrintWriter printWriter, String string) {
        printWriter.println(string + "texCoordIndex [");
        printWriter.print(string + "\t");
        Jun3dPoint[] jun3dPointArray = this.vrmlVertexes();
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            printWriter.print(i);
            printWriter.print(", ");
        }
        printWriter.println(-1);
        printWriter.println(string + "] #texCoordIndex");
    }

    protected abstract String vrml10IndexedSetName();

    protected abstract String vrml20IndexedSetName();

    protected Jun3dPoint[] vrmlVertexes() {
        return this.vertexes();
    }

    protected Jun3dPoint preferredNormalVector() {
        StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_(Object object) {
                int n = (Integer)object;
                Jun3dPoint jun3dPoint = JunOpenGL3dVertexesObject.this.vertexes[n];
                int n2 = n - 1;
                int n3 = JunOpenGL3dVertexesObject.this.vertexes.length;
                while (n + n2 + n3 > 0) {
                    int n4 = (n2 % n3 + n3) % n3;
                    if (jun3dPoint.distance_(JunOpenGL3dVertexesObject.this.vertexes[n4]) >= 1.0E-12) {
                        return JunOpenGL3dVertexesObject.this.vertexes[n4];
                    }
                    --n2;
                }
                return null;
            }
        };
        StBlockClosure stBlockClosure2 = new StBlockClosure(){

            public Object value_(Object object) {
                int n = (Integer)object;
                Jun3dPoint jun3dPoint = JunOpenGL3dVertexesObject.this.vertexes[n];
                int n2 = n + 1;
                int n3 = JunOpenGL3dVertexesObject.this.vertexes.length;
                while (n - n2 + n3 > 0) {
                    int n4 = (n2 % n3 + n3) % n3;
                    if (jun3dPoint.distance_(JunOpenGL3dVertexesObject.this.vertexes[n4]) >= 1.0E-12) {
                        return JunOpenGL3dVertexesObject.this.vertexes[n4];
                    }
                    ++n2;
                }
                return null;
            }
        };
        Jun3dPoint jun3dPoint = Jun3dPoint.Zero();
        for (int i = 0; i < this.vertexes.length; ++i) {
            Jun3dPoint jun3dPoint2 = (Jun3dPoint)((Object)stBlockClosure.value_((Object)new Integer(i)));
            Jun3dPoint jun3dPoint3 = (Jun3dPoint)((Object)stBlockClosure2.value_((Object)new Integer(i)));
            if (jun3dPoint2 == null || jun3dPoint3 == null) continue;
            Jun3dPoint jun3dPoint4 = this.vertexes[i];
            jun3dPoint = jun3dPoint.plus_(jun3dPoint4.minus_(jun3dPoint2).vectorProduct_(jun3dPoint3.minus_(jun3dPoint4)));
        }
        return jun3dPoint.unitVector();
    }
}

