/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.projection;

import java.awt.Rectangle;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.projection.JunOpenGLParallelProjection;
import jp.co.sra.jun.opengl.projection.JunOpenGLPerspectiveProjection;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;

public abstract class JunOpenGLProjection
extends JunAbstractObject {
    protected String description;
    protected Jun3dPoint eyePoint;
    protected Jun3dPoint sightPoint;
    protected Jun3dPoint upVector;
    protected double viewFactor;
    protected double near;
    protected double far;
    public static Jun3dPoint DefaultEyePoint = new Jun3dPoint(30.0, 30.0, 30.0);
    public static Jun3dPoint DefaultSightPoint = new Jun3dPoint(0.0, 0.0, 0.0);
    public static Jun3dPoint DefaultUpVector = new Jun3dPoint(0.0, 0.0, 1.0);
    public static double DefaultViewFactor = 50.0;
    public static double DefaultNear = 0.001;
    public static double DefaultFar = 1000.0;

    public static JunOpenGLProjection Default() {
        return JunOpenGLProjection.DefaultPerspectiveProjection();
    }

    public static JunOpenGLProjection DefaultPerspectiveProjection() {
        return new JunOpenGLPerspectiveProjection();
    }

    public static JunOpenGLParallelProjection ParallelProjectionEyePoint_sightPoint_upVector_height_near_far_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, double d, double d2, double d3) {
        return new JunOpenGLParallelProjection(jun3dPoint, jun3dPoint2, jun3dPoint3, d, d2, d3);
    }

    public static JunOpenGLPerspectiveProjection PerspectiveProjectionEyePoint_sightPoint_upVector_fovy_near_far_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, JunAngle junAngle, double d, double d2) {
        return new JunOpenGLPerspectiveProjection(jun3dPoint, jun3dPoint2, jun3dPoint3, junAngle, d, d2);
    }

    protected void initialize() {
        super.initialize();
        this.viewFactor = DefaultViewFactor;
    }

    public abstract StSymbol type();

    public String description() {
        return this.description;
    }

    public void description_(String string) {
        this.description = string;
    }

    public Jun3dPoint eyePoint() {
        return this.eyePoint;
    }

    public void eyePoint_(Jun3dPoint jun3dPoint) {
        this.setEyePoint_(jun3dPoint);
        this.fitDistance();
        this.normalizeUpVector();
    }

    public Jun3dPoint sightPoint() {
        return this.sightPoint;
    }

    public void sightPoint_(Jun3dPoint jun3dPoint) {
        this.setSightPoint_(jun3dPoint);
        this.fitDistance();
        this.normalizeUpVector();
    }

    public void eyePoint_sightPoint_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        if (jun3dPoint.equal_((Object)jun3dPoint2)) {
            return;
        }
        this.setEyePoint_(jun3dPoint);
        this.setSightPoint_(jun3dPoint2);
    }

    public Jun3dPoint upVector() {
        return this.upVector;
    }

    public void upVector_(Jun3dPoint jun3dPoint) {
        this.setUpVector_(jun3dPoint);
        this.normalizeUpVector();
    }

    public double viewFactor() {
        return this.viewFactor;
    }

    public void viewFactor_(double d) {
        this.setViewFactor_(d);
        this.fitDistance();
        this.normalizeUpVector();
    }

    public double near() {
        return this.near;
    }

    public void near_(double d) {
        this.near = d;
    }

    public double far() {
        return this.far;
    }

    public void far_(double d) {
        this.far = d;
    }

    public abstract double regularHeight();

    public double distance() {
        return this.sightPoint().minus_(this.eyePoint()).abs().length();
    }

    public Jun3dPoint nearCenter() {
        return this.eyePoint().plus_(this.unitSightVector().multipliedBy_(this.near()));
    }

    public Jun3dPoint farCenter() {
        return this.eyePoint().plus_(this.unitSightVector().multipliedBy_(this.far()));
    }

    public Jun3dPoint rightVector() {
        return this.sightVector().product_(this.upVector());
    }

    public void rightVector_(Jun3dPoint jun3dPoint) {
        this.upVector_(jun3dPoint.product_(this.sightVector()).unitVector());
    }

    public Jun3dPoint sightVector() {
        return this.sightPoint().minus_(this.eyePoint());
    }

    public Jun3dPoint unitUpVector() {
        return this.upVector().dividedBy_(this.upVector().length());
    }

    public Jun3dPoint unitRightVector() {
        Jun3dPoint jun3dPoint = this.rightVector();
        return jun3dPoint.dividedBy_(jun3dPoint.length());
    }

    public Jun3dPoint unitSightVector() {
        Jun3dPoint jun3dPoint = this.sightVector();
        return jun3dPoint.dividedBy_(jun3dPoint.length());
    }

    public boolean isParallel() {
        return false;
    }

    public boolean isPerspective() {
        return false;
    }

    public abstract void projectOn_(JunOpenGLRenderingContext var1);

    public void moveForward_(double d) {
        this.eyePoint_(this.eyePoint().plus_(this.unitSightVector().multipliedBy_(d)));
    }

    public void moveBackward_(double d) {
        this.eyePoint_(this.eyePoint().minus_(this.unitSightVector().multipliedBy_(d)));
    }

    public void moveLeft_(double d) {
        this.eyePoint_(this.eyePoint().minus_(this.unitRightVector().multipliedBy_(d)));
    }

    public void moveRight_(double d) {
        this.eyePoint_(this.eyePoint().plus_(this.unitRightVector().multipliedBy_(d)));
    }

    public void pan() {
        this.pan_(2.0);
    }

    public abstract void pan_(double var1);

    public void zoom() {
        this.zoom_(2.0);
    }

    public abstract void zoom_(double var1);

    public abstract double zoomHeight();

    public abstract void zoomHeight_(double var1);

    public StBlockClosure boundaryConditionForRectangle_(Rectangle rectangle) {
        Jun3dPoint jun3dPoint = this.translateTo3dPointInFarBoundaryPlaneFromPoint_(new Jun2dPoint(rectangle.x, rectangle.y));
        Jun3dPoint jun3dPoint2 = this.translateTo3dPointInFarBoundaryPlaneFromPoint_(new Jun2dPoint(rectangle.x + rectangle.width, rectangle.y));
        Jun3dPoint jun3dPoint3 = this.translateTo3dPointInFarBoundaryPlaneFromPoint_(new Jun2dPoint(rectangle.x, rectangle.y + rectangle.height));
        Jun3dPoint jun3dPoint4 = this.translateTo3dPointInFarBoundaryPlaneFromPoint_(new Jun2dPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
        Jun3dPoint jun3dPoint5 = this.translateTo3dPointInNearBoundaryPlaneFromPoint_(new Jun2dPoint(rectangle.x, rectangle.y));
        Jun3dPoint jun3dPoint6 = this.translateTo3dPointInNearBoundaryPlaneFromPoint_(new Jun2dPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
        final StBlockClosure stBlockClosure = this.boundaryConditionFrom3dPoint_and_and_includes_(jun3dPoint, jun3dPoint3, jun3dPoint5, jun3dPoint2);
        final StBlockClosure stBlockClosure2 = this.boundaryConditionFrom3dPoint_and_and_includes_(jun3dPoint2, jun3dPoint4, jun3dPoint6, jun3dPoint);
        final StBlockClosure stBlockClosure3 = this.boundaryConditionFrom3dPoint_and_and_includes_(jun3dPoint, jun3dPoint2, jun3dPoint5, jun3dPoint3);
        final StBlockClosure stBlockClosure4 = this.boundaryConditionFrom3dPoint_and_and_includes_(jun3dPoint3, jun3dPoint4, jun3dPoint6, jun3dPoint);
        return new StBlockClosure(){

            public Object value_(Object object) {
                if (((Boolean)stBlockClosure.value_(object)).booleanValue() && ((Boolean)stBlockClosure2.value_(object)).booleanValue() && ((Boolean)stBlockClosure3.value_(object)).booleanValue() && ((Boolean)stBlockClosure4.value_(object)).booleanValue()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
    }

    public StBlockClosure boundaryConditionFrom3dPoint_and_and_includes_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, Jun3dPoint jun3dPoint4) {
        if (jun3dPoint.equals((Object)jun3dPoint2) || jun3dPoint2.equals((Object)jun3dPoint3) || jun3dPoint3.equals((Object)jun3dPoint)) {
            return new StBlockClosure(){

                public Object value_(Object object) {
                    return Boolean.FALSE;
                }
            };
        }
        JunPlane junPlane = new JunPlane(jun3dPoint, jun3dPoint2, jun3dPoint3);
        final double d = junPlane.a();
        final double d2 = junPlane.b();
        final double d3 = junPlane.c();
        final double d4 = junPlane.d();
        double d5 = d * jun3dPoint4.x() + d2 * jun3dPoint4.y() + d3 * jun3dPoint4.z() + d4;
        if (d5 < 0.0) {
            return new StBlockClosure(){

                public Object value_(Object object) {
                    Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)object);
                    return new Boolean(d * jun3dPoint.x() + d2 * jun3dPoint.y() + d3 * jun3dPoint.z() + d4 < 0.0);
                }
            };
        }
        if (d5 > 0.0) {
            return new StBlockClosure(){

                public Object value_(Object object) {
                    Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)object);
                    return new Boolean(d * jun3dPoint.x() + d2 * jun3dPoint.y() + d3 * jun3dPoint.z() + d4 > 0.0);
                }
            };
        }
        return new StBlockClosure(){

            public Object value_(Object object) {
                Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)object);
                return new Boolean(d * jun3dPoint.x() + d2 * jun3dPoint.y() + d3 * jun3dPoint.z() + d4 == 0.0);
            }
        };
    }

    public abstract JunOpenGLParallelProjection asParallelProjection();

    public abstract JunOpenGLPerspectiveProjection asPerspectiveProjection();

    public JunOpenGLProjection asPickingProjectionAt_(Jun2dPoint jun2dPoint) {
        Jun3dPoint jun3dPoint = this.translateTo3dPointFromPoint_(jun2dPoint);
        double d = jun3dPoint.minus_(this.translateTo3dPointFromPoint_(jun2dPoint.plus_(new Jun2dPoint(0.0, -0.01)))).length();
        JunOpenGLProjection junOpenGLProjection = (JunOpenGLProjection)this.copy();
        junOpenGLProjection.sightPoint_(jun3dPoint);
        if (this.isParallel()) {
            junOpenGLProjection.eyePoint_(this.eyePoint().plus_(jun3dPoint).minus_(this.sightPoint()));
        }
        junOpenGLProjection.zoomHeight_(d);
        return junOpenGLProjection;
    }

    public abstract Jun3dTransformation asTransformation();

    public abstract Jun3dTransformation asEyeTransformation();

    public Jun3dPoint applyTo_(Jun3dPoint jun3dPoint) {
        return jun3dPoint.transform_(this.asTransformation());
    }

    public Jun3dPoint applyToPoint_(Jun3dPoint jun3dPoint) {
        return this.translateToPointFrom3dPoint_(jun3dPoint);
    }

    public abstract Jun3dPoint translateTo3dPointFromPoint_depth_(Jun2dPoint var1, double var2);

    public Jun3dLine translateTo3dLineFromPoint_(Jun2dPoint jun2dPoint) {
        Jun3dPoint jun3dPoint = this.translateTo3dPointFromPoint_depth_(jun2dPoint, this.near());
        Jun3dPoint jun3dPoint2 = this.translateTo3dPointFromPoint_depth_(jun2dPoint, this.far());
        return new Jun3dLine(jun3dPoint, jun3dPoint2);
    }

    public Jun3dPoint translateTo3dPointFromPoint_(Jun2dPoint jun2dPoint) {
        return this.translateTo3dPointFromPoint_depth_(jun2dPoint, this.distance());
    }

    public Jun3dPoint translateTo3dPointInNearBoundaryPlaneFromPoint_(Jun2dPoint jun2dPoint) {
        return this.translateTo3dPointFromPoint_depth_(jun2dPoint, this.near());
    }

    public Jun3dPoint translateTo3dPointInFarBoundaryPlaneFromPoint_(Jun2dPoint jun2dPoint) {
        return this.translateTo3dPointFromPoint_depth_(jun2dPoint, this.far());
    }

    public Jun3dPoint translateToPointFrom3dPoint_(Jun3dPoint jun3dPoint) {
        return jun3dPoint.transform_(this.asTransformation());
    }

    protected void fitDistance() {
        double d = this.viewFactor();
        this.far = this.distance() * d;
        this.near = this.distance() / d;
    }

    protected void normalizeUpVector() {
        this.setUpVector_(this.rightVector().product_(this.sightVector()).unitVector());
    }

    protected void setEyePoint_(Jun3dPoint jun3dPoint) {
        this.eyePoint = jun3dPoint;
    }

    protected void setSightPoint_(Jun3dPoint jun3dPoint) {
        this.sightPoint = jun3dPoint;
    }

    protected void setUpVector_(Jun3dPoint jun3dPoint) {
        this.upVector = jun3dPoint;
    }

    protected void setViewFactor_(double d) {
        this.viewFactor = d;
    }

    protected abstract void setZoomHeight_(double var1);

    protected void setProjection() {
        this.fitDistance();
        this.normalizeUpVector();
    }
}

