/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.rotation;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.opengl.rotation.JunOpenGLRotationModel;
import jp.co.sra.jun.opengl.rotation.JunOpenGLRotationView;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.smalltalk.StView;

public class JunOpenGLRotationController
extends JunAbstractController
implements MouseListener,
MouseMotionListener {
    protected Point startPoint;
    protected int startIndex;
    protected Jun2dPoint startVertex;
    protected boolean shiftDown;
    protected boolean moved;
    protected int lastIndex;

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.startPoint == null) {
            return;
        }
        if (this.shiftDown) {
            this.shiftSelectionActivity_(mouseEvent);
            return;
        }
        JunOpenGLRotationModel junOpenGLRotationModel = (JunOpenGLRotationModel)this.model();
        JunOpenGLRotationView junOpenGLRotationView = (JunOpenGLRotationView)this.view();
        Point point = junOpenGLRotationView.scaledPoint_(this._startVertex());
        Point point2 = mouseEvent.getPoint();
        Jun2dPoint jun2dPoint = junOpenGLRotationModel.descaledPoint_(new Point(point2.x - point.x, point2.y - point.y));
        if (jun2dPoint.isZero()) {
            return;
        }
        for (int i = 0; i < junOpenGLRotationModel.selectedIndices().size(); ++i) {
            int n = (Integer)junOpenGLRotationModel.selectedIndices().elementAt(i);
            junOpenGLRotationModel.vertexAt_put_(n, junOpenGLRotationModel.vertexAt_(n).plus_(jun2dPoint));
        }
        ((Component)((Object)junOpenGLRotationView)).repaint();
        this._startVertex_(junOpenGLRotationView.descaledPoint_(point2));
        this.moved = true;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        JunOpenGLRotationView junOpenGLRotationView = (JunOpenGLRotationView)this.view();
        if (mouseEvent.isMetaDown()) {
            this.view()._showPopupMenu(mouseEvent.getX(), mouseEvent.getY());
            return;
        }
        this.startPoint = mouseEvent.getPoint();
        int n = junOpenGLRotationView.scaledVertexIndex_(this.startPoint);
        this._startIndex_(n);
        this._startVertex_(junOpenGLRotationView.descaledPoint_(this.startPoint));
        this.shiftDown = mouseEvent.isShiftDown();
        if (this.shiftDown) {
            this.lastIndex = -1;
            this.shiftSelectionActivity_(mouseEvent);
            return;
        }
        this.moved = true;
        if (n >= 0) {
            JunOpenGLRotationModel junOpenGLRotationModel = (JunOpenGLRotationModel)this.model();
            if (junOpenGLRotationModel.selectedIndices().contains(new Integer(n))) {
                this.moved = false;
            } else {
                this.selectionActivity_(mouseEvent);
            }
            return;
        }
        this.creationActivity_(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.shiftDown && !this.moved) {
            this.selectionActivity_(mouseEvent);
        }
        this.startPoint = null;
    }

    private int _startIndex() {
        return this.startIndex;
    }

    private void _startIndex_(int n) {
        this.startIndex = n;
    }

    private Jun2dPoint _startVertex() {
        return this.startVertex;
    }

    private void _startVertex_(Jun2dPoint jun2dPoint) {
        this.startVertex = jun2dPoint;
    }

    protected void buildListener(StView stView) {
        Component component = (Component)stView;
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    protected void creationActivity_(MouseEvent mouseEvent) {
        JunOpenGLRotationModel junOpenGLRotationModel = (JunOpenGLRotationModel)this.model();
        JunOpenGLRotationView junOpenGLRotationView = (JunOpenGLRotationView)this.view();
        Point point = mouseEvent.getPoint();
        Jun2dPoint jun2dPoint = junOpenGLRotationView.descaledPoint_(point);
        int n = junOpenGLRotationModel.nearestVertexIndex_(jun2dPoint);
        junOpenGLRotationModel.deselectAll();
        junOpenGLRotationModel.addVertex_beforeIndex_(jun2dPoint, n);
        junOpenGLRotationModel.selectVertex_(jun2dPoint);
        ((Component)((Object)junOpenGLRotationView)).repaint();
        this._startIndex_(n);
        this._startVertex_(jun2dPoint);
    }

    protected void selectionActivity_(MouseEvent mouseEvent) {
        JunOpenGLRotationView junOpenGLRotationView = (JunOpenGLRotationView)this.view();
        JunOpenGLRotationModel junOpenGLRotationModel = (JunOpenGLRotationModel)this.model();
        int n = this._startIndex();
        if (junOpenGLRotationModel.selectedIndices().contains(new Integer(n))) {
            boolean bl = junOpenGLRotationModel.numSelection() > 1;
            junOpenGLRotationModel.deselectAll();
            if (bl) {
                junOpenGLRotationModel.selectIndex_(n);
            }
        } else {
            junOpenGLRotationModel.deselectAll();
            junOpenGLRotationModel.selectIndex_(n);
        }
        ((Component)((Object)junOpenGLRotationView)).repaint();
    }

    protected void shiftSelectionActivity_(MouseEvent mouseEvent) {
        JunOpenGLRotationView junOpenGLRotationView = (JunOpenGLRotationView)this.view();
        JunOpenGLRotationModel junOpenGLRotationModel = (JunOpenGLRotationModel)this.model();
        int n = junOpenGLRotationView.scaledVertexIndex_(new Point(mouseEvent.getX(), mouseEvent.getY()));
        if (0 <= n && n != this.lastIndex) {
            if (junOpenGLRotationModel.selectedIndices().contains(new Integer(n))) {
                junOpenGLRotationModel.deselectIndex_(n);
            } else {
                junOpenGLRotationModel.selectIndex_(n);
            }
            ((Component)((Object)junOpenGLRotationView)).repaint();
        }
        this.lastIndex = n;
    }
}

