/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.support;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import jp.co.sra.jun.opengl.support.JunGLInterface;
import jp.co.sra.jun.opengl.support.JunOpenGLDrawable;
import jp.co.sra.jun.opengl.support.JunOpenGLInterface;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderer;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.smalltalk.DependentEvent;

public class JunGLCanvas
extends Canvas
implements JunOpenGLDrawable {
    protected JunOpenGLRenderer renderer;
    protected int handle;
    protected boolean isMoved;
    protected boolean isResized;

    public JunGLCanvas() {
        this((JunOpenGLRenderer)null);
    }

    public JunGLCanvas(JunOpenGLRenderer junOpenGLRenderer) {
        this.initialize();
        this.setRenderer(junOpenGLRenderer);
    }

    protected void initialize() {
        this.renderer = null;
        this.handle = -1;
        this.isMoved = false;
        this.isResized = false;
    }

    public void release() {
        if (this.handle >= 0) {
            JunGLInterface.Current.gljDeleteContext(this.handle, false);
            this.handle = -1;
        }
    }

    public void removeNotify() {
        this.release();
        super.removeNotify();
    }

    public JunOpenGLInterface getOpenGLInterface() {
        return JunGLInterface.Current;
    }

    public Color getBackgroundColor() {
        return this.getBackground();
    }

    public void setRenderer(JunOpenGLRenderer junOpenGLRenderer) {
        if (this.renderer == junOpenGLRenderer) {
            return;
        }
        this.renderer = junOpenGLRenderer;
        this.redisplay();
    }

    protected int handle() {
        if (this.handle <= 0) {
            this.handle = JunGLInterface.Current.gljCreateContext(this, this.getWidth(), this.getHeight(), 4);
        }
        return this.handle;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.getBounds();
        if (rectangle.x != n || rectangle.y != n2) {
            this.isMoved = true;
        }
        if (rectangle.width != n3 || rectangle.height != n4) {
            this.isResized = true;
        }
        super.setBounds(n, n2, n3, n4);
    }

    public Component toComponent() {
        return this;
    }

    public void renderOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        if (this.renderer != null) {
            this.renderer.renderOn_(junOpenGLRenderingContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        JunGLInterface junGLInterface = JunGLInterface.Current;
        synchronized (junGLInterface) {
            try {
                if (this.isResized) {
                    JunGLInterface.Current.gljSetSize(this.handle(), this.getWidth(), this.getHeight());
                    this.isResized = false;
                }
                if (this.isMoved) {
                    JunGLInterface.Current.gljSetLocation(this.handle(), this.getX(), this.getY());
                    this.isMoved = false;
                }
                JunGLInterface.Current.gljMakeCurrent(this.handle());
                JunOpenGLRenderingContext junOpenGLRenderingContext = new JunOpenGLRenderingContext(this);
                this.renderOn_(junOpenGLRenderingContext);
            }
            finally {
                JunGLInterface.Current.gljFlushBuffer(this.handle());
            }
        }
        if (this.renderer != null) {
            this.renderer.superimposeOn_(graphics, this);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void redisplay() {
        if (this.isShowing()) {
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redisplayImmediately() {
        if (!this.isShowing()) {
            return;
        }
        Graphics graphics = null;
        try {
            graphics = this.getGraphics();
            this.paint(graphics);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
    }

    public void update_(DependentEvent dependentEvent) {
        this.redisplay();
    }
}

