/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.support;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import jp.co.sra.jun.opengl.support.JunGLInterface;
import jp.co.sra.jun.opengl.support.JunOpenGLDrawable;
import jp.co.sra.jun.opengl.support.JunOpenGLInterface;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderer;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StImage;

public class JunGLImage
extends StImage
implements JunOpenGLDrawable {
    protected JunOpenGLRenderer renderer;
    protected Color background;

    public JunGLImage(int n, int n2) {
        this(null, n, n2, Color.white);
    }

    public JunGLImage(JunOpenGLRenderer junOpenGLRenderer, int n, int n2, Color color) {
        super(n, n2);
        this.background = color;
        this.setRenderer(junOpenGLRenderer);
    }

    public JunOpenGLInterface getOpenGLInterface() {
        return JunGLInterface.Current;
    }

    public Dimension getSize() {
        return new Dimension(this.width(), this.height());
    }

    public Color getBackgroundColor() {
        return this.background;
    }

    public void setRenderer(JunOpenGLRenderer junOpenGLRenderer) {
        if (this.renderer == junOpenGLRenderer) {
            return;
        }
        this.renderer = junOpenGLRenderer;
        this.redisplay();
    }

    public Component toComponent() {
        throw SmalltalkException.ShouldNotImplement();
    }

    public void renderOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        if (this.renderer != null) {
            this.renderer.renderOn_(junOpenGLRenderingContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayOn_at_(Graphics graphics, Point point) {
        JunGLInterface junGLInterface = JunGLInterface.Current;
        synchronized (junGLInterface) {
            int n = -1;
            try {
                n = JunGLInterface.Current.gljCreateContext(null, this.width(), this.height(), 2);
                JunGLInterface.Current.gljMakeCurrent(n);
                JunOpenGLRenderingContext junOpenGLRenderingContext = new JunOpenGLRenderingContext(this);
                this.renderOn_(junOpenGLRenderingContext);
                int n2 = this.width();
                int n3 = this.height();
                int[] nArray = new int[n2 * n3];
                JunGLInterface.Current.gljReadImage(n, nArray, false);
                MemoryImageSource memoryImageSource = new MemoryImageSource(n2, n3, nArray, 0, n2);
                Image image = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
                graphics.drawImage(image, point.x, point.y, null);
            }
            finally {
                if (n >= 0) {
                    JunGLInterface.Current.gljFlushBuffer(n);
                    JunGLInterface.Current.gljDeleteContext(n, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redisplay() {
        Graphics graphics = null;
        try {
            graphics = this.image().getGraphics();
            this.displayOn_(graphics);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
    }

    public void redisplayImmediately() {
        this.redisplay();
    }
}

