/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.support;

import jp.co.sra.jun.opengl.support.JunGLCanvas;
import jp.co.sra.jun.opengl.support.JunGLJPanel;
import jp.co.sra.jun.opengl.support.JunOpenGLDrawable;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StUserMessage;
import jp.co.sra.smalltalk.menu.MenuEvent;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StRadioButtonGroup;
import jp.co.sra.smalltalk.menu.StRadioButtonMenuItem;

public abstract class JunOpenGLResource
extends JunAbstractObject {
    public static final StMenu DefaultOpenGLViewMenu;
    protected static Class DefaultOpenGLDrawableClass;

    protected static void InitializeDefaultOpenGLDrawableClass() {
        Class clazz = null;
        if (JunOpenGLResource.UseJOGL()) {
            if (JunOpenGLResource.IsJOGLAvailable()) {
                clazz = StApplicationModel.GetDefaultViewMode() != 2 ? JunOpenGLResource.GetJOGLCanvasClass() : JunOpenGLResource.GetJOGLJPanelClass();
            } else {
                System.err.println("JOGL is specified to be used, but not available.");
            }
        }
        if (clazz == null) {
            clazz = StApplicationModel.GetDefaultViewMode() != 2 ? JunGLCanvas.class : JunGLJPanel.class;
        }
        JunOpenGLResource.SetDefaultOpenGLDrawableClass(clazz);
    }

    public static Class GetDefaultOpenGLDrawableClass() {
        return DefaultOpenGLDrawableClass;
    }

    public static void SetDefaultOpenGLDrawableClass(Class clazz) {
        if (!JunOpenGLDrawable.class.isAssignableFrom(clazz)) {
            throw SmalltalkException.Error((String)("The specified class is not a kind of JunOpenGLDrawable : " + clazz));
        }
        DefaultOpenGLDrawableClass = clazz;
        System.err.println("The default OpenGL drawable class is set to " + JunOpenGLResource.GetDefaultOpenGLDrawableClassName());
        JunOpenGLResource.UpdateDefaultOpenGLViewMenu();
    }

    public static StSymbol GetDefaultOpenGLDrawableClassName() {
        String string = DefaultOpenGLDrawableClass.getName();
        return JunOpenGLResource.$((String)string.substring(string.lastIndexOf(46) + 1));
    }

    public static Class GetJOGLCanvasClass() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("jp.co.sra.jun.opengl.support.JOGLCanvas");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return clazz;
    }

    public static Class GetJOGLJPanelClass() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("jp.co.sra.jun.opengl.support.JOGLJPanel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return clazz;
    }

    protected static StMenu CreateDefaultOpenGLViewMenu() {
        StRadioButtonGroup stRadioButtonGroup = new StRadioButtonGroup();
        StMenu stMenu = new StMenu((Object)new StUserMessage("Default OpenGL View"));
        stMenu.add((StMenuItem)new StRadioButtonMenuItem((Object)new StUserMessage("JunGL Canvas"), JunOpenGLResource.$((String)"JunGLCanvas"), stRadioButtonGroup, new MenuListener(){

            public void menuPerformed(MenuEvent menuEvent) {
                JunOpenGLResource.SetDefaultOpenGLDrawableClass(class$jp$co$sra$jun$opengl$support$JunGLCanvas == null ? (class$jp$co$sra$jun$opengl$support$JunGLCanvas = JunOpenGLResource.class$("jp.co.sra.jun.opengl.support.JunGLCanvas")) : class$jp$co$sra$jun$opengl$support$JunGLCanvas);
            }
        }));
        stMenu.add((StMenuItem)new StRadioButtonMenuItem((Object)new StUserMessage("JunGL JPanel"), JunOpenGLResource.$((String)"JunGLJPanel"), stRadioButtonGroup, new MenuListener(){

            public void menuPerformed(MenuEvent menuEvent) {
                JunOpenGLResource.SetDefaultOpenGLDrawableClass(class$jp$co$sra$jun$opengl$support$JunGLJPanel == null ? (class$jp$co$sra$jun$opengl$support$JunGLJPanel = JunOpenGLResource.class$("jp.co.sra.jun.opengl.support.JunGLJPanel")) : class$jp$co$sra$jun$opengl$support$JunGLJPanel);
            }
        }));
        stMenu.add((StMenuItem)new StRadioButtonMenuItem((Object)new StUserMessage("JOGL Canvas"), JunOpenGLResource.$((String)"JOGLCanvas"), stRadioButtonGroup, new MenuListener(){

            public void menuPerformed(MenuEvent menuEvent) {
                JunOpenGLResource.SetDefaultOpenGLDrawableClass(JunOpenGLResource.GetJOGLCanvasClass());
            }
        }));
        stMenu.add((StMenuItem)new StRadioButtonMenuItem((Object)new StUserMessage("JOGL JPanel"), JunOpenGLResource.$((String)"JOGLJPanel"), stRadioButtonGroup, new MenuListener(){

            public void menuPerformed(MenuEvent menuEvent) {
                JunOpenGLResource.SetDefaultOpenGLDrawableClass(JunOpenGLResource.GetJOGLJPanelClass());
            }
        }));
        return stMenu;
    }

    protected static void UpdateDefaultOpenGLViewMenu() {
        DefaultOpenGLViewMenu.atNameKey_(JunOpenGLResource.$((String)"JOGLCanvas")).beEnabled(JunOpenGLResource.IsJOGLAvailable());
        DefaultOpenGLViewMenu.atNameKey_(JunOpenGLResource.$((String)"JOGLJPanel")).beEnabled(JunOpenGLResource.IsJOGLAvailable());
        StRadioButtonMenuItem stRadioButtonMenuItem = (StRadioButtonMenuItem)DefaultOpenGLViewMenu.atNameKey_(JunOpenGLResource.GetDefaultOpenGLDrawableClassName());
        if (stRadioButtonMenuItem != null && !stRadioButtonMenuItem.isSelected()) {
            stRadioButtonMenuItem.beOn();
        }
    }

    public static boolean IsJOGLAvailable() {
        try {
            Class.forName("javax.media.opengl.GL");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean UseJOGL() {
        return Boolean.getBoolean("jun.opengl.jogl");
    }

    protected void initialize() {
        super.initialize();
    }

    static {
        DefaultOpenGLDrawableClass = null;
        DefaultOpenGLViewMenu = JunOpenGLResource.CreateDefaultOpenGLViewMenu();
        JunOpenGLResource.InitializeDefaultOpenGLDrawableClass();
    }
}

