/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.texture;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.font.JunFontModel;
import jp.co.sra.jun.goodies.image.support.JunImageAdjuster;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;

public class JunOpenGLTexture
extends JunAbstractObject {
    protected StImage textureImage;
    protected JunOpenGL3dObject textureObject;
    protected Jun2dPoint[] textureCoordinates;
    protected boolean clampBoolean = true;
    protected boolean nearestBoolean = true;
    protected boolean modulateBoolean = true;
    protected boolean mipmapBoolean = false;
    protected double[] sParameters;
    protected double[] tParameters;
    protected byte[] cachedPixels;

    protected JunOpenGLTexture() {
    }

    public JunOpenGLTexture(StImage stImage) {
        this();
        this.image_(stImage);
    }

    public JunOpenGLTexture(Image image) {
        this();
        this.image_(image);
    }

    public JunOpenGLTexture(JunLispList junLispList) {
        this();
        this.fromLispList(junLispList);
    }

    public static JunOpenGLTexture Image_(StImage stImage) {
        JunOpenGLTexture junOpenGLTexture = new JunOpenGLTexture();
        junOpenGLTexture.image_(stImage);
        return junOpenGLTexture;
    }

    public static JunOpenGLTexture Image_(Image image) {
        JunOpenGLTexture junOpenGLTexture = new JunOpenGLTexture();
        junOpenGLTexture.image_(image);
        return junOpenGLTexture;
    }

    public static JunOpenGLTexture FromLispList_(JunLispList junLispList) {
        return new JunOpenGLTexture(junLispList);
    }

    public static JunOpenGLTexture TextureForString_foreColor_backColor_(String string, Color color, Color color2) {
        return JunOpenGLTexture.Texture1ForString_foreColor_backColor_(string, color, color2);
    }

    public static JunOpenGLTexture TextureForString_foreColor_backColor_alignmentSymbol_(String string, Color color, Color color2, StSymbol stSymbol) {
        return JunOpenGLTexture.Texture1ForString_foreColor_backColor_alignmentSymbol_(string, color, color2, stSymbol);
    }

    protected static JunOpenGLTexture Texture1ForString_foreColor_backColor_(String string, Color color, Color color2) {
        return JunOpenGLTexture.Texture1ForString_foreColor_backColor_alignmentSymbol_(string, color, color2, JunOpenGLTexture.$((String)"center"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static JunOpenGLTexture Texture1ForString_foreColor_backColor_alignmentSymbol_(String string, Color color, Color color2, StSymbol stSymbol) {
        int n;
        Jun2dPoint[] jun2dPointArray;
        Object object;
        StComposedText stComposedText = new StComposedText(string, JunFontModel.TextStyle(100.0f));
        Dimension dimension = stComposedText.extent();
        dimension = JunOpenGLTexture.NthPowerExtent_(new Point(dimension.width + 2, dimension.height + 2));
        BufferedImage bufferedImage = new StImage(dimension.width, dimension.height).image();
        Graphics graphics = null;
        try {
            graphics = ((Image)bufferedImage).getGraphics();
            graphics.setColor(color2);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(color);
            object = new StRectangle(stComposedText.bounds());
            jun2dPointArray = new StRectangle(dimension);
            Point point = object.align_with_(object._pointAt(stSymbol), jun2dPointArray._pointAt(stSymbol)).origin();
            stComposedText.displayOn_at_(graphics, point);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
                graphics = null;
            }
        }
        object = new JunOpenGLTexture(bufferedImage);
        jun2dPointArray = new Jun2dPoint[24];
        int n2 = 0;
        Jun2dPoint[] jun2dPointArray2 = new Jun2dPoint[]{new Jun2dPoint(0.0, 0.0), new Jun2dPoint(1.0, 0.0), new Jun2dPoint(1.0, 1.0), new Jun2dPoint(0.0, 1.0)};
        for (n = 0; n < 4; ++n) {
            jun2dPointArray[n2++] = jun2dPointArray2[n];
        }
        for (n = 3; n >= 0; --n) {
            jun2dPointArray[n2++] = jun2dPointArray2[n];
        }
        for (n = 0; n < 16; ++n) {
            jun2dPointArray[n2++] = new Jun2dPoint(0.0, 0.0);
        }
        ((JunOpenGLTexture)((Object)object)).coordinates_(jun2dPointArray);
        ((JunOpenGLTexture)((Object)object)).pointerOfPixels();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static JunOpenGLTexture Texture2ForString_foreColor_backColor_(String string, Color color, Color color2) {
        int n;
        StComposedText stComposedText = new StComposedText(string, JunFontModel.TextStyle(100.0f));
        Dimension dimension = stComposedText.extent();
        BufferedImage bufferedImage = new StImage(dimension.width + 2, dimension.height + 2).image();
        Graphics graphics = null;
        try {
            graphics = ((Image)bufferedImage).getGraphics();
            graphics.setColor(color2);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(color);
            stComposedText.displayOn_at_(graphics, new Point(1, 1));
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
                graphics = null;
            }
        }
        JunOpenGLTexture junOpenGLTexture = JunOpenGLTexture.Image_(bufferedImage);
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[24];
        int n2 = 0;
        Jun2dPoint[] jun2dPointArray2 = new Jun2dPoint[]{new Jun2dPoint(0.0, 0.0), new Jun2dPoint(1.0, 0.0), new Jun2dPoint(1.0, 1.0), new Jun2dPoint(0.0, 1.0)};
        for (n = 0; n < 4; ++n) {
            jun2dPointArray[n2++] = jun2dPointArray2[n];
        }
        for (n = 3; n >= 0; --n) {
            jun2dPointArray[n2++] = jun2dPointArray2[n];
        }
        for (n = 0; n < 16; ++n) {
            jun2dPointArray[n2++] = new Jun2dPoint(0.0, 0.0);
        }
        junOpenGLTexture.coordinates_(jun2dPointArray);
        junOpenGLTexture.pointerOfPixels();
        return junOpenGLTexture;
    }

    protected static Dimension NthPowerExtent_(Point point) {
        int n;
        int n2 = point.x;
        int n3 = point.y;
        int n4 = 11;
        int[] nArray = new int[n4];
        for (n = 0; n < n4; ++n) {
            nArray[n] = (int)Math.pow(2.0, n);
        }
        for (n = 1; n < n4; ++n) {
            int n5;
            int n6 = nArray[n - 1];
            if (n2 > n6 & n2 <= (n5 = nArray[n])) {
                n2 = n5;
            }
            if (!(n3 > n6 & n3 <= n5)) continue;
            n3 = n5;
        }
        return new Dimension(n2, n3);
    }

    protected void initialize() {
        super.initialize();
        this.textureImage = null;
        this.textureObject = null;
        this.textureCoordinates = null;
        this.clampBoolean = true;
        this.nearestBoolean = true;
        this.modulateBoolean = true;
        this.mipmapBoolean = false;
        this.sParameters = null;
        this.tParameters = null;
        this.cachedPixels = null;
    }

    public StImage image() {
        if (this.textureImage == null) {
            StImage stImage = new StImage(1, 1);
            stImage.valueAtPoint_put_(new Point(0, 0), Color.black);
            this.textureImage = stImage;
        }
        return this.textureImage;
    }

    public void image_(StImage stImage) {
        if (stImage.width() == 0 || stImage.height() == 0) {
            return;
        }
        this.textureImage = this.convertToTextureImage_(stImage);
        this.flushPointerOfPixels();
    }

    public void image_(Image image) {
        this.image_(new StImage(image));
    }

    public JunOpenGL3dObject object() {
        return this.textureObject;
    }

    public void object_(JunOpenGL3dObject junOpenGL3dObject) {
        this.textureObject = junOpenGL3dObject;
    }

    public Jun2dPoint[] coordinates() {
        return this.textureCoordinates;
    }

    public void coordinates_(Jun2dPoint[] jun2dPointArray) {
        if (jun2dPointArray == null) {
            this.textureCoordinates = null;
        } else {
            Jun2dPoint[] jun2dPointArray2 = new Jun2dPoint[jun2dPointArray.length];
            System.arraycopy(jun2dPointArray, 0, jun2dPointArray2, 0, jun2dPointArray.length);
            this.textureCoordinates = jun2dPointArray2;
        }
    }

    public int width() {
        return this.image().width();
    }

    public int height() {
        return this.image().height();
    }

    public boolean hasCoordinates() {
        return this.textureCoordinates != null && this.textureCoordinates.length > 0;
    }

    public boolean hasParametersS() {
        return this.sParameters != null && this.sParameters.length > 0;
    }

    public boolean hasParametersT() {
        return this.tParameters != null && this.tParameters.length > 0;
    }

    public boolean clamp() {
        return this.clampBoolean;
    }

    public void clamp_(boolean bl) {
        this.clampBoolean = bl;
    }

    public boolean linear() {
        return !this.nearest();
    }

    public void linear_(boolean bl) {
        this.nearest_(!bl);
    }

    public boolean mipmap() {
        return this.mipmapBoolean;
    }

    public void mipmap_(boolean bl) {
        this.mipmapBoolean = bl;
    }

    public boolean modulate() {
        return this.modulateBoolean;
    }

    public void modulate_(boolean bl) {
        this.modulateBoolean = bl;
    }

    public boolean nearest() {
        return this.nearestBoolean;
    }

    public void nearest_(boolean bl) {
        this.nearestBoolean = bl;
    }

    public boolean repeat() {
        return !this.clamp();
    }

    public void repeat_(boolean bl) {
        this.clamp_(!bl);
    }

    public double[] parametersForS() {
        if (this.sParameters == null) {
            if (this.object() == null) {
                this.defaultParameters();
            } else {
                this.xPositiveParameters();
            }
        }
        return this.sParameters;
    }

    public void parametersForS_(double[] dArray) {
        this.sParameters = dArray;
    }

    public double[] parametersForT() {
        if (this.tParameters == null) {
            if (this.object() == null) {
                this.defaultParameters();
            } else {
                this.xPositiveParameters();
            }
        }
        return this.tParameters;
    }

    public void parametersForT_(double[] dArray) {
        this.tParameters = dArray;
    }

    public void xPositiveParameters() {
        try {
            this.parametersForS_(new double[]{0.0, 1.0 / this.object().boundingBox().height(), 0.0, 0.5});
            this.parametersForT_(new double[]{0.0, 0.0, 1.0 / this.object().boundingBox().depth(), 0.5});
        }
        catch (ArithmeticException arithmeticException) {
            this.defaultParameters();
        }
    }

    public void xNegativeParameters() {
        try {
            this.parametersForS_(new double[]{0.0, -1.0 / this.object().boundingBox().height(), 0.0, 0.5});
            this.parametersForT_(new double[]{0.0, 0.0, 1.0 / this.object().boundingBox().depth(), 0.5});
        }
        catch (ArithmeticException arithmeticException) {
            this.defaultParameters();
        }
    }

    public void yPositiveParameters() {
        try {
            this.parametersForS_(new double[]{-1.0 / this.object().boundingBox().width(), 0.0, 0.0, 0.5});
            this.parametersForT_(new double[]{0.0, 0.0, 1.0 / this.object().boundingBox().depth(), 0.5});
        }
        catch (ArithmeticException arithmeticException) {
            this.defaultParameters();
        }
    }

    public void yNegativeParameters() {
        try {
            this.parametersForS_(new double[]{1.0 / this.object().boundingBox().width(), 0.0, 0.0, 0.5});
            this.parametersForT_(new double[]{0.0, 0.0, 1.0 / this.object().boundingBox().depth(), 0.5});
        }
        catch (ArithmeticException arithmeticException) {
            this.defaultParameters();
        }
    }

    public void zPositiveParameters() {
        try {
            this.parametersForS_(new double[]{1.0 / this.object().boundingBox().width(), 0.0, 0.0, 0.5});
            this.parametersForT_(new double[]{0.0, 1.0 / this.object().boundingBox().height(), 0.0, 0.5});
        }
        catch (ArithmeticException arithmeticException) {
            this.defaultParameters();
        }
    }

    public void zNegativeParameters() {
        try {
            this.parametersForS_(new double[]{-1.0 / this.object().boundingBox().width(), 0.0, 0.0, 0.5});
            this.parametersForT_(new double[]{0.0, 1.0 / this.object().boundingBox().height(), 0.0, 0.5});
        }
        catch (ArithmeticException arithmeticException) {
            this.defaultParameters();
        }
    }

    protected void defaultParameters() {
        this.parametersForS_(new double[]{0.0, 1.0, 0.0, 0.0});
        this.parametersForT_(new double[]{0.0, 0.0, 1.0, 0.0});
    }

    public byte[] pointerOfPixels() {
        if (this.cachedPixels == null) {
            int n = this.image().width();
            int n2 = this.image().height();
            byte[] byArray = new byte[n * n2 * 3];
            int n3 = 0;
            for (int i = n2 - 1; i > -1; --i) {
                for (int j = 0; j < n; ++j) {
                    Color color = this.image().valueAtPoint_(new Point(j, i));
                    int n4 = Math.min(255, Math.max(0, color.getRed()));
                    int n5 = Math.min(255, Math.max(0, color.getGreen()));
                    int n6 = Math.min(255, Math.max(0, color.getBlue()));
                    byArray[n3++] = (byte)n4;
                    byArray[n3++] = (byte)n5;
                    byArray[n3++] = (byte)n6;
                }
            }
            this.cachedPixels = byArray;
        }
        return this.cachedPixels;
    }

    public float[] pointerOfParametersForS() {
        double[] dArray = this.parametersForS();
        int n = dArray.length;
        float[] fArray = new float[n];
        for (int i = 0; i < dArray.length; ++i) {
            fArray[i] = (float)dArray[i];
        }
        return fArray;
    }

    public float[] pointerOfParametersForT() {
        double[] dArray = this.parametersForT();
        int n = dArray.length;
        float[] fArray = new float[n];
        for (int i = 0; i < dArray.length; ++i) {
            fArray[i] = (float)dArray[i];
        }
        return fArray;
    }

    protected void flushPointerOfPixels() {
        this.cachedPixels = null;
    }

    public void enableTextureOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        junOpenGLRenderingContext.texture_(this);
        junOpenGLRenderingContext.enableTexture2d();
    }

    public void disableTextureOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        junOpenGLRenderingContext.texture_(null);
        junOpenGLRenderingContext.disableTexture2d();
    }

    protected StImage convertToTextureImage_(StImage stImage) {
        StImage stImage2 = this.convertToNthPowerExtentImage_(stImage);
        stImage2 = this.convertToPaletteImage_(stImage2);
        return stImage2;
    }

    protected StImage convertToNthPowerExtentImage_(StImage stImage) {
        StImage stImage2 = stImage;
        if (stImage2.width() <= 0 || stImage2.height() <= 0) {
            return stImage2;
        }
        Dimension dimension = JunOpenGLTexture.NthPowerExtent_(stImage.extent());
        stImage2 = JunImageAdjuster.Adjust_extent_(stImage2, dimension);
        return stImage2;
    }

    private StImage convertToPaletteImage_(StImage stImage) {
        return stImage;
    }

    public StSymbol kindName() {
        return this._className();
    }

    public JunLispCons lispCons() {
        return JunLispCons.Cell();
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(this.kindName());
        junLispCons.add_((Object)this.imageToLispList());
        if (this.hasCoordinates()) {
            junLispCons.add_((Object)this.coordinatesToLispList());
        }
        junLispCons.add_((Object)this.clampToLispList());
        junLispCons.add_((Object)this.nearestToLispList());
        junLispCons.add_((Object)this.modulateToLispList());
        junLispCons.add_((Object)this.mipmapToLispList());
        if (this.hasParametersS()) {
            junLispCons.add_((Object)this.sParametersToLispList());
        }
        if (this.hasParametersT()) {
            junLispCons.add_((Object)this.tParametersToLispList());
        }
        return junLispCons;
    }

    protected JunLispList imageToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGLTexture.$((String)"image"));
        junLispCons.tail_(this.image());
        return junLispCons;
    }

    protected JunLispList coordinatesToLispList() {
        Jun2dPoint[] jun2dPointArray = this.coordinates();
        Object[] objectArray = new Object[jun2dPointArray.length + 1];
        objectArray[0] = JunOpenGLTexture.$((String)"coordinates");
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            objectArray[i + 1] = jun2dPointArray[i];
        }
        return JunLispCons.List_(objectArray);
    }

    protected JunLispList clampToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGLTexture.$((String)"clamp"));
        junLispCons.tail_(new Boolean(this.clamp()));
        return junLispCons;
    }

    protected JunLispList nearestToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGLTexture.$((String)"nearest"));
        junLispCons.tail_(new Boolean(this.nearest()));
        return junLispCons;
    }

    protected JunLispList modulateToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGLTexture.$((String)"modulate"));
        junLispCons.tail_(new Boolean(this.modulate()));
        return junLispCons;
    }

    protected JunLispList mipmapToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGLTexture.$((String)"mipmap"));
        junLispCons.tail_(new Boolean(this.mipmap()));
        return junLispCons;
    }

    protected JunLispList sParametersToLispList() {
        double[] dArray = this.parametersForS();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(JunOpenGLTexture.$((String)"sParameters"));
        for (int i = 0; i < dArray.length; ++i) {
            arrayList.add(new Double(dArray[i]));
        }
        return JunLispCons.List_(arrayList);
    }

    protected JunLispList tParametersToLispList() {
        double[] dArray = this.parametersForT();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(JunOpenGLTexture.$((String)"sParameters"));
        for (int i = 0; i < dArray.length; ++i) {
            arrayList.add(new Double(dArray[i]));
        }
        return JunLispCons.List_(arrayList);
    }

    public void fromLispList(JunLispList junLispList) {
        this.imageFromLispList(junLispList);
        this.coordinatesFromLispList(junLispList);
        this.clampFromLispList(junLispList);
        this.nearestFromLispList(junLispList);
        this.modulateFromLispList(junLispList);
        this.mipmapFromLispList(junLispList);
        this.sParametersFromLispList(junLispList);
        this.tParametersFromLispList(junLispList);
    }

    protected void imageFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 1.$((String)"image"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.image_((StImage)junLispCons.tail());
    }

    protected void coordinatesFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 2.$((String)"coordinates"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        Object[] objectArray = ((JunLispCons)((Object)junLispCons.tail())).asArray();
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[objectArray.length];
        System.arraycopy(objectArray, 0, jun2dPointArray, 0, objectArray.length);
        this.coordinates_(jun2dPointArray);
    }

    protected void clampFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 3.$((String)"clamp"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.clamp_((Boolean)junLispCons.tail());
    }

    protected void nearestFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 4.$((String)"nearest"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.nearest_((Boolean)junLispCons.tail());
    }

    protected void modulateFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 5.$((String)"modulate"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.modulate_((Boolean)junLispCons.tail());
    }

    protected void mipmapFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 6.$((String)"mipmap"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.mipmap_((Boolean)junLispCons.tail());
    }

    protected void sParametersFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 7.$((String)"sParameters"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        Object[] objectArray = ((JunLispCons)((Object)junLispCons.tail())).asArray();
        double[] dArray = new double[objectArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = ((Number)objectArray[i]).doubleValue();
        }
        this.parametersForS_(dArray);
    }

    protected void tParametersFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 8.$((String)"tParameters"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        Object[] objectArray = ((JunLispCons)((Object)junLispCons.tail())).asArray();
        double[] dArray = new double[objectArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = ((Number)objectArray[i]).doubleValue();
        }
        this.parametersForT_(dArray);
    }

    public void vrmlSFImageOn_(Writer writer) {
        try {
            StImage stImage = this.image();
            int n = stImage.width();
            int n2 = stImage.height();
            writer.write(String.valueOf(n));
            writer.write(" ");
            writer.write(String.valueOf(n2));
            writer.write(" 3");
            for (int i = n2 - 1; i >= 0; --i) {
                for (int j = 0; j < n; ++j) {
                    writer.write(" 0x");
                    writer.write(Integer.toHexString(stImage.getPixel(j, i)).toUpperCase());
                }
            }
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
    }
}

