/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.system.framework;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import jp.co.sra.jun.system.framework.JunAbstractModel;
import jp.co.sra.jun.system.framework.JunAbstractView;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StViewCanvas;

public abstract class JunAbstractViewCanvas
extends StViewCanvas
implements JunAbstractView {
    protected boolean _doubleBuffer;
    protected Image _doubleBufferImage;
    protected Graphics _doubleBufferGraphics;

    public JunAbstractViewCanvas() {
    }

    public JunAbstractViewCanvas(JunApplicationModel junApplicationModel) {
        super((StModel)junApplicationModel);
    }

    protected void initialize() {
        super.initialize();
        this._doubleBuffer = false;
        this._doubleBufferImage = null;
        this._doubleBufferGraphics = null;
    }

    public void release() {
        super.release();
        this._flushDoubleBuffer();
    }

    public void _doubleBuffer(boolean bl) {
        this._doubleBuffer = bl;
    }

    protected Image _doubleBufferImage() {
        if (this._doubleBufferImage == null) {
            Dimension dimension = this.getSize();
            this._doubleBufferImage = this.createImage(dimension.width, dimension.height);
        }
        return this._doubleBufferImage;
    }

    protected Graphics _doubleBufferGraphics() {
        if (this._doubleBufferGraphics == null) {
            this._doubleBufferGraphics = this._doubleBufferImage().getGraphics();
        }
        return this._doubleBufferGraphics;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this._flushDoubleBuffer();
        super.setBounds(n, n2, n3, n4);
    }

    protected void _flushDoubleBuffer() {
        if (this._doubleBufferImage != null) {
            this._doubleBufferImage.flush();
            this._doubleBufferImage = null;
        }
        if (this._doubleBufferGraphics != null) {
            this._doubleBufferGraphics.dispose();
            this._doubleBufferGraphics = null;
        }
    }

    public void displayOn_(Graphics graphics) {
        if (this.model() instanceof JunAbstractModel) {
            ((JunAbstractModel)this.model()).displayOn_(graphics);
        }
    }

    public void paint(Graphics graphics) {
        if (this._doubleBuffer) {
            this._doubleBufferGraphics().clearRect(0, 0, this.getWidth(), this.getHeight());
            super.paint(this._doubleBufferGraphics());
            graphics.drawImage(this._doubleBufferImage(), 0, 0, (ImageObserver)((Object)this));
        } else {
            super.paint(graphics);
        }
    }

    public void update(Graphics graphics) {
        if (this._doubleBuffer) {
            this.paint(graphics);
        } else {
            super.update(graphics);
        }
    }
}

