/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.system.support;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import jp.co.sra.jun.goodies.display.JunDisplayModel;
import jp.co.sra.jun.goodies.display.JunDisplayViewAwt;
import jp.co.sra.jun.goodies.display.JunDisplayViewSwing;
import jp.co.sra.jun.opengl.support.JunOpenGLResource;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StCheckBoxMenuItem;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuItem;

public abstract class JunTestExamples
extends JunDisplayModel {
    protected boolean closeToExit = true;
    protected StMenuBar _menuBar;

    public JunTestExamples() {
        this.open();
    }

    protected void initialize() {
        super.initialize();
        this._scrollable = false;
    }

    public boolean isElapsing() {
        StCheckBoxMenuItem stCheckBoxMenuItem = (StCheckBoxMenuItem)this._menuBar().atNameKey_(JunTestExamples.$((String)"elapsing"));
        return stCheckBoxMenuItem.isSelected();
    }

    public void beElapsing(boolean bl) {
        StCheckBoxMenuItem stCheckBoxMenuItem = (StCheckBoxMenuItem)this._menuBar().atNameKey_(JunTestExamples.$((String)"elapsing"));
        stCheckBoxMenuItem.beSelected(bl);
    }

    public void closeToExit(boolean bl) {
        this.closeToExit = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StDisplayable visual() {
        if (this.displayObject == null) {
            StImage stImage = new StImage(JunSystem.LogoImage());
            int n = stImage.width();
            int n2 = stImage.height();
            n2 = 167 * n2 / n;
            n = 167;
            StImage stImage2 = new StImage(187, n2);
            Graphics graphics = null;
            try {
                graphics = stImage2.image().getGraphics();
                graphics.drawImage(stImage.image(), 10, 0, n, n2, null);
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                    graphics = null;
                }
            }
            this.displayObject = stImage2;
        }
        return this.displayObject;
    }

    public StView defaultView() {
        if (JunTestExamples.GetDefaultViewMode() == 0) {
            return new JunDisplayViewAwt(this){

                protected void buildComponent() {
                    super.buildComponent();
                    this.canvas().setBackground(Color.white);
                }
            };
        }
        return new JunDisplayViewSwing(this){

            protected void buildComponent() {
                super.buildComponent();
                this.canvas().setBackground(Color.white);
            }
        };
    }

    protected Frame allButOpenView_(StView stView) {
        Frame frame = super.allButOpenView_(stView);
        frame.setSize(203, 167);
        return frame;
    }

    protected String windowTitle() {
        return this._className().toString();
    }

    public void noticeOfWindowClose(WindowEvent windowEvent) {
        if (this.closeToExit) {
            if (JunDialog.Confirm_(JunSystem.$String((String)"Really quit?"), false)) {
                System.exit(0);
            } else {
                windowEvent.getWindow().setVisible(true);
            }
        } else {
            super.noticeOfWindowClose(windowEvent);
        }
    }

    public StMenuBar _menuBar() {
        if (this._menuBar == null) {
            this._menuBar = new StMenuBar();
            this._menuBar.add(this._createExamplesMenu());
            this._menuBar.add(this._createMiscMenu());
        }
        return this._menuBar;
    }

    protected StMenu _createExamplesMenu() {
        StMenu stMenu = new StMenu((Object)JunSystem.$String((String)"Examples"));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"All"), (MenuListener)new MenuPerformer((StObject)this, "executeAllMethods")));
        stMenu.addSeparator();
        String[] stringArray = JunTestExamples.GetStaticMethodNamesFor(((Object)((Object)this)).getClass());
        if (stringArray.length > 20 && stringArray[0].indexOf(95) > 0) {
            HashMap<String, StMenu> hashMap = new HashMap<String, StMenu>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = string.substring(0, string.indexOf(95));
                StMenu stMenu2 = (StMenu)hashMap.get(string2);
                if (stMenu2 == null) {
                    stMenu2 = new StMenu((Object)string2, JunTestExamples.$((String)string2));
                    stMenu.add((StMenuItem)stMenu2);
                    hashMap.put(string2, stMenu2);
                }
                stMenu2.add(new StMenuItem((Object)string, (MenuListener)new MenuPerformer((StObject)this, "executeMethod", (Object)string)));
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                stMenu.add(new StMenuItem((Object)stringArray[i], (MenuListener)new MenuPerformer((StObject)this, "executeMethod", (Object)stringArray[i])));
            }
        }
        return stMenu;
    }

    protected StMenu _createMiscMenu() {
        StMenu stMenu = new StMenu((Object)JunSystem.$String((String)"Misc"));
        stMenu.add((StMenuItem)new StCheckBoxMenuItem((Object)JunSystem.$String((String)"Measure elapsing"), JunTestExamples.$((String)"elapsing"), false));
        stMenu.addSeparator();
        stMenu.add((StMenuItem)JunOpenGLResource.DefaultOpenGLViewMenu);
        stMenu.add((StMenuItem)StApplicationModel.DefaultViewModeMenu);
        stMenu.add((StMenuItem)JunSystem.DefaultLanguageModeMenu);
        return stMenu;
    }

    public void executeAllMethods() {
        String[] stringArray = JunTestExamples.GetStaticMethodNamesFor(((Object)((Object)this)).getClass());
        for (int i = 0; i < stringArray.length; ++i) {
            this.executeMethod(stringArray[i]);
        }
    }

    public void executeMethod(String string) {
        System.out.println(string);
        try {
            long l = System.currentTimeMillis();
            Boolean bl = (Boolean)StObject._Perform(((Object)((Object)this)).getClass(), (String)string);
            long l2 = System.currentTimeMillis();
            System.out.println("-> " + bl);
            if (this.isElapsing()) {
                System.out.println("-> elapsed " + (l2 - l) + " msec");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String[] GetStaticMethodNamesFor(Class clazz) {
        TreeSet<String> treeSet = new TreeSet<String>(new Comparator(){

            public int compare(Object object, Object object2) {
                return object.toString().compareTo(object2.toString());
            }
        });
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            int n;
            Method method = methodArray[i];
            if (method.getParameterTypes().length != 0 || !Modifier.isStatic(n = method.getModifiers()) || !Modifier.isPublic(n)) continue;
            treeSet.add(method.getName());
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }
}

