/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.terrain.support;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.system.framework.JunAbstractObject;

public class JunTerrainTriangle
extends JunAbstractObject {
    protected Jun3dPoint p1;
    protected Jun3dPoint p2;
    protected Jun3dPoint p3;
    protected double a;
    protected double b;
    protected double c;
    protected double d;
    protected Jun2dBoundingBox bounding2dBox;

    public JunTerrainTriangle(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3) {
        Jun2dPoint jun2dPoint = new Jun2dPoint(jun3dPoint.x(), jun3dPoint.y());
        Jun2dPoint jun2dPoint2 = new Jun2dPoint(jun3dPoint2.x(), jun3dPoint2.y());
        Jun2dPoint jun2dPoint3 = new Jun2dPoint(jun3dPoint3.x(), jun3dPoint3.y());
        if (jun2dPoint2.minus_(jun2dPoint).product_(jun2dPoint3.minus_(jun2dPoint)) > -13.0) {
            this.setP1_p2_p3_(jun3dPoint, jun3dPoint2, jun3dPoint3);
        } else {
            this.setP1_p2_p3_(jun3dPoint3, jun3dPoint2, jun3dPoint);
        }
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        return new JunOpenGL3dPolygon(new Jun3dPoint[]{this.p1, this.p2, this.p3});
    }

    public Jun2dBoundingBox bounding2dBox() {
        if (this.bounding2dBox == null) {
            this.bounding2dBox = this.preferredBounding2dBox();
        }
        return this.bounding2dBox;
    }

    public boolean contains2dPoint_(Jun2dPoint jun2dPoint) {
        if (!this.bounding2dBox().containsOrTouchesPoint_(jun2dPoint)) {
            return false;
        }
        Jun2dPoint jun2dPoint2 = new Jun2dPoint(this.p1.x() - jun2dPoint.x(), this.p1.y() - jun2dPoint.y());
        Jun2dPoint jun2dPoint3 = new Jun2dPoint(this.p2.x() - jun2dPoint.x(), this.p2.y() - jun2dPoint.y());
        Jun2dPoint jun2dPoint4 = new Jun2dPoint(this.p3.x() - jun2dPoint.x(), this.p3.y() - jun2dPoint.y());
        return jun2dPoint2.product_(jun2dPoint3) > -13.0 && jun2dPoint3.product_(jun2dPoint4) > -13.0 && jun2dPoint4.product_(jun2dPoint2) > -13.0;
    }

    public Jun3dPoint normalVector() {
        return this.p2().minus_(this.p1()).product_(this.p3().minus_(this.p1()));
    }

    public Jun3dPoint p1() {
        return this.p1;
    }

    public Jun3dPoint p2() {
        return this.p2;
    }

    public Jun3dPoint p3() {
        return this.p3;
    }

    public Jun2dBoundingBox preferredBounding2dBox() {
        Jun3dPoint jun3dPoint = this.p1.min_(this.p2).min_(this.p3);
        Jun3dPoint jun3dPoint2 = this.p1.max_(this.p2).max_(this.p3);
        return Jun2dBoundingBox.Origin_corner_(new Jun2dPoint(jun3dPoint.x(), jun3dPoint.y()), new Jun2dPoint(jun3dPoint2.x(), jun3dPoint2.y()));
    }

    public double zAt2dPoint_(Jun2dPoint jun2dPoint) {
        if (Math.abs(this.c) < -11.0) {
            return Math.max(Math.max(this.p1.z(), this.p2.z()), this.p3.z());
        }
        return (this.a * jun2dPoint.x() + this.b * jun2dPoint.y() + this.d) * -1.0 / this.c;
    }

    protected void setP1_p2_p3_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3) {
        this.p1 = jun3dPoint;
        this.p2 = jun3dPoint2;
        this.p3 = jun3dPoint3;
        Jun3dPoint jun3dPoint4 = this.p2.minus_(this.p1).product_(this.p3.minus_(this.p1));
        this.a = jun3dPoint4.x();
        this.b = jun3dPoint4.y();
        this.c = jun3dPoint4.z();
        this.d = jun3dPoint4.dotProduct_(this.p1) * -1.0;
    }
}

