/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.topology.globaloperators;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.Jun3dPolygon;
import jp.co.sra.jun.topology.abstracts.JunAbstractOperator;
import jp.co.sra.jun.topology.abstracts.JunGlobalOperator;
import jp.co.sra.jun.topology.elements.JunBody;
import jp.co.sra.jun.topology.elements.JunEdge;
import jp.co.sra.jun.topology.elements.JunLoop;
import jp.co.sra.jun.topology.elements.JunVertex;
import jp.co.sra.jun.topology.support.JunGeometryTransformer;
import jp.co.sra.smalltalk.StBlockClosure;

public class JunPlaneSCALE
extends JunGlobalOperator {
    protected Jun3dPoint point;
    protected Jun3dPoint vector;
    protected double factor;

    public static final JunPlaneSCALE Body_point_vector_factor_(JunBody junBody, Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, double d) {
        JunPlaneSCALE junPlaneSCALE = new JunPlaneSCALE();
        junPlaneSCALE.body_(junBody);
        junPlaneSCALE.point_(jun3dPoint);
        junPlaneSCALE.vector_(jun3dPoint2);
        junPlaneSCALE.factor_(d);
        return junPlaneSCALE;
    }

    public void execute() {
        final JunPlaneSCALE junPlaneSCALE = this;
        final Jun3dLine jun3dLine = this.scaleAxis();
        StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_(Object object) {
                Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)object);
                Jun3dPoint jun3dPoint2 = jun3dPoint.minus_(junPlaneSCALE.point());
                double d = jun3dPoint2.length();
                if (d < 1.0E-12) {
                    return jun3dPoint;
                }
                JunAngle junAngle = jun3dLine.angleWithLine_(new Jun3dLine(junPlaneSCALE.point(), jun3dPoint));
                double d2 = junAngle.cos() * d;
                Jun3dPoint jun3dPoint3 = junPlaneSCALE.unitVector().multipliedBy_(d2);
                if (jun3dPoint3.innerProduct_(jun3dPoint2) < 0.0) {
                    jun3dPoint3 = jun3dPoint3.negated();
                }
                Jun3dPoint jun3dPoint4 = jun3dPoint2.minus_(jun3dPoint3);
                return jun3dPoint3.multipliedBy_(junPlaneSCALE.factor()).plus_(jun3dPoint4).plus_(junPlaneSCALE.point());
            }
        };
        final JunGeometryTransformer junGeometryTransformer = JunGeometryTransformer.Block_(stBlockClosure);
        this.body().vertexesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunVertex junVertex = (JunVertex)object;
                if (junVertex.point() != null) {
                    junVertex.point_(junVertex.point().transform_(junGeometryTransformer));
                }
                return null;
            }
        });
        this.body().edgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunEdge junEdge = (JunEdge)object;
                Jun3dLine jun3dLine = (Jun3dLine)junEdge.basicCurve();
                if (jun3dLine != null) {
                    junEdge.setCurve_(jun3dLine.transform_(junGeometryTransformer));
                }
                return null;
            }
        });
        this.body().loopsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunLoop junLoop = (JunLoop)object;
                Jun3dPolygon jun3dPolygon = (Jun3dPolygon)junLoop.basicSurface();
                if (jun3dPolygon != null) {
                    junLoop.setSurface_(jun3dPolygon.transform_(junGeometryTransformer));
                }
                return null;
            }
        });
    }

    public final double factor() {
        return this.factor;
    }

    public final void factor_(double d) {
        this.factor = d;
    }

    public JunAbstractOperator inverse() {
        return JunPlaneSCALE.Body_point_vector_factor_(this.body(), this.point(), this.vector(), 1.0 / this.factor());
    }

    public final Jun3dPoint point() {
        return this.point;
    }

    public final void point_(Jun3dPoint jun3dPoint) {
        this.point = jun3dPoint;
    }

    public Jun3dLine scaleAxis() {
        return new Jun3dLine(this.point(), this.point().plus_(this.unitVector()));
    }

    public Jun3dPoint unitVector() {
        return this.vector().unitVector();
    }

    public final Jun3dPoint vector() {
        return this.vector;
    }

    public final void vector_(Jun3dPoint jun3dPoint) {
        this.vector = jun3dPoint;
    }
}

