/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.voronoi.twoD.diagram;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel;
import jp.co.sra.jun.goodies.movie.support.JunImagesToMovie;
import jp.co.sra.jun.goodies.utilities.JunImageUtility;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.jun.voronoi.twoD.diagram.JunDelaunay2dDiagram;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDiagram;
import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StRectangle;

public class JunVoronoi2dDiagramTestExamples
extends JunTestExamples {
    public static boolean Example1() {
        JunVoronoi2dDiagram junVoronoi2dDiagram = new JunVoronoi2dDiagram(200, 200);
        for (int i = 0; i < 50; ++i) {
            Jun2dPoint jun2dPoint = new Jun2dPoint(Math.random() * (double)junVoronoi2dDiagram.width(), Math.random() * (double)junVoronoi2dDiagram.height());
            junVoronoi2dDiagram.add_(jun2dPoint);
        }
        System.out.println("area: " + junVoronoi2dDiagram.area());
        junVoronoi2dDiagram.show();
        return true;
    }

    public static boolean Example2() {
        JunVoronoi2dDiagram junVoronoi2dDiagram = new JunVoronoi2dDiagram(200, 200);
        for (int i = 0; i < 50; ++i) {
            Jun2dPoint jun2dPoint = new Jun2dPoint(Math.random() * (double)junVoronoi2dDiagram.width(), Math.random() * (double)junVoronoi2dDiagram.height());
            junVoronoi2dDiagram.add_(jun2dPoint);
        }
        junVoronoi2dDiagram.show();
        junVoronoi2dDiagram.asDelaunayDiagram().show();
        System.out.println("area: " + junVoronoi2dDiagram.area());
        return true;
    }

    public static boolean Example3() {
        final JunVoronoi2dDiagram junVoronoi2dDiagram = new JunVoronoi2dDiagram(200, 200);
        final JPanel jPanel = new JPanel(){

            public void paint(Graphics graphics) {
                junVoronoi2dDiagram.displayOn_(graphics);
            }
        };
        jPanel.setPreferredSize(new Dimension(200, 200));
        JFrame jFrame = new JFrame();
        jFrame.setTitle(junVoronoi2dDiagram.labelString());
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
            }
        });
        jFrame.getContentPane().add(jPanel);
        jFrame.pack();
        StApplicationModel._ShowAtMousePoint((Window)jFrame);
        Thread thread = new Thread(){

            public void run() {
                while (jPanel.isShowing()) {
                    junVoronoi2dDiagram.add_(new Jun2dPoint(Math.random() * (double)junVoronoi2dDiagram.width(), Math.random() * (double)junVoronoi2dDiagram.height()));
                    jPanel.paintImmediately(jPanel.getBounds());
                    Thread.yield();
                }
            }
        };
        thread.setPriority(4);
        thread.start();
        return true;
    }

    public static boolean Example4() {
        JunVoronoi2dDiagram junVoronoi2dDiagram = new JunVoronoi2dDiagram(200, 200);
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[]{new Jun2dPoint(0.1, 0.1), new Jun2dPoint(0.1, 0.9), new Jun2dPoint(0.9, 0.1), new Jun2dPoint(0.9, 0.9), new Jun2dPoint(0.5, 0.5), new Jun2dPoint(0.1, 0.5), new Jun2dPoint(0.9, 0.5), new Jun2dPoint(0.5, 0.1), new Jun2dPoint(0.5, 0.9)};
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            double d = jun2dPointArray[i].x() * (double)junVoronoi2dDiagram.width();
            double d2 = jun2dPointArray[i].y() * (double)junVoronoi2dDiagram.height();
            junVoronoi2dDiagram.add_(new Jun2dPoint(d, d2));
        }
        System.out.println("area: " + junVoronoi2dDiagram.area());
        junVoronoi2dDiagram.show();
        return true;
    }

    public static boolean Example5() {
        JunVoronoi2dDiagram junVoronoi2dDiagram = new JunVoronoi2dDiagram(200, 200);
        int n = 0;
        for (int i = 0; i <= 10; ++i) {
            for (int j = 0; j <= 10; ++j) {
                if (n % 2 == 0) {
                    double d = (double)j / 10.0 * (double)junVoronoi2dDiagram.width();
                    double d2 = (double)i / 10.0 * (double)junVoronoi2dDiagram.height();
                    junVoronoi2dDiagram.add_(new Jun2dPoint(d, d2));
                }
                ++n;
            }
        }
        System.out.println("area: " + junVoronoi2dDiagram.area());
        junVoronoi2dDiagram.show();
        return true;
    }

    public static boolean Example6() {
        JunVoronoi2dDiagram junVoronoi2dDiagram = new JunVoronoi2dDiagram(200, 200);
        ArrayList<Jun2dPoint> arrayList = new ArrayList<Jun2dPoint>();
        arrayList.add(new Jun2dPoint(0.0, 0.0));
        int n = 10;
        for (int i = 0; i <= 360; i += n) {
            JunAngle junAngle = JunAngle.FromDeg_(i);
            arrayList.add(new Jun2dPoint(junAngle.cos(), junAngle.sin()));
            junAngle = JunAngle.FromDeg_(i + n / 2);
            arrayList.add(new Jun2dPoint(junAngle.cos() * 0.5, junAngle.sin() * 0.5));
        }
        Jun2dPoint[] jun2dPointArray = arrayList.toArray(new Jun2dPoint[arrayList.size()]);
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            double d = (jun2dPointArray[i].x() + 1.0) * (double)junVoronoi2dDiagram.width() / 2.0;
            double d2 = (jun2dPointArray[i].y() + 1.0) * (double)junVoronoi2dDiagram.height() / 2.0;
            junVoronoi2dDiagram.add_(new Jun2dPoint(d, d2));
        }
        System.out.println("area: " + junVoronoi2dDiagram.area());
        junVoronoi2dDiagram.show();
        return true;
    }

    public static boolean Example7() {
        Object object;
        int n;
        ArrayList<JunImageDisplayModel> arrayList = new ArrayList<JunImageDisplayModel>();
        Dimension dimension = new Dimension(300, 300);
        final JunVoronoi2dDiagram junVoronoi2dDiagram = new JunVoronoi2dDiagram(dimension);
        JunImageDisplayModel junImageDisplayModel = JunImageDisplayModel.Show_label_at_((StDisplayable)new StImage(dimension), "Voronoi (" + dimension.width + "x" + dimension.height + ")", new Point(100, 200));
        arrayList.add(junImageDisplayModel);
        junImageDisplayModel.closeTogether_(arrayList);
        final JunDelaunay2dDiagram junDelaunay2dDiagram = new JunDelaunay2dDiagram(dimension);
        junImageDisplayModel = JunImageDisplayModel.Show_label_at_((StDisplayable)new StImage(dimension), "Delaunay (" + dimension.width + "x" + dimension.height + ")", new Point(100 + dimension.width + 50, 200));
        arrayList.add(junImageDisplayModel);
        junImageDisplayModel.closeTogether_(arrayList);
        ArrayList<Jun2dPoint> arrayList2 = new ArrayList<Jun2dPoint>();
        StRectangle stRectangle = new StRectangle(junVoronoi2dDiagram.extent());
        for (int i = stRectangle.originY(); i <= stRectangle.cornerY(); i += 10) {
            for (n = stRectangle.originX(); n <= stRectangle.cornerX(); n += 10) {
                object = new Jun2dPoint((double)n + Math.random() * 5.0 - 2.5, (double)i + Math.random() * 5.0 - 2.5);
                double d = object.distance_(new Jun2dPoint(dimension.width / 2, dimension.height / 2));
                if (!(d < (double)(dimension.width / 2 - 10)) || !(d < (double)(dimension.height / 2 - 10))) continue;
                arrayList2.add((Jun2dPoint)((Object)object));
            }
        }
        Collections.shuffle(arrayList2);
        Jun2dPoint[] jun2dPointArray = arrayList2.toArray(new Jun2dPoint[arrayList2.size()]);
        for (n = 0; n < jun2dPointArray.length; ++n) {
            junVoronoi2dDiagram.add_(jun2dPointArray[n]);
            junDelaunay2dDiagram.add_(jun2dPointArray[n]);
            if (n % 10 != 0) continue;
            object = JunImageUtility.ImageExtent_displayBlock_(junVoronoi2dDiagram.extent(), new StBlockClosure(){

                public Object value_(Object object) {
                    junVoronoi2dDiagram.displayOn_((Graphics)object);
                    return null;
                }
            });
            ((JunImageDisplayModel)((Object)arrayList.get(0))).image_((Image)object);
            ((JunImageDisplayModel)((Object)arrayList.get(0))).redisplay();
            object = JunImageUtility.ImageExtent_displayBlock_(junDelaunay2dDiagram.extent(), new StBlockClosure(){

                public Object value_(Object object) {
                    junDelaunay2dDiagram.displayOn_((Graphics)object);
                    return null;
                }
            });
            ((JunImageDisplayModel)((Object)arrayList.get(1))).image_((Image)object);
            ((JunImageDisplayModel)((Object)arrayList.get(1))).redisplay();
        }
        BufferedImage bufferedImage = JunImageUtility.ImageExtent_displayBlock_(junVoronoi2dDiagram.extent(), new StBlockClosure(){

            public Object value_(Object object) {
                junVoronoi2dDiagram.displayOn_((Graphics)object);
                return null;
            }
        });
        ((JunImageDisplayModel)((Object)arrayList.get(0))).image_(bufferedImage);
        ((JunImageDisplayModel)((Object)arrayList.get(0))).redisplay();
        bufferedImage = JunImageUtility.ImageExtent_displayBlock_(junDelaunay2dDiagram.extent(), new StBlockClosure(){

            public Object value_(Object object) {
                junDelaunay2dDiagram.displayOn_((Graphics)object);
                return null;
            }
        });
        ((JunImageDisplayModel)((Object)arrayList.get(1))).image_(bufferedImage);
        ((JunImageDisplayModel)((Object)arrayList.get(1))).redisplay();
        return true;
    }

    public static boolean Example8() {
        Object object;
        final Dimension dimension = new Dimension(300, 300);
        final JunVoronoi2dDiagram junVoronoi2dDiagram = new JunVoronoi2dDiagram(dimension);
        final JunDelaunay2dDiagram junDelaunay2dDiagram = new JunDelaunay2dDiagram(dimension);
        final Dimension dimension2 = new Dimension(dimension.width * 2 + 15, dimension.height + 10);
        final JunImageDisplayModel junImageDisplayModel = JunImageDisplayModel.Show_label_at_((StDisplayable)new StImage(dimension2), "Voronoi and Delaunay", new Point(100, 200));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StRectangle stRectangle = new StRectangle(junVoronoi2dDiagram.extent());
        for (int i = stRectangle.originY(); i <= stRectangle.cornerY(); i += 10) {
            for (int j = stRectangle.originX(); j <= stRectangle.cornerX(); j += 10) {
                object = new Jun2dPoint((double)j + Math.random() * 5.0 - 2.5, (double)i + Math.random() * 5.0 - 2.5);
                double d = ((Jun2dPoint)((Object)object)).distance_(new Jun2dPoint(dimension.width / 2, dimension.height / 2));
                if (!(d < (double)(dimension.width / 2 - 10)) || !(d < (double)(dimension.height / 2 - 10))) continue;
                arrayList.add(object);
            }
        }
        Collections.shuffle(arrayList);
        final Jun2dPoint[] jun2dPointArray = arrayList.toArray(new Jun2dPoint[arrayList.size()]);
        object = new File("VoronoiAndDelaunay.mov");
        JunImagesToMovie.File_extent_do_(object, dimension2, new StBlockClosure(){

            public Object value_(Object object) {
                JunImagesToMovie junImagesToMovie = (JunImagesToMovie)((Object)object);
                for (int i = 0; i < jun2dPointArray.length; ++i) {
                    junVoronoi2dDiagram.add_(jun2dPointArray[i]);
                    junDelaunay2dDiagram.add_(jun2dPointArray[i]);
                    if (i % 10 != 0) continue;
                    BufferedImage bufferedImage = JunImageUtility.ImageExtent_displayBlock_(dimension2, new StBlockClosure(){

                        public Object value_(Object object) {
                            junVoronoi2dDiagram.displayOn_at_((Graphics)object, new Point(5, 5));
                            junDelaunay2dDiagram.displayOn_at_((Graphics)object, new Point((this).dimension.width + 10, 5));
                            return null;
                        }
                    });
                    junImageDisplayModel.image_(bufferedImage);
                    junImageDisplayModel.redisplay();
                    junImagesToMovie.add_milliseconds_(new StImage((Image)bufferedImage), 50);
                }
                BufferedImage bufferedImage = JunImageUtility.ImageExtent_displayBlock_(dimension2, new StBlockClosure(){

                    public Object value_(Object object) {
                        junVoronoi2dDiagram.displayOn_at_((Graphics)object, new Point(5, 5));
                        junDelaunay2dDiagram.displayOn_at_((Graphics)object, new Point((this).dimension.width + 10, 5));
                        return null;
                    }
                });
                junImageDisplayModel.image_(bufferedImage);
                junImageDisplayModel.redisplay();
                junImagesToMovie.add_milliseconds_(new StImage((Image)bufferedImage), 50);
                return null;
            }
        });
        return true;
    }

    public static boolean Example9() {
        JunVoronoi2dDiagram junVoronoi2dDiagram = new JunVoronoi2dDiagram(200, 200);
        junVoronoi2dDiagram.add_(new Jun2dPoint(50.0, 100.0));
        junVoronoi2dDiagram.add_(new Jun2dPoint(150.0, 100.0));
        System.out.println("area: " + junVoronoi2dDiagram.area());
        junVoronoi2dDiagram.show();
        return true;
    }

    public static void main(String[] stringArray) {
        new JunVoronoi2dDiagramTestExamples();
    }
}

