/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.voronoi.twoD.diagram;

import java.awt.Point;
import java.io.IOException;
import java.io.Writer;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dLine;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dObject;
import jp.co.sra.smalltalk.SmalltalkException;

public class JunVoronoi2dDot
extends JunVoronoi2dObject {
    protected double x;
    protected double y;

    public JunVoronoi2dDot(double d, double d2) {
        this.x_(d);
        this.y_(d2);
    }

    public JunVoronoi2dDot(Jun2dPoint jun2dPoint) {
        this(jun2dPoint.x(), jun2dPoint.y());
    }

    public JunVoronoi2dDot(Point point) {
        this(point.x, point.y);
    }

    protected void initialize() {
        super.initialize();
        this.x = Double.NaN;
        this.y = Double.NaN;
    }

    public double x() {
        return this.x;
    }

    public void x_(double d) {
        this.x = d;
    }

    public double y() {
        return this.y;
    }

    public void y_(double d) {
        this.y = d;
    }

    public double distance_(JunVoronoi2dDot junVoronoi2dDot) {
        double d = this.x();
        double d2 = this.y();
        double d3 = junVoronoi2dDot.x();
        double d4 = junVoronoi2dDot.y();
        double d5 = d - d3;
        double d6 = d2 - d4;
        return Math.sqrt(d5 * d5 + d6 * d6);
    }

    public JunVoronoi2dLine bisector_(JunVoronoi2dDot junVoronoi2dDot) {
        double d = this.x();
        double d2 = this.y();
        double d3 = junVoronoi2dDot.x();
        double d4 = junVoronoi2dDot.y();
        double d5 = d3 - d;
        double d6 = d4 - d2;
        double d7 = (d3 * d3 + d4 * d4 - (d * d + d2 * d2)) * 0.5 * -1.0;
        if (Math.abs(d5) < this.accuracy() && Math.abs(d6) < this.accuracy()) {
            throw SmalltalkException.Error((String)"two points are the same.");
        }
        return new JunVoronoi2dLine(d5, d6, d7);
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write("dot ( ");
        writer.write(String.valueOf(this.x));
        writer.write(" , ");
        writer.write(String.valueOf(this.y));
        writer.write(" )");
    }
}

