/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.qt4jun;

import java.awt.Component;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.qt4jun.JunQTMovie;
import jp.co.sra.qt4jun.JunQTNativeMovie;
import jp.co.sra.qt4jun.JunQTNativePort;
import jp.co.sra.qt4jun.JunQTPort;

public class JunQTMovieFactory {
    private static boolean UseJunQTNativeMovie = true;

    public static boolean canGetMovieFile() {
        if (UseJunQTNativeMovie) {
            return JunQTNativeMovie.canGetMovieFile();
        }
        try {
            Class<?> clazz = Class.forName("jp.co.sra.qt4jun.JunQTJMovie");
            Method method = clazz.getDeclaredMethod("canGetMovieFile", null);
            return (Boolean)method.invoke(null, (Object[])null);
        }
        catch (Exception exception) {
            throw new Error(exception.getMessage());
        }
    }

    public static String getMovieFile() {
        if (UseJunQTNativeMovie) {
            return JunQTNativeMovie.getMovieFile();
        }
        try {
            Class<?> clazz = Class.forName("jp.co.sra.qt4jun.JunQTJMovie");
            Method method = clazz.getDeclaredMethod("getMovieFile", null);
            return (String)method.invoke(null, (Object[])null);
        }
        catch (Exception exception) {
            throw new Error(exception.getMessage());
        }
    }

    public static JunQTMovie openMovie(File file) {
        return JunQTMovieFactory.openMovie(file.getPath());
    }

    public static JunQTMovie openMovie(String string) {
        if (UseJunQTNativeMovie) {
            return JunQTNativeMovie.openMovie(string);
        }
        try {
            Class<?> clazz = Class.forName("jp.co.sra.qt4jun.JunQTJMovie");
            Class[] classArray = new Class[]{String.class};
            Method method = clazz.getDeclaredMethod("openMovie", classArray);
            Object[] objectArray = new Object[]{string};
            return (JunQTMovie)method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            throw new Error(exception.getMessage());
        }
    }

    public static JunQTPort createPort(Component component) {
        if (UseJunQTNativeMovie) {
            return new JunQTNativePort(component);
        }
        try {
            Class<?> clazz = Class.forName("jp.co.sra.qt4jun.JunQTJPort");
            Class[] classArray = new Class[]{Component.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{component};
            return (JunQTPort)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new Error(exception.getMessage());
        }
    }

    public static boolean portCreatesComponent() {
        return !UseJunQTNativeMovie;
    }

    static {
        if (JunSystem.IsMacOSX()) {
            UseJunQTNativeMovie = false;
        }
        if (System.getProperty("UseJunQTNativeMovie") != null) {
            UseJunQTNativeMovie = Boolean.getBoolean("UseJunQTNativeMovie");
        }
        JunQTMovieFactory.canGetMovieFile();
    }
}

