/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;

public class StColorValue
extends StObject {
    public static int _MaxDistanceSquared = -1;
    public static int _MaxValue = 255;
    public static int _MaxLuminanceValue = _MaxValue * 1000;
    public static double _LuminanceScaleValue = 1.0f / (float)_MaxLuminanceValue;
    public static final Color Black = Color.black;
    public static final Color Blue = Color.blue;
    public static final Color Brown = new Color(127, 63, 63);
    public static final Color Chartreuse = new Color(127, 255, 0);
    public static final Color Cyan = new Color(0, 255, 255);
    public static final Color DarkCyan = new Color(0, 127, 127);
    public static final Color DarkGray = new Color(95, 95, 95);
    public static final Color DarkGreen = new Color(0, 127, 0);
    public static final Color DarkMagenta = new Color(127, 0, 127);
    public static final Color DarkRed = new Color(127, 0, 0);
    public static final Color Gray = new Color(127, 127, 127);
    public static final Color Green = new Color(0, 255, 0);
    public static final Color LightGray = new Color(170, 170, 170);
    public static final Color LightCyan = new Color(127, 255, 255);
    public static final Color LightYellow = new Color(255, 255, 127);
    public static final Color Magenta = new Color(255, 0, 255);
    public static final Color Navy = new Color(0, 0, 127);
    public static final Color Olive = new Color(127, 127, 0);
    public static final Color Orange = new Color(255, 127, 0);
    public static final Color Orchid = new Color(255, 127, 255);
    public static final Color PaleGreen = new Color(127, 255, 127);
    public static final Color Pink = new Color(255, 191, 191);
    public static final Color Purple = new Color(159, 31, 223);
    public static final Color Red = Color.red;
    public static final Color RoyalBlue = new Color(127, 127, 255);
    public static final Color Salmon = new Color(255, 127, 127);
    public static final Color SpringGreen = new Color(0, 255, 127);
    public static final Color VeryDarkGray = new Color(63, 63, 63);
    public static final Color VeryLightGray = new Color(212, 212, 212);
    public static final Color White = Color.white;
    public static final Color Yellow = new Color(255, 255, 0);
    protected static Hashtable NamedColors = new Hashtable(31);

    public static double _DistanceFrom(Color color, Color color2) {
        return Math.sqrt(StColorValue._DistanceSquaredFrom(color, color2));
    }

    public static int _DistanceSquaredFrom(Color color, Color color2) {
        int n = color.getRed() - color2.getRed();
        int n2 = color.getGreen() - color2.getGreen();
        int n3 = color.getBlue() - color2.getBlue();
        return n * n + n2 * n2 + n3 * n3;
    }

    public static Integer _DistanceSquaredFrom_ifLessThan_(Color color, Color color2, int n) {
        int n2 = color.getRed() - color2.getRed();
        int n3 = n2 * n2;
        if (n3 >= n) {
            return null;
        }
        int n4 = color.getGreen() - color2.getGreen();
        if ((n3 += n4 * n4) >= n) {
            return null;
        }
        int n5 = color.getBlue() - color2.getBlue();
        if ((n3 += n5 * n5) >= n) {
            return null;
        }
        return new Integer(n3);
    }

    public static int _GetAlpha(Color color) {
        ColorModel colorModel = ColorModel.getRGBdefault();
        return colorModel.getAlpha(color.getRGB());
    }

    public static float _GetBrightness(Color color) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        return fArray[2];
    }

    public static Color _GetColorByName_(String string) {
        char[] cArray;
        Color color = (Color)NamedColors.get(string);
        if (color == null && Character.isLowerCase((cArray = string.toCharArray())[0])) {
            cArray[0] = Character.toUpperCase(cArray[0]);
            color = (Color)NamedColors.get(new String(cArray));
        }
        return color;
    }

    public static float _GetHue(Color color) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        return fArray[0];
    }

    public static double _GetLuminance(Color color) {
        return _LuminanceScaleValue * (double)StColorValue._ScaledLuminance_(color);
    }

    public static float _GetSaturation(Color color) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        return fArray[1];
    }

    public static boolean _IsGray(Color color) {
        return color.getRed() == color.getGreen() && color.getGreen() == color.getBlue() && (color.getRGB() >> 24 & 0xFF) != 0;
    }

    public static int _MaxDistanceSquared() {
        if (_MaxDistanceSquared == -1) {
            _MaxDistanceSquared = StColorValue._DistanceSquaredFrom(Color.black, Color.white);
        }
        return _MaxDistanceSquared;
    }

    public static Color _NewColor(float f, float f2, float f3, float f4) {
        return StColorValue._NewColor(f * 255.0f, f2 * 255.0f, f3 * 255.0f, f4 * 255.0f);
    }

    public static Color _NewColor(int n, int n2, int n3, int n4) {
        int n5 = n4 << 24 | n << 16 | n2 << 8 | n3 << 0;
        return new Color(n5);
    }

    public static int _ScaledLuminance_(Color color) {
        return 299 * color.getRed() + 587 * color.getGreen() + 114 * color.getBlue();
    }

    public static String _StoreStringOf(Color color) {
        int n = 8191;
        float f = (float)n / 255.0f;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(ColorValue scaledRed: ");
        stringBuffer.append(Math.round((float)color.getRed() * f));
        stringBuffer.append(" scaledGreen: ");
        stringBuffer.append(Math.round((float)color.getGreen() * f));
        stringBuffer.append(" scaledBlue: ");
        stringBuffer.append(Math.round((float)color.getBlue() * f));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String _PrintStringOf(Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append("ColorValue");
        if (color.getRed() == color.getGreen() && color.getRed() == color.getBlue()) {
            stringBuffer.append(" brightness: ");
            stringBuffer.append((float)color.getBlue() / 255.0f);
        } else {
            stringBuffer.append(" red: ");
            stringBuffer.append((float)color.getRed() / 255.0f);
            stringBuffer.append(" green: ");
            stringBuffer.append((float)color.getGreen() / 255.0f);
            stringBuffer.append(" blue: ");
            stringBuffer.append((float)color.getBlue() / 255.0f);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static Color Blend(Color color, Color color2) {
        int n = (color.getRed() + color2.getRed()) / 2;
        int n2 = (color.getGreen() + color2.getGreen()) / 2;
        int n3 = (color.getBlue() + color2.getBlue()) / 2;
        int n4 = (color.getAlpha() + color2.getAlpha()) / 2;
        return new Color(n, n2, n3, n4);
    }

    public static Color Brightness_(double d) {
        int n = Math.round((float)(d * 255.0));
        if (n >= 0 && n <= 255) {
            return new Color(n, n, n);
        }
        return Color.black;
    }

    public static Vector ConstantNames() {
        Vector<StSymbol> vector = new Vector<StSymbol>();
        Enumeration enumeration = NamedColors.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(StColorValue.$((String)enumeration.nextElement()));
        }
        return vector;
    }

    public static Color Cyan_Magenta_Yellow_(double d, double d2, double d3) {
        return new Color((float)(1.0 - d), (float)(1.0 - d2), (float)(1.0 - d3));
    }

    public static Color ScaledRed_ScaledGreen_ScaledBlue_(int n, int n2, int n3) {
        int n4 = Math.min(Math.max(n / 32, 0), 255);
        int n5 = Math.min(Math.max(n2 / 32, 0), 255);
        int n6 = Math.min(Math.max(n3 / 32, 0), 255);
        return new Color(n4, n5, n6);
    }

    static {
        NamedColors.put("black", Black);
        NamedColors.put("blue", Blue);
        NamedColors.put("brown", Brown);
        NamedColors.put("chartreuse", Chartreuse);
        NamedColors.put("cyan", Cyan);
        NamedColors.put("darkCyan", DarkCyan);
        NamedColors.put("darkGray", DarkGray);
        NamedColors.put("darkGreen", DarkGreen);
        NamedColors.put("darkMagenta", DarkMagenta);
        NamedColors.put("darkRed", DarkRed);
        NamedColors.put("gray", Gray);
        NamedColors.put("green", Green);
        NamedColors.put("lightGray", LightGray);
        NamedColors.put("lightCyan", LightCyan);
        NamedColors.put("lightYellow", LightYellow);
        NamedColors.put("magenta", Magenta);
        NamedColors.put("navy", Navy);
        NamedColors.put("olive", Olive);
        NamedColors.put("orange", Orange);
        NamedColors.put("orchid", Orchid);
        NamedColors.put("paleGreen", PaleGreen);
        NamedColors.put("pink", Pink);
        NamedColors.put("purple", Purple);
        NamedColors.put("red", Red);
        NamedColors.put("royalBlue", RoyalBlue);
        NamedColors.put("salmon", Salmon);
        NamedColors.put("springGreen", SpringGreen);
        NamedColors.put("veryDarkGray", VeryDarkGray);
        NamedColors.put("veryLightGray", VeryLightGray);
        NamedColors.put("white", White);
        NamedColors.put("yellow", Yellow);
    }
}

