/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import jp.co.sra.smalltalk.SmalltalkTestExamples;
import jp.co.sra.smalltalk.StByteArray;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.SystemInterface;

public class StImageTestExamples
extends SmalltalkTestExamples {
    public static boolean Example1() {
        StImage stImage = new StImage(128, 96);
        if (stImage == null) {
            return false;
        }
        stImage._display();
        return true;
    }

    public static boolean Example2() {
        StImage stImage = StImage._FromUser();
        if (stImage == null) {
            return false;
        }
        stImage._display();
        return true;
    }

    public static boolean Example3() {
        Rectangle rectangle = SystemInterface._RectangleFromUser();
        if (rectangle == null) {
            return false;
        }
        System.out.println("rect = " + rectangle);
        StImage stImage = StImage._OfArea(rectangle);
        if (stImage == null) {
            return false;
        }
        stImage._display();
        return true;
    }

    public static boolean Example4() {
        StImage stImage = StImage._OfWholeScreen();
        if (stImage == null) {
            return false;
        }
        stImage._display();
        return true;
    }

    public static boolean Example5() {
        Object object;
        Object object2;
        StImage stImage = StImage._FromUser();
        StImage stImage2 = null;
        try {
            object2 = new ByteArrayOutputStream();
            object = new ObjectOutputStream((OutputStream)object2);
            ((ObjectOutputStream)object).writeObject(stImage);
            ((ObjectOutputStream)object).flush();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray()));
            stImage2 = (StImage)objectInputStream.readObject();
            ((ObjectOutputStream)object).close();
            objectInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            iOException.printStackTrace();
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(classNotFoundException.getMessage());
            classNotFoundException.printStackTrace();
            return false;
        }
        stImage._display();
        stImage2._display();
        object2 = stImage.getPixels();
        object = stImage2.getPixels();
        for (int i = 0; i < ((Object)object2).length; ++i) {
            if (object2[i] == object[i]) continue;
            System.out.println("pixels[" + i + "] image1 = " + (int)object2[i] + " image2 = " + (int)object[i]);
            return false;
        }
        byte[] byArray = stImage.bits();
        byte[] byArray2 = stImage2.bits();
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            System.out.println("bits[" + i + "] image1 = " + byArray[i] + " image2 = " + byArray2[i]);
            return false;
        }
        return true;
    }

    public static boolean Example6() {
        StImage stImage = StImage._FromUser();
        if (stImage == null) {
            return false;
        }
        stImage.rotatedByQuadrants_(0)._display();
        stImage.rotatedByQuadrants_(1)._display();
        stImage.rotatedByQuadrants_(2)._display();
        stImage.rotatedByQuadrants_(3)._display();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean Example_CombinationRule() {
        int n = 32;
        StImage stImage = new StImage(200, 200);
        Graphics graphics = null;
        try {
            graphics = stImage.image().getGraphics();
            for (int i = 0; i < 16; ++i) {
                int n2 = i % 4 * (n + 4) + 3;
                int n3 = i / 4 * (n + 4) + 3;
                StImage stImage2 = new StImage(n, n);
                Graphics graphics2 = null;
                try {
                    graphics2 = stImage2.image().getGraphics();
                    graphics2.setColor(Color.white);
                    graphics2.fillRect(0, 0, stImage2.width(), stImage2.height());
                    graphics2.setColor(Color.black);
                    graphics2.fillRect(16, 4, 12, 24);
                    stImage2.image().flush();
                }
                finally {
                    if (graphics2 != null) {
                        graphics2.dispose();
                        graphics2 = null;
                    }
                }
                StImage stImage3 = new StImage(n, n);
                Graphics graphics3 = null;
                try {
                    graphics3 = stImage3.image().getGraphics();
                    graphics3.setColor(Color.white);
                    graphics3.fillRect(0, 0, stImage3.width(), stImage3.height());
                    graphics3.setColor(Color.black);
                    graphics3.fillPolygon(new int[]{4, 28, 4, 4}, new int[]{4, 16, 28, 4}, 4);
                    stImage3.image().flush();
                }
                finally {
                    if (graphics3 != null) {
                        graphics3.dispose();
                        graphics3 = null;
                    }
                }
                stImage3.copy_from_in_rule_(stImage3.bounds(), new Point(0, 0), stImage2, i);
                stImage3.displayOn_at_(graphics, new Point(n2, n3));
                graphics.setColor(Color.gray);
                graphics.drawRect(n2 - 1, n3 - 1, n + 1, n + 1);
            }
            stImage.image().flush();
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
                graphics = null;
            }
        }
        stImage._display();
        return true;
    }

    protected static StImage Image1() {
        return new StImage(17, 19, StByteArray.FromPackedString_("2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT@L#P5L#P5L#P5L#P5L#P5L#P5L#P5L#P5L#P5L#P5L#P5L#P5L#P5L#P5L#P5L#P5L#P5@CH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MP@2MCT2MCTP$IBP$IBP$IB@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@2MCT2MCT2MCT@L#P5L#P5DIBP-[V5-[V5-[V5 @@@@@@@@@@@J6-+Z6-+Z6-+P@@@J6-+P@@@L#P5L#P5@CH4MSH4MQBP$KV5-Z-+Z6-+Z4@@@@@@@@@@@B-+Z6-+Z6-+Z4@@@B-+Z6-+Z4@@@CH4MP@2MCT2MCTP$IB5-[V+Z6-+Z6-@@@@@@@@@@@@+Z6-+Z6-+Z6-@@@@+Z6-+Z6-@@@@2MCT@L#P5L#P5DIBP-[V5*6-+Z6-+P@@@@@@@@@@@@@@@@@@@@@@@J6-+Z6-+Z6-+P@@@L#P5@CH4MSH4MQBP$KV5-Z-+Z6-+Z6-+Z6-+Z6-+Z6-+Z6-+Z6-+Z6-+Z6-+Z6-+Z4@@@CH4MP@2MCT2MCTP$IB5-[V+Z6-X6M#X6M#X6M#X6M#X6M#X6M#X6M#X6M#+Z6-+Z6-@@@@2MCT@L#P5L#P5DIBP-[V5&M#X?????????????????????????????_&+VM#X:6-+P@@@L#P5@CH4MSH4MQBP$KV5-Y#X6O????????????????????????79*7???=#X6N-+Z4@@@CH4MP@2MCT2MCTP$IB5-[VX6M#????????????????????=>Z-????=>Z-X6M#+Z6-@@@@2MCT@L#P5L#P5DIBP-[V5&M#X?????????????????_&+_????_&+__&+VM#X:6-+P@@@L#P5@CH4MSH4MQBP$KV5-Y#X6O????????????79*7????79*779*779*5#X6L@@@@@@@CH4MP@2MCT2MCTP$IB5-[VX6M#????????=>Z-????=>Z-=>Z-=>Z-=>Z-X6M#????@@@@2MCT@L#P5L#P5@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@L#P5@CH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MSH4MP@2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT2MCT@@@a"), (ColorModel)new DirectColorModel(24, 255, 65280, 0xFF0000));
    }

    protected static StImage Image2() {
        return new StImage(17, 19, StByteArray.FromPackedString_("@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@P$IB@DIBP ABP$H@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@2MCT@L#P5@CH4MP@2MCT@L#P5@ABP$H@5-[V@M[V5 CV5-X@@@@@@@@@@@@@@@@@+Z6-@J6-+PB-+Z4@@@@@@J6-+P@@@@@@2MCT@L#P5@CH4MP@2MCT@DIBP CV5-X@+Z6-@J6-+P@@@@@@@@@@@@@@@@B-+Z4@+Z6-@J6-+P@@@@@@+Z6-@J6-+P@@@@@@2MCT@L#P5@CH4MP@P$IB@M[V5 B-+Z4@+Z6-@@@@@@@@@@@@@@@@@J6-+PB-+Z4@+Z6-@@@@@@B-+Z4@+Z6-@@@@@@CH4MP@2MCT@L#P5@ABP$H@5-[V@J6-+PB-+Z4@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+Z6-@J6-+PB-+Z4@@@@@@L#P5@CH4MP@2MCT@DIBP CV5-X@+Z6-@J6-+PB-+Z4@+Z6-@J6-+PB-+Z4@+Z6-@J6-+PB-+Z4@+Z6-@J6-+P@@@@@@2MCT@L#P5@CH4MP@P$IB@M[V5 B-+Z4@X6M#@FM#X0A#X6L@X6M#@FM#X0A#X6L@X6M#@FM#X0B-+Z4@+Z6-@@@@@@CH4MP@2MCT@L#P5@ABP$H@5-[V@FM#X0C???<@????@O???0C???<@????@O???0C???<@=>Z-@FM#X0B-+Z4@@@@@@L#P5@CH4MP@2MCT@DIBP CV5-X@X6M#@O???0C???<@????@O???0C???<@????@O_&+PC???<@X6M#@J6-+P@@@@@@2MCT@L#P5@CH4MP@P$IB@M[V5 A#X6L@????@O???0C???<@????@O???0C79*4@????@O_&+PA#X6L@+Z6-@@@@@@CH4MP@2MCT@L#P5@ABP$H@5-[V@FM#X0C???<@????@O???0C???<@=>Z-@O???0C79*4@=>Z-@FM#X0B-+Z4@@@@@@L#P5@CH4MP@2MCT@DIBP CV5-X@X6M#@O???0C???<@????@O_&+PC???<@=>Z-@O_&+PC79*4@X6M#@@@@@@@@@@@@2MCT@L#P5@CH4MP@P$IB@M[V5 A#X6L@????@O???0C79*4@????@O_&+PC79*4@=>Z-@O_&+PA#X6L@????@@@@@@CH4MP@2MCT@L#P5@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MP@2MCT@L#P5@CH4MPb"), (ColorModel)new DirectColorModel(32, 255, 65280, 0xFF0000, -16777216));
    }

    protected static StImage Image3() {
        byte[] byArray = new byte[]{-1, 0};
        return new StImage(16, 16, new byte[]{0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0}, (ColorModel)new IndexColorModel(1, 2, byArray, byArray, byArray));
    }

    public static void main(String[] stringArray) {
        new StImageTestExamples();
    }
}

