/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk;

import java.io.IOException;
import java.io.Writer;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StObject;

public class StInterval
extends StObject {
    private double start;
    private double stop;
    private double step = 1.0;

    public StInterval() {
    }

    public StInterval(double d, double d2) {
        this.setFrom_to_by_(d, d2, 1.0);
    }

    public StInterval(double d, double d2, double d3) {
        this.setFrom_to_by_(d, d2, d3);
    }

    public static StInterval From_to_(double d, double d2) {
        StInterval stInterval = new StInterval();
        stInterval.setFrom_to_by_(d, d2, 1.0);
        return stInterval;
    }

    public static StInterval From_to_by_(double d, double d2, double d3) {
        StInterval stInterval = new StInterval();
        stInterval.setFrom_to_by_(d, d2, d3);
        return stInterval;
    }

    public double at_(int n) {
        if (n >= 1 && n <= this.size()) {
            return this.start + this.step * (double)(n - 1);
        }
        throw new IndexOutOfBoundsException("size: " + this.size() + " index: " + n);
    }

    public double[] collect_(StBlockClosure stBlockClosure) {
        double[] dArray = new double[this.size()];
        double d = this.start;
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (Double)stBlockClosure.value_(new Double(d));
            d += this.step;
        }
        return dArray;
    }

    public void do_(StBlockClosure stBlockClosure) {
        double d;
        if (this.step < 0.0) {
            for (d = this.start; this.stop <= d; d += this.step) {
                stBlockClosure.value_(new Double(d));
            }
        } else {
            while (this.stop >= d) {
                stBlockClosure.value_(new Double(d));
                d += this.step;
            }
        }
    }

    public boolean equals(Object object) {
        if (object.getClass() == this.getClass()) {
            StInterval stInterval = (StInterval)object;
            return this.start == stInterval.start && this.step == stInterval.increment() && this.size() == stInterval.size();
        }
        return false;
    }

    public double first() {
        return this.start;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.start);
        int n = (int)(l ^ l >> 32);
        long l2 = Double.doubleToLongBits(this.stop);
        int n2 = (int)(l2 ^ l2 >> 32);
        return (n >> 2 | n2) >> 1 | this.size();
    }

    public double increment() {
        return this.step;
    }

    public double last() {
        return this.stop - (this.stop - this.start) % this.step;
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write("(" + this.start + " to: " + this.stop);
        if (this.step != 1.0) {
            writer.write(" by: " + this.step);
        }
        writer.write(")");
    }

    public void reverseDo_(StBlockClosure stBlockClosure) {
        double d;
        if (this.step < 0.0) {
            for (d = this.stop; this.start >= d; d -= this.step) {
                stBlockClosure.value_(new Double(d));
            }
        } else {
            while (this.start <= d) {
                stBlockClosure.value_(new Double(d));
                d -= this.step;
            }
        }
    }

    public int size() {
        int n = 0;
        if (this.step < 0.0) {
            if (!(this.start < this.stop)) {
                n = (int)((this.stop - this.start) / this.step) + 1;
            }
        } else if (!(this.stop < this.start)) {
            n = (int)((this.stop - this.start) / this.step) + 1;
        }
        return n;
    }

    public double start() {
        return this.start;
    }

    public double start_(double d) {
        this.start = d;
        return this.start;
    }

    public double step() {
        return this.step;
    }

    public double step_(double d) {
        this.step = d;
        return this.step;
    }

    public double stop() {
        return this.stop;
    }

    public double stop_(double d) {
        this.stop = d;
        return this.stop;
    }

    public void storeOn_(Writer writer) throws IOException {
        this.printOn_(writer);
    }

    private StInterval setFrom_to_by_(double d, double d2, double d3) {
        this.start = d;
        this.stop = d2;
        this.step = d3;
        return this;
    }
}

