/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk;

import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StUserMessage;

public class StMessageCatalog
extends StObject {
    protected ResourceBundle resourceBundle;
    public static final ArrayList Catalogs = new ArrayList();
    public static final StMessageCatalog DefaultMessageCatalog = new StMessageCatalog((ResourceBundle)null){

        public String lookUp(StUserMessage stUserMessage) {
            if (stUserMessage.catalog() != null && stUserMessage.catalog() != this) {
                return null;
            }
            String string = stUserMessage.defaultString();
            if (string == null) {
                string = stUserMessage.key();
            }
            return string;
        }
    };

    public static StMessageCatalog With(ResourceBundle resourceBundle) {
        for (int i = 0; i < Catalogs.size(); ++i) {
            StMessageCatalog stMessageCatalog = (StMessageCatalog)Catalogs.get(i);
            if (stMessageCatalog.resourceBundle != resourceBundle) continue;
            return stMessageCatalog;
        }
        return new StMessageCatalog(resourceBundle);
    }

    public static StMessageCatalog With(String string) {
        return StMessageCatalog.With(string, Locale.getDefault());
    }

    public static StMessageCatalog With(String string, Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
        if (!resourceBundle.getLocale().equals(locale)) {
            throw new MissingResourceException("Can't find bundle for base name " + string + ", locale " + locale, string + "_" + locale, "");
        }
        return StMessageCatalog.With(resourceBundle);
    }

    public static String LookUp(StUserMessage stUserMessage) {
        for (int i = 0; i < Catalogs.size(); ++i) {
            String string = ((StMessageCatalog)Catalogs.get(i)).lookUp(stUserMessage);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public static void GivePriorityTo(StMessageCatalog stMessageCatalog) {
        Catalogs.remove(stMessageCatalog);
        Catalogs.add(0, stMessageCatalog);
    }

    public StMessageCatalog(String string) {
        throw new SmalltalkException("Deprecated since StPL7.0, use StMessageCatalog#With(String)");
    }

    public StMessageCatalog(String string, Locale locale) {
        throw new SmalltalkException("Deprecated since StPL7.0, use StMessageCatalog#With(String, Locale)");
    }

    private StMessageCatalog(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        Catalogs.add(0, this);
    }

    public Locale getLocale() {
        return this.resourceBundle == null ? null : this.resourceBundle.getLocale();
    }

    public void setLocale(Locale locale) {
        throw new SmalltalkException("Can't change the locale dynamically. Create another one for a different locale.");
    }

    public String lookUp(StUserMessage stUserMessage) {
        if (stUserMessage.catalog() != null && stUserMessage.catalog() != this) {
            return null;
        }
        if (this.resourceBundle == null) {
            return null;
        }
        String string = null;
        try {
            string = this.resourceBundle.getString(stUserMessage.key());
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string;
    }

    public String lookUp(String string) {
        return this.lookUp(string, null);
    }

    public String lookUp(String string, String string2) {
        if (string2 == null) {
            string2 = string;
        }
        if (this.resourceBundle == null) {
            return this.lookUpFailed(string, string2);
        }
        try {
            return this.resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return this.lookUpFailed(string, string2);
        }
    }

    public String lookUp(String string, String string2, Object object) {
        return this.lookUp(string, string2, new Object[]{object});
    }

    public String lookUp(String string, String string2, Object[] objectArray) {
        String string3 = this.lookUp(string, string2);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                int n;
                StringBuffer stringBuffer = new StringBuffer(string3.length());
                String string4 = "<" + (i + 1) + "p>";
                int n2 = 0;
                while ((n = string3.indexOf(string4, n2)) >= 0) {
                    stringBuffer.append(string3.substring(n2, n));
                    stringBuffer.append(objectArray[i].toString());
                    n2 = n + string4.length();
                }
                stringBuffer.append(string3.substring(n2));
                string3 = stringBuffer.toString();
            }
        }
        return string3;
    }

    protected String lookUpFailed(String string, String string2) {
        return string2;
    }
}

