/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StObject;

public class StReadStream
extends StObject {
    protected String source = null;
    protected int position;
    protected int length;

    public StReadStream() {
        this("");
    }

    public StReadStream(String string) {
        this.on_(string);
    }

    public StReadStream(Reader reader) throws IOException {
        if (reader != null) {
            int n;
            BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = bufferedReader.read()) != -1) {
                stringBuffer.append((char)n);
            }
            this.on_(stringBuffer.toString());
        }
    }

    public StReadStream(File file) throws IOException {
        this(file == null ? (Reader)null : new FileReader(file));
    }

    public String contents() {
        return new String(this.source);
    }

    public char next() {
        return this.source.charAt(this.position++);
    }

    public String nextAvailable_(int n) {
        int n2 = Math.min(this.length, this.position() + n);
        int n3 = n2 - this.position();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n3; ++i) {
            stringBuffer.append(this.next());
        }
        return stringBuffer.toString();
    }

    public char peek() {
        if (this.atEnd()) {
            return '\u0000';
        }
        return this.source.charAt(this.position);
    }

    public boolean peekFor_(char c) {
        if (this.atEnd()) {
            return false;
        }
        char c2 = this.next();
        if (c == c2) {
            return true;
        }
        this.skip_(-1);
        return false;
    }

    public String upTo_(char c) {
        StringBuffer stringBuffer = new StringBuffer(64);
        while (!this.atEnd()) {
            char c2 = this.next();
            if (c2 == c) {
                return stringBuffer.toString();
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public String upToEnd() {
        return this.source.substring(this.position, this.length);
    }

    public boolean atEnd() {
        return this.position >= this.length;
    }

    public void close() {
    }

    public final int position() {
        return this.position;
    }

    public void position_(int n) {
        if (0 > n || n > this.source.length()) {
            throw new SmalltalkException("positionOutOfBoundsError: " + n);
        }
        this.position = n;
    }

    public void setToEnd() {
        this.position = this.length;
    }

    public void skip_(int n) {
        this.position_(this.position + n);
    }

    public String toString() {
        return super.toString();
    }

    protected void on_(String string) {
        this.length = string.length();
        char[] cArray = new char[this.length + 1];
        System.arraycopy(string.toCharArray(), 0, cArray, 0, this.length);
        cArray[this.length] = '\u0000';
        this.source = new String(cArray);
        this.position = 0;
    }
}

