/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk.menu;

import java.awt.Frame;
import java.awt.Label;
import java.awt.PopupMenu;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import jp.co.sra.smalltalk.SmalltalkTestExamples;
import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.menu.MenuEvent;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.StCheckBoxMenuItem;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuBarViewAwt;
import jp.co.sra.smalltalk.menu.StMenuBarViewSwing;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;
import jp.co.sra.smalltalk.menu.StPopupMenuViewAwt;
import jp.co.sra.smalltalk.menu.StPopupMenuViewSwing;
import jp.co.sra.smalltalk.menu.StRadioButtonGroup;
import jp.co.sra.smalltalk.menu.StRadioButtonMenuItem;

public class StMenuTestExamples
extends SmalltalkTestExamples {
    protected static StMenuBar SampleMenuBar;
    protected static StPopupMenu SamplePopupMenu;

    public static boolean Example1_AWT() {
        StApplicationModel.SetDefaultViewMode(0);
        Frame frame = new Frame();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        frame.setMenuBar(new StMenuBarViewAwt(SampleMenuBar).toMenuBar());
        final PopupMenu popupMenu = new StPopupMenuViewAwt(SamplePopupMenu).toPopupMenu();
        final Label label = new Label("click me", 1);
        label.add(popupMenu);
        label.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                StMenuItem stMenuItem = SampleMenuBar.atNameKey_(StObject.$("openMenuKey"));
                stMenuItem.label_("Open???");
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    popupMenu.show(label, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        frame.add(label);
        frame.pack();
        StApplicationModel._ShowAtMousePoint(frame);
        return true;
    }

    public static boolean Example1_Swing() {
        StApplicationModel.SetDefaultViewMode(1);
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setJMenuBar(new StMenuBarViewSwing(SampleMenuBar).toMenuBar());
        final JPopupMenu jPopupMenu = new StPopupMenuViewSwing(SamplePopupMenu).toPopupMenu();
        final JLabel jLabel = new JLabel("click me", 0);
        jLabel.add(jPopupMenu);
        jLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                StMenuItem stMenuItem = SampleMenuBar.atNameKey_(StObject.$("fileMenuKey"));
                stMenuItem.label_("File???");
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show(jLabel, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        jFrame.getContentPane().add(jLabel);
        jFrame.pack();
        StApplicationModel._ShowAtMousePoint(jFrame);
        return true;
    }

    public static void main(String[] stringArray) {
        new StMenuTestExamples();
    }

    static {
        StMenu stMenu = new StMenu((Object)"File", StMenuTestExamples.$("fileMenuKey"));
        stMenu.add(new StMenuItem((Object)"New", StMenuTestExamples.$("newMenuKey"), 78, 2));
        stMenu.add(new StMenuItem((Object)"Open", StMenuTestExamples.$("openMenuKey"), 79, 3));
        stMenu.add(new StMenuItem((Object)"Save", 83, 9));
        StMenu stMenu2 = new StMenu("Open...");
        stMenu2.add(new StMenuItem("VRML1.0"));
        stMenu2.add(new StMenuItem("VRML97"));
        stMenu.add(stMenu2);
        stMenu.addSeparator();
        stMenu.add(new StCheckBoxMenuItem((Object)"CheckBox", StMenuTestExamples.$("checkBoxMenuKey"), false));
        stMenu.add(new StCheckBoxMenuItem((Object)"CheckBox2", true));
        stMenu.addSeparator();
        StRadioButtonGroup stRadioButtonGroup = new StRadioButtonGroup();
        stMenu.add(new StRadioButtonMenuItem((Object)"RadioButton1", StMenuTestExamples.$("xrb1"), stRadioButtonGroup));
        stMenu.add(new StRadioButtonMenuItem((Object)"RadioButton2", stRadioButtonGroup));
        stMenu.add(new StRadioButtonMenuItem((Object)"RadioButton3", stRadioButtonGroup));
        stMenu.addSeparator();
        stMenu.addAll(new StRadioButtonGroup(new StRadioButtonMenuItem[]{new StRadioButtonMenuItem((Object)"RadioButton1", StMenuTestExamples.$("yrb1")), new StRadioButtonMenuItem((Object)"RadioButton2", StMenuTestExamples.$("yrb2")), new StRadioButtonMenuItem((Object)"RadioButton3", StMenuTestExamples.$("yrb3"))}).menuItems());
        SampleMenuBar = new StMenuBar();
        SampleMenuBar.add(stMenu);
        SampleMenuBar.add(new StMenu("Help"));
        SamplePopupMenu = new StPopupMenu();
        SamplePopupMenu.addAll(stMenu.menuItems());
        SamplePopupMenu.addSeparator();
        SamplePopupMenu.add(new StMenuItem("Misc"));
        MenuListener menuListener = new MenuListener(){

            public void menuPerformed(MenuEvent menuEvent) {
                System.out.println(menuEvent);
            }
        };
        SampleMenuBar.atNameKey_(StMenuTestExamples.$("openMenuKey")).addMenuListener(menuListener);
        SampleMenuBar.atNameKey_(StMenuTestExamples.$("Save")).addMenuListener(menuListener);
        SampleMenuBar.atNameKey_(StMenuTestExamples.$("checkBoxMenuKey")).addMenuListener(menuListener);
        SampleMenuBar.atNameKey_(StMenuTestExamples.$("checkBoxMenuKey")).addMenuListener(new MenuListener(){

            public void menuPerformed(MenuEvent menuEvent) {
                StCheckBoxMenuItem stCheckBoxMenuItem = (StCheckBoxMenuItem)menuEvent.getMenuItem();
                SampleMenuBar.atNameKey_(StObject.$("VRML1.0")).beEnabled(stCheckBoxMenuItem.isSelected());
            }
        });
        SampleMenuBar.atNameKey_(StMenuTestExamples.$("VRML1.0")).disable();
        SampleMenuBar.atNameKey_(StMenuTestExamples.$("xrb1")).addMenuListener(menuListener);
        SampleMenuBar.atNameKey_(StMenuTestExamples.$("yrb1")).addMenuListener(menuListener);
    }
}

