#ifdef WIN32
	#include <windows.h>
	#include <GL\glu.h>
#else
	#include <GL/glu.h>
#endif
#include "jp_co_sra_gl4jun_GLjInterface.h"

/**
 * procedures-glu.c:
 *
 * 	@author:	MATSUDA Ryouichi
 * 	@version:	2.0
 * 	@created:	1998/10/08 (by MATSUDA Ryouichi)
 * 	@updated:	N/A
 *
 * 	$Id: procedures-glu.c,v 2.0 2005/02/17 00:38:38 hoshi Exp $
 */

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluBeginCurve
  (JNIEnv *env, jobject obj, jint nobj)
{
	gluBeginCurve((GLUnurbsObj *) nobj);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluBeginPolygon
  (JNIEnv *env, jobject obj, jint tobj)
{
	gluBeginPolygon((GLUtriangulatorObj *) tobj);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluBeginSurface
  (JNIEnv *env, jobject obj, jint nobj)
{
	gluBeginSurface((GLUnurbsObj *) nobj);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluBeginTrim
  (JNIEnv *env, jobject obj, jint nobj)
{
	gluBeginTrim((GLUnurbsObj *) nobj);
}

JNIEXPORT jint JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluBuild1DMipmaps
  (JNIEnv *env, jobject obj, jint target, jint components, jint width, jint format, jint type, jbyteArray data)
{
	jbyte *ptr1 = (*env)->GetByteArrayElements(env, data, 0);
	jint rc = gluBuild1DMipmaps(target, components, width, format, type, ptr1);
	(*env)->ReleaseByteArrayElements(env, data, ptr1, 0);
	return rc;
}

JNIEXPORT jint JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluBuild2DMipmaps
  (JNIEnv *env, jobject obj, jint target, jint components, jint width, jint height, jint format, jint type, jbyteArray data)
{
	jbyte *ptr1 = (*env)->GetByteArrayElements(env, data, 0);
	jint rc = gluBuild2DMipmaps(target, components, width, height, format, type, ptr1);
	(*env)->ReleaseByteArrayElements(env, data, ptr1, 0);
	return rc;
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluCylinder
  (JNIEnv *env, jobject obj, jint qobj, jdouble baseRadius, jdouble topRadius, jdouble height, jint slices, jint stacks)
{
	gluCylinder((GLUquadricObj *) qobj, baseRadius, topRadius, height, slices, stacks);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluDeleteNurbsRenderer
  (JNIEnv *env, jobject obj, jint nobj)
{
	gluDeleteNurbsRenderer((GLUnurbsObj *) nobj);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluDeleteQuadric
  (JNIEnv *env, jobject obj, jint state)
{
	gluDeleteQuadric((GLUquadricObj *) state);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluDeleteTess
  (JNIEnv *env, jobject obj, jint tobj)
{
	gluDeleteTess((GLUtriangulatorObj *) tobj);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluDisk
  (JNIEnv *env, jobject obj, jint qobj, jdouble innerRadius, jdouble outerRadius, jint slices, jint loops)
{
	gluDisk((GLUquadricObj *) qobj, innerRadius, outerRadius, slices, loops);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluEndCurve
  (JNIEnv *env, jobject obj, jint nobj)
{
	gluEndCurve((GLUnurbsObj *) nobj);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluEndPolygon
  (JNIEnv *env, jobject obj, jint tobj)
{
	gluEndPolygon((GLUtriangulatorObj *) tobj);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluEndSurface
  (JNIEnv *env, jobject obj, jint nobj)
{
	gluEndSurface((GLUnurbsObj *) nobj);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluEndTrim
  (JNIEnv *env, jobject obj, jint nobj)
{
	gluEndTrim((GLUnurbsObj *) nobj);
}

JNIEXPORT jstring JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluErrorString
  (JNIEnv *env, jobject obj, jint errorCode)
{
    return (*env)->NewStringUTF(env, gluErrorString(errorCode));
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluGetNurbsProperty
  (JNIEnv *env, jobject obj, jint nobj, jint property, jfloatArray value)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, value, 0);
	gluGetNurbsProperty((GLUnurbsObj *) nobj, property, ptr1);
	(*env)->ReleaseFloatArrayElements(env, value, ptr1, 0);
}

JNIEXPORT jstring JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluGetString
  (JNIEnv *env, jobject obj, jint name)
{
    return (*env)->NewStringUTF(env, gluGetString(name));
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluLoadSamplingMatrices
  (JNIEnv *env, jobject obj, jint nobj, jfloatArray modelMatrix, jfloatArray projMatrix, jintArray viewport)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, modelMatrix, 0);
	jfloat *ptr2 = (*env)->GetFloatArrayElements(env, projMatrix, 0);
	jint *ptr3 = (*env)->GetIntArrayElements(env, viewport, 0);
	gluLoadSamplingMatrices((GLUnurbsObj *) nobj, ptr1, ptr2, (GLint *) ptr3);
	(*env)->ReleaseFloatArrayElements(env, modelMatrix, ptr1, 0);
	(*env)->ReleaseFloatArrayElements(env, projMatrix, ptr2, 0);
	(*env)->ReleaseIntArrayElements(env, viewport, ptr3, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluLookAt
  (JNIEnv *env, jobject obj, jdouble eyex, jdouble eyey, jdouble eyez, jdouble centerx, jdouble centery, jdouble centerz, jdouble upx, jdouble upy, jdouble upz)
{
	gluLookAt(eyex, eyey, eyez, centerx, centery, centerz, upx, upy, upz);
}

JNIEXPORT jint JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluNewNurbsRenderer
  (JNIEnv *env, jobject obj)
{
	return (jint) gluNewNurbsRenderer();
}

JNIEXPORT jint JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluNewQuadric
  (JNIEnv *env, jobject obj)
{
	return (jint) gluNewQuadric();
}

JNIEXPORT jint JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluNewTess
  (JNIEnv *env, jobject obj)
{
	return (jint) gluNewTess();
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluNextContour
  (JNIEnv *env, jobject obj, jint tobj, jint type)
{
	gluNextContour((GLUtriangulatorObj *) tobj, type);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluNurbsCurve
  (JNIEnv *env, jobject obj, jint nobj, jint nknots, jfloatArray knot, jint stride, jfloatArray ctlarray, jint order, jint type)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, knot, 0);
	jfloat *ptr2 = (*env)->GetFloatArrayElements(env, ctlarray, 0);
	gluNurbsCurve((GLUnurbsObj *) nobj, nknots, ptr1, stride, ptr2, order, type);
	(*env)->ReleaseFloatArrayElements(env, knot, ptr1, 0);
	(*env)->ReleaseFloatArrayElements(env, ctlarray, ptr2, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluNurbsProperty
  (JNIEnv *env, jobject obj, jint nobj, jint property, jfloat value)
{
	gluNurbsProperty((GLUnurbsObj *) nobj, property, value);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluNurbsSurface
  (JNIEnv *env, jobject obj, jint nobj, jint sknot_count, jfloatArray sknot, jint tknot_count, jfloatArray tknot, jint s_stride, jint t_stride, jfloatArray ctlarray, jint sorder, jint torder, jint type)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, sknot, 0);
	jfloat *ptr2 = (*env)->GetFloatArrayElements(env, tknot, 0);
	jfloat *ptr3 = (*env)->GetFloatArrayElements(env, ctlarray, 0);
	gluNurbsSurface((GLUnurbsObj *) nobj, sknot_count, ptr1, tknot_count, ptr2, s_stride, t_stride, ptr3, sorder, torder, type);
	(*env)->ReleaseFloatArrayElements(env, sknot, ptr1, 0);
	(*env)->ReleaseFloatArrayElements(env, tknot, ptr2, 0);
	(*env)->ReleaseFloatArrayElements(env, ctlarray, ptr3, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluOrtho2D
  (JNIEnv *env, jobject obj, jdouble left, jdouble right, jdouble bottom, jdouble top)
{
	gluOrtho2D(left, right, bottom, top);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluPartialDisk
  (JNIEnv *env, jobject obj, jint qobj, jdouble innerRadius, jdouble outerRadius, jint slices, jint loops, jdouble startAngle, jdouble sweepAngle)
{
	gluPartialDisk((GLUquadricObj *) qobj, innerRadius, outerRadius, slices, loops, startAngle, sweepAngle);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluPerspective
  (JNIEnv *env, jobject obj, jdouble fovy, jdouble aspect, jdouble zNear, jdouble zFar)
{
	gluPerspective(fovy, aspect, zNear, zFar);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluPickMatrix
  (JNIEnv *env, jobject obj, jdouble x, jdouble y, jdouble width, jdouble height, jintArray viewport)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, viewport, 0);
	gluPickMatrix(x, y, width, height, (GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, viewport, ptr1, 0);
}

JNIEXPORT jint JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluProject
  (JNIEnv *env, jobject obj, jdouble objx, jdouble objy, jdouble objz, jdoubleArray modelMatrix, jdoubleArray projMatrix, jintArray viewport, jdoubleArray winx, jdoubleArray winy, jdoubleArray winz)
{
	jint ret;

	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, modelMatrix, 0);
	jdouble *ptr2 = (*env)->GetDoubleArrayElements(env, projMatrix, 0);
	jint *ptr3 = (*env)->GetIntArrayElements(env, viewport, 0);
	jdouble *ptr4 = (*env)->GetDoubleArrayElements(env, winx, 0);
	jdouble *ptr5 = (*env)->GetDoubleArrayElements(env, winy, 0);
	jdouble *ptr6 = (*env)->GetDoubleArrayElements(env, winz, 0);
	ret = gluProject(objx, objy, objz, ptr1, ptr2, (GLint *) ptr3, ptr4, ptr5, ptr6);
	(*env)->ReleaseDoubleArrayElements(env, modelMatrix, ptr1, 0);
	(*env)->ReleaseDoubleArrayElements(env, projMatrix, ptr2, 0);
	(*env)->ReleaseIntArrayElements(env, viewport, ptr3, 0);
	(*env)->ReleaseDoubleArrayElements(env, winx, ptr4, 0);
	(*env)->ReleaseDoubleArrayElements(env, winy, ptr5, 0);
	(*env)->ReleaseDoubleArrayElements(env, winz, ptr6, 0);
	return ret;
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluPwlCurve
  (JNIEnv *env, jobject obj, jint nobj, jint count, jfloatArray array, jint stride, jint type)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, array, 0);
	gluPwlCurve((GLUnurbsObj *) nobj, count, ptr1, stride, type);
	(*env)->ReleaseFloatArrayElements(env, array, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluQuadricDrawStyle
  (JNIEnv *env, jobject obj, jint quadObject, jint drawStyle)
{
	gluQuadricDrawStyle((GLUquadricObj *) quadObject, drawStyle);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluQuadricNormals
  (JNIEnv *env, jobject obj, jint quadObject, jint normals)
{
	gluQuadricNormals((GLUquadricObj *) quadObject, normals);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluQuadricOrientation
  (JNIEnv *env, jobject obj, jint quadObject, jint orientation)
{
	gluQuadricOrientation((GLUquadricObj *) quadObject, orientation);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluQuadricTexture
  (JNIEnv *env, jobject obj, jint quadObject, jboolean textureCoords)
{
	gluQuadricTexture((GLUquadricObj *) quadObject, textureCoords);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluSphere
  (JNIEnv *env, jobject obj, jint qobj, jdouble radius, jint slices, jint stacks)
{
	gluSphere((GLUquadricObj *) qobj, radius, slices, stacks);
}

JNIEXPORT jint JNICALL Java_jp_co_sra_gl4jun_GLjInterface_gluUnProject
  (JNIEnv *env, jobject obj, jdouble winx, jdouble winy, jdouble winz, jdoubleArray modelMatrix, jdoubleArray projMatrix, jintArray viewport, jdoubleArray objx, jdoubleArray objy, jdoubleArray objz)
{
	jint ret;

	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, modelMatrix, 0);
	jdouble *ptr2 = (*env)->GetDoubleArrayElements(env, projMatrix, 0);
	jint *ptr3 = (*env)->GetIntArrayElements(env, viewport, 0);
	jdouble *ptr4 = (*env)->GetDoubleArrayElements(env, objx, 0);
	jdouble *ptr5 = (*env)->GetDoubleArrayElements(env, objy, 0);
	jdouble *ptr6 = (*env)->GetDoubleArrayElements(env, objz, 0);
	ret = gluUnProject((GLdouble) winx, winy, winz, ptr1, ptr2, (GLint *) ptr3, ptr4, ptr5, ptr6);
	(*env)->ReleaseDoubleArrayElements(env, modelMatrix, ptr1, 0);
	(*env)->ReleaseDoubleArrayElements(env, projMatrix, ptr2, 0);
	(*env)->ReleaseIntArrayElements(env, viewport, ptr3, 0);
	(*env)->ReleaseDoubleArrayElements(env, objx, ptr4, 0);
	(*env)->ReleaseDoubleArrayElements(env, objy, ptr5, 0);
	(*env)->ReleaseDoubleArrayElements(env, objz, ptr6, 0);
	return ret;
}
