/**
 * JunQTInterface.c:
 *
 * 	@author:	NISHIHARA Satoshi
 * 	@version:	2.0
 * 	@created:	2000/12/29 (by NISHIHARA Satoshi)
 * 	@updated:	2001/11/14 (by Hoshi Takanori)
 *
 * 	$Id: JunQTInterface.c,v 2.1 2006/12/13 05:23:03 hoshi Exp $
 */

#ifdef __MACOSX__
#define __MACOS__
#else
#include <QTML.h>
#include <FixMath.h>
#endif
#include <Movies.h>

#ifndef __MACOS__
#include <stdlib.h>
#include <direct.h>

#include <Windows.h>

#include <Sound.h>
#endif

#include <jawt.h>
#ifndef __MACOSX_JAVA_141__
#include <jawt_md.h>
#endif

#include "jp_co_sra_qt4jun_JunQTInterface.h"
#include "version.h"

#ifdef __MACOSX_JAVA_141__
typedef struct JAWT_MacOSXDrawingSurfaceInfo JAWT_MacOSXDrawingSurfaceInfo;
#include "JunQTMacOSXUtils.h"
#endif


/*
 * constants and macros
 */

#if defined(__MACOS__) && defined(__BIG_ENDIAN__)
#define PIXEL_FORMAT k32ARGBPixelFormat
#else
#define PIXEL_FORMAT k32BGRAPixelFormat
#endif

/* alpha channel doesn't work on Windows...  */
#define RGB_PIXEL(red, green, blue) \
		(0xff000000 | ((red) << 16) | ((green) << 8) | (blue))

#define GET_RED(pixel) (((pixel) >> 16) & 0xff)
#define GET_GREEN(pixel) (((pixel) >> 8) & 0xff)
#define GET_BLUE(pixel) ((pixel) & 0xff)


/*
 * static variables
 */

#ifndef __MACOS__
static int initializeCount = 0;
#endif


/*
 * sub routines
 */

#ifdef __MACOS__

#ifdef __MACOSX__

static OSErr NativePathNameToFSSpec(const char *path, FSSpec *spec, long flags)
{
	FSRef ref;
	char *new_path, *p;
	Boolean is_directory;
	FSCatalogInfo catalog_info;
	OSStatus status;

	status = FSPathMakeRef(path, &ref, NULL);

	if (status == noErr) {
		return FSGetCatalogInfo(&ref, kFSCatInfoNone, NULL, NULL, spec, NULL);
	} else if (status != fnfErr) {
		return status;
	}

	new_path = malloc(strlen(path) + 1);
	if (new_path == NULL) {
		return memFullErr;
	}

	strcpy(new_path, path);
	p = strrchr(new_path, '/');
	if (p == NULL) {
		free(new_path);
		return paramErr;
	}

	*p = '\0';
	status = FSPathMakeRef(new_path, &ref, &is_directory);
	if (status != noErr || ! is_directory) {
		free(new_path);
		return paramErr;
	}

	status = FSGetCatalogInfo(&ref, kFSCatInfoVolume | kFSCatInfoNodeID,
			&catalog_info, NULL, NULL, NULL);
	if (status != noErr) {
		free(new_path);
		return status;
	}

	*p = strlen(p + 1);
	status = FSMakeFSSpec(catalog_info.volume, catalog_info.nodeID, p, spec);

	free(new_path);

	return status;
}

/* this function is not used...
static OSErr FSSpecToNativePathName
  (const FSSpec *spec, char *path, unsigned long length, long flags)
{
	FSRef ref;
	OSErr err;
	OSStatus status;

	err = FSpMakeFSRef(spec, &ref);
	if (err != noErr) {
		return err;
	}

	status = FSRefMakePath(&ref, path, length);
	if (status != noErr) {
		return fnfErr;
	}

	return noErr;
}
*/

#else

static OSErr NativePathNameToFSSpec(const char *path, FSSpec *spec, long flags)
{
	Str255 filename;
	int i = 0;

	if (*path == '/') {
		++path;
	} else {
		filename[i++] = ':';
	}

	while (*path != '\0' && i < sizeof filename - 1) {
		filename[i++] = (*path == '/') ? ':' : *path;
		++path;
	}

	filename[i] = '\0';
	c2pstr(filename);
	return FSMakeFSSpec(0, 0, filename, spec);
}

static OSErr FSSpecToNativePathName
  (const FSSpec *spec, char *path, unsigned long length, long flags)
{
	unsigned long current;
	FSSpec dir;
	CInfoPBRec pb;
	OSErr err;

	path[0] = '\0';
	current = 1;
	dir = *spec;

	for (;;) {
		if (current + dir.name[0] < length) {
			BlockMoveData(path, path + dir.name[0] + 1, current);
			BlockMoveData(dir.name + 1, path + 1, dir.name[0]);
			path[0] = '/';
			current += dir.name[0] + 1;
		} else {
			return buffersTooSmall;
		}

		if (dir.parID == fsRtParID) {
			return noErr;
		} else {
			pb.dirInfo.ioNamePtr = dir.name;
			pb.dirInfo.ioVRefNum = dir.vRefNum;
			pb.dirInfo.ioFDirIndex = -1;
			pb.dirInfo.ioDrDirID = dir.parID;
			err = PBGetCatInfoSync(&pb);
			if (err != noErr) {
				return err;
			}
			dir.parID = pb.dirInfo.ioDrParID;
		}
	}
}

#endif

static OSErr path2spec(JNIEnv *env, jstring jfilename, FSSpec *spec)
{
	const char *filename;
	OSErr err;

	filename = (*env)->GetStringUTFChars(env, jfilename, NULL);
	err = NativePathNameToFSSpec(filename, spec, 0);
	(*env)->ReleaseStringUTFChars(env, jfilename, filename);

	return err;
}

#ifndef __MACOSX__

#define kFullNativePath 0

static jstring spec2path(JNIEnv *env, const FSSpec *spec)
{
	Str255 filename;
	OSErr err;

	err = FSSpecToNativePathName(
			spec, filename, sizeof filename, kFullNativePath);

	if (err == noErr) {
		return (*env)->NewStringUTF(env, filename);
	} else {
		return NULL;
	}
}

#endif

#else

static OSErr path2spec(JNIEnv *env, jstring jfilename, FSSpec *spec)
{
	jsize jlength, length;
	const jchar *jchars;
	char *chars;
	OSErr err = memFullErr;

	jlength = (*env)->GetStringLength(env, jfilename);
	jchars = (*env)->GetStringChars(env, jfilename, NULL);

	length = WideCharToMultiByte(
			CP_ACP, 0, jchars, jlength, NULL, 0, NULL, NULL);
	if (length > 0) {
		chars = malloc(length + 1);
		if (chars != NULL) {
			length = WideCharToMultiByte(
					CP_ACP, 0, jchars, jlength, chars, length, NULL, NULL);
			chars[length] = '\0';
			err = NativePathNameToFSSpec(chars, spec, 0);
			free(chars);
		}
	}

	(*env)->ReleaseStringChars(env, jfilename, jchars);

	return err;
}

static jstring spec2path(JNIEnv *env, const FSSpec *spec)
{
	char filename[_MAX_PATH];
	jsize wlength;
	jchar *wchars;
	jstring jfilename = NULL;
	OSErr err;

	err = FSSpecToNativePathName(
			spec, filename, sizeof filename, kFullNativePath);
	if (err != noErr) {
		return NULL;
	}

	wlength = MultiByteToWideChar(
			CP_ACP, MB_PRECOMPOSED, filename, -1, NULL, 0);
	if (wlength >= 0) {
		wchars = malloc(sizeof(jchar) * wlength);
		if (wchars != NULL) {
			wlength = MultiByteToWideChar(
					CP_ACP, MB_PRECOMPOSED, filename, -1, wchars, wlength);
			jfilename = (*env)->NewString(env, wchars, wlength);
			free(wchars);
		}
	}

	return jfilename;
}

#endif


/*
 * Java specific functions
 */

static jint component2window(JNIEnv *env, jobject component)
{
#if defined(__MACOS__) && ! defined(__MACOSX_JAVA_141__)
	jclass cls;
	jmethodID mid;
	jobject tk;
	jint window;

	// java: Toolkit tk = Toolkit.getDefaultToolkit();
	cls = (*env)->FindClass(env, "java/awt/Toolkit");
	if (cls == 0) { return 0; }
	mid = (*env)->GetStaticMethodID(env, cls,
		"getDefaultToolkit", "()Ljava/awt/Toolkit;");
	if (mid == 0) { return 0; }
	tk = (*env)->CallStaticObjectMethod(env, cls, mid);
	if (tk == 0) { return 0; }

	// java: window = tk.getNativeWindowHandleFromComponent(component);
	cls = (*env)->GetObjectClass(env, tk);
	if (cls == 0) { return 0; }
	mid = (*env)->GetMethodID(env, cls,
		"getNativeWindowHandleFromComponent", "(Ljava/awt/Component;)I");
	if (mid == 0) { return 0; }
	window = (*env)->CallIntMethod(env, tk, mid, component);

	return window;
#else
#ifndef __MACOS__
	static HINSTANCE jawt_handle;
	static jboolean (JNICALL *jawt_getawt)(JNIEnv *env, JAWT *awt);
	static jboolean jawt_failed;
#endif

	JAWT awt;
	JAWT_DrawingSurface *ds;
	JAWT_DrawingSurfaceInfo *dsi;
#ifndef __MACOS__
	JAWT_Win32DrawingSurfaceInfo *dsi_win;
#endif
	jint lock;
#ifdef __MACOS__
	PortAssociation *window;
#else
	HWND window;
#endif

#ifndef __MACOS__
	if (jawt_handle == NULL) {
		if (jawt_failed) {
			return 0;
		}

		jawt_handle = LoadLibrary("jawt.dll");
		if (jawt_handle == NULL) {
			jawt_failed = JNI_TRUE;
			return 0;
		}

		jawt_getawt = (void *) GetProcAddress(jawt_handle, "_JAWT_GetAWT@8");
		if (jawt_getawt == NULL) {
			FreeLibrary(jawt_handle);
			jawt_handle = NULL;
			jawt_failed = JNI_TRUE;
			return 0;
		}
	}
#endif

	awt.version = JAWT_VERSION_1_3;
#ifdef __MACOSX_JAVA_141__
	if (JAWT_GetAWT(env, &awt) == JNI_FALSE) {
#else
	if ((*jawt_getawt)(env, &awt) == JNI_FALSE) {
#endif
		return 0;
	}

	ds = awt.GetDrawingSurface(env, component);
	if (ds == NULL) {
		return 0;
	}

	lock = ds->Lock(ds);
	if ((lock & JAWT_LOCK_ERROR) != 0) {
		awt.FreeDrawingSurface(ds);
		return 0;
	}

	dsi = ds->GetDrawingSurfaceInfo(ds);
	if (dsi == NULL) {
		ds->Unlock(ds);
		awt.FreeDrawingSurface(ds);
		return 0;
	}

#ifdef __MACOSX_JAVA_141__
	window = JunMacOSX_CreatePortAssociation1(
			env, component, dsi->platformInfo);
#else
	dsi_win = (JAWT_Win32DrawingSurfaceInfo *) dsi->platformInfo;
	window = dsi_win->hwnd;
#endif

	ds->Unlock(ds);
	awt.FreeDrawingSurface(ds);

	return (jint) window;
#endif
}

#if ! defined(__MACOS__) || ! defined(__MACOSX_JAVA_141__)

static jint peer2window(JNIEnv *env, jobject component)
{
	jclass cls;
	jmethodID mid, lock, unlock;
	jobject peer, dsi, pds;
	jint window;

	// java: ComponentPeer peer = component.getPeer();
	cls = (*env)->GetObjectClass(env, component);
	if (cls == 0) { return 0; }
	mid = (*env)->GetMethodID(env, cls,
		"getPeer", "()Ljava/awt/peer/ComponentPeer;");
	if (mid == 0) { return 0; }
	peer = (*env)->CallObjectMethod(env, component, mid);
	if (peer == 0) { return 0; }

	// java: DrawingSurfaceInfo dsi = peer.getDrawingSurfaceInfo();
	cls = (*env)->GetObjectClass(env, peer);
	if (cls == 0) { return 0; }
	mid = (*env)->GetMethodID(env, cls,
		"getDrawingSurfaceInfo", "()Lsun/awt/DrawingSurfaceInfo;");
	if (mid == 0) { return 0; }
	dsi = (*env)->CallObjectMethod(env, peer, mid);
	if (dsi == 0) { return 0; }

	// java: dsi.lock();
	// java: PhysicalDrawingSurface pds = dsi.getSurface();
	// java: dsi.unlock();
	cls = (*env)->GetObjectClass(env, dsi);
	if (cls == 0) { return 0; }
	lock = (*env)->GetMethodID(env, cls, "lock", "()I");
	if (lock == 0) { return 0; }
	unlock = (*env)->GetMethodID(env, cls, "unlock", "()V");
	if (unlock == 0) { return 0; }
	mid = (*env)->GetMethodID(env, cls,
		"getSurface", "()Lsun/awt/PhysicalDrawingSurface;");
	if (mid == 0) { return 0; }
	(*env)->CallIntMethod(env, dsi, lock);
	pds = (*env)->CallObjectMethod(env, dsi, mid);
	(*env)->CallVoidMethod(env, dsi, unlock);
	if (pds == 0) { return 0; }

	// java: dsi.lock();
	// java: window = pds.getPort() or pds.getHWnd();
	// java: dsi.unlock();
	cls = (*env)->GetObjectClass(env, pds);
	if (cls == 0) { return 0; }
#ifdef __MACOS__
	mid = (*env)->GetMethodID(env, cls, "getPort", "()I");
#else
	mid = (*env)->GetMethodID(env, cls, "getHWnd", "()I");
#endif
	if (mid == 0) { return 0; }
	(*env)->CallIntMethod(env, dsi, lock);
	window = (*env)->CallIntMethod(env, pds, mid);
	(*env)->CallVoidMethod(env, dsi, unlock);

	return window;
}

#endif

static jint get_window(JNIEnv *env, jobject component)
{
	jint window;

	// first, call component2window().
	window = component2window(env, component);

	// clear exception, if any.
	(*env)->ExceptionClear(env);

#if ! defined(__MACOS__) || ! defined(__MACOSX_JAVA_141__)
	// if it fails, call peer2window().
	if (window == 0) {
		window = peer2window(env, component);
	}
#endif

	// clear exception, if any.
	(*env)->ExceptionClear(env);

	return window;
}

static jintArray new_array
  (JNIEnv *env, jsize size, jint a, jint b, jint c, jint d)
{
	jint buf[4];
	jintArray array;

	buf[0] = a;
	buf[1] = b;
	buf[2] = c;
	buf[3] = d;

	array = (*env)->NewIntArray(env, size);
	if (array != NULL) {
		(*env)->SetIntArrayRegion(env, array, 0, size, buf);
	}

	return array;
}


/* --- Jun315WinQT --- */

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    GetVersion
 * Signature: ()Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_GetVersion
  (JNIEnv *env, jclass cls)
{
	return (*env)->NewStringUTF(env, JUNQT_JNI_VERSION);
}


/*
 * functions from QTML.h
 */

/* initialization */

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtInitializeQTML
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtInitializeQTML
  (JNIEnv *env, jobject obj, jint flag)
{
#ifdef __MACOS__
	return noErr;
#else
	OSErr err = noErr;

	if (initializeCount == 0) {
		err = InitializeQTML(flag);
	}

	++initializeCount;

	return err;
#endif
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtTerminateQTML
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtTerminateQTML
  (JNIEnv *env, jobject obj)
{
#ifndef __MACOS__
	--initializeCount;

	if (initializeCount == 0) {
		TerminateQTML();
	}
#endif
}

/* port association */

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtCreatePortAssociation1
 * Signature: (Ljava/awt/Component;II)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtCreatePortAssociation1
  (JNIEnv *env, jobject obj, jobject component, jint storage, jint flags)
{
#ifdef __MACOS__
	return get_window(env, component);
#else
	HWND hwnd = (HWND) get_window(env, component);

	if (hwnd == 0) {
		return 0;
	}

	return (jint) CreatePortAssociation(hwnd, (Ptr) storage, flags);
#endif
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtCreatePortAssociation2
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtCreatePortAssociation2
  (JNIEnv *env, jobject obj, jint view)
{
#ifdef __MACOSX_JAVA_141__
	return (jint) JunMacOSX_CreatePortAssociation2((void *) view);
#else
	return view;
#endif
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtDestroyPortAssociation
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtDestroyPortAssociation
  (JNIEnv *env, jobject obj, jint view)
{
#ifdef __MACOSX_JAVA_141__
	JunMacOSX_DestroyPortAssociation((PortAssociation *) view);
#endif
#ifndef __MACOS__
	DestroyPortAssociation((CGrafPtr) view);
#endif
}


/*
 * functions from Movies.h
 */

/* initialization routines */

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtEnterMovies
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtEnterMovies
  (JNIEnv *env, jobject obj)
{
	return EnterMovies();
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtExitMovies
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtExitMovies
  (JNIEnv *env, jobject obj)
{
	ExitMovies();
}

/* idle routines */

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtMoviesTask
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtMoviesTask
  (JNIEnv *env, jobject obj, jint movie, jint maxMilliSecToUse)
{
#ifdef __MACOSX_JAVA_141__
	if (! JunMacOSX_IsMoviePortInitialized((Movie) movie)) {
		return;
	}
#endif

	MoviesTask((Movie) movie, maxMilliSecToUse);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtPrerollMovie
 * Signature: (III)V
 */
JNIEXPORT void JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtPrerollMovie
  (JNIEnv *env, jobject obj, jint movie, jint time, jint rate)
{
#ifdef __MACOSX_JAVA_141__
	if (! JunMacOSX_IsMoviePortInitialized((Movie) movie)) {
		return;
	}
#endif

	PrerollMovie((Movie) movie, time, rate);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtSetMovieActive
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtSetMovieActive
  (JNIEnv *env, jobject obj, jint movie, jboolean active)
{
	SetMovieActive((Movie) movie, active);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtGetMovieActive
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtGetMovieActive
  (JNIEnv *env, jobject obj, jint movie)
{
	return GetMovieActive((Movie) movie);
}

/* calls for playing movies, previews, posters */

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtStartMovie
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtStartMovie
  (JNIEnv *env, jobject obj, jint movie)
{
#ifdef __MACOSX_JAVA_141__
	if (! JunMacOSX_IsMoviePortInitialized((Movie) movie)) {
		return;
	}
#endif

	StartMovie((Movie) movie);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtStopMovie
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtStopMovie
  (JNIEnv *env, jobject obj, jint movie)
{
	StopMovie((Movie) movie);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtGoToBeginningOfMovie
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtGoToBeginningOfMovie
  (JNIEnv *env, jobject obj, jint movie)
{
	GoToBeginningOfMovie((Movie) movie);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtGoToEndOfMovie
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtGoToEndOfMovie
  (JNIEnv *env, jobject obj, jint movie)
{
	GoToEndOfMovie((Movie) movie);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtIsMovieDone
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtIsMovieDone
  (JNIEnv *env, jobject obj, jint movie)
{
	return IsMovieDone((Movie) movie);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtShowMoviePoster
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtShowMoviePoster
  (JNIEnv *env, jobject obj, jint movie)
{
	ShowMoviePoster((Movie) movie);
}

/* calls for controlling movies & tracks which are playing */

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtGetMovieGWorld
 * Signature: (I)[I
 */
JNIEXPORT jintArray JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtGetMovieGWorld
  (JNIEnv *env, jobject obj, jint movie)
{
#ifdef __MACOSX_JAVA_141__
	PortAssociation *port;
#else
	CGrafPtr port;
#endif
	GDHandle gdh;

#ifdef __MACOSX_JAVA_141__
	JunMacOSX_GetMoviePort((Movie) movie, &port, &gdh);
#else
	GetMovieGWorld((Movie) movie, &port, &gdh);
#endif

	return new_array(env, 2, (jint) port, (jint) gdh, 0, 0);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtSetMovieGWorld
 * Signature: (III)V
 */
JNIEXPORT void JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtSetMovieGWorld
  (JNIEnv *env, jobject obj, jint movie, jint port, jint gdh)
{
#ifdef __MACOSX_JAVA_141__
	JunMacOSX_SetMoviePort(
			(Movie) movie, (PortAssociation *) port, (GDHandle) gdh);
#else
	SetMovieGWorld((Movie) movie, (CGrafPtr) port, (GDHandle) gdh);
#endif
}

/* called between Begin & EndUpdate */

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtUpdateMovie
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtUpdateMovie
  (JNIEnv *env, jobject obj, jint movie)
{
#ifdef __MACOSX_JAVA_141__
	if (! JunMacOSX_IsMoviePortInitialized((Movie) movie)) {
		return noErr;
	}
#endif

	return UpdateMovie((Movie) movie);
}

/* spatial movie routines */

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtGetMovieBox
 * Signature: (I)[I
 */
JNIEXPORT jintArray JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtGetMovieBox
  (JNIEnv *env, jobject obj, jint movie)
{
	Rect box;

	GetMovieBox((Movie) movie, &box);

	return new_array(env, 4,
			box.left, box.top, box.right - box.left, box.bottom - box.top);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtSetMovieBox
 * Signature: (I[I)V
 */
JNIEXPORT void JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtSetMovieBox
  (JNIEnv *env, jobject obj, jint movie, jint x, jint y, jint width, jint height)
{
	Rect box;

	MacSetRect(&box,
			(short) x, (short) y, (short) (x + width), (short) (y + height));

#ifdef __MACOSX_JAVA_141__
	JunMacOSX_SetMovieBox((Movie) movie, &box);
#else
	SetMovieBox((Movie) movie, &box);
#endif
}

/* calls for getting/saving movies */

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtDisposeMovie
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtDisposeMovie
  (JNIEnv *env, jobject obj, jint movie)
{
#ifdef __MACOSX_JAVA_141__
	JunMacOSX_SetMoviePort((Movie) movie, nil, nil);
#endif

	DisposeMovie((Movie) movie);
}

/* movie state routines */

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtGetMovieTimeScale
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtGetMovieTimeScale
  (JNIEnv *env, jobject obj, jint movie)
{
	return GetMovieTimeScale((Movie) movie);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtGetMovieDuration
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtGetMovieDuration
  (JNIEnv *env, jobject obj, jint movie)
{
	return GetMovieDuration((Movie) movie);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtGetMovieRate
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtGetMovieRate
  (JNIEnv *env, jobject obj, jint movie)
{
	return GetMovieRate((Movie) movie);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtSetMovieRate
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtSetMovieRate
  (JNIEnv *env, jobject obj, jint movie, jint rate)
{
#ifdef __MACOSX_JAVA_141__
	if (! JunMacOSX_IsMoviePortInitialized((Movie) movie)) {
		return;
	}
#endif

	SetMovieRate((Movie) movie, rate);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtGetMoviePreferredRate
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtGetMoviePreferredRate
  (JNIEnv *env, jobject obj, jint movie)
{
	return GetMoviePreferredRate((Movie) movie);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtGetMoviePreferredVolume
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtGetMoviePreferredVolume
  (JNIEnv *env, jobject obj, jint movie)
{
	return GetMoviePreferredVolume((Movie) movie);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtGetMovieVolume
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtGetMovieVolume
  (JNIEnv *env, jobject obj, jint movie)
{
	return GetMovieVolume((Movie) movie);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtSetMovieVolume
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtSetMovieVolume
  (JNIEnv *env, jobject obj, jint movie, jint volume)
{
	SetMovieVolume((Movie) movie, (short) volume);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtGetMovieTimeValue
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtGetMovieTimeValue
  (JNIEnv *env, jobject obj, jint movie)
{
	return GetMovieTime((Movie) movie, nil);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtSetMovieTimeValue
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtSetMovieTimeValue
  (JNIEnv *env, jobject obj, jint movie, jint time)
{
	SetMovieTimeValue((Movie) movie, time);
}

/* ... */

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtOpenMovie
 * Signature: (Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtOpenMovie
  (JNIEnv *env, jobject obj, jstring jfilename)
{
	FSSpec spec;
	Movie movie = nil;
	short movieResFile;
	short movieResId = 0;
	Boolean wasChanged;
	OSErr err;

	err = path2spec(env, jfilename, &spec);
	if (err != noErr) { return nil; }

	err = OpenMovieFile(&spec, &movieResFile, fsRdPerm);
	if (err != noErr) { return nil; }

	err = NewMovieFromFile(&movie, movieResFile, &movieResId, nil, 0, &wasChanged);
	CloseMovieFile(movieResFile);

	return (jint) movie;
}


/*
 * functions from ImageCompression.h
 */

/* file selection dialogs */

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtStandardGetFilePreview
 * Signature: ([I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtStandardGetFilePreview
  (JNIEnv *env, jobject obj, jintArray typeList)
{
#ifdef __MACOSX__
	return NULL;
#else

#ifndef __MACOS__
	char *p, cwd[_MAX_DIR];
#endif
	jsize numTypes;
	jint *types;
	StandardFileReply reply;
	jstring jfilename;

#ifndef __MACOS__
	p = _getcwd(cwd, _MAX_DIR);
#endif

	numTypes = (*env)->GetArrayLength(env, typeList);
	types = (*env)->GetIntArrayElements(env, typeList, 0);
	StandardGetFilePreview(nil, (short) numTypes, types, &reply);
	(*env)->ReleaseIntArrayElements(env, typeList, types, JNI_ABORT);

	if (reply.sfGood) {
		jfilename = spec2path(env, &reply.sfFile);
	} else {
		jfilename = NULL;
	}

#ifndef __MACOS__
	if (p != NULL) {
		_chdir(cwd);
	}
#endif

	return jfilename;

#endif
}


/* --- Jun317WinQT --- */

/*
 * misc. functions
 */

/* drawing a frame into dc */

static jint *get_pixels(PixMapHandle pixmap, int width, int height)
{
	int row_bytes, x, y;
	unsigned char *base_addr, *row, red, green, blue;
	jint *pixels, *p;

	pixels = (jint *) malloc(sizeof(jint) * width * height);
	if (pixels == NULL) {
		return NULL;
	}

	base_addr = GetPixBaseAddr(pixmap);
	row_bytes = (**pixmap).rowBytes & 0x3fff;
	for (p = pixels, y = 0; y < height; ++y) {
		row = base_addr + y * row_bytes;
		for (x = 0; x < width; ++x) {
#ifdef __MACOS__
			++row;
			red   = *row++;
			green = *row++;
			blue  = *row++;
#else
			blue  = *row++;
			green = *row++;
			red   = *row++;
			++row;
#endif
			*p++ = RGB_PIXEL(red, green, blue);
		}
	}

	return pixels;
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtDrawMovieFrame
 * Signature: (IIII)[I
 */
JNIEXPORT jintArray JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtDrawMovieFrame
  (JNIEnv *env, jobject obj, jint movie, jint time, jint width, jint height)
{
	PicHandle picture;
	Rect rect;
	GWorldPtr gworld;
	PixMapHandle pixmap;
	CGrafPtr savedPort;
	GDHandle savedDevice;
	QDErr err;
	jint *pixels;
	jintArray array = NULL;

	picture = GetMoviePict((Movie) movie, time);
	if (picture == nil) {
		return NULL;
	}

	MacSetRect(&rect, 0, 0, (short) width, (short) height);
	err = QTNewGWorld(&gworld, PIXEL_FORMAT, &rect, nil, nil, nil);
	if (err != noErr) {
		KillPicture(picture);
		return NULL;
	}

	pixmap = GetGWorldPixMap(gworld);
	if (! LockPixels(pixmap)) {
		DisposeGWorld(gworld);
		KillPicture(picture);
		return NULL;
	}

	GetGWorld(&savedPort, &savedDevice);
	SetGWorld(gworld, nil);
	DrawPicture(picture, &rect);
	SetGWorld(savedPort, savedDevice);

	KillPicture(picture);

	pixels = get_pixels(pixmap, width, height);

	UnlockPixels(pixmap);
	DisposeGWorld(gworld);

	if (pixels != NULL) {
		array = (*env)->NewIntArray(env, width * height);
		if (array != NULL) {
			(*env)->SetIntArrayRegion(env, array, 0, width * height, pixels);
		}
		free(pixels);
	}

	return array;
}


/* --- Jun357WinQT --- */

/*
 * movie generation functions...
 */

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtCreateMovieFile
 * Signature: (Ljava/lang/String;III)[I
 */
JNIEXPORT jintArray JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtCreateMovieFile
  (JNIEnv *env, jobject obj, jstring jfilename, jint creator, jint script, jint flags)
{
	FSSpec spec;
	short resRefNum = 0;
	Movie movie = nil;
	OSErr err;

	err = path2spec(env, jfilename, &spec);
	if (err != noErr && err != fnfErr) { return nil; }

	err = CreateMovieFile(
			&spec, creator, (short) script, flags, &resRefNum, &movie);

	return new_array(env, 3, err, resRefNum, (jint) movie, 0);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtAddMovieResource
 * Signature: (IIILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtAddMovieResource
  (JNIEnv *env, jobject obj, jint movie, jint resRefNum, jint jresId, jstring resName)
{
	short resId = (short) jresId;

	return AddMovieResource((Movie) movie, (short) resRefNum, &resId, nil);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtCloseMovieFile
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtCloseMovieFile
  (JNIEnv *env, jobject obj, jint resRefNum)
{
	return CloseMovieFile((short) resRefNum);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtNewMovieTrack
 * Signature: (IIII)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtNewMovieTrack
  (JNIEnv *env, jobject obj, jint movie, jint width, jint height, jint trackVolume)
{
	return (jint) NewMovieTrack((Movie) movie, width, height, (short) trackVolume);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtInsertMediaIntoTrack
 * Signature: (IIIII)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtInsertMediaIntoTrack
  (JNIEnv *env, jobject obj, jint track, jint trackStart, jint mediaTime, jint mediaDuration, jint mediaRate)
{
	return InsertMediaIntoTrack((Track) track, trackStart, mediaTime, mediaDuration, mediaRate);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtNewTrackMedia
 * Signature: (IIIII)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtNewTrackMedia
  (JNIEnv *env, jobject obj, jint track, jint mediaType, jint timeScale, jint dataRef, jint dataRefType)
{
	return (jint) NewTrackMedia((Track) track, mediaType, timeScale, (Handle) dataRef, dataRefType);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtBeginMediaEdits
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtBeginMediaEdits
  (JNIEnv *env, jobject obj, jint media)
{
	return BeginMediaEdits((Media) media);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtEndMediaEdits
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtEndMediaEdits
  (JNIEnv *env, jobject obj, jint media)
{
	return EndMediaEdits((Media) media);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtGetMediaDuration
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtGetMediaDuration
  (JNIEnv *env, jobject obj, jint media)
{
	return GetMediaDuration((Media) media);
}

/*
 * adding media samples...
 */

static void put_pixels
  (PixMapHandle pixmap, int width, int height, const jint *pixels)
{
	unsigned char *base_addr;
	int row_bytes, x, y;
	UInt32 *row;
	const jint *p;

	base_addr = GetPixBaseAddr(pixmap);
	row_bytes = (**pixmap).rowBytes & 0x3fff;
	for (p = pixels, y = 0; y < height; ++y) {
		row = (jint *) (base_addr + y * row_bytes);
		for (x = 0; x < width; ++x) {
			*row++ = *p++;
		}
	}
}

static OSErr add_sample
  (Media media, GWorldPtr gworld, PixMapHandle pixmap, const Rect *r,
   CodecQ quality, CodecType codecType, TimeValue duration)
{
	long size;
	Handle h;
	ImageDescriptionHandle image_desc;
	CGrafPtr saved_port;
	GDHandle saved_gdevice;
	OSErr err;

	err = GetMaxCompressionSize(
			pixmap, r, 0, quality, codecType, anyCodec, &size);
	if (err != noErr) {
		return err;
	}

	h = NewHandle(size);
	if (h == nil) {
		return memFullErr;
	}

	image_desc = (ImageDescriptionHandle) NewHandle(4);
	if (image_desc == nil) {
		DisposeHandle(h);
		return memFullErr;
	}

	GetGWorld(&saved_port, &saved_gdevice);
	SetGWorld(gworld, nil);

	HLock(h);
	err = CompressImage(pixmap, r, quality, codecType, image_desc, *h);
	if (err == noErr) {
		err = AddMediaSample(media, h, 0, (**image_desc).dataSize,
				duration, (SampleDescriptionHandle) image_desc, 1, 0, nil);
	}
	HUnlock(h);

	SetGWorld(saved_port, saved_gdevice);

	DisposeHandle((Handle) image_desc);
	DisposeHandle(h);

	return err;
}

static OSErr add_scaled_sample
  (Media media, GWorldPtr src_gworld, PixMapHandle src_pixmap, const Rect *src,
   const Rect *dest, CodecQ quality, CodecType codecType, TimeValue duration)
{
	GWorldPtr dest_gworld;
	PixMapHandle dest_pixmap;
	ImageDescriptionHandle image_desc;
	CGrafPtr saved_port;
	GDHandle saved_gdevice;
	QDErr err;

	err = QTNewGWorld(&dest_gworld, PIXEL_FORMAT, dest, nil, nil, nil);
	if (err != noErr) {
		return err;
	}

	dest_pixmap = GetGWorldPixMap(dest_gworld);
	if (! LockPixels(dest_pixmap)) {
		DisposeGWorld(dest_gworld);
		return memFullErr;
	}

	GetGWorld(&saved_port, &saved_gdevice);
	SetGWorld(dest_gworld, nil);

	err = MakeImageDescriptionForPixMap(src_pixmap, &image_desc);
	if (err == noErr) {
		err = DecompressImage(GetPixBaseAddr(src_pixmap),
				image_desc, dest_pixmap, src, dest, ditherCopy, nil);
		DisposeHandle((Handle) image_desc);
	}

	SetGWorld(saved_port, saved_gdevice);

	if (err == noErr) {
		err = add_sample((Media) media,
				dest_gworld, dest_pixmap, dest, quality, codecType, duration);
	}

	UnlockPixels(dest_pixmap);
	DisposeGWorld(dest_gworld);

	return err;
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtAddMediaSampleImage
 * Signature: (I[IIIIIIII)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtAddMediaSampleImage
  (JNIEnv *env, jobject obj, jint media, jintArray jpixels, jint width, jint height, jint destWidth, jint destHeight, jint quality, jint codecType, jint duration)
{
	Rect rect, dest;
	GWorldPtr gworld;
	PixMapHandle pixmap;
	QDErr err;
	jint *pixels;

	MacSetRect(&rect, 0, 0, (short) width, (short) height);
	err = QTNewGWorld(&gworld, PIXEL_FORMAT, &rect, nil, nil, nil);
	if (err != noErr) {
		return err;
	}

	pixmap = GetGWorldPixMap(gworld);
	if (! LockPixels(pixmap)) {
		DisposeGWorld(gworld);
		return memFullErr;
	}

	pixels = (*env)->GetIntArrayElements(env, jpixels, 0);
	put_pixels(pixmap, width, height, pixels);
	(*env)->ReleaseIntArrayElements(env, jpixels, pixels, 0);

	if (destWidth == width && destHeight == height) {
		err = add_sample((Media) media,
				gworld, pixmap, &rect, quality, codecType, duration);
	} else {
		MacSetRect(&dest, 0, 0, (short) destWidth, (short) destHeight);
		err = add_scaled_sample((Media) media,
				gworld, pixmap, &rect, &dest, quality, codecType, duration);
	}

	UnlockPixels(pixmap);
	DisposeGWorld(gworld);

	return err;
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtGetMoviesError
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtGetMoviesError
  (JNIEnv *env, jobject obj)
{
	return GetMoviesError();
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtFixRatio
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtFixRatio
  (JNIEnv *env, jobject obj, jint numer, jint denom)
{
	return FixRatio((short) numer, (short) denom);
}


/* --- Jun366WinQT --- */

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtGetMovieSelection
 * Signature: (I)[I
 */
JNIEXPORT jintArray JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtGetMovieSelection
  (JNIEnv *env, jobject obj, jint movie)
{
	TimeValue time, duration;

	GetMovieSelection((Movie) movie, &time, &duration);

	return new_array(env, 2, time, duration, 0, 0);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtSetMovieSelection
 * Signature: (III)V
 */
JNIEXPORT void JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtSetMovieSelection
  (JNIEnv *env, jobject obj, jint movie, jint time, jint duration)
{
	SetMovieSelection((Movie) movie, time, duration);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtCopyMovieSelection
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtCopyMovieSelection
  (JNIEnv *env, jobject obj, jint movie)
{
	return (jint) CopyMovieSelection((Movie) movie);
}


/* --- Jun368WinQT --- */

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtNewMovie
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtNewMovie
  (JNIEnv *env, jobject obj, jint flags)
{
	return (jint) NewMovie(flags);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtInsertMovieSegment
 * Signature: (IIIII)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtInsertMovieSegment
  (JNIEnv *env, jobject obj, jint srcMovie, jint dstMovie, jint srcIn, jint srcDuration, jint dstIn)
{
	return InsertMovieSegment(
			(Movie) srcMovie, (Movie) dstMovie, srcIn, srcDuration, dstIn);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtFlattenMovieData
 * Signature: (IILjava/lang/String;III)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtFlattenMovieData
  (JNIEnv *env, jobject obj, jint movie, jint movieFlattenFlags, jstring jfilename, jint creator, jint scriptTag, jint createMovieFileFlags)
{
	FSSpec spec;
	OSErr err;

	err = path2spec(env, jfilename, &spec);
	if (err != noErr) { return nil; }

	return (jint) FlattenMovieData((Movie) movie, movieFlattenFlags,
			&spec, creator, (short) scriptTag, createMovieFileFlags);
}


/* --- Jun401WinQT --- */

Ptr convert_sound(Handle handle,
		jint format, jint numChannels, jint sampleSize, jint sampleRate)
{
	SoundComponentData inputFormat, outputFormat;
	unsigned long numFrames, dataOffset, targetBytes;
	unsigned long inputFrames, inputBytes, outputBytes;
	unsigned long outputFrames, outputSize1, outputSize2;
	SoundConverter sc;
	Ptr buffer;
	OSErr err;

	err = ParseSndHeader((SndListHandle) handle,
			&inputFormat, &numFrames, &dataOffset);
	if (err != noErr) {
		return nil;
	}

	targetBytes = inputFormat.sampleCount
			* inputFormat.numChannels * (inputFormat.sampleSize / 8);
	inputFormat.sampleCount = 0;

	outputFormat.flags = 0;
	outputFormat.format = (format != 0) ? format : inputFormat.format;
	outputFormat.numChannels =
			(numChannels != 0) ? numChannels : inputFormat.numChannels;
	outputFormat.sampleSize =
			(sampleSize != 0) ? sampleSize : inputFormat.sampleSize;
	outputFormat.sampleRate =
			(sampleRate != 0) ? sampleRate : inputFormat.sampleRate;
	outputFormat.sampleCount = 0;
	outputFormat.buffer = nil;
	outputFormat.reserved = 0;

	err = SoundConverterOpen(&inputFormat, &outputFormat, &sc);
	if (err != noErr) {
		return nil;
	}

	err = SoundConverterGetBufferSizes(sc,
			targetBytes, &inputFrames, &inputBytes, &outputBytes);
	if (err != noErr) {
		SoundConverterClose(sc);
		return nil;
	}

	buffer = NewPtr(outputBytes + 32);
	if (buffer == nil) {
		SoundConverterClose(sc);
		return nil;
	}

	err = SoundConverterBeginConversion(sc);
	if (err != noErr) {
		SoundConverterClose(sc);
		DisposePtr(buffer);
		return nil;
	}

	err = SoundConverterConvertBuffer(sc, *handle + dataOffset, numFrames,
			buffer, &outputFrames, &outputSize1);
	if (err != noErr) {
		SoundConverterClose(sc);
		DisposePtr(buffer);
		return nil;
	}

	err = SoundConverterEndConversion(sc,
			buffer + outputSize1, &outputFrames, &outputSize2);
	if (err != noErr) {
		SoundConverterClose(sc);
		DisposePtr(buffer);
		return nil;
	}

	SoundConverterClose(sc);

	SetPtrSize(buffer, outputSize1 + outputSize2);

	return buffer;
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtConvertMovieToSoundData
 * Signature: (IIIIIII)[B
 */
JNIEXPORT jbyteArray JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtConvertMovieToSoundData
  (JNIEnv *env, jobject obj, jint movie, jint start, jint duration, jint format, jint numChannels, jint sampleSize, jint sampleRate)
{
	Handle handle;
	Ptr buffer;
	Size size;
	jbyteArray array;
	OSErr err;

	handle = NewHandle(1);
	if (handle == nil) {
		return NULL;
	}

	err = PutMovieIntoTypedHandle((Movie) movie, nil,
			soundListRsrc, handle, start, duration, 0, nil);
	if (err != noErr) {
		DisposeHandle(handle);
		return NULL;
	}

	HLock(handle);
	buffer = convert_sound(handle, format, numChannels, sampleSize, sampleRate);
	HUnlock(handle);
	DisposeHandle(handle);
	if (buffer == nil) {
		return NULL;
	}

	size = GetPtrSize(buffer);
	array = (*env)->NewByteArray(env, size);
	if (array != NULL) {
		(*env)->SetByteArrayRegion(env, array, 0, size, buffer);
	}

	DisposePtr(buffer);

	return array;
}


/* --- Jun404WinQT --- */

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtNewMovieFromURL
 * Signature: (Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtNewMovieFromURL
  (JNIEnv *env, jobject obj, jstring jurl)
{
	const char *url;
	Handle h;
	Movie movie;
	OSErr err;

	url = (*env)->GetStringUTFChars(env, jurl, NULL);
	h = NewHandle(strlen(url) + 1);
	if (h != nil) {
		strcpy(*h, url);
	}
	(*env)->ReleaseStringUTFChars(env, jurl, url);

	if (h != nil) {
		err = NewMovieFromDataRef(&movie, 0, nil, h, URLDataHandlerSubType);
		if (err == noErr) {
			return (jint) movie;
		}
	}

	return nil;
}


/* --- Jun422WinQT --- */

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtGetMovieNextInterestingTime
 * Signature: (II[III)[I
 */
JNIEXPORT jintArray JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtGetMovieNextInterestingTime
  (JNIEnv *env, jobject obj, jint movie, jint flags, jintArray mediaTypes, jint time, jint rate)
{
	jsize numTypes;
	jint *types;
	TimeValue itime, duration;

	numTypes = (*env)->GetArrayLength(env, mediaTypes);
	types = (*env)->GetIntArrayElements(env, mediaTypes, 0);
	GetMovieNextInterestingTime((Movie) movie, (short) flags,
			(short) numTypes, types, time, rate, &itime, &duration);
	(*env)->ReleaseIntArrayElements(env, mediaTypes, types, JNI_ABORT);

	return new_array(env, 2, itime, duration, 0, 0);
}


/* --- Jun448WinQT --- */

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtNewMovieController
 * Signature: (IIIIII)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtNewMovieController
  (JNIEnv *env, jobject obj, jint movie, jint x, jint y, jint width, jint height, jint flags)
{
	Rect box;

	MacSetRect(&box,
			(short) x, (short) y, (short) (x + width), (short) (y + height));
	return (jint) NewMovieController((Movie) movie, &box, flags);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtDisposeMovieController
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtDisposeMovieController
  (JNIEnv *env, jobject obj, jint mc)
{
	DisposeMovieController((MovieController) mc);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtMCDoAction
 * Signature: (III)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtMCDoAction
  (JNIEnv *env, jobject obj, jint mc, jint action, jint params)
{
#ifdef __MACOSX_JAVA_141__
	Movie movie = MCGetMovie((MovieController) mc);

	if (movie == nil || ! JunMacOSX_IsMoviePortInitialized(movie)) {
		return noErr;
	}
#endif

	return MCDoAction((MovieController) mc, (short) action, (void *) params);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtMCIdle
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtMCIdle
  (JNIEnv *env, jobject obj, jint mc)
{
#ifdef __MACOSX_JAVA_141__
	Movie movie = MCGetMovie((MovieController) mc);

	if (movie == nil || ! JunMacOSX_IsMoviePortInitialized(movie)) {
		return noErr;
	}
#endif

	return MCIdle((MovieController) mc);
}

/*
 * Class:     jp_co_sra_qt4jun_JunQTInterface
 * Method:    qtMCMovieChanged
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_jp_co_sra_qt4jun_JunQTInterface_qtMCMovieChanged
  (JNIEnv *env, jobject obj, jint mc, jint movie)
{
#ifdef __MACOSX_JAVA_141__
	if (! JunMacOSX_IsMoviePortInitialized((Movie) movie)) {
		return noErr;
	}
#endif

	return MCMovieChanged((MovieController) mc, (Movie) movie);
}
