package jp.co.sra.gl4jun;

/**
 * GLjInterface class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1999/08/19 (by MATSUDA Ryouichi)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: GLjInterface.java,v 8.11 2008/02/20 06:30:52 nisinaka Exp $
 */
public class GLjInterface {
	public static final String libraryName = "JunGL";
	public static final String requiredVersion = "2.0";
	public static final int requiredBuildNo = 33;

	private static GLjInterface Current = new GLjInterface();

	static {
		try {
			System.loadLibrary(libraryName);

			String findVersion = getVersion();
			String buildPrefix = requiredVersion + " build ";
			int buildNo;

			try {
				buildNo = Integer.parseInt(findVersion.substring(buildPrefix.length()));
			} catch (NumberFormatException e) {
				buildNo = 0;
			}

			if (findVersion.startsWith(buildPrefix) && (buildNo >= requiredBuildNo)) {
				System.out.println("JNI library '" + libraryName + "' version " + findVersion);
			} else {
				System.out.println("JNI library '" + libraryName + "' version error.");
				System.out.println("Found library is version " + findVersion);
				System.out.println("Required library is version " + requiredVersion + ", build " + requiredBuildNo + " or later");
				System.exit(0);
			}
		} catch (UnsatisfiedLinkError e) {
			System.out.println("Can't find JNI library '" + libraryName + "'.");
			System.exit(0);
		}
	}

	public static final int GLU_AUTO_LOAD_MATRIX = 100200;
	public static final int GLU_BEGIN = 100100; //GLU_TESS_BEGIN
	public static final int GLU_CCW = 100121;
	public static final int GLU_CULLING = 100201;
	public static final int GLU_CW = 100120;
	public static final int GLU_DISPLAY_MODE = 100204;
	public static final int GLU_DOMAIN_DISTANCE = 100217;
	public static final int GLU_EDGE_FLAG = 100104; //GLU_TESS_EDGE_FLAG
	public static final int GLU_END = 100102; //GLU_TESS_END
	public static final int GLU_ERROR = 100103; //LU_TESS_ERROR
	public static final int GLU_EXTENSIONS = 100801;
	public static final int GLU_EXTERIOR = 100123;
	public static final int GLU_FALSE = 0; //GL_FALSE
	public static final int GLU_FILL = 100012;
	public static final int GLU_FLAT = 100001;
	public static final int GLU_INCOMPATIBLE_GL_VERSION = 100903;
	public static final int GLU_INSIDE = 100021;
	public static final int GLU_INTERIOR = 100122;
	public static final int GLU_INVALID_ENUM = 100900;
	public static final int GLU_INVALID_VALUE = 100901;
	public static final int GLU_LINE = 100011;
	public static final int GLU_MAP1_TRIM_2 = 100210;
	public static final int GLU_MAP1_TRIM_3 = 100211;
	public static final int GLU_NONE = 100002;
	public static final int GLU_NURBS_ERROR1 = 100251;
	public static final int GLU_NURBS_ERROR10 = 100260;
	public static final int GLU_NURBS_ERROR11 = 100261;
	public static final int GLU_NURBS_ERROR12 = 100262;
	public static final int GLU_NURBS_ERROR13 = 100263;
	public static final int GLU_NURBS_ERROR14 = 100264;
	public static final int GLU_NURBS_ERROR15 = 100265;
	public static final int GLU_NURBS_ERROR16 = 100266;
	public static final int GLU_NURBS_ERROR17 = 100267;
	public static final int GLU_NURBS_ERROR18 = 100268;
	public static final int GLU_NURBS_ERROR19 = 100269;
	public static final int GLU_NURBS_ERROR2 = 100252;
	public static final int GLU_NURBS_ERROR20 = 100270;
	public static final int GLU_NURBS_ERROR21 = 100271;
	public static final int GLU_NURBS_ERROR22 = 100272;
	public static final int GLU_NURBS_ERROR23 = 100273;
	public static final int GLU_NURBS_ERROR24 = 100274;
	public static final int GLU_NURBS_ERROR25 = 100275;
	public static final int GLU_NURBS_ERROR26 = 100276;
	public static final int GLU_NURBS_ERROR27 = 100277;
	public static final int GLU_NURBS_ERROR28 = 100278;
	public static final int GLU_NURBS_ERROR29 = 100279;
	public static final int GLU_NURBS_ERROR3 = 100253;
	public static final int GLU_NURBS_ERROR30 = 100280;
	public static final int GLU_NURBS_ERROR31 = 100281;
	public static final int GLU_NURBS_ERROR32 = 100282;
	public static final int GLU_NURBS_ERROR33 = 100283;
	public static final int GLU_NURBS_ERROR34 = 100284;
	public static final int GLU_NURBS_ERROR35 = 100285;
	public static final int GLU_NURBS_ERROR36 = 100286;
	public static final int GLU_NURBS_ERROR37 = 100287;
	public static final int GLU_NURBS_ERROR4 = 100254;
	public static final int GLU_NURBS_ERROR5 = 100255;
	public static final int GLU_NURBS_ERROR6 = 100256;
	public static final int GLU_NURBS_ERROR7 = 100257;
	public static final int GLU_NURBS_ERROR8 = 100258;
	public static final int GLU_NURBS_ERROR9 = 100259;
	public static final int GLU_OUTLINE_PATCH = 100241;
	public static final int GLU_OUTLINE_POLYGON = 100240;
	public static final int GLU_OUTSIDE = 100020;
	public static final int GLU_OUT_OF_MEMORY = 100902;
	public static final int GLU_PARAMETRIC_ERROR = 100216;
	public static final int GLU_PARAMETRIC_TOLERANCE = 100202;
	public static final int GLU_PATH_LENGTH = 100215;
	public static final int GLU_POINT = 100010;
	public static final int GLU_SAMPLING_METHOD = 100205;
	public static final int GLU_SAMPLING_TOLERANCE = 100203;
	public static final int GLU_SILHOUETTE = 100013;
	public static final int GLU_SMOOTH = 100000;
	public static final int GLU_TESS_BEGIN = 100100;
	public static final int GLU_TESS_BEGIN_DATA = 100106;
	public static final int GLU_TESS_BOUNDARY_ONLY = 100141;
	public static final int GLU_TESS_COMBINE = 100105;
	public static final int GLU_TESS_COMBINE_DATA = 100111;
	public static final int GLU_TESS_COORD_TOO_LARGE = 100155; //GLU_TESS_ERROR5
	public static final int GLU_TESS_EDGE_FLAG = 100104;
	public static final int GLU_TESS_EDGE_FLAG_DATA = 100110;
	public static final int GLU_TESS_END = 100102;
	public static final int GLU_TESS_END_DATA = 100108;
	public static final int GLU_TESS_ERROR = 100103;
	public static final int GLU_TESS_ERROR1 = 100151;
	public static final int GLU_TESS_ERROR2 = 100152;
	public static final int GLU_TESS_ERROR3 = 100153;
	public static final int GLU_TESS_ERROR4 = 100154;
	public static final int GLU_TESS_ERROR5 = 100155;
	public static final int GLU_TESS_ERROR6 = 100156;
	public static final int GLU_TESS_ERROR7 = 100157;
	public static final int GLU_TESS_ERROR8 = 100158;
	public static final int GLU_TESS_ERROR_DATA = 100109;
	//public static final int GLU_TESS_MAX_COORD = 1.0d 150;
	public static final int GLU_TESS_MISSING_BEGIN_CONTOUR = GLU_TESS_ERROR2;
	public static final int GLU_TESS_MISSING_BEGIN_POLYGON = GLU_TESS_ERROR1;
	public static final int GLU_TESS_MISSING_END_CONTOUR = GLU_TESS_ERROR4;
	public static final int GLU_TESS_MISSING_END_POLYGON = GLU_TESS_ERROR3;
	public static final int GLU_TESS_NEED_COMBINE_CALLBACK = GLU_TESS_ERROR6;
	public static final int GLU_TESS_TOLERANCE = 100142;
	public static final int GLU_TESS_VERTEX = 100101;
	public static final int GLU_TESS_VERTEX_DATA = 100107;
	public static final int GLU_TESS_WINDING_ABS_GEQ_TWO = 100134;
	public static final int GLU_TESS_WINDING_NEGATIVE = 100133;
	public static final int GLU_TESS_WINDING_NONZERO = 100131;
	public static final int GLU_TESS_WINDING_ODD = 100130;
	public static final int GLU_TESS_WINDING_POSITIVE = 100132;
	public static final int GLU_TESS_WINDING_RULE = 100140;
	public static final int GLU_TRUE = 1; //GL_TRUE
	public static final int GLU_UNKNOWN = 100124;
	public static final int GLU_U_STEP = 100206;
	public static final int GLU_VERSION = 100800;
	public static final int GLU_VERSION_1_1 = 1;
	public static final int GLU_VERSION_1_2 = 1;
	public static final int GLU_VERTEX = GLU_TESS_VERTEX;
	public static final int GLU_V_STEP = 100207;
	public static final int GL_2D = 1536;
	public static final int GL_2_BYTES = 5127;
	public static final int GL_3D = 1537;
	public static final int GL_3D_COLOR = 1538;
	public static final int GL_3D_COLOR_TEXTURE = 1539;
	public static final int GL_3_BYTES = 5128;
	public static final int GL_4D_COLOR_TEXTURE = 1540;
	public static final int GL_4_BYTES = 5129;
	public static final int GL_ACCUM = 256;
	public static final int GL_ACCUM_ALPHA_BITS = 3419;
	public static final int GL_ACCUM_BLUE_BITS = 3418;
	public static final int GL_ACCUM_BUFFER_BIT = 0x00000200;
	public static final int GL_ACCUM_CLEAR_VALUE = 2944;
	public static final int GL_ACCUM_GREEN_BITS = 3417;
	public static final int GL_ACCUM_RED_BITS = 3416;
	public static final int GL_ADD = 260;
	public static final int GL_ALL_ATTRIB_BITS = 0x000FFFFF;
	public static final int GL_ALPHA = 6406;
	public static final int GL_ALPHA_BIAS = 3357;
	public static final int GL_ALPHA_BITS = 3413;
	public static final int GL_ALPHA_SCALE = 3356;
	public static final int GL_ALPHA_TEST = 3008;
	public static final int GL_ALPHA_TEST_FUNC = 3009;
	public static final int GL_ALPHA_TEST_REF = 3010;
	public static final int GL_ALWAYS = 519;
	public static final int GL_AMBIENT = 4608;
	public static final int GL_AMBIENT_AND_DIFFUSE = 5634;
	public static final int GL_AND = 5377;
	public static final int GL_AND_INVERTED = 5380;
	public static final int GL_AND_REVERSE = 5378;
	public static final int GL_ATTRIB_STACK_DEPTH = 2992;
	public static final int GL_AUTO_NORMAL = 3456;
	public static final int GL_AUX0 = 1033;
	public static final int GL_AUX1 = 1034;
	public static final int GL_AUX2 = 1035;
	public static final int GL_AUX3 = 1036;
	public static final int GL_AUX_BUFFERS = 3072;
	public static final int GL_BACK = 1029;
	public static final int GL_BACK_LEFT = 1026;
	public static final int GL_BACK_RIGHT = 1027;
	public static final int GL_BITMAP = 6656;
	public static final int GL_BITMAP_TOKEN = 1796;
	public static final int GL_BLEND = 3042;
	public static final int GL_BLEND_DST = 3040;
	public static final int GL_BLEND_SRC = 3041;
	public static final int GL_BLUE = 6405;
	public static final int GL_BLUE_BIAS = 3355;
	public static final int GL_BLUE_BITS = 3412;
	public static final int GL_BLUE_SCALE = 3354;
	public static final int GL_BYTE = 5120;
	public static final int GL_CCW = 2305;
	public static final int GL_CLAMP = 10496;
	public static final int GL_CLEAR = 5376;
	public static final int GL_CLIP_PLANE0 = 12288;
	public static final int GL_CLIP_PLANE1 = 12289;
	public static final int GL_CLIP_PLANE2 = 12290;
	public static final int GL_CLIP_PLANE3 = 12291;
	public static final int GL_CLIP_PLANE4 = 12292;
	public static final int GL_CLIP_PLANE5 = 12293;
	public static final int GL_COEFF = 2560;
	public static final int GL_COLOR = 6144;
	public static final int GL_COLOR_ARRAY_COUNT_EXT = 32900;
	public static final int GL_COLOR_ARRAY_EXT = 32886;
	public static final int GL_COLOR_ARRAY_POINTER_EXT = 32912;
	public static final int GL_COLOR_ARRAY_SIZE_EXT = 32897;
	public static final int GL_COLOR_ARRAY_STRIDE_EXT = 32899;
	public static final int GL_COLOR_ARRAY_TYPE_EXT = 32898;
	public static final int GL_COLOR_BUFFER_BIT = 0x00004000;
	public static final int GL_COLOR_CLEAR_VALUE = 3106;
	public static final int GL_COLOR_INDEX = 6400;
	public static final int GL_COLOR_INDEXES = 5635;
	public static final int GL_COLOR_MATERIAL = 2903;
	public static final int GL_COLOR_MATERIAL_FACE = 2901;
	public static final int GL_COLOR_MATERIAL_PARAMETER = 2902;
	public static final int GL_COLOR_WRITEMASK = 3107;
	public static final int GL_COMPILE = 4864;
	public static final int GL_COMPILE_AND_EXECUTE = 4865;
	public static final int GL_CONSTANT_ATTENUATION = 4615;
	public static final int GL_COPY = 5379;
	public static final int GL_COPY_INVERTED = 5388;
	public static final int GL_COPY_PIXEL_TOKEN = 1798;
	public static final int GL_CULL_FACE = 2884;
	public static final int GL_CULL_FACE_MODE = 2885;
	public static final int GL_CURRENT_BIT = 0x00000001;
	public static final int GL_CURRENT_COLOR = 2816;
	public static final int GL_CURRENT_INDEX = 2817;
	public static final int GL_CURRENT_NORMAL = 2818;
	public static final int GL_CURRENT_RASTER_COLOR = 2820;
	public static final int GL_CURRENT_RASTER_DISTANCE = 2825;
	public static final int GL_CURRENT_RASTER_INDEX = 2821;
	public static final int GL_CURRENT_RASTER_POSITION = 2823;
	public static final int GL_CURRENT_RASTER_POSITION_VALID = 2824;
	public static final int GL_CURRENT_RASTER_TEXTURE_COORDS = 2822;
	public static final int GL_CURRENT_TEXTURE_COORDS = 2819;
	public static final int GL_CW = 2304;
	public static final int GL_DECAL = 8449;
	public static final int GL_DECR = 7683;
	public static final int GL_DEPTH = 6145;
	public static final int GL_DEPTH_BIAS = 3359;
	public static final int GL_DEPTH_BITS = 3414;
	public static final int GL_DEPTH_BUFFER_BIT = 0x00000100;
	public static final int GL_DEPTH_CLEAR_VALUE = 2931;
	public static final int GL_DEPTH_COMPONENT = 6402;
	public static final int GL_DEPTH_FUNC = 2932;
	public static final int GL_DEPTH_RANGE = 2928;
	public static final int GL_DEPTH_SCALE = 3358;
	public static final int GL_DEPTH_TEST = 2929;
	public static final int GL_DEPTH_WRITEMASK = 2930;
	public static final int GL_DIFFUSE = 4609;
	public static final int GL_DITHER = 3024;
	public static final int GL_DOMAIN = 2562;
	public static final int GL_DONT_CARE = 4352;
	public static final int GL_DOUBLEBUFFER = 3122;
	public static final int GL_DOUBLE_EXT = 5130;
	public static final int GL_DRAW_BUFFER = 3073;
	public static final int GL_DRAW_PIXEL_TOKEN = 1797;
	public static final int GL_DST_ALPHA = 772;
	public static final int GL_DST_COLOR = 774;
	public static final int GL_EDGE_FLAG = 2883;
	public static final int GL_EDGE_FLAG_ARRAY_COUNT_EXT = 32909;
	public static final int GL_EDGE_FLAG_ARRAY_EXT = 32889;
	public static final int GL_EDGE_FLAG_ARRAY_POINTER_EXT = 32915;
	public static final int GL_EDGE_FLAG_ARRAY_STRIDE_EXT = 32908;
	public static final int GL_EMISSION = 5632;
	public static final int GL_ENABLE_BIT = 0x00002000;
	public static final int GL_EQUAL = 514;
	public static final int GL_EQUIV = 5385;
	public static final int GL_EVAL_BIT = 0x00010000;
	public static final int GL_EXP = 2048;
	public static final int GL_EXP2 = 2049;
	public static final int GL_EXTENSIONS = 7939;
	public static final int GL_EXT_vertex_array = 1;
	public static final int GL_EYE_LINEAR = 9216;
	public static final int GL_EYE_PLANE = 9474;
	public static final int GL_FALSE = 0;
	public static final int GL_FASTEST = 4353;
	public static final int GL_FEEDBACK = 7169;
	public static final int GL_FILL = 6914;
	public static final int GL_FLAT = 7424;
	public static final int GL_FLOAT = 5126;
	public static final int GL_FOG = 2912;
	public static final int GL_FOG_BIT = 0x00000080;
	public static final int GL_FOG_COLOR = 2918;
	public static final int GL_FOG_DENSITY = 2914;
	public static final int GL_FOG_END = 2916;
	public static final int GL_FOG_HINT = 3156;
	public static final int GL_FOG_INDEX = 2913;
	public static final int GL_FOG_MODE = 2917;
	public static final int GL_FOG_START = 2915;
	public static final int GL_FRONT = 1028;
	public static final int GL_FRONT_AND_BACK = 1032;
	public static final int GL_FRONT_FACE = 2886;
	public static final int GL_FRONT_LEFT = 1024;
	public static final int GL_FRONT_RIGHT = 1025;
	public static final int GL_GEQUAL = 518;
	public static final int GL_GREATER = 516;
	public static final int GL_GREEN = 6404;
	public static final int GL_GREEN_BIAS = 3353;
	public static final int GL_GREEN_BITS = 3411;
	public static final int GL_GREEN_SCALE = 3352;
	public static final int GL_HINT_BIT = 0x00008000;
	public static final int GL_INCR = 7682;
	public static final int GL_INDEX_ARRAY_COUNT_EXT = 32903;
	public static final int GL_INDEX_ARRAY_EXT = 32887;
	public static final int GL_INDEX_ARRAY_POINTER_EXT = 32913;
	public static final int GL_INDEX_ARRAY_STRIDE_EXT = 32902;
	public static final int GL_INDEX_ARRAY_TYPE_EXT = 32901;
	public static final int GL_INDEX_BITS = 3409;
	public static final int GL_INDEX_CLEAR_VALUE = 3104;
	public static final int GL_INDEX_MODE = 3120;
	public static final int GL_INDEX_OFFSET = 3347;
	public static final int GL_INDEX_SHIFT = 3346;
	public static final int GL_INDEX_WRITEMASK = 3105;
	public static final int GL_INT = 5124;
	public static final int GL_INVALID_ENUM = 1280;
	public static final int GL_INVALID_OPERATION = 1282;
	public static final int GL_INVALID_VALUE = 1281;
	public static final int GL_INVERT = 5386;
	public static final int GL_KEEP = 7680;
	public static final int GL_LEFT = 1030;
	public static final int GL_LEQUAL = 515;
	public static final int GL_LESS = 513;
	public static final int GL_LIGHT0 = 16384;
	public static final int GL_LIGHT1 = 16385;
	public static final int GL_LIGHT2 = 16386;
	public static final int GL_LIGHT3 = 16387;
	public static final int GL_LIGHT4 = 16388;
	public static final int GL_LIGHT5 = 16389;
	public static final int GL_LIGHT6 = 16390;
	public static final int GL_LIGHT7 = 16391;
	public static final int GL_LIGHTING = 2896;
	public static final int GL_LIGHTING_BIT = 0x00000040;
	public static final int GL_LIGHT_MODEL_AMBIENT = 2899;
	public static final int GL_LIGHT_MODEL_LOCAL_VIEWER = 2897;
	public static final int GL_LIGHT_MODEL_TWO_SIDE = 2898;
	public static final int GL_LINE = 6913;
	public static final int GL_LINEAR = 9729;
	public static final int GL_LINEAR_ATTENUATION = 4616;
	public static final int GL_LINEAR_MIPMAP_LINEAR = 9987;
	public static final int GL_LINEAR_MIPMAP_NEAREST = 9985;
	public static final int GL_LINES = 0x0001;
	public static final int GL_LINE_BIT = 0x00000004;
	public static final int GL_LINE_LOOP = 0x0002;
	public static final int GL_LINE_RESET_TOKEN = 1799;
	public static final int GL_LINE_SMOOTH = 2848;
	public static final int GL_LINE_SMOOTH_HINT = 3154;
	public static final int GL_LINE_STIPPLE = 2852;
	public static final int GL_LINE_STIPPLE_PATTERN = 2853;
	public static final int GL_LINE_STIPPLE_REPEAT = 2854;
	public static final int GL_LINE_STRIP = 0x0003;
	public static final int GL_LINE_TOKEN = 1794;
	public static final int GL_LINE_WIDTH = 2849;
	public static final int GL_LINE_WIDTH_GRANULARITY = 2851;
	public static final int GL_LINE_WIDTH_RANGE = 2850;
	public static final int GL_LIST_BASE = 2866;
	public static final int GL_LIST_BIT = 0x00020000;
	public static final int GL_LIST_INDEX = 2867;
	public static final int GL_LIST_MODE = 2864;
	public static final int GL_LOAD = 257;
	public static final int GL_LOGIC_OP = 3057;
	public static final int GL_LOGIC_OP_MODE = 3056;
	public static final int GL_LUMINANCE = 6409;
	public static final int GL_LUMINANCE_ALPHA = 6410;
	public static final int GL_MAP1_COLOR_4 = 3472;
	public static final int GL_MAP1_GRID_DOMAIN = 3536;
	public static final int GL_MAP1_GRID_SEGMENTS = 3537;
	public static final int GL_MAP1_INDEX = 3473;
	public static final int GL_MAP1_NORMAL = 3474;
	public static final int GL_MAP1_TEXTURE_COORD_1 = 3475;
	public static final int GL_MAP1_TEXTURE_COORD_2 = 3476;
	public static final int GL_MAP1_TEXTURE_COORD_3 = 3477;
	public static final int GL_MAP1_TEXTURE_COORD_4 = 3478;
	public static final int GL_MAP1_VERTEX_3 = 3479;
	public static final int GL_MAP1_VERTEX_4 = 3480;
	public static final int GL_MAP2_COLOR_4 = 3504;
	public static final int GL_MAP2_GRID_DOMAIN = 3538;
	public static final int GL_MAP2_GRID_SEGMENTS = 3539;
	public static final int GL_MAP2_INDEX = 3505;
	public static final int GL_MAP2_NORMAL = 3506;
	public static final int GL_MAP2_TEXTURE_COORD_1 = 3507;
	public static final int GL_MAP2_TEXTURE_COORD_2 = 3508;
	public static final int GL_MAP2_TEXTURE_COORD_3 = 3509;
	public static final int GL_MAP2_TEXTURE_COORD_4 = 3510;
	public static final int GL_MAP2_VERTEX_3 = 3511;
	public static final int GL_MAP2_VERTEX_4 = 3512;
	public static final int GL_MAP_COLOR = 3344;
	public static final int GL_MAP_STENCIL = 3345;
	public static final int GL_MATRIX_MODE = 2976;
	public static final int GL_MAX_ATTRIB_STACK_DEPTH = 3381;
	public static final int GL_MAX_CLIP_PLANES = 3378;
	public static final int GL_MAX_EVAL_ORDER = 3376;
	public static final int GL_MAX_LIGHTS = 3377;
	public static final int GL_MAX_LIST_NESTING = 2865;
	public static final int GL_MAX_MODELVIEW_STACK_DEPTH = 3382;
	public static final int GL_MAX_NAME_STACK_DEPTH = 3383;
	public static final int GL_MAX_PIXEL_MAP_TABLE = 3380;
	public static final int GL_MAX_PROJECTION_STACK_DEPTH = 3384;
	public static final int GL_MAX_TEXTURE_SIZE = 3379;
	public static final int GL_MAX_TEXTURE_STACK_DEPTH = 3385;
	public static final int GL_MAX_VIEWPORT_DIMS = 3386;
	public static final int GL_MODELVIEW = 5888;
	public static final int GL_MODELVIEW_MATRIX = 2982;
	public static final int GL_MODELVIEW_STACK_DEPTH = 2979;
	public static final int GL_MODULATE = 8448;
	public static final int GL_MULT = 259;
	public static final int GL_NAME_STACK_DEPTH = 3440;
	public static final int GL_NAND = 5390;
	public static final int GL_NEAREST = 9728;
	public static final int GL_NEAREST_MIPMAP_LINEAR = 9986;
	public static final int GL_NEAREST_MIPMAP_NEAREST = 9984;
	public static final int GL_NEVER = 512;
	public static final int GL_NICEST = 4354;
	public static final int GL_NONE = 0;
	public static final int GL_NOOP = 5381;
	public static final int GL_NOR = 5384;
	public static final int GL_NORMALIZE = 2977;
	public static final int GL_NORMAL_ARRAY_COUNT_EXT = 32896;
	public static final int GL_NORMAL_ARRAY_EXT = 32885;
	public static final int GL_NORMAL_ARRAY_POINTER_EXT = 32911;
	public static final int GL_NORMAL_ARRAY_STRIDE_EXT = 32895;
	public static final int GL_NORMAL_ARRAY_TYPE_EXT = 32894;
	public static final int GL_NOTEQUAL = 517;
	public static final int GL_NO_ERROR = 0;
	public static final int GL_OBJECT_LINEAR = 9217;
	public static final int GL_OBJECT_PLANE = 9473;
	public static final int GL_ONE = 1;
	public static final int GL_ONE_MINUS_DST_ALPHA = 773;
	public static final int GL_ONE_MINUS_DST_COLOR = 775;
	public static final int GL_ONE_MINUS_SRC_ALPHA = 771;
	public static final int GL_ONE_MINUS_SRC_COLOR = 769;
	public static final int GL_OR = 5383;
	public static final int GL_ORDER = 2561;
	public static final int GL_OR_INVERTED = 5389;
	public static final int GL_OR_REVERSE = 5387;
	public static final int GL_OUT_OF_MEMORY = 1285;
	public static final int GL_PACK_ALIGNMENT = 3333;
	public static final int GL_PACK_LSB_FIRST = 3329;
	public static final int GL_PACK_ROW_LENGTH = 3330;
	public static final int GL_PACK_SKIP_PIXELS = 3332;
	public static final int GL_PACK_SKIP_ROWS = 3331;
	public static final int GL_PACK_SWAP_BYTES = 3328;
	public static final int GL_PASS_THROUGH_TOKEN = 1792;
	public static final int GL_PERSPECTIVE_CORRECTION_HINT = 3152;
	public static final int GL_PIXEL_MAP_A_TO_A = 3193;
	public static final int GL_PIXEL_MAP_A_TO_A_SIZE = 3257;
	public static final int GL_PIXEL_MAP_B_TO_B = 3192;
	public static final int GL_PIXEL_MAP_B_TO_B_SIZE = 3256;
	public static final int GL_PIXEL_MAP_G_TO_G = 3191;
	public static final int GL_PIXEL_MAP_G_TO_G_SIZE = 3255;
	public static final int GL_PIXEL_MAP_I_TO_A = 3189;
	public static final int GL_PIXEL_MAP_I_TO_A_SIZE = 3253;
	public static final int GL_PIXEL_MAP_I_TO_B = 3188;
	public static final int GL_PIXEL_MAP_I_TO_B_SIZE = 3252;
	public static final int GL_PIXEL_MAP_I_TO_G = 3187;
	public static final int GL_PIXEL_MAP_I_TO_G_SIZE = 3251;
	public static final int GL_PIXEL_MAP_I_TO_I = 3184;
	public static final int GL_PIXEL_MAP_I_TO_I_SIZE = 3248;
	public static final int GL_PIXEL_MAP_I_TO_R = 3186;
	public static final int GL_PIXEL_MAP_I_TO_R_SIZE = 3250;
	public static final int GL_PIXEL_MAP_R_TO_R = 3190;
	public static final int GL_PIXEL_MAP_R_TO_R_SIZE = 3254;
	public static final int GL_PIXEL_MAP_S_TO_S = 3185;
	public static final int GL_PIXEL_MAP_S_TO_S_SIZE = 3249;
	public static final int GL_PIXEL_MODE_BIT = 0x00000020;
	public static final int GL_POINT = 6912;
	public static final int GL_POINTS = 0x0000;
	public static final int GL_POINT_BIT = 0x00000002;
	public static final int GL_POINT_SIZE = 2833;
	public static final int GL_POINT_SIZE_GRANULARITY = 2835;
	public static final int GL_POINT_SIZE_RANGE = 2834;
	public static final int GL_POINT_SMOOTH = 2832;
	public static final int GL_POINT_SMOOTH_HINT = 3153;
	public static final int GL_POINT_TOKEN = 1793;
	public static final int GL_POLYGON = 0x0009;
	public static final int GL_POLYGON_BIT = 0x00000008;
	public static final int GL_POLYGON_MODE = 2880;
	public static final int GL_POLYGON_OFFSET_FACTOR = 32824;
	public static final int GL_POLYGON_OFFSET_FILL = 32823;
	public static final int GL_POLYGON_OFFSET_LINE = 10754;
	public static final int GL_POLYGON_OFFSET_POINT = 10753;
	public static final int GL_POLYGON_OFFSET_UNITS = 10752;
	public static final int GL_POLYGON_SMOOTH = 2881;
	public static final int GL_POLYGON_SMOOTH_HINT = 3155;
	public static final int GL_POLYGON_STIPPLE = 2882;
	public static final int GL_POLYGON_STIPPLE_BIT = 0x00000010;
	public static final int GL_POLYGON_TOKEN = 1795;
	public static final int GL_POSITION = 4611;
	public static final int GL_PROJECTION = 5889;
	public static final int GL_PROJECTION_MATRIX = 2983;
	public static final int GL_PROJECTION_STACK_DEPTH = 2980;
	public static final int GL_Q = 8195;
	public static final int GL_QUADRATIC_ATTENUATION = 4617;
	public static final int GL_QUADS = 0x0007;
	public static final int GL_QUAD_STRIP = 0x0008;
	public static final int GL_R = 8194;
	public static final int GL_READ_BUFFER = 3074;
	public static final int GL_RED = 6403;
	public static final int GL_RED_BIAS = 3349;
	public static final int GL_RED_BITS = 3410;
	public static final int GL_RED_SCALE = 3348;
	public static final int GL_RENDER = 7168;
	public static final int GL_RENDERER = 7937;
	public static final int GL_RENDER_MODE = 3136;
	public static final int GL_REPEAT = 10497;
	public static final int GL_REPLACE = 7681;
	public static final int GL_RETURN = 258;
	public static final int GL_RGB = 6407;
	public static final int GL_RGBA = 6408;
	public static final int GL_RGBA_MODE = 3121;
	public static final int GL_RIGHT = 1031;
	public static final int GL_S = 8192;
	public static final int GL_SCISSOR_BIT = 0x00080000;
	public static final int GL_SCISSOR_BOX = 3088;
	public static final int GL_SCISSOR_TEST = 3089;
	public static final int GL_SELECT = 7170;
	public static final int GL_SET = 5391;
	public static final int GL_SHADE_MODEL = 2900;
	public static final int GL_SHININESS = 5633;
	public static final int GL_SHORT = 5122;
	public static final int GL_SMOOTH = 7425;
	public static final int GL_SPECULAR = 4610;
	public static final int GL_SPHERE_MAP = 9218;
	public static final int GL_SPOT_CUTOFF = 4614;
	public static final int GL_SPOT_DIRECTION = 4612;
	public static final int GL_SPOT_EXPONENT = 4613;
	public static final int GL_SRC_ALPHA = 770;
	public static final int GL_SRC_ALPHA_SATURATE = 776;
	public static final int GL_SRC_COLOR = 768;
	public static final int GL_STACK_OVERFLOW = 1283;
	public static final int GL_STACK_UNDERFLOW = 1284;
	public static final int GL_STENCIL = 6146;
	public static final int GL_STENCIL_BITS = 3415;
	public static final int GL_STENCIL_BUFFER_BIT = 0x00000400;
	public static final int GL_STENCIL_CLEAR_VALUE = 2961;
	public static final int GL_STENCIL_FAIL = 2964;
	public static final int GL_STENCIL_FUNC = 2962;
	public static final int GL_STENCIL_INDEX = 6401;
	public static final int GL_STENCIL_PASS_DEPTH_FAIL = 2965;
	public static final int GL_STENCIL_PASS_DEPTH_PASS = 2966;
	public static final int GL_STENCIL_REF = 2967;
	public static final int GL_STENCIL_TEST = 2960;
	public static final int GL_STENCIL_VALUE_MASK = 2963;
	public static final int GL_STENCIL_WRITEMASK = 2968;
	public static final int GL_STEREO = 3123;
	public static final int GL_SUBPIXEL_BITS = 3408;
	public static final int GL_T = 8193;
	public static final int GL_TEXTURE = 5890;
	public static final int GL_TEXTURE_1D = 3552;
	public static final int GL_TEXTURE_2D = 3553;
	public static final int GL_TEXTURE_BIT = 0x00040000;
	public static final int GL_TEXTURE_BORDER = 4101;
	public static final int GL_TEXTURE_BORDER_COLOR = 4100;
	public static final int GL_TEXTURE_COMPONENTS = 4099;
	public static final int GL_TEXTURE_COORD_ARRAY_COUNT_EXT = 32907;
	public static final int GL_TEXTURE_COORD_ARRAY_EXT = 32888;
	public static final int GL_TEXTURE_COORD_ARRAY_POINTER_EXT = 32914;
	public static final int GL_TEXTURE_COORD_ARRAY_SIZE_EXT = 32904;
	public static final int GL_TEXTURE_COORD_ARRAY_STRIDE_EXT = 32906;
	public static final int GL_TEXTURE_COORD_ARRAY_TYPE_EXT = 32905;
	public static final int GL_TEXTURE_ENV = 8960;
	public static final int GL_TEXTURE_ENV_COLOR = 8705;
	public static final int GL_TEXTURE_ENV_MODE = 8704;
	public static final int GL_TEXTURE_GEN_MODE = 9472;
	public static final int GL_TEXTURE_GEN_Q = 3171;
	public static final int GL_TEXTURE_GEN_R = 3170;
	public static final int GL_TEXTURE_GEN_S = 3168;
	public static final int GL_TEXTURE_GEN_T = 3169;
	public static final int GL_TEXTURE_HEIGHT = 4097;
	public static final int GL_TEXTURE_MAG_FILTER = 10240;
	public static final int GL_TEXTURE_MATRIX = 2984;
	public static final int GL_TEXTURE_MIN_FILTER = 10241;
	public static final int GL_TEXTURE_STACK_DEPTH = 2981;
	public static final int GL_TEXTURE_WIDTH = 4096;
	public static final int GL_TEXTURE_WRAP_S = 10242;
	public static final int GL_TEXTURE_WRAP_T = 10243;
	public static final int GL_TRANSFORM_BIT = 0x00001000;
	public static final int GL_TRIANGLES = 0x0004;
	public static final int GL_TRIANGLE_FAN = 0x0006;
	public static final int GL_TRIANGLE_STRIP = 0x0005;
	public static final int GL_TRUE = 1;
	public static final int GL_UNPACK_ALIGNMENT = 3317;
	public static final int GL_UNPACK_LSB_FIRST = 3313;
	public static final int GL_UNPACK_ROW_LENGTH = 3314;
	public static final int GL_UNPACK_SKIP_PIXELS = 3316;
	public static final int GL_UNPACK_SKIP_ROWS = 3315;
	public static final int GL_UNPACK_SWAP_BYTES = 3312;
	public static final int GL_UNSIGNED_BYTE = 5121;
	public static final int GL_UNSIGNED_INT = 5125;
	public static final int GL_UNSIGNED_SHORT = 5123;
	public static final int GL_VENDOR = 7936;
	public static final int GL_VERSION = 7938;
	public static final int GL_VERTEX_ARRAY_COUNT_EXT = 32893;
	public static final int GL_VERTEX_ARRAY_EXT = 32884;
	public static final int GL_VERTEX_ARRAY_POINTER_EXT = 32910;
	public static final int GL_VERTEX_ARRAY_SIZE_EXT = 32890;
	public static final int GL_VERTEX_ARRAY_STRIDE_EXT = 32892;
	public static final int GL_VERTEX_ARRAY_TYPE_EXT = 32891;
	public static final int GL_VIEWPORT = 2978;
	public static final int GL_VIEWPORT_BIT = 0x00000800;
	public static final int GL_WIN_swap_hint = 1;
	public static final int GL_XOR = 5382;
	public static final int GL_ZERO = 0;
	public static final int GL_ZOOM_X = 3350;
	public static final int GL_ZOOM_Y = 3351;

	/**
	 * Constainer Method.
	 */
	protected GLjInterface() {
		// Singleton pattern
		super();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static native String getVersion();

	/**
	 * Answer the only instance of GLjInterface. Call a instance method in a
	 * block of synchronized. sample:
	 * <pre>
	 *   GLjInterface gl = GLjInterface.Current();
	 *   synchronized (gl) {
	 *     gl.wglMakeCurrent(hDC, hRC);
	 *     // ...
	 *     gl.glFlush();
	 *   }
	 * </pre>
	 * 
	 * @return jp.co.sra.gl4jun.GLjInterface
	 */
	public static GLjInterface Current() {
		return Current;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param op DOCUMENT ME!
	 * @param value DOCUMENT ME!
	 */
	public native void glAccum(int op, float value);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param func DOCUMENT ME!
	 * @param ref DOCUMENT ME!
	 */
	public native void glAlphaFunc(int func, float ref);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param mode DOCUMENT ME!
	 */
	public native void glBegin(int mode);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param width DOCUMENT ME!
	 * @param height DOCUMENT ME!
	 * @param xorig DOCUMENT ME!
	 * @param yorig DOCUMENT ME!
	 * @param xmove DOCUMENT ME!
	 * @param ymove DOCUMENT ME!
	 * @param bitmap DOCUMENT ME!
	 */
	public native void glBitmap(int width, int height, float xorig, float yorig, float xmove, float ymove, byte[] bitmap);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param sfactor DOCUMENT ME!
	 * @param dfactor DOCUMENT ME!
	 */
	public native void glBlendFunc(int sfactor, int dfactor);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param list DOCUMENT ME!
	 */
	public native void glCallList(int list);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param n DOCUMENT ME!
	 * @param type DOCUMENT ME!
	 * @param lists DOCUMENT ME!
	 */
	public native void glCallLists(int n, int type, byte[] lists);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param mask DOCUMENT ME!
	 */
	public native void glClear(int mask);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param red DOCUMENT ME!
	 * @param green DOCUMENT ME!
	 * @param blue DOCUMENT ME!
	 * @param alpha DOCUMENT ME!
	 */
	public native void glClearAccum(float red, float green, float blue, float alpha);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param red DOCUMENT ME!
	 * @param green DOCUMENT ME!
	 * @param blue DOCUMENT ME!
	 * @param alpha DOCUMENT ME!
	 */
	public native void glClearColor(float red, float green, float blue, float alpha);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param depth DOCUMENT ME!
	 */
	public native void glClearDepth(double depth);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param c DOCUMENT ME!
	 */
	public native void glClearIndex(float c);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param s DOCUMENT ME!
	 */
	public native void glClearStencil(int s);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param plane DOCUMENT ME!
	 * @param equation DOCUMENT ME!
	 */
	public native void glClipPlane(int plane, double[] equation);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param red DOCUMENT ME!
	 * @param green DOCUMENT ME!
	 * @param blue DOCUMENT ME!
	 */
	public native void glColor3b(byte red, byte green, byte blue);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glColor3bv(byte[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param red DOCUMENT ME!
	 * @param green DOCUMENT ME!
	 * @param blue DOCUMENT ME!
	 */
	public native void glColor3d(double red, double green, double blue);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glColor3dv(double[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param red DOCUMENT ME!
	 * @param green DOCUMENT ME!
	 * @param blue DOCUMENT ME!
	 */
	public native void glColor3f(float red, float green, float blue);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glColor3fv(float[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param red DOCUMENT ME!
	 * @param green DOCUMENT ME!
	 * @param blue DOCUMENT ME!
	 */
	public native void glColor3i(int red, int green, int blue);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glColor3iv(int[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param red DOCUMENT ME!
	 * @param green DOCUMENT ME!
	 * @param blue DOCUMENT ME!
	 */
	public native void glColor3s(short red, short green, short blue);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glColor3sv(short[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param red DOCUMENT ME!
	 * @param green DOCUMENT ME!
	 * @param blue DOCUMENT ME!
	 */
	public native void glColor3ub(byte red, byte green, byte blue);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glColor3ubv(byte[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param red DOCUMENT ME!
	 * @param green DOCUMENT ME!
	 * @param blue DOCUMENT ME!
	 */
	public native void glColor3ui(int red, int green, int blue);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glColor3uiv(int[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param red DOCUMENT ME!
	 * @param green DOCUMENT ME!
	 * @param blue DOCUMENT ME!
	 */
	public native void glColor3us(short red, short green, short blue);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glColor3usv(short[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param red DOCUMENT ME!
	 * @param green DOCUMENT ME!
	 * @param blue DOCUMENT ME!
	 * @param alpha DOCUMENT ME!
	 */
	public native void glColor4b(byte red, byte green, byte blue, byte alpha);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glColor4bv(byte[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param red DOCUMENT ME!
	 * @param green DOCUMENT ME!
	 * @param blue DOCUMENT ME!
	 * @param alpha DOCUMENT ME!
	 */
	public native void glColor4d(double red, double green, double blue, double alpha);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glColor4dv(double[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param red DOCUMENT ME!
	 * @param green DOCUMENT ME!
	 * @param blue DOCUMENT ME!
	 * @param alpha DOCUMENT ME!
	 */
	public native void glColor4f(float red, float green, float blue, float alpha);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glColor4fv(float[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param red DOCUMENT ME!
	 * @param green DOCUMENT ME!
	 * @param blue DOCUMENT ME!
	 * @param alpha DOCUMENT ME!
	 */
	public native void glColor4i(int red, int green, int blue, int alpha);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glColor4iv(int[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param red DOCUMENT ME!
	 * @param green DOCUMENT ME!
	 * @param blue DOCUMENT ME!
	 * @param alpha DOCUMENT ME!
	 */
	public native void glColor4s(short red, short green, short blue, short alpha);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glColor4sv(short[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param red DOCUMENT ME!
	 * @param green DOCUMENT ME!
	 * @param blue DOCUMENT ME!
	 * @param alpha DOCUMENT ME!
	 */
	public native void glColor4ub(byte red, byte green, byte blue, byte alpha);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glColor4ubv(byte[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param red DOCUMENT ME!
	 * @param green DOCUMENT ME!
	 * @param blue DOCUMENT ME!
	 * @param alpha DOCUMENT ME!
	 */
	public native void glColor4ui(int red, int green, int blue, int alpha);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glColor4uiv(int[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param red DOCUMENT ME!
	 * @param green DOCUMENT ME!
	 * @param blue DOCUMENT ME!
	 * @param alpha DOCUMENT ME!
	 */
	public native void glColor4us(short red, short green, short blue, short alpha);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glColor4usv(short[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param red DOCUMENT ME!
	 * @param green DOCUMENT ME!
	 * @param blue DOCUMENT ME!
	 * @param alpha DOCUMENT ME!
	 */
	public native void glColorMask(boolean red, boolean green, boolean blue, boolean alpha);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param face DOCUMENT ME!
	 * @param mode DOCUMENT ME!
	 */
	public native void glColorMaterial(int face, int mode);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param width DOCUMENT ME!
	 * @param height DOCUMENT ME!
	 * @param type DOCUMENT ME!
	 */
	public native void glCopyPixels(int x, int y, int width, int height, int type);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param mode DOCUMENT ME!
	 */
	public native void glCullFace(int mode);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param list DOCUMENT ME!
	 * @param range DOCUMENT ME!
	 */
	public native void glDeleteLists(int list, int range);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param func DOCUMENT ME!
	 */
	public native void glDepthFunc(int func);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param flag DOCUMENT ME!
	 */
	public native void glDepthMask(boolean flag);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param zNear DOCUMENT ME!
	 * @param zFar DOCUMENT ME!
	 */
	public native void glDepthRange(double zNear, double zFar);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param cap DOCUMENT ME!
	 */
	public native void glDisable(int cap);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param mode DOCUMENT ME!
	 */
	public native void glDrawBuffer(int mode);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param width DOCUMENT ME!
	 * @param height DOCUMENT ME!
	 * @param format DOCUMENT ME!
	 * @param type DOCUMENT ME!
	 * @param pixels DOCUMENT ME!
	 */
	public native void glDrawPixels(int width, int height, int format, int type, byte[] pixels);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param flag DOCUMENT ME!
	 */
	public native void glEdgeFlag(boolean flag);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param flag DOCUMENT ME!
	 */
	public native void glEdgeFlagv(boolean[] flag);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param cap DOCUMENT ME!
	 */
	public native void glEnable(int cap);

	/**
	 * DOCUMENT ME!
	 */
	public native void glEnd();

	/**
	 * DOCUMENT ME!
	 */
	public native void glEndList();

	/**
	 * DOCUMENT ME!
	 * 
	 * @param u DOCUMENT ME!
	 */
	public native void glEvalCoord1d(double u);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param u DOCUMENT ME!
	 */
	public native void glEvalCoord1dv(double[] u);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param u DOCUMENT ME!
	 */
	public native void glEvalCoord1f(float u);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param u DOCUMENT ME!
	 */
	public native void glEvalCoord1fv(float[] u);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param u DOCUMENT ME!
	 * @param v DOCUMENT ME!
	 */
	public native void glEvalCoord2d(double u, double v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param u DOCUMENT ME!
	 */
	public native void glEvalCoord2dv(double[] u);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param u DOCUMENT ME!
	 * @param v DOCUMENT ME!
	 */
	public native void glEvalCoord2f(float u, float v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param u DOCUMENT ME!
	 */
	public native void glEvalCoord2fv(float[] u);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param mode DOCUMENT ME!
	 * @param i1 DOCUMENT ME!
	 * @param i2 DOCUMENT ME!
	 */
	public native void glEvalMesh1(int mode, int i1, int i2);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param mode DOCUMENT ME!
	 * @param i1 DOCUMENT ME!
	 * @param i2 DOCUMENT ME!
	 * @param j1 DOCUMENT ME!
	 * @param j2 DOCUMENT ME!
	 */
	public native void glEvalMesh2(int mode, int i1, int i2, int j1, int j2);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param i DOCUMENT ME!
	 */
	public native void glEvalPoint1(int i);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param i DOCUMENT ME!
	 * @param j DOCUMENT ME!
	 */
	public native void glEvalPoint2(int i, int j);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param size DOCUMENT ME!
	 * @param type DOCUMENT ME!
	 * @param buffer DOCUMENT ME!
	 */
	public native void glFeedbackBuffer(int size, int type, float[] buffer);

	/**
	 * DOCUMENT ME!
	 */
	public native void glFinish();

	/**
	 * DOCUMENT ME!
	 */
	public native void glFlush();

	/**
	 * DOCUMENT ME!
	 * 
	 * @param pname DOCUMENT ME!
	 * @param param DOCUMENT ME!
	 */
	public native void glFogf(int pname, float param);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glFogfv(int pname, float[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param pname DOCUMENT ME!
	 * @param param DOCUMENT ME!
	 */
	public native void glFogi(int pname, int param);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glFogiv(int pname, int[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param mode DOCUMENT ME!
	 */
	public native void glFrontFace(int mode);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param left DOCUMENT ME!
	 * @param right DOCUMENT ME!
	 * @param bottom DOCUMENT ME!
	 * @param top DOCUMENT ME!
	 * @param zNear DOCUMENT ME!
	 * @param zFar DOCUMENT ME!
	 */
	public native void glFrustum(double left, double right, double bottom, double top, double zNear, double zFar);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param range DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native int glGenLists(int range);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glGetBooleanv(int pname, boolean[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param plane DOCUMENT ME!
	 * @param equation DOCUMENT ME!
	 */
	public native void glGetClipPlane(int plane, double[] equation);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glGetDoublev(int pname, double[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native int glGetError();

	/**
	 * DOCUMENT ME!
	 * 
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glGetFloatv(int pname, float[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glGetIntegerv(int pname, int[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param light DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glGetLightfv(int light, int pname, float[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param light DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glGetLightiv(int light, int pname, int[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param query DOCUMENT ME!
	 * @param v DOCUMENT ME!
	 */
	public native void glGetMapdv(int target, int query, double[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param query DOCUMENT ME!
	 * @param v DOCUMENT ME!
	 */
	public native void glGetMapfv(int target, int query, float[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param query DOCUMENT ME!
	 * @param v DOCUMENT ME!
	 */
	public native void glGetMapiv(int target, int query, int[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param face DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glGetMaterialfv(int face, int pname, float[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param face DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glGetMaterialiv(int face, int pname, int[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param map DOCUMENT ME!
	 * @param values DOCUMENT ME!
	 */
	public native void glGetPixelMapfv(int map, float[] values);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param map DOCUMENT ME!
	 * @param values DOCUMENT ME!
	 */
	public native void glGetPixelMapuiv(int map, int[] values);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param map DOCUMENT ME!
	 * @param values DOCUMENT ME!
	 */
	public native void glGetPixelMapusv(int map, short[] values);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param mask DOCUMENT ME!
	 */
	public native void glGetPolygonStipple(byte[] mask);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param name DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native String glGetString(int name);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glGetTexEnvfv(int target, int pname, float[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glGetTexEnviv(int target, int pname, int[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param coord DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glGetTexGendv(int coord, int pname, double[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param coord DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glGetTexGenfv(int coord, int pname, float[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param coord DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glGetTexGeniv(int coord, int pname, int[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param level DOCUMENT ME!
	 * @param format DOCUMENT ME!
	 * @param type DOCUMENT ME!
	 * @param pixels DOCUMENT ME!
	 */
	public native void glGetTexImage(int target, int level, int format, int type, byte[] pixels);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param level DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glGetTexLevelParameterfv(int target, int level, int pname, float[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param level DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glGetTexLevelParameteriv(int target, int level, int pname, int[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glGetTexParameterfv(int target, int pname, float[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glGetTexParameteriv(int target, int pname, int[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param mode DOCUMENT ME!
	 */
	public native void glHint(int target, int mode);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param mask DOCUMENT ME!
	 */
	public native void glIndexMask(int mask);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param c DOCUMENT ME!
	 */
	public native void glIndexd(double c);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param c DOCUMENT ME!
	 */
	public native void glIndexdv(double[] c);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param c DOCUMENT ME!
	 */
	public native void glIndexf(float c);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param c DOCUMENT ME!
	 */
	public native void glIndexfv(float[] c);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param c DOCUMENT ME!
	 */
	public native void glIndexi(int c);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param c DOCUMENT ME!
	 */
	public native void glIndexiv(int[] c);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param c DOCUMENT ME!
	 */
	public native void glIndexs(short c);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param c DOCUMENT ME!
	 */
	public native void glIndexsv(short[] c);

	/**
	 * DOCUMENT ME!
	 */
	public native void glInitNames();

	/**
	 * DOCUMENT ME!
	 * 
	 * @param cap DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native boolean glIsEnabled(int cap);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param list DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native boolean glIsList(int list);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param pname DOCUMENT ME!
	 * @param param DOCUMENT ME!
	 */
	public native void glLightModelf(int pname, float param);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glLightModelfv(int pname, float[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param pname DOCUMENT ME!
	 * @param param DOCUMENT ME!
	 */
	public native void glLightModeli(int pname, int param);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glLightModeliv(int pname, int[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param light DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param param DOCUMENT ME!
	 */
	public native void glLightf(int light, int pname, float param);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param light DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glLightfv(int light, int pname, float[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param light DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param param DOCUMENT ME!
	 */
	public native void glLighti(int light, int pname, int param);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param light DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glLightiv(int light, int pname, int[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param factor DOCUMENT ME!
	 * @param pattern DOCUMENT ME!
	 */
	public native void glLineStipple(int factor, short pattern);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param width DOCUMENT ME!
	 */
	public native void glLineWidth(float width);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param base DOCUMENT ME!
	 */
	public native void glListBase(int base);

	/**
	 * DOCUMENT ME!
	 */
	public native void glLoadIdentity();

	/**
	 * DOCUMENT ME!
	 * 
	 * @param m DOCUMENT ME!
	 */
	public native void glLoadMatrixd(double[] m);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param m DOCUMENT ME!
	 */
	public native void glLoadMatrixf(float[] m);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param name DOCUMENT ME!
	 */
	public native void glLoadName(int name);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param opcode DOCUMENT ME!
	 */
	public native void glLogicOp(int opcode);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param u1 DOCUMENT ME!
	 * @param u2 DOCUMENT ME!
	 * @param stride DOCUMENT ME!
	 * @param order DOCUMENT ME!
	 * @param points DOCUMENT ME!
	 */
	public native void glMap1d(int target, double u1, double u2, int stride, int order, double[] points);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param u1 DOCUMENT ME!
	 * @param u2 DOCUMENT ME!
	 * @param stride DOCUMENT ME!
	 * @param order DOCUMENT ME!
	 * @param points DOCUMENT ME!
	 */
	public native void glMap1f(int target, float u1, float u2, int stride, int order, float[] points);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param u1 DOCUMENT ME!
	 * @param u2 DOCUMENT ME!
	 * @param ustride DOCUMENT ME!
	 * @param uorder DOCUMENT ME!
	 * @param v1 DOCUMENT ME!
	 * @param v2 DOCUMENT ME!
	 * @param vstride DOCUMENT ME!
	 * @param vorder DOCUMENT ME!
	 * @param points DOCUMENT ME!
	 */
	public native void glMap2d(int target, double u1, double u2, int ustride, int uorder, double v1, double v2, int vstride, int vorder, double[] points);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param u1 DOCUMENT ME!
	 * @param u2 DOCUMENT ME!
	 * @param ustride DOCUMENT ME!
	 * @param uorder DOCUMENT ME!
	 * @param v1 DOCUMENT ME!
	 * @param v2 DOCUMENT ME!
	 * @param vstride DOCUMENT ME!
	 * @param vorder DOCUMENT ME!
	 * @param points DOCUMENT ME!
	 */
	public native void glMap2f(int target, float u1, float u2, int ustride, int uorder, float v1, float v2, int vstride, int vorder, float[] points);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param un DOCUMENT ME!
	 * @param u1 DOCUMENT ME!
	 * @param u2 DOCUMENT ME!
	 */
	public native void glMapGrid1d(int un, double u1, double u2);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param un DOCUMENT ME!
	 * @param u1 DOCUMENT ME!
	 * @param u2 DOCUMENT ME!
	 */
	public native void glMapGrid1f(int un, float u1, float u2);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param un DOCUMENT ME!
	 * @param u1 DOCUMENT ME!
	 * @param u2 DOCUMENT ME!
	 * @param vn DOCUMENT ME!
	 * @param v1 DOCUMENT ME!
	 * @param v2 DOCUMENT ME!
	 */
	public native void glMapGrid2d(int un, double u1, double u2, int vn, double v1, double v2);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param un DOCUMENT ME!
	 * @param u1 DOCUMENT ME!
	 * @param u2 DOCUMENT ME!
	 * @param vn DOCUMENT ME!
	 * @param v1 DOCUMENT ME!
	 * @param v2 DOCUMENT ME!
	 */
	public native void glMapGrid2f(int un, float u1, float u2, int vn, float v1, float v2);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param face DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param param DOCUMENT ME!
	 */
	public native void glMaterialf(int face, int pname, float param);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param face DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glMaterialfv(int face, int pname, float[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param face DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param param DOCUMENT ME!
	 */
	public native void glMateriali(int face, int pname, int param);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param face DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glMaterialiv(int face, int pname, int[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param mode DOCUMENT ME!
	 */
	public native void glMatrixMode(int mode);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param m DOCUMENT ME!
	 */
	public native void glMultMatrixd(double[] m);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param m DOCUMENT ME!
	 */
	public native void glMultMatrixf(float[] m);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param list DOCUMENT ME!
	 * @param mode DOCUMENT ME!
	 */
	public native void glNewList(int list, int mode);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param nx DOCUMENT ME!
	 * @param ny DOCUMENT ME!
	 * @param nz DOCUMENT ME!
	 */
	public native void glNormal3b(byte nx, byte ny, byte nz);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glNormal3bv(byte[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param nx DOCUMENT ME!
	 * @param ny DOCUMENT ME!
	 * @param nz DOCUMENT ME!
	 */
	public native void glNormal3d(double nx, double ny, double nz);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glNormal3dv(double[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param nx DOCUMENT ME!
	 * @param ny DOCUMENT ME!
	 * @param nz DOCUMENT ME!
	 */
	public native void glNormal3f(float nx, float ny, float nz);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glNormal3fv(float[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param nx DOCUMENT ME!
	 * @param ny DOCUMENT ME!
	 * @param nz DOCUMENT ME!
	 */
	public native void glNormal3i(int nx, int ny, int nz);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glNormal3iv(int[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param nx DOCUMENT ME!
	 * @param ny DOCUMENT ME!
	 * @param nz DOCUMENT ME!
	 */
	public native void glNormal3s(short nx, short ny, short nz);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glNormal3sv(short[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param left DOCUMENT ME!
	 * @param right DOCUMENT ME!
	 * @param bottom DOCUMENT ME!
	 * @param top DOCUMENT ME!
	 * @param zNear DOCUMENT ME!
	 * @param zFar DOCUMENT ME!
	 */
	public native void glOrtho(double left, double right, double bottom, double top, double zNear, double zFar);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param token DOCUMENT ME!
	 */
	public native void glPassThrough(float token);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param map DOCUMENT ME!
	 * @param mapsize DOCUMENT ME!
	 * @param values DOCUMENT ME!
	 */
	public native void glPixelMapfv(int map, int mapsize, float[] values);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param map DOCUMENT ME!
	 * @param mapsize DOCUMENT ME!
	 * @param values DOCUMENT ME!
	 */
	public native void glPixelMapuiv(int map, int mapsize, int[] values);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param map DOCUMENT ME!
	 * @param mapsize DOCUMENT ME!
	 * @param values DOCUMENT ME!
	 */
	public native void glPixelMapusv(int map, int mapsize, short[] values);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param pname DOCUMENT ME!
	 * @param param DOCUMENT ME!
	 */
	public native void glPixelStoref(int pname, float param);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param pname DOCUMENT ME!
	 * @param param DOCUMENT ME!
	 */
	public native void glPixelStorei(int pname, int param);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param pname DOCUMENT ME!
	 * @param param DOCUMENT ME!
	 */
	public native void glPixelTransferf(int pname, float param);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param pname DOCUMENT ME!
	 * @param param DOCUMENT ME!
	 */
	public native void glPixelTransferi(int pname, int param);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param xfactor DOCUMENT ME!
	 * @param yfactor DOCUMENT ME!
	 */
	public native void glPixelZoom(float xfactor, float yfactor);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param size DOCUMENT ME!
	 */
	public native void glPointSize(float size);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param face DOCUMENT ME!
	 * @param mode DOCUMENT ME!
	 */
	public native void glPolygonMode(int face, int mode);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param factor DOCUMENT ME!
	 * @param units DOCUMENT ME!
	 */
	public native void glPolygonOffset(float factor, float units);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param mask DOCUMENT ME!
	 */
	public native void glPolygonStipple(byte[] mask);

	/**
	 * DOCUMENT ME!
	 */
	public native void glPopAttrib();

	/**
	 * DOCUMENT ME!
	 */
	public native void glPopMatrix();

	/**
	 * DOCUMENT ME!
	 */
	public native void glPopName();

	/**
	 * DOCUMENT ME!
	 * 
	 * @param mask DOCUMENT ME!
	 */
	public native void glPushAttrib(int mask);

	/**
	 * DOCUMENT ME!
	 */
	public native void glPushMatrix();

	/**
	 * DOCUMENT ME!
	 * 
	 * @param name DOCUMENT ME!
	 */
	public native void glPushName(int name);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 */
	public native void glRasterPos2d(double x, double y);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glRasterPos2dv(double[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 */
	public native void glRasterPos2f(float x, float y);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glRasterPos2fv(float[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 */
	public native void glRasterPos2i(int x, int y);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glRasterPos2iv(int[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 */
	public native void glRasterPos2s(short x, short y);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glRasterPos2sv(short[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 */
	public native void glRasterPos3d(double x, double y, double z);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glRasterPos3dv(double[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 */
	public native void glRasterPos3f(float x, float y, float z);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glRasterPos3fv(float[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 */
	public native void glRasterPos3i(int x, int y, int z);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glRasterPos3iv(int[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 */
	public native void glRasterPos3s(short x, short y, short z);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glRasterPos3sv(short[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 * @param w DOCUMENT ME!
	 */
	public native void glRasterPos4d(double x, double y, double z, double w);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glRasterPos4dv(double[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 * @param w DOCUMENT ME!
	 */
	public native void glRasterPos4f(float x, float y, float z, float w);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glRasterPos4fv(float[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 * @param w DOCUMENT ME!
	 */
	public native void glRasterPos4i(int x, int y, int z, int w);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glRasterPos4iv(int[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 * @param w DOCUMENT ME!
	 */
	public native void glRasterPos4s(short x, short y, short z, short w);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glRasterPos4sv(short[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param mode DOCUMENT ME!
	 */
	public native void glReadBuffer(int mode);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param width DOCUMENT ME!
	 * @param height DOCUMENT ME!
	 * @param format DOCUMENT ME!
	 * @param type DOCUMENT ME!
	 * @param pixels DOCUMENT ME!
	 */
	public native void glReadPixels(int x, int y, int width, int height, int format, int type, byte[] pixels);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x1 DOCUMENT ME!
	 * @param y1 DOCUMENT ME!
	 * @param x2 DOCUMENT ME!
	 * @param y2 DOCUMENT ME!
	 */
	public native void glRectd(double x1, double y1, double x2, double y2);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v1 DOCUMENT ME!
	 * @param v2 DOCUMENT ME!
	 */
	public native void glRectdv(double[] v1, double[] v2);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x1 DOCUMENT ME!
	 * @param y1 DOCUMENT ME!
	 * @param x2 DOCUMENT ME!
	 * @param y2 DOCUMENT ME!
	 */
	public native void glRectf(float x1, float y1, float x2, float y2);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v1 DOCUMENT ME!
	 * @param v2 DOCUMENT ME!
	 */
	public native void glRectfv(float[] v1, float[] v2);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x1 DOCUMENT ME!
	 * @param y1 DOCUMENT ME!
	 * @param x2 DOCUMENT ME!
	 * @param y2 DOCUMENT ME!
	 */
	public native void glRecti(int x1, int y1, int x2, int y2);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v1 DOCUMENT ME!
	 * @param v2 DOCUMENT ME!
	 */
	public native void glRectiv(int[] v1, int[] v2);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x1 DOCUMENT ME!
	 * @param y1 DOCUMENT ME!
	 * @param x2 DOCUMENT ME!
	 * @param y2 DOCUMENT ME!
	 */
	public native void glRects(short x1, short y1, short x2, short y2);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v1 DOCUMENT ME!
	 * @param v2 DOCUMENT ME!
	 */
	public native void glRectsv(short[] v1, short[] v2);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param mode DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native int glRenderMode(int mode);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param angle DOCUMENT ME!
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 */
	public native void glRotated(double angle, double x, double y, double z);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param angle DOCUMENT ME!
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 */
	public native void glRotatef(float angle, float x, float y, float z);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 */
	public native void glScaled(double x, double y, double z);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 */
	public native void glScalef(float x, float y, float z);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param width DOCUMENT ME!
	 * @param height DOCUMENT ME!
	 */
	public native void glScissor(int x, int y, int width, int height);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param buffer DOCUMENT ME!
	 * @param handle DOCUMENT ME!
	 */
	public native void glSelectBufferEnd(int[] buffer, int handle);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param buffer DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native int glSelectBufferStart(int[] buffer);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param mode DOCUMENT ME!
	 */
	public native void glShadeModel(int mode);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param func DOCUMENT ME!
	 * @param ref DOCUMENT ME!
	 * @param mask DOCUMENT ME!
	 */
	public native void glStencilFunc(int func, int ref, int mask);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param mask DOCUMENT ME!
	 */
	public native void glStencilMask(int mask);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param fail DOCUMENT ME!
	 * @param zfail DOCUMENT ME!
	 * @param zpass DOCUMENT ME!
	 */
	public native void glStencilOp(int fail, int zfail, int zpass);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param s DOCUMENT ME!
	 */
	public native void glTexCoord1d(double s);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glTexCoord1dv(double[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param s DOCUMENT ME!
	 */
	public native void glTexCoord1f(float s);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glTexCoord1fv(float[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param s DOCUMENT ME!
	 */
	public native void glTexCoord1i(int s);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glTexCoord1iv(int[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param s DOCUMENT ME!
	 */
	public native void glTexCoord1s(short s);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glTexCoord1sv(short[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param s DOCUMENT ME!
	 * @param t DOCUMENT ME!
	 */
	public native void glTexCoord2d(double s, double t);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glTexCoord2dv(double[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param s DOCUMENT ME!
	 * @param t DOCUMENT ME!
	 */
	public native void glTexCoord2f(float s, float t);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glTexCoord2fv(float[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param s DOCUMENT ME!
	 * @param t DOCUMENT ME!
	 */
	public native void glTexCoord2i(int s, int t);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glTexCoord2iv(int[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param s DOCUMENT ME!
	 * @param t DOCUMENT ME!
	 */
	public native void glTexCoord2s(short s, short t);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glTexCoord2sv(short[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param s DOCUMENT ME!
	 * @param t DOCUMENT ME!
	 * @param r DOCUMENT ME!
	 */
	public native void glTexCoord3d(double s, double t, double r);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glTexCoord3dv(double[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param s DOCUMENT ME!
	 * @param t DOCUMENT ME!
	 * @param r DOCUMENT ME!
	 */
	public native void glTexCoord3f(float s, float t, float r);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glTexCoord3fv(float[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param s DOCUMENT ME!
	 * @param t DOCUMENT ME!
	 * @param r DOCUMENT ME!
	 */
	public native void glTexCoord3i(int s, int t, int r);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glTexCoord3iv(int[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param s DOCUMENT ME!
	 * @param t DOCUMENT ME!
	 * @param r DOCUMENT ME!
	 */
	public native void glTexCoord3s(short s, short t, short r);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glTexCoord3sv(short[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param s DOCUMENT ME!
	 * @param t DOCUMENT ME!
	 * @param r DOCUMENT ME!
	 * @param q DOCUMENT ME!
	 */
	public native void glTexCoord4d(double s, double t, double r, double q);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glTexCoord4dv(double[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param s DOCUMENT ME!
	 * @param t DOCUMENT ME!
	 * @param r DOCUMENT ME!
	 * @param q DOCUMENT ME!
	 */
	public native void glTexCoord4f(float s, float t, float r, float q);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glTexCoord4fv(float[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param s DOCUMENT ME!
	 * @param t DOCUMENT ME!
	 * @param r DOCUMENT ME!
	 * @param q DOCUMENT ME!
	 */
	public native void glTexCoord4i(int s, int t, int r, int q);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glTexCoord4iv(int[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param s DOCUMENT ME!
	 * @param t DOCUMENT ME!
	 * @param r DOCUMENT ME!
	 * @param q DOCUMENT ME!
	 */
	public native void glTexCoord4s(short s, short t, short r, short q);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glTexCoord4sv(short[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param param DOCUMENT ME!
	 */
	public native void glTexEnvf(int target, int pname, float param);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glTexEnvfv(int target, int pname, float[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param param DOCUMENT ME!
	 */
	public native void glTexEnvi(int target, int pname, int param);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glTexEnviv(int target, int pname, int[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param coord DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param param DOCUMENT ME!
	 */
	public native void glTexGend(int coord, int pname, double param);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param coord DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glTexGendv(int coord, int pname, double[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param coord DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param param DOCUMENT ME!
	 */
	public native void glTexGenf(int coord, int pname, float param);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param coord DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glTexGenfv(int coord, int pname, float[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param coord DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param param DOCUMENT ME!
	 */
	public native void glTexGeni(int coord, int pname, int param);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param coord DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glTexGeniv(int coord, int pname, int[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param level DOCUMENT ME!
	 * @param components DOCUMENT ME!
	 * @param width DOCUMENT ME!
	 * @param border DOCUMENT ME!
	 * @param format DOCUMENT ME!
	 * @param type DOCUMENT ME!
	 * @param pixels DOCUMENT ME!
	 */
	public native void glTexImage1D(int target, int level, int components, int width, int border, int format, int type, byte[] pixels);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param level DOCUMENT ME!
	 * @param components DOCUMENT ME!
	 * @param width DOCUMENT ME!
	 * @param height DOCUMENT ME!
	 * @param border DOCUMENT ME!
	 * @param format DOCUMENT ME!
	 * @param type DOCUMENT ME!
	 * @param pixels DOCUMENT ME!
	 */
	public native void glTexImage2D(int target, int level, int components, int width, int height, int border, int format, int type, byte[] pixels);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param param DOCUMENT ME!
	 */
	public native void glTexParameterf(int target, int pname, float param);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glTexParameterfv(int target, int pname, float[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param param DOCUMENT ME!
	 */
	public native void glTexParameteri(int target, int pname, int param);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param pname DOCUMENT ME!
	 * @param params DOCUMENT ME!
	 */
	public native void glTexParameteriv(int target, int pname, int[] params);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 */
	public native void glTranslated(double x, double y, double z);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 */
	public native void glTranslatef(float x, float y, float z);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 */
	public native void glVertex2d(double x, double y);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glVertex2dv(double[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 */
	public native void glVertex2f(float x, float y);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glVertex2fv(float[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 */
	public native void glVertex2i(int x, int y);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glVertex2iv(int[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 */
	public native void glVertex2s(short x, short y);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glVertex2sv(short[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 */
	public native void glVertex3d(double x, double y, double z);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glVertex3dv(double[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 */
	public native void glVertex3f(float x, float y, float z);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glVertex3fv(float[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 */
	public native void glVertex3i(int x, int y, int z);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glVertex3iv(int[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 */
	public native void glVertex3s(short x, short y, short z);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glVertex3sv(short[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 * @param w DOCUMENT ME!
	 */
	public native void glVertex4d(double x, double y, double z, double w);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glVertex4dv(double[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 * @param w DOCUMENT ME!
	 */
	public native void glVertex4f(float x, float y, float z, float w);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glVertex4fv(float[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 * @param w DOCUMENT ME!
	 */
	public native void glVertex4i(int x, int y, int z, int w);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glVertex4iv(int[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 * @param w DOCUMENT ME!
	 */
	public native void glVertex4s(short x, short y, short z, short w);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param v DOCUMENT ME!
	 */
	public native void glVertex4sv(short[] v);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param width DOCUMENT ME!
	 * @param height DOCUMENT ME!
	 */
	public native void glViewport(int x, int y, int width, int height);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param componentOrPeer DOCUMENT ME!
	 * @param width DOCUMENT ME!
	 * @param height DOCUMENT ME!
	 * @param mode DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native int gljCreateContext(Object componentOrPeer, int width, int height, int mode);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param handle DOCUMENT ME!
	 * @param isApplet DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native boolean gljDeleteContext(int handle, boolean isApplet);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param handle DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native boolean gljFlushBuffer(int handle);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param handle DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native boolean gljMakeCurrent(int handle);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param handle DOCUMENT ME!
	 * @param imageSource DOCUMENT ME!
	 * @param isRGBA DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native boolean gljReadImage(int handle, int[] imageSource, boolean isRGBA);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param handle DOCUMENT ME!
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native boolean gljSetLocation(int handle, int x, int y);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param handle DOCUMENT ME!
	 * @param width DOCUMENT ME!
	 * @param height DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native boolean gljSetSize(int handle, int width, int height);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param nobj DOCUMENT ME!
	 */
	public native void gluBeginCurve(int nobj);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param tess DOCUMENT ME!
	 */
	public native void gluBeginPolygon(int tess);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param nobj DOCUMENT ME!
	 */
	public native void gluBeginSurface(int nobj);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param nobj DOCUMENT ME!
	 */
	public native void gluBeginTrim(int nobj);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param components DOCUMENT ME!
	 * @param width DOCUMENT ME!
	 * @param format DOCUMENT ME!
	 * @param type DOCUMENT ME!
	 * @param data DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native int gluBuild1DMipmaps(int target, int components, int width, int format, int type, byte[] data);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param target DOCUMENT ME!
	 * @param components DOCUMENT ME!
	 * @param width DOCUMENT ME!
	 * @param height DOCUMENT ME!
	 * @param format DOCUMENT ME!
	 * @param type DOCUMENT ME!
	 * @param data DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native int gluBuild2DMipmaps(int target, int components, int width, int height, int format, int type, byte[] data);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param qobj DOCUMENT ME!
	 * @param baseRadius DOCUMENT ME!
	 * @param topRadius DOCUMENT ME!
	 * @param height DOCUMENT ME!
	 * @param slices DOCUMENT ME!
	 * @param stacks DOCUMENT ME!
	 */
	public native void gluCylinder(int qobj, double baseRadius, double topRadius, double height, int slices, int stacks);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param nobj DOCUMENT ME!
	 */
	public native void gluDeleteNurbsRenderer(int nobj);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param state DOCUMENT ME!
	 */
	public native void gluDeleteQuadric(int state);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param tess DOCUMENT ME!
	 */
	public native void gluDeleteTess(int tess);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param qobj DOCUMENT ME!
	 * @param innerRadius DOCUMENT ME!
	 * @param outerRadius DOCUMENT ME!
	 * @param slices DOCUMENT ME!
	 * @param loops DOCUMENT ME!
	 */
	public native void gluDisk(int qobj, double innerRadius, double outerRadius, int slices, int loops);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param nobj DOCUMENT ME!
	 */
	public native void gluEndCurve(int nobj);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param tess DOCUMENT ME!
	 */
	public native void gluEndPolygon(int tess);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param nobj DOCUMENT ME!
	 */
	public native void gluEndSurface(int nobj);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param nobj DOCUMENT ME!
	 */
	public native void gluEndTrim(int nobj);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param errCode DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native String gluErrorString(int errCode);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param nobj DOCUMENT ME!
	 * @param property DOCUMENT ME!
	 * @param value DOCUMENT ME!
	 */
	public native void gluGetNurbsProperty(int nobj, int property, float[] value);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param name DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native String gluGetString(int name);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param nobj DOCUMENT ME!
	 * @param modelMatrix DOCUMENT ME!
	 * @param projMatrix DOCUMENT ME!
	 * @param viewport DOCUMENT ME!
	 */
	public native void gluLoadSamplingMatrices(int nobj, float[] modelMatrix, float[] projMatrix, int[] viewport);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param eyex DOCUMENT ME!
	 * @param eyey DOCUMENT ME!
	 * @param eyez DOCUMENT ME!
	 * @param centerx DOCUMENT ME!
	 * @param centery DOCUMENT ME!
	 * @param centerz DOCUMENT ME!
	 * @param upx DOCUMENT ME!
	 * @param upy DOCUMENT ME!
	 * @param upz DOCUMENT ME!
	 */
	public native void gluLookAt(double eyex, double eyey, double eyez, double centerx, double centery, double centerz, double upx, double upy, double upz);

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native int gluNewNurbsRenderer();

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native int gluNewQuadric();

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native int gluNewTess();

	/**
	 * DOCUMENT ME!
	 * 
	 * @param tess DOCUMENT ME!
	 * @param type DOCUMENT ME!
	 */
	public native void gluNextContour(int tess, int type);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param nobj DOCUMENT ME!
	 * @param nknots DOCUMENT ME!
	 * @param knot DOCUMENT ME!
	 * @param stride DOCUMENT ME!
	 * @param ctlarray DOCUMENT ME!
	 * @param order DOCUMENT ME!
	 * @param type DOCUMENT ME!
	 */
	public native void gluNurbsCurve(int nobj, int nknots, float[] knot, int stride, float[] ctlarray, int order, int type);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param nobj DOCUMENT ME!
	 * @param property DOCUMENT ME!
	 * @param value DOCUMENT ME!
	 */
	public native void gluNurbsProperty(int nobj, int property, float value);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param nobj DOCUMENT ME!
	 * @param sknot_count DOCUMENT ME!
	 * @param sknot DOCUMENT ME!
	 * @param tknot_count DOCUMENT ME!
	 * @param tknot DOCUMENT ME!
	 * @param s_stride DOCUMENT ME!
	 * @param t_stride DOCUMENT ME!
	 * @param ctlarray DOCUMENT ME!
	 * @param sorder DOCUMENT ME!
	 * @param torder DOCUMENT ME!
	 * @param type DOCUMENT ME!
	 */
	public native void gluNurbsSurface(int nobj, int sknot_count, float[] sknot, int tknot_count, float[] tknot, int s_stride, int t_stride, float[] ctlarray, int sorder, int torder, int type);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param left DOCUMENT ME!
	 * @param right DOCUMENT ME!
	 * @param bottom DOCUMENT ME!
	 * @param top DOCUMENT ME!
	 */
	public native void gluOrtho2D(double left, double right, double bottom, double top);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param qobj DOCUMENT ME!
	 * @param innerRadius DOCUMENT ME!
	 * @param outerRadius DOCUMENT ME!
	 * @param slices DOCUMENT ME!
	 * @param loops DOCUMENT ME!
	 * @param startAngle DOCUMENT ME!
	 * @param sweepAngle DOCUMENT ME!
	 */
	public native void gluPartialDisk(int qobj, double innerRadius, double outerRadius, int slices, int loops, double startAngle, double sweepAngle);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param fovy DOCUMENT ME!
	 * @param aspect DOCUMENT ME!
	 * @param zNear DOCUMENT ME!
	 * @param zFar DOCUMENT ME!
	 */
	public native void gluPerspective(double fovy, double aspect, double zNear, double zFar);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param width DOCUMENT ME!
	 * @param height DOCUMENT ME!
	 * @param viewport DOCUMENT ME!
	 */
	public native void gluPickMatrix(double x, double y, double width, double height, int[] viewport);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param objx DOCUMENT ME!
	 * @param objy DOCUMENT ME!
	 * @param objz DOCUMENT ME!
	 * @param modelMatrix DOCUMENT ME!
	 * @param projMatrix DOCUMENT ME!
	 * @param viewport DOCUMENT ME!
	 * @param winx DOCUMENT ME!
	 * @param winy DOCUMENT ME!
	 * @param winz DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native int gluProject(double objx, double objy, double objz, double[] modelMatrix, double[] projMatrix, int[] viewport, double[] winx, double[] winy, double[] winz);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param nobj DOCUMENT ME!
	 * @param count DOCUMENT ME!
	 * @param array DOCUMENT ME!
	 * @param stride DOCUMENT ME!
	 * @param type DOCUMENT ME!
	 */
	public native void gluPwlCurve(int nobj, int count, float[] array, int stride, int type);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param quadObject DOCUMENT ME!
	 * @param drawStyle DOCUMENT ME!
	 */
	public native void gluQuadricDrawStyle(int quadObject, int drawStyle);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param quadObject DOCUMENT ME!
	 * @param normals DOCUMENT ME!
	 */
	public native void gluQuadricNormals(int quadObject, int normals);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param quadObject DOCUMENT ME!
	 * @param orientation DOCUMENT ME!
	 */
	public native void gluQuadricOrientation(int quadObject, int orientation);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param quadObject DOCUMENT ME!
	 * @param textureCoords DOCUMENT ME!
	 */
	public native void gluQuadricTexture(int quadObject, boolean textureCoords);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param qobj DOCUMENT ME!
	 * @param radius DOCUMENT ME!
	 * @param slices DOCUMENT ME!
	 * @param stacks DOCUMENT ME!
	 */
	public native void gluSphere(int qobj, double radius, int slices, int stacks);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param winx DOCUMENT ME!
	 * @param winy DOCUMENT ME!
	 * @param winz DOCUMENT ME!
	 * @param modelMatrix DOCUMENT ME!
	 * @param projMatrix DOCUMENT ME!
	 * @param viewport DOCUMENT ME!
	 * @param objx DOCUMENT ME!
	 * @param objy DOCUMENT ME!
	 * @param objz DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public native int gluUnProject(double winx, double winy, double winz, double[] modelMatrix, double[] projMatrix, int[] viewport, double[] objx, double[] objy, double[] objz);

	/**
	 * DOCUMENT ME!
	 * 
	 * @param size DOCUMENT ME!
	 * @param buffer DOCUMENT ME!
	 */
	private void glSelectBuffer(int size, int[] buffer) {
		// @see: glSelectBufferStart and glSelectBufferEnd
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param errCode DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	private String gluErrorUnicodeStringEXT(int errCode) {
		return null;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param tess DOCUMENT ME!
	 * @param which DOCUMENT ME!
	 * @param value DOCUMENT ME!
	 */
	private void gluGetTessProperty(Object tess, int which, double value) {
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param nobj DOCUMENT ME!
	 * @param which DOCUMENT ME!
	 * @param fn DOCUMENT ME!
	 */
	private void gluNurbsCallback(Object nobj, int which, Object /*callback*/
	fn) {
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param qobj DOCUMENT ME!
	 * @param which DOCUMENT ME!
	 * @param fn DOCUMENT ME!
	 */
	private void gluQuadricCallback(Object qobj, int which, Object /*callback*/
	fn) {
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param format DOCUMENT ME!
	 * @param widthin DOCUMENT ME!
	 * @param heightin DOCUMENT ME!
	 * @param typein DOCUMENT ME!
	 * @param datain DOCUMENT ME!
	 * @param widthout DOCUMENT ME!
	 * @param heightout DOCUMENT ME!
	 * @param typeout DOCUMENT ME!
	 * @param dataout DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	private int gluScaleImage(int format, int widthin, int heightin, int typein, byte[] datain, int widthout, int heightout, int typeout, byte[] dataout) {
		return 0;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param tess DOCUMENT ME!
	 */
	private void gluTessBeginContour(Object tess) {
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param tess DOCUMENT ME!
	 * @param polygon_data DOCUMENT ME!
	 */
	private void gluTessBeginPolygon(Object tess, byte[] polygon_data) {
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param tess DOCUMENT ME!
	 * @param which DOCUMENT ME!
	 * @param fn DOCUMENT ME!
	 */
	private void gluTessCallback(Object tess, int which, Object /*callback*/
	fn) {
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param tess DOCUMENT ME!
	 */
	private void gluTessEndContour(Object tess) {
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param tess DOCUMENT ME!
	 */
	private void gluTessEndPolygon(Object tess) {
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param tess DOCUMENT ME!
	 * @param x DOCUMENT ME!
	 * @param y DOCUMENT ME!
	 * @param z DOCUMENT ME!
	 */
	private void gluTessNormal(Object tess, double x, double y, double z) {
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param tess DOCUMENT ME!
	 * @param which DOCUMENT ME!
	 * @param value DOCUMENT ME!
	 */
	private void gluTessProperty(Object tess, int which, double value) {
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param tess DOCUMENT ME!
	 * @param coords DOCUMENT ME!
	 * @param data DOCUMENT ME!
	 */
	private void gluTessVertex(Object tess, double[] coords, byte[] data) {
	}
}
