package jp.co.sra.jun.collections.linkedlist;

import jp.co.sra.smalltalk.StBlockClosure;

/**
 * JunDoubleLinkedList class
 * 
 *  @author    nisinaka
 *  @created   2002/01/21 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDoubleLinkedList.java,v 8.10 2008/02/20 06:30:52 nisinaka Exp $
 */
public class JunDoubleLinkedList extends JunSingleLinkedList {

	/**
	 * Add an object after the key object.
	 * 
	 * @param addObject java.lang.Object
	 * @param keyObject java.lang.Object
	 */
	public void add_after_(final Object addObject, final Object keyObject) {
		if ((keyObject == null) || firstLink.equals(lastLink) || lastLink.entityObject().equals(keyObject)) {
			this.addLast_(addObject);

			return;
		}

		Object result = this.linksDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunDoubleLink link = (JunDoubleLink) anObject;

				if (link.entityObject().equals(keyObject) == false) {
					return null;
				}

				JunDoubleLink newLink = new JunDoubleLink(addObject, (JunDoubleLink) link.nextLink(), link);

				if (link.nextLink() != null) {
					((JunDoubleLink) link.nextLink()).backLink_(newLink);
				}

				link.nextLink_(newLink);

				return newLink;
			}
		});

		if (result == null) {
			this.addLast_(addObject);
		}
	}

	/**
	 * Add an object before the key object.
	 * 
	 * @param addObject java.lang.Object
	 * @param keyObject java.lang.Object
	 */
	public void add_before_(final Object addObject, final Object keyObject) {
		if ((keyObject == null) || firstLink.equals(lastLink) || firstLink.entityObject().equals(keyObject)) {
			this.addFirst_(addObject);

			return;
		}

		Object result = this.linksDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunDoubleLink link = (JunDoubleLink) anObject;

				if (link.entityObject().equals(keyObject) == false) {
					return null;
				}

				JunDoubleLink newLink = new JunDoubleLink(addObject, link, link.backLink());
				link.backLink().nextLink_(newLink);
				link.backLink_(newLink);

				return newLink;
			}
		});

		if (result == null) {
			this.addFirst_(addObject);
		}
	}

	/**
	 * Add an object to the first place.
	 * 
	 * @param anObject java.lang.Object
	 */
	public void addFirst_(Object anObject) {
		JunDoubleLink aLink = new JunDoubleLink(anObject);

		if (this.isEmpty()) {
			lastLink = aLink;
		} else {
			aLink.nextLink_(firstLink);
			((JunDoubleLink) firstLink).backLink_(aLink);
		}

		firstLink = aLink;
	}

	/**
	 * Add an object to the last place.
	 * 
	 * @param anObject java.lang.Object
	 */
	public void addLast_(Object anObject) {
		JunDoubleLink aLink = new JunDoubleLink(anObject);

		if (this.isEmpty()) {
			firstLink = aLink;
		} else {
			lastLink.nextLink_(aLink);
			aLink.backLink_((JunDoubleLink) lastLink);
		}

		lastLink = aLink;
	}

	/**
	 * Remove the specified object. If the object does not exist, the exception
	 * block will be evaluated.
	 * 
	 * @param anObject java.lang.Object
	 * @param exceptionBlock jp.co.sra.smalltalk.StBlockClosure
	 * 
	 * @return java.lang.Object
	 */
	public Object remove_ifAbsent_(Object anObject, StBlockClosure exceptionBlock) {
		if (this.isEmpty()) {
			return exceptionBlock.value();
		}

		JunDoubleLink curLink = null;

		if (firstLink.entityObject().equals(anObject)) {
			curLink = (JunDoubleLink) firstLink;
			firstLink = curLink.nextLink();

			if (curLink.nextLink() != null) {
				((JunDoubleLink) curLink.nextLink()).backLink_(null);
			}

			if (curLink == lastLink) {
				lastLink = null;
			}
		} else {
			JunDoubleLink preLink = (JunDoubleLink) firstLink;
			curLink = (JunDoubleLink) preLink.nextLink();

			if (curLink == null) {
				return exceptionBlock.value();
			}

			while (curLink.entityObject().equals(anObject) == false) {
				preLink = (JunDoubleLink) preLink.nextLink();
				curLink = (JunDoubleLink) curLink.nextLink();

				if (curLink == null) {
					return exceptionBlock.value();
				}
			}

			preLink.nextLink_(curLink.nextLink());

			if (curLink.nextLink() != null) {
				((JunDoubleLink) curLink.nextLink()).backLink_(preLink);
			}

			if (curLink == lastLink) {
				lastLink = preLink;
			}
		}

		curLink.nextLink_(null);
		curLink.backLink_(null);

		return curLink.entityObject();
	}

	/**
	 * Remove the first object.
	 * 
	 * @return java.lang.Object
	 */
	public Object removeFirst() {
		this.emptyCheck();

		JunDoubleLink oldLink = (JunDoubleLink) firstLink;

		if (firstLink == lastLink) {
			firstLink = null;
			lastLink = null;
		} else {
			firstLink = oldLink.nextLink();
			((JunDoubleLink) oldLink.nextLink()).backLink_(null);
		}

		oldLink.nextLink_(null);
		oldLink.backLink_(null);

		return oldLink.entityObject();
	}

	/**
	 * Remove the last object.
	 * 
	 * @return java.lang.Object
	 */
	public Object removeLast() {
		this.emptyCheck();

		JunDoubleLink oldLink = (JunDoubleLink) lastLink;

		if (firstLink == lastLink) {
			firstLink = null;
			lastLink = null;
		} else {
			lastLink = oldLink.backLink();
			oldLink.backLink().nextLink_(null);
		}

		oldLink.nextLink_(null);
		oldLink.backLink_(null);

		return oldLink.entityObject();
	}

	/**
	 * Enumate the objects in reverse order and evaluate with the block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * 
	 * @return java.lang.Object
	 */
	public Object reverseDo_(StBlockClosure aBlock) {
		JunDoubleLink aLink = (JunDoubleLink) lastLink;

		while (aLink != null) {
			Object result = aBlock.value_(aLink.entityObject());

			if (result != null) {
				return result;
			}

			aLink = aLink.backLink();
		}

		return null;
	}

	/**
	 * Enumarate all the links and evaluate the block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * 
	 * @return java.lang.Object
	 */
	protected Object reverseLinksDo_(StBlockClosure aBlock) {
		JunDoubleLink aLink = (JunDoubleLink) lastLink;

		while (aLink != null) {
			Object result = aBlock.value_(aLink);

			if (result != null) {
				return result;
			}

			aLink = aLink.backLink();
		}

		return null;
	}
}
