package jp.co.sra.jun.collections.sequences;

/**
 * JunLinearEquationsTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1998/10/30 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLinearEquationsTestExamples.java,v 8.10 2008/02/20 06:30:53 nisinaka Exp $
 */
public class JunLinearEquationsTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example0() {
		double[] elements = { 1, -1, 0, 1, 1, 2, 4, -17, 2, -1, 1, -3 };
		JunLinearEquations aMatrix = new JunLinearEquations(3, 4, elements);
		aMatrix.solve();
		System.out.println(aMatrix.printString());

		return (aMatrix._doubleValueAt(0, 0) == 0)
			&& (aMatrix._doubleValueAt(0, 1) == 1)
			&& (aMatrix._doubleValueAt(0, 2) == 0)
			&& (aMatrix._doubleValueAt(0, 3) == -2)
			&& (aMatrix._doubleValueAt(1, 0) == 0)
			&& (aMatrix._doubleValueAt(1, 1) == 0)
			&& (aMatrix._doubleValueAt(1, 2) == 1)
			&& (aMatrix._doubleValueAt(1, 3) == -3)
			&& (aMatrix._doubleValueAt(2, 0) == 1)
			&& (aMatrix._doubleValueAt(2, 1) == 0)
			&& (aMatrix._doubleValueAt(2, 2) == 0)
			&& (aMatrix._doubleValueAt(2, 3) == -1);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		double[] elements = { 1, 3, 5, 7, 11, 13, 17, 19, 29, 31, 37, 41 };
		JunLinearEquations aMatrix = new JunLinearEquations(3, 4, elements);
		aMatrix.solve();
		System.out.println(aMatrix.printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		double[] elements = { 1, 2, 3, 4, 5, 6, 1, 1, 1 };
		JunLinearEquations aMatrix = new JunLinearEquations(3, 3, elements);
		aMatrix.solve();
		System.out.println(aMatrix.printString());

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new JunLinearEquationsTestExamples();
	}
}
