package jp.co.sra.jun.collections.sequences;

import jp.co.sra.smalltalk.*;

/**
 * JunSequence class
 * 
 *  @author    nisinaka
 *  @created   2002/07/18 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSequence.java,v 8.11 2008/02/20 06:30:53 nisinaka Exp $
 */
public abstract class JunSequence extends StObject {
	/**
	 * Enumerate the objects and evaluate the block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @throws jp.co.sra.smalltalk.SmalltalkException
	 * @category enumerating
	 */
	public Object detect_(StBlockClosure aBlock) {
		return this.detect_ifNone_(aBlock, new StBlockClosure() {
			public Object value() {
				throw SmalltalkException.Error("Element not Found");
			}
		});
	}

	/**
	 * Evaluate aBlock with each of the receiver's elements as the argument.
	 * Answer the first element for which aBlock evaluates to true.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param exceptionBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @category enumerating
	 */
	public Object detect_ifNone_(final StBlockClosure aBlock, StBlockClosure exceptionBlock) {
		Object result = this.do_(new StBlockClosure() {
			public Object value_(Object each) {
				return ((Boolean) aBlock.value_(each)).booleanValue() ? each : null;
			}
		});

		return (result == null) ? exceptionBlock.value() : result;
	}

	/**
	 * Emunerate all the elements and evaluate the Block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @category enumerating
	 */
	public abstract Object do_(final StBlockClosure aBlock);
}
