package jp.co.sra.jun.csg.abstracts;

import jp.co.sra.smalltalk.StInterval;
import jp.co.sra.jun.csg.atoms.*;
import jp.co.sra.jun.csg.compound.*;
import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.geometry.boundaries.*;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.metaball.atoms.JunMetaGeometry;

/**
 * JunCSGTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2000/01/05 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCSGTestExamples.java,v 8.10 2008/02/20 06:30:53 nisinaka Exp $
 */
public class JunCSGTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		JunCSGSphere ball = JunCSGSphere.Center_radius_(new Jun3dPoint(0, 0, 0), 1.0d);
		JunSolidCSG bar = JunMetaGeometry.Geometry_order_weight_(new Jun3dLine(new Jun3dPoint(0, 0, -1), new Jun3dPoint(0, 0, 1)), 2, 0.1).asCSGSolidThreshold_(1.0);
		JunCSGDifference difference = new JunCSGDifference(ball, bar);
		difference.asJunBoxelOctreeDepth_bounds_(6, Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(-1.5, -1.5, -1.5), new Jun3dPoint(1.5, 1.5, 1.5))).show();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		JunCSGSphere ball = JunCSGSphere.Center_radius_(new Jun3dPoint(0, 0, 0), 1.0d);
		JunSolidCSG bar = JunMetaGeometry.Geometry_order_weight_(new Jun3dLine(new Jun3dPoint(0, 0, -1), new Jun3dPoint(0, 0, 1)), 2, 0.1).asCSGSolidThreshold_(1.0);
		JunCSGDifference difference = new JunCSGDifference(ball, bar);
		difference.asJunBrepsOctreeDepth_bounds_(4, Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(-1.5, -1.5, -1.5), new Jun3dPoint(1.5, 1.5, 1.5))).show();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		Jun3dPoint carbonPosition = new Jun3dPoint(0.75d, 0.0d, 0.0d);
		Jun3dPoint hydrogenPosition = new Jun3dPoint(1.5d, 0.0d, 0.0d);
		double carbonRadius = 1.0d;
		double hydrogenRadius = carbonRadius * 0.6d;
		JunCSG solid = null;

		for (int each = 60; each <= 360; each += 60) {
			Jun3dTransformation aT = Jun3dTransformation.Rotate_(JunAngle.FromDeg_(each));
			JunCSGSphere carbon = JunCSGSphere.Center_radius_(carbonPosition.transform_(aT), carbonRadius);
			JunCSGSphere hydrogen = JunCSGSphere.Center_radius_(hydrogenPosition.transform_(aT), hydrogenRadius);
			JunCSGUnion ch = new JunCSGUnion(carbon, hydrogen);

			if (solid == null) {
				solid = ch;
			} else {
				solid = new JunCSGUnion(solid, ch);
			}
		}

		StInterval interval = new StInterval(-2, 2.5, Math.sqrt(2) * 0.15);
		solid.asJunOpenGL3dObjectXInterval_yInterval_zInterval_(interval, interval, interval).show();

		return true;
	}

	/**
	 * Create a new instance of JunCSGTestExamples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunCSGTestExamples();
	}
}
