package jp.co.sra.jun.csg.atoms;

import jp.co.sra.jun.csg.abstracts.JunCSG;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;

/**
 * JunCSGSphere class
 * 
 *  @author    nisinaka
 *  @created   1998/10/18 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCSGSphere.java,v 8.10 2008/02/20 06:30:53 nisinaka Exp $
 */
public class JunCSGSphere extends JunCSG {
	protected Jun3dPoint center;
	protected double radius;

	/**
	 * Create a new instance of JunCSGSphere.
	 * 
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aNumber double
	 */
	public JunCSGSphere(Jun3dPoint aJun3dPoint, double aNumber) {
		this.center_(aJun3dPoint);
		this.radius_(aNumber);
	}

	/**
	 * Create a new instance of JunCSGSphere.
	 * 
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aNumber double
	 * 
	 * @return jp.co.sra.jun.csg.atoms.JunCSGSphere
	 */
	public static JunCSGSphere Center_radius_(Jun3dPoint aJun3dPoint, double aNumber) {
		return new JunCSGSphere(aJun3dPoint, aNumber);
	}

	/**
	 * Answer the center point.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public Jun3dPoint center() {
		return center;
	}

	/**
	 * Set the center point.
	 * 
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public void center_(Jun3dPoint aJun3dPoint) {
		center = aJun3dPoint;
	}

	/**
	 * Answer the radius.
	 * 
	 * @return double
	 */
	public double radius() {
		return radius;
	}

	/**
	 * Set the radius.
	 * 
	 * @param aNumber double
	 */
	public void radius_(double aNumber) {
		radius = aNumber;
	}

	/**
	 * Answer a value at the specified point.
	 * 
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * 
	 * @return double
	 */
	public double valueAt_(Jun3dPoint aJun3dPoint) {
		return radius - center.distance_(aJun3dPoint);
	}
}
