package jp.co.sra.jun.csg.atoms;

import jp.co.sra.jun.csg.abstracts.JunCSG;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;

/**
 * JunTransformedCSG class
 * 
 *  @author    nisinaka
 *  @created   1998/10/18 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTransformedCSG.java,v 8.10 2008/02/20 06:30:53 nisinaka Exp $
 */
public class JunTransformedCSG extends JunCSG {
	protected JunCSG csg;
	protected Jun3dTransformation transformationInv;

	/**
	 * Create a new instance of JunTransformedCSG.
	 * 
	 * @param aJunCSG jp.co.sra.jun.csg.abstracts.JunCSG
	 * @param aJun3dTransformation
	 *        jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 */
	public JunTransformedCSG(JunCSG aJunCSG, Jun3dTransformation aJun3dTransformation) {
		this.setCSG_transformation_(aJunCSG, aJun3dTransformation);
	}

	/**
	 * Create a new instance of JunTransformedCSG.
	 * 
	 * @param aJunCSG jp.co.sra.jun.csg.abstracts.JunCSG
	 * @param aJun3dTransformation
	 *        jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * 
	 * @return jp.co.sra.jun.csg.atoms.JunTransformedCSG
	 */
	public static JunTransformedCSG On_transform_(JunCSG aJunCSG, Jun3dTransformation aJun3dTransformation) {
		return new JunTransformedCSG(aJunCSG, aJun3dTransformation);
	}

	/**
	 * Answer the JunCSG which is applied the specified transformation.
	 * 
	 * @param aJun3dTransformation
	 *        jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * 
	 * @return jp.co.sra.jun.csg.abstracts.JunCSG
	 */
	public JunCSG transform_(Jun3dTransformation aJun3dTransformation) {
		return JunTransformedCSG.On_transform_(csg, transformationInv.inverse().transform_(aJun3dTransformation));
	}

	/**
	 * Answer a value at the specified point.
	 * 
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * 
	 * @return double
	 */
	public double valueAt_(Jun3dPoint aJun3dPoint) {
		return csg.valueAt_(aJun3dPoint.transform_(transformationInv));
	}

	/**
	 * Set the attributes of the receiver.
	 * 
	 * @param aJunCSG jp.co.sra.jun.csg.abstracts.JunCSG
	 * @param aJun3dTransformation
	 *        jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 */
	protected void setCSG_transformation_(JunCSG aJunCSG, Jun3dTransformation aJun3dTransformation) {
		csg = aJunCSG;
		transformationInv = aJun3dTransformation.inverse();
	}
}
