package jp.co.sra.jun.delaunay.twoD;

import java.awt.Graphics;
import java.io.IOException;
import java.io.Writer;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * Jun2dDelaunayHalfEdge class
 * 
 *  @author    Ryouichi Matsuda
 *  @created   2002/01/14 (by Ryouichi Matsuda)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun2dDelaunayHalfEdge.java,v 8.11 2008/02/20 06:30:54 nisinaka Exp $
 */
public class Jun2dDelaunayHalfEdge extends JunAbstractObject {
	protected Jun2dDelaunayLoop loop;
	protected Jun2dDelaunayVertex vertex;
	protected Jun2dDelaunayEdge edge;
	protected Jun2dDelaunayHalfEdge pair;
	protected Jun2dDelaunayHalfEdge next;
	protected Jun2dDelaunayHalfEdge prev;

	/**
	 * Create a new instance of <code>Jun2dDelaunayHalfEdge</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public Jun2dDelaunayHalfEdge() {
		super();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param value double
	 * 
	 * @return int
	 */
	protected static int _Sign_(double value) {
		if (value < 0) {
			return -1;
		}

		if (0 < value) {
			return 1;
		}

		return 0;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aJun2dDelaunayVertex jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayVertex
	 * 
	 * @return double
	 */
	public double areaWith_(Jun2dDelaunayVertex aJun2dDelaunayVertex) {
		return this.pair().vertex().areaWith_with_(this.vertex(), aJun2dDelaunayVertex);
	}

	/**
	 * Display the receiver on aGraphics.
	 * 
	 * @param aGraphicsContext java.awt.Graphics
	 */
	public void displayOn_(Graphics aGraphicsContext) {
		aGraphicsContext.drawLine((int) pair.vertex().x(), (int) pair.vertex().y(), (int) vertex.x(), (int) vertex.y());
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * 
	 * @return DOCUMENT ME!
	 */
	public Object do_(StBlockClosure aBlock) {
		Jun2dDelaunayHalfEdge halfEdge;
		Jun2dDelaunayHalfEdge nextHalfEdge;

		halfEdge = this;

		do {
			Object returnObject;

			nextHalfEdge = halfEdge.next();
			returnObject = aBlock.value_(halfEdge);

			if (returnObject != null) {
				return returnObject;
			}

			halfEdge = nextHalfEdge;
		} while (halfEdge != this);

		return null;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayEdge
	 */
	public Jun2dDelaunayEdge edge() {
		return edge;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aJun2dDelaunayVertex1 jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayVertex
	 * @param aJun2dDelaunayVertex2 jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayVertex
	 * 
	 * @return boolan
	 */
	public boolean intersectsWithLineSegmentFrom_to_(Jun2dDelaunayVertex aJun2dDelaunayVertex1, Jun2dDelaunayVertex aJun2dDelaunayVertex2) {
		Jun2dDelaunayVertex myV1;
		Jun2dDelaunayVertex myV2;
		Jun2dDelaunayVertex yourV1;
		Jun2dDelaunayVertex yourV2;

		myV1 = this.vertex();
		myV2 = this.pair().vertex();
		yourV1 = aJun2dDelaunayVertex1;
		yourV2 = aJun2dDelaunayVertex2;

		return (_Sign_(myV1.areaWith_with_(yourV1, yourV2)) != _Sign_(myV2.areaWith_with_(yourV1, yourV2))) && (_Sign_(yourV1.areaWith_with_(myV1, myV2)) != _Sign_(yourV2.areaWith_with_(myV1, myV2)));
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayLoop
	 */
	public Jun2dDelaunayLoop loop() {
		return loop;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aJun2dDelaunayLoop jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayLoop
	 */
	public void loop_(Jun2dDelaunayLoop aJun2dDelaunayLoop) {
		loop = aJun2dDelaunayLoop;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayHalfEdge
	 */
	public Jun2dDelaunayHalfEdge next() {
		return next;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aJun2dDelaunayHalfEdge
	 *        jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayHalfEdge
	 */
	public void next_(Jun2dDelaunayHalfEdge aJun2dDelaunayHalfEdge) {
		this.setNext_(aJun2dDelaunayHalfEdge);
		aJun2dDelaunayHalfEdge.setPrev_(this);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayHalfEdge
	 */
	public Jun2dDelaunayHalfEdge pair() {
		return pair;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayHalfEdge
	 */
	public Jun2dDelaunayHalfEdge prev() {
		return prev;
	}

	/**
	 * Print my string representation on aWriter.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws IOException DOCUMENT ME!
	 * @see jp.co.sra.smalltalk.StObject#printOn_(java.io.Writer)
	 * @category printing
	 */
	public void printOn_(Writer aWriter) throws IOException {
		aWriter.write("HalfEdge(");
		aWriter.write(Double.toString(pair.vertex().x()));
		aWriter.write("@");
		aWriter.write(Double.toString(pair.vertex().y()));
		aWriter.write(" ");
		aWriter.write(Double.toString(this.vertex().x()));
		aWriter.write("@");
		aWriter.write(Double.toString(this.vertex().y()));
		aWriter.write(")");
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayVertex
	 */
	public Jun2dDelaunayVertex vertex() {
		return vertex;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aJun2dDelaunayVertex jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayVertex
	 */
	public void vertex_(Jun2dDelaunayVertex aJun2dDelaunayVertex) {
		vertex = aJun2dDelaunayVertex;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aJun2dDelaunayEdge jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayEdge
	 */
	protected void setEdge_(Jun2dDelaunayEdge aJun2dDelaunayEdge) {
		edge = aJun2dDelaunayEdge;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aJun2dDelaunayHalfEdge
	 *        jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayHalfEdge
	 */
	protected void setNext_(Jun2dDelaunayHalfEdge aJun2dDelaunayHalfEdge) {
		next = aJun2dDelaunayHalfEdge;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aJun2dDelaunayHalfEdge
	 *        jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayHalfEdge
	 */
	protected void setPair_(Jun2dDelaunayHalfEdge aJun2dDelaunayHalfEdge) {
		pair = aJun2dDelaunayHalfEdge;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aJun2dDelaunayHalfEdge
	 *        jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayHalfEdge
	 */
	protected void setPrev_(Jun2dDelaunayHalfEdge aJun2dDelaunayHalfEdge) {
		prev = aJun2dDelaunayHalfEdge;
	}
}
