package jp.co.sra.jun.delaunay.twoD;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * Jun2dDelaunayProcessorTestExamples class
 * 
 *  @author    Ryouichi Matsuda
 *  @created   2002/03/03 (by Ryouichi Matsuda)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun2dDelaunayProcessorTestExamples.java,v 8.12 2008/02/20 06:30:54 nisinaka Exp $
 */
public class Jun2dDelaunayProcessorTestExamples extends JunTestExamples {
	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		class CanvasExample extends Canvas implements Runnable {
			protected Jun2dBoundingBox bounds;
			protected Jun2dDelaunayProcessor processor;
			protected Thread thread;

			public void run() {
				while (thread != null) {
					this.repaint();
					thread.yield();
				}
			}

			public void start() {
				thread = new Thread(this);
				thread.setPriority(Thread.MIN_PRIORITY);
				thread.start();
			}

			public void stop() {
				thread = null;
			}

			public void paint(final Graphics gc) {
				if (processor == null) {
					Jun2dPoint originPoint = new Jun2dPoint(0, 0);
					Jun2dPoint extentPoint = new Jun2dPoint(this.getSize().width, this.getSize().height);
					bounds = Jun2dBoundingBox.Origin_extent_(originPoint, extentPoint).expandedBy_(-2);
					processor = new Jun2dDelaunayProcessor(bounds);
					bounds = bounds.expandedBy_(-10);
				}

				double x = (Math.random() * bounds.width()) + bounds.origin().x();
				double y = (Math.random() * bounds.height()) + bounds.origin().y();
				processor.insertPoint_(new Jun2dPoint(x, y));
				gc.setClip(0, 0, this.getSize().width, this.getSize().height);
				gc.clearRect(0, 0, this.getSize().width, this.getSize().height);
				processor.displayOn_(gc);
			}
		}

		final CanvasExample canvas = new CanvasExample();
		Frame frame = new Frame();
		frame.setSize(400, 400);
		frame.setLayout(new BorderLayout());
		frame.add(canvas, BorderLayout.CENTER);
		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				canvas.stop();
				e.getWindow().dispose();
			}
		});
		frame.setVisible(true);
		canvas.start();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		Frame frame = new Frame();
		Canvas canvas = new Canvas() {
			public void paint(final Graphics gc) {
				Jun2dPoint originPoint = new Jun2dPoint(0, 0);
				Jun2dPoint extentPoint = new Jun2dPoint(this.getSize().width, this.getSize().height);
				Jun2dBoundingBox bounds = Jun2dBoundingBox.Origin_extent_(originPoint, extentPoint).expandedBy_(-2);
				Jun2dDelaunayProcessor processor = new Jun2dDelaunayProcessor(bounds);
				bounds = bounds.expandedBy_(-10);

				//
				Jun2dPoint center = new Jun2dPoint((int) bounds.center().x(), (int) bounds.center().y());
				double f = Math.min(bounds.height(), bounds.width()) / 4.0d;
				Jun2dPoint[] points = new Jun2dPoint[12];
				points[0] = new Jun2dPoint(-0.3, 1).multipliedBy_(f).plus_(center);
				points[1] = new Jun2dPoint(0.3, 1).multipliedBy_(f).plus_(center);
				points[2] = new Jun2dPoint(0.3, 0).multipliedBy_(f).plus_(center);
				points[3] = new Jun2dPoint(0.2, 0).multipliedBy_(f).plus_(center);
				points[4] = new Jun2dPoint(0.2, 0.9).multipliedBy_(f).plus_(center);
				points[5] = new Jun2dPoint(0.05, 0.9).multipliedBy_(f).plus_(center);
				points[6] = new Jun2dPoint(0.05, -1).multipliedBy_(f).plus_(center);
				points[7] = new Jun2dPoint(-0.05, -1).multipliedBy_(f).plus_(center);
				points[8] = new Jun2dPoint(-0.05, 0.9).multipliedBy_(f).plus_(center);
				points[9] = new Jun2dPoint(-0.2, 0.9).multipliedBy_(f).plus_(center);
				points[10] = new Jun2dPoint(-0.2, 0).multipliedBy_(f).plus_(center);
				points[11] = new Jun2dPoint(-0.3, 0).multipliedBy_(f).plus_(center);
				processor.insertPolygon_(points);

				//
				gc.setClip(0, 0, this.getSize().width, this.getSize().height);
				gc.clearRect(0, 0, this.getSize().width, this.getSize().height);
				gc.setColor(Color.blue);
				processor.insideTrianglesDo_(new StBlockClosure() {
					public Object value_value_value_(Object p1_, Object p2_, Object p3_) {
						Jun2dPoint p1 = (Jun2dPoint) p1_;
						Jun2dPoint p2 = (Jun2dPoint) p2_;
						Jun2dPoint p3 = (Jun2dPoint) p3_;
						int[] xPoints = { (int) p1.x(), (int) p2.x(), (int) p3.x() };
						int[] yPoints = { (int) p1.y(), (int) p2.y(), (int) p3.y() };
						int nPoints = 3;
						gc.fillPolygon(xPoints, yPoints, nPoints);

						return null;
					}
				});
				gc.setColor(Color.black);
				processor.displayOn_(gc);
			}
		};

		frame.setSize(400, 400);
		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		frame.setLayout(new BorderLayout());
		frame.add(canvas, BorderLayout.CENTER);
		frame.setVisible(true);

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		Frame frame = new Frame();
		frame.setSize(400, 400);
		frame.setLayout(new BorderLayout());

		final Canvas canvas = new Canvas() {
			public void paint(final Graphics gc) {
				final Dimension size = this.getSize();
				Jun2dPoint originPoint = new Jun2dPoint(0, 0);
				Jun2dPoint extentPoint = new Jun2dPoint(size.width, size.height);
				Jun2dBoundingBox bounds = Jun2dBoundingBox.Origin_extent_(originPoint, extentPoint).expandedBy_(-2);
				Jun2dDelaunayProcessor processor = new Jun2dDelaunayProcessor(bounds);
				bounds = bounds.expandedBy_(-30);

				gc.setClip(0, 0, size.width, size.height);
				gc.clearRect(0, 0, size.width, size.height);
				processor.displayOn_(gc);

				Jun2dPoint center = bounds.center();
				double maxR = Math.min(bounds.height(), bounds.width()) / 2.0d;
				Jun2dPoint[] points = new Jun2dPoint[100];

				for (int i = 0; i < 100; i++) {
					double a = i / 100.0d;
					double angle = Math.PI * 2.0d * a;
					double r = (Math.random() * 0.2 + 0.8) * maxR;
					points[i] = new Jun2dPoint(Math.cos(angle) * r, Math.sin(angle) * r).plus_(center);
				}

				processor.insertPolygon_interim_(points, new StBlockClosure() {
					public Object value_(Object p_) {
						Jun2dDelaunayProcessor p = (Jun2dDelaunayProcessor) p_;
						gc.clearRect(0, 0, size.width, size.height);
						p.displayOn_(gc);

						return null;
					}
				});

				for (int i = 0; i < 100; i++) {
					double a = i / 100.0d;
					double angle = Math.PI * 2.0d * a;
					double r = (Math.random() * 0.5 + 0.3) * maxR;
					points[i] = new Jun2dPoint(Math.cos(angle) * r, Math.sin(angle) * r).plus_(center);
				}

				processor.insertPolygon_interim_(points, new StBlockClosure() {
					public Object value_(Object p_) {
						Jun2dDelaunayProcessor p = (Jun2dDelaunayProcessor) p_;
						gc.clearRect(0, 0, size.width, size.height);
						p.displayOn_(gc);

						return null;
					}
				});
				gc.clearRect(0, 0, size.width, size.height);
				gc.setColor(Color.blue);
				processor.insideTrianglesDo_(new StBlockClosure() {
					public Object value_value_value_(Object p1_, Object p2_, Object p3_) {
						Jun2dPoint p1 = (Jun2dPoint) p1_;
						Jun2dPoint p2 = (Jun2dPoint) p2_;
						Jun2dPoint p3 = (Jun2dPoint) p3_;
						int[] xPoints = { (int) p1.x(), (int) p2.x(), (int) p3.x() };
						int[] yPoints = { (int) p1.y(), (int) p2.y(), (int) p3.y() };
						int nPoints = 3;
						gc.fillPolygon(xPoints, yPoints, nPoints);

						return null;
					}
				});
				gc.setColor(Color.black);
				processor.displayOn_(gc);
			}
		};

		frame.add(canvas, BorderLayout.CENTER);
		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		frame.setVisible(true);

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		Frame frame = new Frame();
		frame.setSize(400, 400);
		frame.setLayout(new BorderLayout());

		final Canvas canvas = new Canvas() {
			public void paint(final Graphics gc) {
				final Dimension size = this.getSize();
				Jun2dPoint originPoint = new Jun2dPoint(0, 0);
				Jun2dPoint extentPoint = new Jun2dPoint(size.width, size.height);
				Jun2dBoundingBox bounds = Jun2dBoundingBox.Origin_extent_(originPoint, extentPoint).expandedBy_(-2);
				Jun2dDelaunayProcessor processor = new Jun2dDelaunayProcessor(bounds);
				bounds = bounds.expandedBy_(-30);

				gc.setClip(0, 0, size.width, size.height);
				gc.clearRect(0, 0, size.width, size.height);
				processor.displayOn_(gc);

				Jun2dPoint center = bounds.center();
				double maxR = Math.min(bounds.height(), bounds.width()) / 2.0d;
				Jun2dPoint[] points = new Jun2dPoint[100];

				for (int i = 0; i < 100; i++) {
					double a = i / 100.0d;
					double angle = Math.PI * 2.0d * a;
					double r = (Math.random() * 0.2 + 0.3) * maxR;
					points[i] = new Jun2dPoint(Math.cos(angle) * r, Math.sin(angle) * r).plus_(new Jun2dPoint(center.x() * 0.9, center.y()));
				}

				processor.insertPolygon_interim_(points, new StBlockClosure() {
					public Object value_(Object p_) {
						Jun2dDelaunayProcessor p = (Jun2dDelaunayProcessor) p_;
						gc.clearRect(0, 0, size.width, size.height);
						p.displayOn_(gc);

						return null;
					}
				});

				for (int i = 0; i < 100; i++) {
					double a = i / 100.0d;
					double angle = Math.PI * 2.0d * a;
					double r = (Math.random() * 0.2 + 0.3) * maxR;
					points[i] = new Jun2dPoint(Math.cos(angle) * r, Math.sin(angle) * r).plus_(new Jun2dPoint(center.x() * 1.1, center.y()));
				}

				processor.insertPolygon_interim_(points, new StBlockClosure() {
					public Object value_(Object p_) {
						Jun2dDelaunayProcessor p = (Jun2dDelaunayProcessor) p_;
						gc.clearRect(0, 0, size.width, size.height);
						p.displayOn_(gc);

						return null;
					}
				});
				gc.clearRect(0, 0, size.width, size.height);
				gc.setColor(Color.blue);
				processor.insideTrianglesDo_(new StBlockClosure() {
					public Object value_value_value_(Object p1_, Object p2_, Object p3_) {
						Jun2dPoint p1 = (Jun2dPoint) p1_;
						Jun2dPoint p2 = (Jun2dPoint) p2_;
						Jun2dPoint p3 = (Jun2dPoint) p3_;
						int[] xPoints = { (int) p1.x(), (int) p2.x(), (int) p3.x() };
						int[] yPoints = { (int) p1.y(), (int) p2.y(), (int) p3.y() };
						int nPoints = 3;
						gc.fillPolygon(xPoints, yPoints, nPoints);

						return null;
					}
				});
				gc.setColor(Color.black);
				processor.displayOn_(gc);
			}
		};

		frame.add(canvas, BorderLayout.CENTER);
		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		frame.setVisible(true);

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		Frame frame = new Frame();
		frame.setSize(400, 400);
		frame.setLayout(new BorderLayout());

		final Canvas canvas = new Canvas() {
			public void paint(final Graphics gc) {
				final Dimension size = this.getSize();
				Jun2dPoint originPoint = new Jun2dPoint(0, 0);
				Jun2dPoint extentPoint = new Jun2dPoint(size.width, size.height);
				Jun2dBoundingBox bounds = Jun2dBoundingBox.Origin_extent_(originPoint, extentPoint).expandedBy_(-2);
				Jun2dDelaunayProcessor processor = new Jun2dDelaunayProcessor(bounds);
				bounds = bounds.expandedBy_(-30);

				gc.setClip(0, 0, size.width, size.height);
				gc.clearRect(0, 0, size.width, size.height);
				processor.displayOn_(gc);

				Jun2dPoint center = bounds.center();
				double maxR = Math.min(bounds.height(), bounds.width()) / 2.0d;
				Jun2dPoint[] points = new Jun2dPoint[40];

				for (int i = 0; i < 40; i++) {
					points[i] = new Jun2dPoint(((Math.random() * 2.0d - 1.0d) * maxR) + center.x(), ((Math.random() * 2.0d - 1.0d) * maxR) + center.y());
				}

				processor.insertPolygon_interim_(points, new StBlockClosure() {
					public Object value_(Object p_) {
						Jun2dDelaunayProcessor p = (Jun2dDelaunayProcessor) p_;
						gc.clearRect(0, 0, size.width, size.height);
						p.displayOn_(gc);

						return null;
					}
				});
				gc.clearRect(0, 0, size.width, size.height);
				gc.setColor(Color.blue);
				processor.insideTrianglesDo_(new StBlockClosure() {
					public Object value_value_value_(Object p1_, Object p2_, Object p3_) {
						Jun2dPoint p1 = (Jun2dPoint) p1_;
						Jun2dPoint p2 = (Jun2dPoint) p2_;
						Jun2dPoint p3 = (Jun2dPoint) p3_;
						int[] xPoints = { (int) p1.x(), (int) p2.x(), (int) p3.x() };
						int[] yPoints = { (int) p1.y(), (int) p2.y(), (int) p3.y() };
						int nPoints = 3;
						gc.fillPolygon(xPoints, yPoints, nPoints);

						return null;
					}
				});
				gc.setColor(Color.black);
				processor.displayOn_(gc);
			}
		};

		frame.add(canvas, BorderLayout.CENTER);
		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		frame.setVisible(true);

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new Jun2dDelaunayProcessorTestExamples();
	}
}
