package jp.co.sra.jun.geometry.boundaries;

import java.awt.Rectangle;
import java.io.IOException;

import jp.co.sra.smalltalk.StRectangle;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunBorderVertex class
 * 
 *  @author    Hirotsugu Kondo
 *  @created   1999/01/08 (by Hirotsugu Kondo)
 *  @updated   2002/01/21 (by nisinaka)
 *  @updated   2007/07/03 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunBorderVertex.java,v 8.12 2008/02/20 06:30:56 nisinaka Exp $
 */
public class JunBorderVertex extends JunAbstractObject {

	protected Jun3dPoint vertex1;
	protected Jun3dPoint vertex2;
	protected double label;

	/**
	 * Create a new instance of <code>JunBorderVertex</code> and initialize it.
	 * 
	 * @param aPoint1 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aPoint2 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aNumber double
	 * @category Instance creation
	 */
	public JunBorderVertex(Jun3dPoint aPoint1, Jun3dPoint aPoint2, double aNumber) {
		super();
		this.vertex1_(aPoint1);
		this.vertex2_(aPoint2);
		this.label_(aNumber);
	}

	/**
	 * Create a new instance of <code>JunBorderVertex</code> and initialize it.
	 * 
	 * @param aPoint1 jp.co.sra.jun.geometry.basic.JunPoint
	 * @param aPoint2 jp.co.sra.jun.geometry.basic.JunPoint
	 * @param aNumber double
	 * @return jp.co.sra.jun.geometry.boundaries.JunBorderVertex
	 * @category Instance creation
	 */
	public static JunBorderVertex Vertex_vertex_label_(JunPoint aPoint1, JunPoint aPoint2, double aNumber) {
		return new JunBorderVertex((Jun3dPoint) aPoint1, (Jun3dPoint) aPoint2, aNumber);
	}

	/**
	 * Answer my current vertex1.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category accessing
	 */
	public Jun3dPoint vertex1() {
		return vertex1;
	}

	/**
	 * Set my new vertex1.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category accessing
	 */
	public void vertex1_(Jun3dPoint aPoint) {
		vertex1 = aPoint;
	}

	/**
	 * Answer my current vertex2.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category accessing
	 */
	public Jun3dPoint vertex2() {
		return vertex2;
	}

	/**
	 * Set my new vertex2.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category accessing
	 */
	public void vertex2_(Jun3dPoint aPoint) {
		vertex2 = aPoint;
	}

	/**
	 * Answer my current label.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double label() {
		return label;
	}

	/**
	 * Set my new label.
	 * 
	 * @param aNumber double
	 * @category accessing
	 */
	public void label_(double aNumber) {
		label = aNumber;
	}

	/**
	 * Answer true if the object is equal to the receiver, otherwise false.
	 * 
	 * @param anObject java.lang.Object
	 * @return boolean
	 * @see java.lang.Object#equals(java.lang.Object)
	 * @category comparing
	 */
	public boolean equals(Object anObject) {
		if (anObject.getClass() != this.getClass()) {
			return false;
		}

		JunBorderVertex aBorderVertex = (JunBorderVertex) anObject;
		return (vertex1.equals(aBorderVertex.vertex1) && vertex2.equals(aBorderVertex.vertex2) && (label == aBorderVertex.label));
	}

	/**
	 * Computes a hash code for this object.
	 * 
	 * @return int
	 * @see java.lang.Object#hashCode()
	 * @category comparing
	 */
	public int hashCode() {
		return vertex1.hashCode();
	}

	/**
	 * Answer true if the x values of the vertex equals to the number.
	 * 
	 * @param aNumber double
	 * @return boolean
	 * @category testing
	 */
	public boolean onX_(double aNumber) {
		return vertex1.x() == aNumber && vertex2.x() == aNumber;
	}

	/**
	 * Answer true if the y values of the vertex equals to the number.
	 * 
	 * @param aNumber double
	 * @return boolean
	 * @category testing
	 */
	public boolean onY_(double aNumber) {
		return vertex1.y() == aNumber && vertex2.y() == aNumber;
	}

	/**
	 * Answer true if the z values of the vertex equals to the number.
	 * 
	 * @param aNumber double
	 * @return boolean
	 * @category testing
	 */
	public boolean onZ_(double aNumber) {
		return vertex1.z() == aNumber && vertex2.z() == aNumber;
	}

	/**
	 * Answer true if the receiver is on the border of the specified rectangle, otherwise false.
	 * 
	 * @param aRectangle jp.co.sra.smalltalk.StRectangle
	 * @return boolean
	 * @category testing
	 */
	public boolean onBorderOfRectangle_(StRectangle aRectangle) {
		return this.onX_(aRectangle.left()) || this.onX_(aRectangle.right()) || this.onX_(aRectangle.top()) || this.onX_(aRectangle.bottom());
	}

	/**
	 * Answer true if the vertex in on the border of the specified rectangle.
	 * 
	 * @param aRectangle java.awt.Rectangle
	 * @return boolean
	 * @category testing
	 */
	public boolean onBorderOfRectangle_(Rectangle aRectangle) {
		return this.onBorderOfRectangle_(new StRectangle(aRectangle));
	}

	/**
	 * Answer true if the receiver is on the corner of the specified rectangle, otherwise false.
	 * 
	 * @param aRectangle jp.co.sra.smalltalk.StRectangle
	 * @return boolean
	 * @category testing
	 */
	public boolean onCornerOfRectangle_(StRectangle aRectangle) {
		return (this.onX_(aRectangle.left()) || this.onX_(aRectangle.right())) && (this.onY_(aRectangle.top()) || this.onY_(aRectangle.bottom()));
	}

	/**
	 * Print my string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws java.io.IOException
	 * @see jp.co.sra.smalltalk.StObject#printOn_(java.io.Writer)
	 * @category printing
	 */
	public void printOn_(java.io.Writer aWriter) throws IOException {
		aWriter.write("JunBorderVertex (");
		aWriter.write(this.vertex1() + ",");
		aWriter.write(this.vertex2() + ",");
		aWriter.write(this.label() + ")");
	}

}
