package jp.co.sra.jun.geometry.boxtree;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StInterval;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.utilities.JunControlUtility;
import jp.co.sra.jun.goodies.utilities.JunImageUtility;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dVertex;

/**
 * Jun3dBoundingBoxTreeTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/06/26 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun666 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun3dBoundingBoxTreeTestExamples.java,v 8.5 2008/02/20 06:30:56 nisinaka Exp $
 */
public class Jun3dBoundingBoxTreeTestExamples extends Jun3dBoundingBoxNodeTestExamples {
	/**
	 * Example1: Example point collection of 3D line.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		Jun3dBoundingBoxTree boundingBoxTree = new Jun3dBoundingBoxTree(ExamplePointCollectionOf3dLine());
		Jun3dBoundingBoxTreeTestExamples.ExampleDisplay_levelInterval_(boundingBoxTree, new StInterval(2, 18));

		return true;
	}

	/**
	 * Example2: Example point collection of 3D sin curve.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		Jun3dBoundingBoxTree boundingBoxTree = new Jun3dBoundingBoxTree(ExamplePointCollectionOf3dSinCurve());
		Jun3dBoundingBoxTreeTestExamples.ExampleDisplay_levelInterval_(boundingBoxTree, new StInterval(2, 18));

		return true;
	}

	/**
	 * Example3: Example point collection of 3D half ball.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		Jun3dBoundingBoxTree boundingBoxTree = new Jun3dBoundingBoxTree(ExamplePointCollectionOf3dHalfBall());
		Jun3dBoundingBoxTreeTestExamples.ExampleDisplay_levelInterval_(boundingBoxTree, new StInterval(4, 18));

		return true;
	}

	/**
	 * Example4: Example segment collection of 3D line.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		Jun3dBoundingBoxTree boundingBoxTree = new Jun3dBoundingBoxTree(ExampleSegmentCollectionOf3dLine());
		Jun3dBoundingBoxTreeTestExamples.ExampleDisplay_levelInterval_(boundingBoxTree, new StInterval(2, 18));

		return true;
	}

	/**
	 * Example5: Example segment collection of 3D sin curve.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		Jun3dBoundingBoxTree boundingBoxTree = new Jun3dBoundingBoxTree(ExampleSegmentCollectionOf3dSinCurve());
		Jun3dBoundingBoxTreeTestExamples.ExampleDisplay_levelInterval_(boundingBoxTree, new StInterval(2, 18));

		return true;
	}

	/**
	 * Example6: Example patch collection of 3D half ball.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		Jun3dBoundingBoxTree boundingBoxTree = new Jun3dBoundingBoxTree(ExamplePatchCollectionOf3dHalfBall());
		Jun3dBoundingBoxTreeTestExamples.ExampleDisplay_levelInterval_(boundingBoxTree, new StInterval(4, 18));

		return true;
	}

	/**
	 * Example7: Example patch collection of 3D half ball.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example7() {
		Jun3dBoundingBoxTree boundingBoxTree = new Jun3dBoundingBoxTree(ExamplePatchCollectionOf3dHalfBall());
		boundingBoxTree.asJunOpenGL3dObject().showWithAxes();
		
		boundingBoxTree.rootNode().messageToSubdivide_($("subdivide"));
		boundingBoxTree.rootNode().compareWithBlock_(new StBlockClosure() {
			public Object value_value_(Object object, Object box) {
				Jun3dTriangle geometry = (Jun3dTriangle) object;
				Jun3dBoundingBox boundingBox = (Jun3dBoundingBox) box;
				Set set = new HashSet();
				Jun3dTriangle[] triangles = geometry.detailedTrianglesLevel_(1);
				for (int i = 0; i < triangles.length; i++) {
					Jun3dPoint[] points = triangles[i].points();
					for (int j = 0; j < points.length; j++) {
						set.add(points[j]);
					}
				}
				Jun3dPoint[] points = (Jun3dPoint[]) set.toArray(new Jun3dPoint[set.size()]);
				boolean containsPoint = false;
				for (int i = 0; i < points.length; i++) {
					if (boundingBox.containsPoint_(points[i])) {
						containsPoint = true;
						break;
					}
				}
				return new Boolean(containsPoint);
			}
		});
		Jun3dBoundingBoxTreeTestExamples.ExampleDisplay_levelInterval_(boundingBoxTree, new StInterval(0, 4));

		return true;
	}

	/**
	 * Example8: Example patch collection of 3D polyline.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example8() {
		Jun3dBoundingBoxTree boundingBoxTree = new Jun3dBoundingBoxTree(ExamplePatchCollectionOf3dPolyline());
		boundingBoxTree.rootNode().messageToSubdivide_($("subdivide"));
		Jun3dBoundingBoxTreeTestExamples.ExampleDisplay_levelInterval_(boundingBoxTree, new StInterval(0, 4));

		return true;
	}

	/**
	 * Example: Display the specified bounding box node with interval parameter.
	 * 
	 * @param boundingBoxTree jp.co.sra.jun.geometry.boxtree.Jun3dBoundingBoxTree
	 * @param anInterval jp.co.sra.smalltalk.StInterval
	 * @return jp.co.sra.jun.geometry.boxtree.Jun3dBoundingBoxTree
	 * @category Examples
	 */
	protected static Jun3dBoundingBoxTree ExampleDisplay_levelInterval_(Jun3dBoundingBoxTree boundingBoxTree, StInterval anInterval) {
		JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel();
		displayModel.openIn_(new Rectangle(200, 100, 600 + 6, 400 + 26));
		((Frame) displayModel.getWindow()).setTitle("Bounding Box Tree");
		for (int levelNumber = (int) Math.round(anInterval.start()); levelNumber <= anInterval.last(); levelNumber = levelNumber + (int) anInterval.step()) {
			JunCursors cursor = new JunCursors(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
			try {
				cursor._show();
				boundingBoxTree.subdividedNodesLevel_(levelNumber);
			} finally {
				cursor._restore();
			}
			ExampleDisplay_with_(displayModel, boundingBoxTree);

			StImage anImage = StImage._OfArea(displayModel.getWindow().getBounds());
			try {
				JunImageUtility.WriteImage_to_(anImage, new File(String.valueOf(levelNumber) + ".bmp"));
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return boundingBoxTree;
	}

	/**
	 * Example: Display a <code>JunOpenGLDisplayModel</code> with the specified bounding box tree.
	 * 
	 * @param displayModel jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @param boundingBoxTree jp.co.sra.jun.geometry.boxtree.Jun3dBoundingBoxTree
	 * @category Examples
	 */
	protected static void ExampleDisplay_with_(final JunOpenGLDisplayModel displayModel, final Jun3dBoundingBoxTree boundingBoxTree) {
		final JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		JunOpenGL3dCompoundObject subObject = new JunOpenGL3dCompoundObject();
		JunGeometry[] objects = boundingBoxTree.containedObjects();
		for (int i = 0; i < objects.length; i++) {
			JunOpenGL3dObject body = null;
			if (objects[i].isPoint()) {
				JunOpenGL3dVertex vertext = (JunOpenGL3dVertex) objects[i].asJunOpenGL3dObjectColor_(Color.gray);
				vertext.size_(3);
				body = vertext;
			}
			if (objects[i].isLine()) {
				JunOpenGL3dCompoundObject compoundBody = new JunOpenGL3dCompoundObject();
				Jun3dLine object = (Jun3dLine) objects[i];
				JunOpenGL3dPolyline line = (JunOpenGL3dPolyline) object.asJunOpenGL3dObjectColor_(Color.black);
				line.lineWidth_(2);
				compoundBody = line.asCompoundObject();
				JunOpenGL3dVertex from = (JunOpenGL3dVertex) object.from().asJunOpenGL3dObjectColor_(Color.black);
				from.size_(3);
				compoundBody.add_(from);
				JunOpenGL3dVertex last = (JunOpenGL3dVertex) object.last().asJunOpenGL3dObjectColor_(Color.black);
				last.size_(3);
				compoundBody.add_(last);
				body = compoundBody;
			}
			if (objects[i].isTriangle()) {
				JunOpenGL3dCompoundObject compoundBody = new JunOpenGL3dCompoundObject();
				Jun3dTriangle object = (Jun3dTriangle) objects[i];
				JunOpenGL3dPolyline polyline = new JunOpenGL3dPolyline(object.asPointArray());
				polyline.paint_(Color.gray);
				polyline.lineWidth_(1);
				compoundBody.add_(polyline);
				JunOpenGL3dVertex p1 = (JunOpenGL3dVertex) object.p3().asJunOpenGL3dObjectColor_(Color.black);
				p1.size_(3);
				compoundBody.add_(p1);
				JunOpenGL3dVertex p2 = (JunOpenGL3dVertex) object.p3().asJunOpenGL3dObjectColor_(Color.black);
				p2.size_(3);
				compoundBody.add_(p2);
				JunOpenGL3dVertex p3 = (JunOpenGL3dVertex) object.p3().asJunOpenGL3dObjectColor_(Color.black);
				p3.size_(3);
				compoundBody.add_(p3);
				body = compoundBody;
			}
			if (body != null) {
				subObject.add_(body);
			}
		}

		compoundObject.add_(subObject);
		compoundObject.add_(boundingBoxTree.asJunOpenGL3dObject());

		subObject = (JunOpenGL3dCompoundObject) JunOpenGL3dObject.XyzUnitArrows().scaledBy_(boundingBoxTree.boundingBox().extent());
		compoundObject.add_(subObject);

		JunControlUtility.Do_forMilliseconds_(new StBlockClosure() {
			public Object value() {
				displayModel.displayObject_(compoundObject);
				displayModel.resetView();
				System.out.print("level ");
				System.out.print(Integer.toString(boundingBoxTree.levelNumber()));
				System.out.print(" -> ");
				System.out.print(Integer.toString(boundingBoxTree.subdividedNodes().length));
				System.out.println(boundingBoxTree.subdividedNodes().length > 1 ? " boxes" : " box");
				return null;
			}
		}, 2000);
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new Jun3dBoundingBoxTreeTestExamples();
	}
}
