package jp.co.sra.jun.geometry.coordinate;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;

/**
 * JunLocalGeometry class
 * 
 *  @author    nisinaka
 *  @created   1998/09/28 (by nisinaka)
 *  @updated   2000/01/06 (by nisinaka)
 *  @updated   2004/10/20 (by Mitsuhiro Asada)
 *  @updated   2006/10/11 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun610 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLocalGeometry.java,v 8.11 2008/02/20 06:30:57 nisinaka Exp $
 */
public class JunLocalGeometry extends JunGeometry {

	protected JunGeometry geometry;
	protected JunCoordinateSystem coordinateSystem;

	/**
	 * Create an local geometry with a specified geometry and a coordinate system.
	 * 
	 * @param aClass java.lang.Class
	 * @param aGeometry jp.co.sra.jun.geometry.abstracts.JunGeometry
	 * @param aCoordinateSystem jp.co.sra.jun.geometry.coordinate.JunCoordinateSystem
	 * @return jp.co.sra.jun.geometry.coordinate.JunLocalGeometry
	 * @category Instance creation
	 */
	public static JunLocalGeometry Geometry_coordinateSystem_(Class aClass, JunGeometry aGeometry, JunCoordinateSystem aCoordinateSystem) {
		return (JunLocalGeometry) _New(aClass, new Object[] { aGeometry, aCoordinateSystem });
	}

	/**
	 * Create a new instance of JunLocalGeometry and initialize it.
	 *
	 * @param aGeometry jp.co.sra.jun.geometry.abstracts.JunGeometry
	 * @category Instance creation
	 */
	public JunLocalGeometry(JunGeometry aGeometry) {
		this(aGeometry, null);
	}

	/**
	 * Create a new instance of JunLocalGeometry and initialize it.
	 *
	 * @param aGeometry jp.co.sra.jun.geometry.abstracts.JunGeometry
	 * @param aCoordinateSystem jp.co.sra.jun.geometry.coordinate.JunCoordinateSystem
	 * @category Instance creation
	 */
	public JunLocalGeometry(JunGeometry aGeometry, JunCoordinateSystem aCoordinateSystem) {
		geometry = aGeometry;
		coordinateSystem = aCoordinateSystem;
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		geometry = null;
		coordinateSystem = null;
	}

	/**
	 * Answer my geometry.
	 * 
	 * @return jp.co.sra.jun.geometry.abstracts.JunGeometry
	 * @category accessing
	 */
	public JunGeometry geometry() {
		return geometry;
	}

	/**
	 * Answer my coordinate system.
	 * 
	 * @return jp.co.sra.jun.geometry.coordinate.JunCoordinateSystem
	 * @category accessing
	 */
	public JunCoordinateSystem coordinateSystem() {
		return coordinateSystem;
	}

	/**
	 * Answer true if the receiver is equal to the object while concerning an accuracy.
	 * 
	 * @param anObject java.lang.Object
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#equal_(java.lang.Object)
	 * @category comparing
	 */
	public boolean equal_(Object anObject) {
		if (anObject == null || this.getClass() != anObject.getClass()) {
			return false;
		}

		JunLocalGeometry aLocalGeometry = (JunLocalGeometry) anObject;
		if (geometry.equal_(aLocalGeometry.geometry()) == false) {
			return false;
		}
		if (coordinateSystem == null) {
			return aLocalGeometry.coordinateSystem() == null;
		}
		return coordinateSystem.equal_(aLocalGeometry.coordinateSystem());
	}

	/**
	 * Answer true if the receiver is equal to the object.
	 * 
	 * @return boolean
	 * @param anObject java.lang.Object
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#equals(java.lang.Object)
	 * @category comparing
	 */
	public boolean equals(Object anObject) {
		if (anObject == null || this.getClass() != anObject.getClass()) {
			return false;
		}

		JunLocalGeometry aLocalGeometry = (JunLocalGeometry) anObject;
		if (geometry.equals(aLocalGeometry.geometry()) == false) {
			return false;
		}
		if (coordinateSystem == null) {
			return aLocalGeometry.coordinateSystem() == null;
		}
		return coordinateSystem.equals(aLocalGeometry.coordinateSystem());
	}

	/**
	 * Convert to a global geometry.
	 * 
	 * @return jp.co.sra.jun.geometry.abstracts.JunGeometry
	 * @category converting
	 */
	public JunGeometry asGlobalGeometry() {
		if (coordinateSystem == null) {
			return geometry;
		}

		return geometry.transform_(coordinateSystem._transformation());
	}

	/**
	 * Convert to a local geometry in the coordinate system.
	 * 
	 * @param aCoordinateSystem jp.co.sra.jun.geometry.coordinate.JunCoordinateSystem
	 * @return jp.co.sra.jun.geometry.coordinate.JunLocalGeometry
	 * @category converting
	 */
	public JunLocalGeometry asLocalGeometryIn_(JunCoordinateSystem aCoordinateSystem) {
		if (coordinateSystem.equals(aCoordinateSystem)) {
			return this;
		}

		return this.asGlobalGeometry().asLocalGeometryIn_(aCoordinateSystem);
	}

	/**
	 * Answer true if this is a kind of 2D geometry object, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean is2d() {
		return this.geometry.is2d();
	}

	/**
	 * Answer true if this is a kind of 3D geometry object, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean is3d() {
		return this.geometry.is3d();
	}

	/**
	 * Answer true if this is a kind of global geometry object, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isGlobalGeometry() {
		return false;
	}

}
