package jp.co.sra.jun.geometry.curves;

import java.awt.Point;
import java.io.IOException;
import java.io.Writer;

import jp.co.sra.smalltalk.SmalltalkException;

import jp.co.sra.jun.geometry.abstracts.JunCurve;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.surfaces.JunPlane;

/**
 * JunLine class
 * 
 *  @author    nisinaka
 *  @created   1998/10/09 (by nisinaka)
 *  @updated   2000/01/06 (by nisinaka)
 *  @updated   2004/10/20 (by Mitsuhiro Asada)
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLine.java,v 8.15 2008/02/20 06:30:57 nisinaka Exp $
 */
public abstract class JunLine extends JunCurve {

	/**
	 * Answer my start point.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.JunPoint
	 * @category accessing
	 */
	protected abstract JunPoint _from();

	/**
	 * Answer my end point.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.JunPoint
	 * @category accessing
	 */
	protected abstract JunPoint _to();

	/**
	 * Answer the length of this curve.
	 * 
	 * @return double
	 * @category accessing
	 */
	public abstract double length();

	/**
	 * Convert the receiver as an arrays of <code>Point</code>.
	 * 
	 * @return java.awt.Point[][]
	 * @category converting
	 */
	public abstract Point[][] asPointArrays();

	/**
	 * Answer the angle with the specified line.
	 * 
	 * @param aLine jp.co.sra.jun.geometry.curves.JunLine
	 * @return jp.co.sra.jun.geometry.basic.JunAngle
	 * @throws java.lang.IllegalArgumentException
	 * @category functions
	 */
	public abstract JunAngle angleWithLine_(JunLine aLine);

	/**
	 * Print my string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws java.io.IOException
	 * @see jp.co.sra.smalltalk.StObject#printOn_(java.io.Writer)
	 * @category printing
	 */
	public void printOn_(Writer aWriter) throws IOException {
		aWriter.write('(');
		this._from().printOn_(aWriter);
		aWriter.write(" to: ");
		this._to().printOn_(aWriter);
		aWriter.write(')');
	}

	/**
	 * Print my storable string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws java.io.IOException
	 * @see jp.co.sra.smalltalk.StObject#storeOn_(java.io.Writer)
	 * @category printing
	 */
	public void storeOn_(Writer aWriter) throws IOException {
		aWriter.write('(');
		aWriter.write(this._className().toString());
		aWriter.write(" from: ");
		this._from().printOn_(aWriter);
		aWriter.write(" to: ");
		this._to().printOn_(aWriter);
		aWriter.write(')');
	}

	/**
	 * Answer true if the receiver is a line geometry, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#isLine()
	 * @category testing
	 */
	public boolean isLine() {
		return true;
	}

	/**
	 * Answer the sign value of which side of the plane the receiver is located.
	 * 
	 * @param aPlane jp.co.sra.jun.geometry.surfaces.JunPlane
	 * @return int
	 * @throws jp.co.sra.smalltalk.SmalltalkException
	 * @category testing
	 */
	public int whichSideOf_(JunPlane aPlane) {
		throw SmalltalkException.ShouldNotImplement();
	}
}
