package jp.co.sra.jun.geometry.forms;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;

/**
 * JunFormTriangleJunction class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/06/15 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun500 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFormTriangleJunction.java,v 8.5 2008/02/20 06:30:57 nisinaka Exp $
 */
public class JunFormTriangleJunction extends JunFormTriangleNode {
	protected Jun2dPoint jp;

	/**
	 * Create a new instance of <code>JunFormTriangleJunction</code> and initialize it.
	 * 
	 * @param aPoint1 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aPoint2 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aPoint3 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category Instance creation
	 */
	public JunFormTriangleJunction(Jun2dPoint aPoint1, Jun2dPoint aPoint2, Jun2dPoint aPoint3) {
		super(aPoint1, aPoint2, aPoint3);
	}

	/**
	 * Create a new instance of <code>JunFormTriangleJunction</code> and initialize it.
	 * 
	 * @param pointArray jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Instance creation
	 */
	public JunFormTriangleJunction(Jun2dPoint[] pointArray) {
		super(pointArray);
	}

	/**
	 * Create a new instance of <code>JunFormTriangleJunction</code> and initialize it.
	 * 
	 * @param pointArray jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @param spinePoints jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Instance creation
	 */
	public JunFormTriangleJunction(Jun2dPoint[] pointArray, Jun2dPoint[] spinePoints) {
		super(pointArray, spinePoints);
	}

	/**
	 * Create a new instance of <code>JunFormTriangleJunction</code> and initialize it.
	 * 
	 * @param aTriangle jp.co.sra.jun.geometry.surfaces.Jun2dTriangle
	 * @category Instance creation
	 */
	public JunFormTriangleJunction(Jun2dTriangle aTriangle) {
		super(aTriangle);
	}

	/**
	 * Answer the receiver's terminal point.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category accessing
	 */
	public Jun2dPoint jp() {
		if (jp == null) {
			double d1 = this.p1().distance_(this.p2());
			double d2 = this.p2().distance_(this.p3());
			double d3 = this.p3().distance_(this.p1());
			double distance = d1 + d2 + d3;
			Jun2dPoint point = this.sp1().multipliedBy_(d1 / distance).plus_(this.sp2().multipliedBy_(d2 / distance)).plus_(this.sp3().multipliedBy_(d3 / distance));
			jp = point;
		}
		return jp;
	}

	/**
	 * Answer <code>true</code> if the receiver is junction, otherwise <code>false</code>
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.forms.JunFormTriangleNode#isJunction()
	 * @category testing
	 */
	public boolean isJunction() {
		return true;
	}
}
