package jp.co.sra.jun.geometry.forms;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;

/**
 * JunFormTriangleSleeve class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/06/15 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun500 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFormTriangleSleeve.java,v 8.5 2008/02/20 06:30:57 nisinaka Exp $
 */
public class JunFormTriangleSleeve extends JunFormTriangleNode {
	/**
	 * Create a new instance of <code>JunFormTriangleSleeve</code> and initialize it.
	 * 
	 * @param aPoint1 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aPoint2 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aPoint3 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category Instance creation
	 */
	public JunFormTriangleSleeve(Jun2dPoint aPoint1, Jun2dPoint aPoint2, Jun2dPoint aPoint3) {
		super(aPoint1, aPoint2, aPoint3);
	}

	/**
	 * Create a new instance of <code>JunFormTriangleSleeve</code> and initialize it.
	 * 
	 * @param aPoint1 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aPoint2 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aPoint3 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aPoint4 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aPoint5 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category Instance creation
	 */
	public JunFormTriangleSleeve(Jun2dPoint aPoint1, Jun2dPoint aPoint2, Jun2dPoint aPoint3, Jun2dPoint aPoint4, Jun2dPoint aPoint5) {
		super(aPoint1, aPoint2, aPoint3);
		this.setSp1_(aPoint4);
		this.setSp2_(aPoint5);
	}

	/**
	 * Create a new instance of <code>JunFormTriangleSleeve</code> and initialize it.
	 * 
	 * @param pointArray jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Instance creation
	 */
	public JunFormTriangleSleeve(Jun2dPoint[] pointArray) {
		super(pointArray);
	}

	/**
	 * Create a new instance of <code>JunFormTriangleSleeve</code> and initialize it.
	 * 
	 * @param pointArray jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @param spinePoints jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Instance creation
	 */
	public JunFormTriangleSleeve(Jun2dPoint[] pointArray, Jun2dPoint[] spinePoints) {
		super(pointArray, spinePoints);
	}

	/**
	 * Create a new instance of <code>JunFormTriangleSleeve</code> and initialize it.
	 * 
	 * @param aTriangle jp.co.sra.jun.geometry.surfaces.Jun2dTriangle
	 * @category Instance creation
	 */
	public JunFormTriangleSleeve(Jun2dTriangle aTriangle) {
		super(aTriangle);
	}

	/**
	 * Answer <code>true</code> if the receiver is sleeve, otherwise <code>false</code>
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.forms.JunFormTriangleNode#isSleeve()
	 * @category testing
	 */
	public boolean isSleeve() {
		return true;
	}
}
